/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.AddonUtil;
import com.ibm.ws.st.ui.internal.download.AddonsWizardFragment;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.DownloaderWizardFragment;
import com.ibm.ws.st.ui.internal.download.IRuntimeHandler;
import com.ibm.ws.st.ui.internal.download.LicenseWizardFragment;
import com.ibm.ws.st.ui.internal.download.LocalProduct;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import com.ibm.ws.st.ui.internal.download.ValidationResult;
import com.ibm.ws.st.ui.internal.plugin.ServerUtil;
import com.ibm.ws.st.ui.internal.wizard.WebSphereRuntimeComposite;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class WebSphereRuntimeWizardFragment
extends WizardFragment {
    protected WebSphereRuntimeComposite comp;
    protected RuntimeHandler runtimeHandler = new RuntimeHandler();
    protected int severity = 0;
    private List<WizardFragment> cachedList;
    private Map<String, Object> map;
    private boolean isFinished = false;

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime == null) {
            return false;
        }
        return this.comp != null && !this.comp.isDisposed() && this.severity != 3;
    }

    public Composite createComposite(Composite parent, final IWizardHandle wizard) {
        WebSphereRuntimeComposite.Mode mode;
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        this.isFinished = false;
        if (this.map != null) {
            this.map.clear();
        }
        if (runtime.getOriginal() == null) {
            String source = (String)this.getTaskModel().getObject("archive_source");
            if (source != null) {
                mode = WebSphereRuntimeComposite.Mode.ARCHIVE;
                this.downloadRequested(true);
            } else {
                mode = runtime.getLocation() != null ? WebSphereRuntimeComposite.Mode.EXISTING_FOLDER : WebSphereRuntimeComposite.Mode.NEW_FOLDER;
            }
        } else {
            mode = WebSphereRuntimeComposite.Mode.EDIT;
        }
        this.comp = new WebSphereRuntimeComposite(parent, new WebSphereRuntimeComposite.IMessageHandler(){

            @Override
            public void setMessage(String message, int severity) {
                WebSphereRuntimeWizardFragment.this.severity = severity;
                wizard.setMessage(message, severity);
                wizard.update();
            }
        }, mode, new WebSphereRuntimeComposite.IDownloadRequestHandler(){

            @Override
            public void downloadRequested(boolean b) {
                WebSphereRuntimeWizardFragment.this.downloadRequested(b);
            }
        });
        wizard.setTitle(Messages.wizRuntimeTitle);
        wizard.setDescription(Messages.wizRuntimeDescription);
        wizard.setImageDescriptor(Activator.getImageDescriptor("wizRuntime"));
        return this.comp;
    }

    public void enter() {
        if (this.comp != null) {
            IRuntimeWorkingCopy rt = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
            this.runtimeHandler.setRuntime(rt);
            this.comp.setRuntimeHandler(this.runtimeHandler);
        }
    }

    public void exit() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime.getOriginal() == null) {
            WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
            wsRuntime.setConstantId(runtime.getName());
            if (this.getTaskModel().getObject("addonMap") != null) {
                this.map.put("runtimeTypeId", runtime.getRuntimeType().getId());
            }
        }
        if (runtime.validate(null).getSeverity() != 4) {
            String canonicalPath;
            IRuntimeType type = runtime.getRuntimeType();
            try {
                canonicalPath = runtime.getLocation().toFile().getCanonicalPath();
            }
            catch (IOException e) {
                canonicalPath = runtime.getLocation().toString();
            }
            Activator.addToPreferenceList(type.getId() + ".folder", canonicalPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (this.comp == null || this.comp.isDisposed()) {
            return;
        }
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime.getOriginal() != null) {
            return;
        }
        IServerWorkingCopy server = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        try {
            int serverCreateTicks = server == null ? 0 : 20;
            int metaDataTicks = this.map == null || this.map.isEmpty() ? 100 - serverCreateTicks : 20;
            monitor.beginTask(Messages.jobInstallingRuntime, 100);
            if (this.isFinished) {
                return;
            }
            Map<IProduct, IStatus> result = new LinkedHashMap<IProduct, IStatus>();
            if (this.map != null && !this.map.isEmpty()) {
                result = this.downlandAndInstall(runtime.getLocation(), (IProgressMonitor)new SubProgressMonitor(monitor, 80 - serverCreateTicks));
            }
            if (result.containsValue(Status.OK_STATUS)) {
                WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
                this.createMetaData(wsRuntime, (IProgressMonitor)new SubProgressMonitor(monitor, metaDataTicks));
                this.isFinished = true;
            }
            if (this.getTaskModel().getObject("server") != null) {
                this.getTaskModel().putObject("installResult", new ArrayList(result.values()));
                this.getTaskModel().putObject("selectedDownloaders", new ArrayList<IProduct>(result.keySet()));
            } else {
                AddonUtil.showResult(null, result);
            }
        }
        finally {
            if (server == null) {
                monitor.done();
            }
        }
    }

    public void performCancel(IProgressMonitor monitor) throws CoreException {
        if (this.comp == null || this.comp.isDisposed()) {
            return;
        }
        if (this.isFinished) {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        wsRuntime.deleteProject(null);
        wsRuntime.removeMetadata(null, true, false);
        IPath folder = runtime.getLocation();
        if (this.map != null && !this.map.isEmpty()) {
            try {
                FileUtil.deleteDirectory((String)folder.toOSString(), (boolean)true);
            }
            catch (IOException e) {
                Trace.trace((byte)1, "Failed to clean up install directory", e);
            }
        }
        this.isFinished = false;
    }

    private Map<IProduct, IStatus> downlandAndInstall(IPath folder, IProgressMonitor monitor) throws CoreException {
        Map<IProduct, IStatus> result = new LinkedHashMap<IProduct, IStatus>();
        try {
            String propsURL;
            List selectedList = (List)this.map.get("selectedDownloaders");
            List authList = (List)this.map.get("productAuthentication");
            IProduct coreManager = (IProduct)this.map.get("coreManager");
            if (coreManager instanceof LocalProduct) {
                String archivePath = coreManager.getSource().getLocation();
                Activator.addToPreferenceList("archives", archivePath);
            }
            this.checkInstallPath(folder);
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("runtimeLocation", folder);
            settings.put("vmInstall", JavaRuntime.getDefaultVMInstall());
            if (SiteHelper.isProxyNeeded() && (propsURL = SiteHelper.getRepoPropertiesURL()) != null) {
                settings.put("repoPropsLocation", propsURL);
            }
            result = DownloadHelper.install(selectedList, authList, settings, monitor);
            IStatus firstStatus = null;
            Iterator<Map.Entry<IProduct, IStatus>> iterator = result.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<IProduct, IStatus> entry = iterator.next();
                firstStatus = entry.getValue();
            }
            if (firstStatus != null && (firstStatus == Status.CANCEL_STATUS || firstStatus != Status.OK_STATUS)) {
                throw new CoreException(firstStatus);
            }
            return result;
        }
        catch (CoreException ce) {
            try {
                FileUtil.deleteDirectory((String)folder.toOSString(), (boolean)true);
            }
            catch (IOException e) {
                Trace.trace((byte)1, "Failed to clean up install directory.The install operation either failed or it was cancelled", e);
            }
            AddonUtil.showResult(null, result);
            throw ce;
        }
    }

    protected void checkInstallPath(IPath installPath) throws CoreException {
        if (!installPath.toFile().exists() && !FileUtil.makeDir((IPath)installPath)) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.ui", 0, NLS.bind((String)Messages.errorInstallingRuntimeEnvironment, (Object)installPath.toOSString()), null));
        }
        File tempFile = installPath.append("writeTest.bat").toFile();
        try {
            tempFile.createNewFile();
            tempFile.delete();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.ui", 0, NLS.bind((String)Messages.errorInstallingRuntimeEnvironment, (Object)(installPath.toOSString() + "\n\n")) + e.getLocalizedMessage(), (Throwable)e));
        }
    }

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList<WizardFragment>();
            this.cachedList.add(new DownloaderWizardFragment());
            if (SiteHelper.downloadAndInstallSupported()) {
                this.cachedList.add(new AddonsWizardFragment());
                this.cachedList.add(new LicenseWizardFragment());
            }
        }
        list.addAll(this.cachedList);
    }

    protected void downloadRequested(boolean b) {
        if (b) {
            if (this.map == null) {
                this.map = new HashMap<String, Object>();
            }
            this.getTaskModel().putObject("addonMap", this.map);
            this.getTaskModel().putObject("runtimeHandler", (Object)this.runtimeHandler);
        } else {
            if (this.map != null) {
                this.map.clear();
            }
            this.getTaskModel().putObject("addonMap", null);
            this.getTaskModel().putObject("runtimeHandler", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMetaData(final WebSphereRuntime wsRuntime, IProgressMonitor monitor) {
        final boolean[] done = new boolean[]{false};
        try {
            String message = NLS.bind((String)Messages.taskRefreshingMetadata, (Object)wsRuntime.getRuntime().getName());
            monitor.beginTask(message, 300);
            monitor.subTask(message);
            Job runtimeAddedJob = new Job(message){

                protected IStatus run(IProgressMonitor monitor2) {
                    wsRuntime.createMetadata((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            done[0] = true;
                            if (!event.getResult().isOK() && Trace.ENABLED) {
                                Trace.trace((byte)1, "Metadata create did not finish successfully");
                            }
                            event.getJob().removeJobChangeListener((IJobChangeListener)this);
                        }
                    });
                    wsRuntime.createProject(null);
                    return Status.OK_STATUS;
                }
            };
            runtimeAddedJob.setPriority(20);
            runtimeAddedJob.schedule();
            for (int i = 0; i < 100 && !done[0]; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                monitor.worked(1);
            }
            if (!done[0] && Trace.ENABLED) {
                Trace.trace((byte)1, "The create metadata job did not finish in time");
            }
        }
        finally {
            monitor.done();
        }
    }

    private static class RuntimeHandler
    implements IRuntimeHandler {
        private IRuntimeWorkingCopy runtimeWC;
        private WebSphereRuntime runtime;
        private IPath oldLocation;

        protected RuntimeHandler() {
        }

        protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
            if (newRuntime == null) {
                this.runtimeWC = null;
                this.runtime = null;
                this.oldLocation = null;
            } else {
                this.runtimeWC = newRuntime;
                this.runtime = (WebSphereRuntime)newRuntime.loadAdapter(WebSphereRuntime.class, null);
                this.oldLocation = this.runtimeWC.getLocation() != null && !this.runtimeWC.getLocation().isEmpty() ? this.runtimeWC.getLocation() : null;
            }
        }

        @Override
        public void setLocation(IPath location) {
            if (this.runtimeWC != null) {
                this.runtimeWC.setLocation(location);
            }
        }

        @Override
        public void setRuntimeName(String name) {
            if (this.runtimeWC != null) {
                this.runtimeWC.setName(name);
            }
        }

        @Override
        public String getRuntimeName() {
            return this.runtimeWC == null ? null : this.runtimeWC.getName();
        }

        @Override
        public String getRuntimeTypeId() {
            if (this.runtimeWC == null) {
                return null;
            }
            IRuntimeType type = this.runtimeWC.getRuntimeType();
            return type.getId();
        }

        @Override
        public IPath getLocation() {
            return this.runtimeWC == null ? null : this.runtimeWC.getLocation();
        }

        @Override
        public WebSphereRuntime getRuntime() {
            return this.runtime;
        }

        @Override
        public ValidationResult validateRuntime(boolean isDownloadOrInstall) {
            IRuntime origRT;
            WebSphereRuntime[] wrts;
            if (this.runtime == null || this.runtimeWC == null) {
                return new ValidationResult(null, 3);
            }
            IPath runtimeLocation = this.runtimeWC.getLocation();
            if (this.oldLocation != null && !this.oldLocation.equals((Object)runtimeLocation) && RuntimeHandler.isLocalServersRunning(this.runtimeWC)) {
                return new ValidationResult(Messages.errorRuntimeServersRunning, 3);
            }
            if (runtimeLocation != null && (wrts = WebSphereUtil.getWebSphereRuntimes()).length > 0) {
                String runtimeId = this.runtimeWC.getId();
                for (WebSphereRuntime wrt : wrts) {
                    IRuntime rt = wrt.getRuntime();
                    if (rt == null || !runtimeLocation.equals((Object)rt.getLocation()) || runtimeId.equals(rt.getId())) continue;
                    return new ValidationResult(NLS.bind((String)Messages.errorRuntimeLocationMapped, (Object[])new String[]{runtimeLocation.toPortableString(), rt.getId()}), 3);
                }
            }
            if (((origRT = this.runtimeWC.getOriginal()) == null || !this.runtimeWC.getName().equals(origRT.getName())) && ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(this.runtimeWC.getName()))) {
                return new ValidationResult(Messages.errorRTNameSameExistingPrjName, 3);
            }
            if (isDownloadOrInstall) {
                return new ValidationResult(null, 0);
            }
            IStatus status = this.runtimeWC.validate(null);
            if (status == null || status.isOK()) {
                return new ValidationResult(null, 0);
            }
            if (status.getSeverity() == 2) {
                return new ValidationResult(status.getMessage(), 2);
            }
            return new ValidationResult(status.getMessage(), 3);
        }

        private static boolean isLocalServersRunning(IRuntimeWorkingCopy runtimeWC) {
            IRuntime originalRT = runtimeWC.getOriginal();
            if (originalRT == null) {
                return false;
            }
            IServer[] servers = ServerUtil.getServers(originalRT);
            if (servers != null) {
                for (IServer server : servers) {
                    if (server.getServerState() != 1 && server.getServerState() != 2 || !SocketUtil.isLocalhost((String)server.getHost())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

