/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.utility;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.crypto.CustomPasswordEncryptionInfo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.config.EnableCustomEncryptionDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class UtilityWizardPage
extends WizardPage {
    protected WebSphereRuntime wsRuntime;
    protected WebSphereServerInfo server;
    protected WebSphereServer wsServer;
    protected boolean doInclude = false;
    protected final ConfigurationFile serverConfig;
    protected final IPath configDir;

    public UtilityWizardPage(WebSphereServerInfo server) {
        super("utility");
        this.wsRuntime = server.getWebSphereRuntime();
        this.server = server;
        this.wsServer = WebSphereUtil.getWebSphereServer((WebSphereServerInfo)server);
        this.serverConfig = server.getConfigRoot();
        this.configDir = this.serverConfig.getPath().removeLastSegments(1);
        this.doInclude = WebSphereUtil.isGreaterOrEqualVersion((String)"8.5.5.2", (String)this.wsRuntime.getRuntimeVersion());
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(comp, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(comp, 3);
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 64);
        label.setText(this.getUserMessage());
        GridData data = new GridData(4, 128, true, false);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        Point p = label.computeSize(200, -1);
        label.setSize(p);
        label = new Label(comp, 258);
        label.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        label.setVisible(false);
        this.createUtilityControl(comp);
        Dialog.applyDialogFont((Control)comp);
        this.setPageComplete(this.validate());
        this.setControl((Control)comp);
    }

    protected abstract String getUserMessage();

    protected abstract void createUtilityControl(Composite var1);

    protected boolean validate() {
        this.setMessage(null, 0);
        return true;
    }

    public boolean preFinish() {
        return true;
    }

    public abstract void finish(IProgressMonitor var1) throws Exception;

    protected boolean notifyRemoteConfigOverwrite(String utilityTitle) {
        if (!this.wsServer.isLocalSetup() && this.wsServer.getServer().getServerState() == 4) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)utilityTitle, (String)Messages.notifyOverwriteRemoteConfigFile);
        }
        return true;
    }

    protected boolean isCustomPasswordEncryption(String encodingMethod) {
        return !"xor".equals(encodingMethod) && !"aes".equals(encodingMethod);
    }

    protected String getUserFeatureName(String encodingMethod) {
        Map customEncryptionMap;
        CustomPasswordEncryptionInfo cpei;
        String featureName = null;
        if (this.wsRuntime != null && (cpei = (CustomPasswordEncryptionInfo)(customEncryptionMap = this.wsRuntime.listCustomEncryption()).get(encodingMethod)) != null) {
            featureName = cpei.getFeatureName();
        }
        return featureName;
    }

    protected boolean isFeatureEnabled(String feature) {
        return this.serverConfig.hasFeature(feature);
    }

    protected void enableFeature(final String itemName, String featureName, IProgressMonitor monitor) {
        ArrayList<String> featureList = new ArrayList<String>();
        featureList.add(featureName);
        final ArrayList<String> featureListFinal = featureList;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                List<String> features;
                EnableCustomEncryptionDialog enableDialog = new EnableCustomEncryptionDialog(UtilityWizardPage.this.getShell(), UtilityWizardPage.this.wsRuntime, itemName, featureListFinal);
                if (enableDialog.open() == 0 && !(features = enableDialog.getSelectedFeatures()).isEmpty()) {
                    UtilityWizardPage.this.serverConfig.addFeatures(features);
                }
            }
        });
    }
}

