/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class QuickFixAddApplicationElement
extends AbstractMarkerResolution {
    private final String appName;

    public QuickFixAddApplicationElement(String appName) {
        this.appName = appName;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.addConfigAppElementLabel, (Object)this.appName);
    }

    public void run(IMarker marker) {
        WebSphereServer[] servers;
        IModule module;
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.appName);
        IModule iModule = module = project != null ? ServerUtil.getModule((IProject)project) : null;
        if (module == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix for add app element to configuration failed. Could not locate application module '" + this.appName + "' on server", null);
            }
            this.showErrorMessage();
            return;
        }
        URI uri = resource.getLocation().toFile().toURI();
        for (WebSphereServer server : servers = WebSphereUtil.getWebSphereServers()) {
            ConfigurationFile configFile = server.getConfigurationFileFromURI(uri);
            if (configFile == null) continue;
            try {
                server.modifyModules(new IModule[]{module}, null, null);
            }
            catch (CoreException ce) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)6, "Quick fix for add app element '" + this.appName + "' to configuration failed. Error trying to add <application> element to configuration file: " + configFile.getURI(), ce);
                }
                this.showErrorMessage();
            }
            return;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)6, "Quick fix for add app element '" + this.appName + "' to configuration failed. Could not locate configuration file: " + uri, null);
        }
        this.showErrorMessage();
    }

    @Override
    protected String getErrorMessage() {
        return Messages.addConfigAppElementFailedMessage;
    }
}

