/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.ManifestElement;

public class FeatureHandler {
    private final Map<String, int[]> featureMap = new HashMap<String, int[]>();
    private FeatureProcessor processor = null;

    public boolean containsFeatures(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        for (String feature : collection) {
            if (this.featureMap.containsKey(feature)) continue;
            return false;
        }
        return true;
    }

    public void addFeatures(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (String feature : collection) {
            int[] count = this.featureMap.get(feature);
            if (count == null) {
                count = new int[1];
                this.featureMap.put(feature, count);
            }
            count[0] = count[0] + 1;
        }
    }

    public void removeFeatures(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (String feature : collection) {
            int[] count = this.featureMap.get(feature);
            if (count == null || (count[0] = count[0] - 1) != 0) continue;
            this.featureMap.remove(feature);
        }
    }

    public boolean isMultipleSelection(String feature) {
        int[] count = this.featureMap.get(feature);
        if (count == null) {
            return false;
        }
        return count[0] > 1;
    }

    public void reset() {
        this.featureMap.clear();
    }

    public boolean isInstalled(IRuntimeInfo runtime, Collection<String> features) {
        if (features == null || features.isEmpty()) {
            return false;
        }
        List installedFeatures = runtime.getInstalledFeatures();
        if (installedFeatures == null || installedFeatures.isEmpty()) {
            return false;
        }
        if (this.processor == null) {
            this.processor = new FeatureProcessor(runtime.getLocation());
        }
        for (String f : features) {
            FeatureVisibility visibility;
            if (installedFeatures.contains(f) || (visibility = this.processor.getFeatureVisibility(f)) != null && visibility != FeatureVisibility.PUBLIC) continue;
            return false;
        }
        return true;
    }

    private static class FeatureProcessor {
        private final HashMap<String, FeatureVisibility> symbolicFeatureMap = new HashMap();
        private final IPath runtimeLocation;

        protected FeatureProcessor(IPath runtimeLocation) {
            this.runtimeLocation = runtimeLocation;
            this.processFeatures();
        }

        protected FeatureVisibility getFeatureVisibility(String symbolicName) {
            return this.symbolicFeatureMap.get(symbolicName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFeatures() {
            File[] files;
            if (this.runtimeLocation == null) {
                return;
            }
            IPath path = this.runtimeLocation.append("lib").append("features");
            for (File f : files = path.toFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return false;
                    }
                    return file.getName().endsWith(".mf");
                }
            })) {
                InputStream in = null;
                try {
                    HashMap props = new HashMap();
                    in = new FileInputStream(f);
                    FileUtil.readSubsystem((InputStream)in, props);
                    String content = (String)props.get("Subsystem-SymbolicName");
                    ManifestElement[] elements = ManifestElement.parseHeader((String)"Subsystem-SymbolicName", (String)content);
                    if (elements == null) continue;
                    String visibility = elements[0].getAttribute("visibility");
                    FeatureVisibility v = this.processVisibility(visibility);
                    this.symbolicFeatureMap.put(elements[0].getValue(), v);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, (String)("Could not process manifest file" + f.getName()), (Throwable)e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private FeatureVisibility processVisibility(String value) {
            if (value == null) {
                return FeatureVisibility.AUTO;
            }
            if (value.equals("public")) {
                return FeatureVisibility.PUBLIC;
            }
            if (value.equals("private")) {
                return FeatureVisibility.PRIVATE;
            }
            if (value.equals("protected")) {
                return FeatureVisibility.PROTECTED;
            }
            return FeatureVisibility.AUTO;
        }
    }

    private static enum FeatureVisibility {
        PUBLIC,
        PRIVATE,
        PROTECTED,
        AUTO;

    }
}

