/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.RuntimeFeatureResolver;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.config.FeatureConflictDialog;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.DownloadUI;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.TaskModel;

public class FeatureUI {
    public static String formatList(Set<String> features) {
        ArrayList<String> featureList = new ArrayList<String>(features.size());
        featureList.addAll(features);
        Collections.sort(featureList);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String feature : featureList) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(feature);
        }
        return builder.toString();
    }

    public static void createColumns(final Table featureTable) {
        final TableColumn featureColumn = new TableColumn(featureTable, 0);
        featureColumn.setText(Messages.featureNameColumn);
        featureColumn.setResizable(true);
        featureColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FeatureUI.sortTable(featureTable, featureColumn);
            }
        });
        final TableColumn nameColumn = new TableColumn(featureTable, 0);
        nameColumn.setText(Messages.featureDisplayNameColumn);
        nameColumn.setResizable(true);
        nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FeatureUI.sortTable(featureTable, nameColumn);
            }
        });
        featureTable.setHeaderVisible(true);
        featureTable.setLinesVisible(false);
        featureTable.setSortDirection(1024);
        featureTable.setSortColumn(featureColumn);
    }

    public static void resizeColumns(Table table) {
        int i;
        TableLayout tableLayout = new TableLayout();
        int numColumns = table.getColumnCount();
        for (i = 0; i < numColumns; ++i) {
            table.getColumn(i).pack();
        }
        for (i = 0; i < numColumns; ++i) {
            int w = Math.max(75, table.getColumn(i).getWidth());
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(w, w, true));
        }
        table.setLayout((Layout)tableLayout);
    }

    public static void sortTable(Table table, TableColumn column) {
        int i;
        TableItem[] items = table.getItems();
        int rows = items.length;
        int dir = table.getSortDirection() == 1024 ? 1 : -1;
        TableColumn currentColumn = table.getSortColumn();
        int columnNum = 0;
        for (int j = 0; j < table.getColumnCount(); ++j) {
            if (!table.getColumn(j).equals(column)) continue;
            columnNum = j;
            break;
        }
        dir = column.equals(currentColumn) ? -dir : 1;
        int[] map = new int[rows];
        for (i = 0; i < rows; ++i) {
            map[i] = i;
        }
        for (i = 0; i < rows - 1; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                TableItem a = items[map[i]];
                TableItem b = items[map[j]];
                if (a.getText(columnNum).compareTo(b.getText(columnNum)) * dir <= 0) continue;
                int t = map[i];
                map[i] = map[j];
                map[j] = t;
            }
        }
        for (i = 0; i < rows; ++i) {
            int n = map[i];
            TableItem item = new TableItem(table, 0);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                item.setText(j, items[n].getText(j));
            }
            item.setImage(items[n].getImage());
            item.setForeground(items[n].getForeground());
            item.setBackground(items[n].getBackground());
            item.setGrayed(items[n].getGrayed());
            item.setChecked(items[n].getChecked());
            item.setData(items[n].getData());
            items[n].dispose();
        }
        table.setSortDirection(dir == 1 ? 1024 : 128);
        table.setSortColumn(column);
    }

    private static String getEnables(TableItem[] items, WebSphereRuntime wsRuntime) {
        HashSet<String> enables = new HashSet<String>();
        for (TableItem item : items) {
            enables.addAll(FeatureList.getFeatureChildren((String)FeatureUI.getItemText(item), (WebSphereRuntime)wsRuntime));
        }
        for (TableItem item : items) {
            Iterator itr = enables.iterator();
            while (itr.hasNext()) {
                String feature = (String)itr.next();
                if (!feature.equalsIgnoreCase(FeatureUI.getItemText(item))) continue;
                itr.remove();
            }
        }
        return FeatureUI.formatList(enables);
    }

    private static String getEnabledBy(TableItem[] items, WebSphereRuntime wsRuntime) {
        HashSet<String> enabledBy = new HashSet<String>();
        for (TableItem item : items) {
            enabledBy.addAll(FeatureList.getFeatureParents((String)FeatureUI.getItemText(item), (WebSphereRuntime)wsRuntime));
        }
        for (TableItem item : items) {
            Iterator itr = enabledBy.iterator();
            while (itr.hasNext()) {
                String feature = (String)itr.next();
                if (!feature.equalsIgnoreCase(FeatureUI.getItemText(item))) continue;
                itr.remove();
            }
        }
        return FeatureUI.formatList(enabledBy);
    }

    private static String getConflictsWith(TableItem[] items) {
        HashSet<String> conflictsWith = new HashSet<String>();
        for (TableItem item : items) {
            List<FeatureConflictDialog.ConflictInfo> conflictList;
            if (item.getData() == null || (conflictList = ((FeatureConflictDialog.FeatureItemData)item.getData()).getConflictInfo()) == null) continue;
            for (FeatureConflictDialog.ConflictInfo conflict : conflictList) {
                if (conflict.enablingFeature != null) {
                    conflictsWith.add(conflict.enablingFeature);
                }
                if (conflict.feature == null) continue;
                conflictsWith.add(conflict.feature);
            }
        }
        for (TableItem item : items) {
            Iterator itr = conflictsWith.iterator();
            while (itr.hasNext()) {
                String feature = (String)itr.next();
                if (!feature.equalsIgnoreCase(((FeatureConflictDialog.FeatureItemData)item.getData()).getFeatureName())) continue;
                itr.remove();
            }
        }
        return FeatureUI.formatList(conflictsWith);
    }

    private static String getDescription(TableItem[] items, WebSphereRuntime wsRuntime) {
        if (items.length != 1) {
            return null;
        }
        String text = FeatureUI.getItemText(items[0]);
        return FeatureList.getFeatureDescription((String)text, (WebSphereRuntime)wsRuntime);
    }

    public static void updateInfo(Text enablesLabel, Text enabledByLabel, Text descriptionLabel, Table featureTable, Set<String> featureSet, WebSphereRuntime wsRuntime) {
        FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, null, null, featureTable, featureSet, wsRuntime);
    }

    public static void updateInfo(Text enablesLabel, Text enabledByLabel, Text descriptionLabel, Text conflictsWithLabel, Link conflictLink, Table featureTable, Set<String> featureSet, WebSphereRuntime wsRuntime) {
        TableItem[] items = featureTable.getSelection();
        String enables = "";
        String enabledBy = "";
        String description = "";
        String conflictsWith = "";
        boolean enabled = false;
        if (items.length > 0) {
            enabled = true;
            enables = FeatureUI.getEnables(items, wsRuntime);
            enabledBy = FeatureUI.getEnabledBy(items, wsRuntime);
            conflictsWith = FeatureUI.getConflictsWith(items);
            description = FeatureUI.getDescription(items, wsRuntime);
            enables = enables.isEmpty() ? Messages.featureNone : enables;
            String string = enabledBy = enabledBy.isEmpty() ? Messages.featureNone : enabledBy;
            if (description == null || description.isEmpty()) {
                description = Messages.featureNone;
            }
        }
        String text = NLS.bind((String)Messages.featureEnables, (Object)enables);
        String shortenedText = SWTUtil.shortenText((Control)enablesLabel, text, Messages.featureEnables.length());
        enablesLabel.setText(shortenedText);
        enablesLabel.setToolTipText(SWTUtil.formatTooltip(enables, shortenedText.length()));
        enablesLabel.setEnabled(enabled);
        text = NLS.bind((String)Messages.featureEnabledBy, (Object)enabledBy);
        shortenedText = SWTUtil.shortenText((Control)enabledByLabel, text, Messages.featureEnabledBy.length());
        enabledByLabel.setText(shortenedText);
        enabledByLabel.setToolTipText(SWTUtil.formatTooltip(enabledBy, shortenedText.length()));
        enabledByLabel.setEnabled(enabled);
        text = NLS.bind((String)Messages.featureDescription, (Object)description);
        int toolTipWidth = 70;
        if ((descriptionLabel.getStyle() & 0x40) == 0) {
            shortenedText = SWTUtil.shortenText((Control)descriptionLabel, text, Messages.featureDescription.length());
            descriptionLabel.setText(shortenedText);
            toolTipWidth = shortenedText.length();
        } else {
            descriptionLabel.setText(text);
            int width = descriptionLabel.getParent().getClientArea().width;
            descriptionLabel.setSize(width, descriptionLabel.computeSize((int)width, (int)-1).y);
            int newWidth = descriptionLabel.getParent().getClientArea().width;
            if (newWidth != width) {
                descriptionLabel.setSize(newWidth, descriptionLabel.computeSize((int)newWidth, (int)-1).y);
            }
        }
        descriptionLabel.setToolTipText(SWTUtil.formatTooltip(description, toolTipWidth));
        descriptionLabel.setEnabled(enabled);
        if (conflictsWithLabel != null && conflictLink != null) {
            if (items.length == 1 && !conflictsWith.isEmpty()) {
                text = NLS.bind((String)Messages.featureConflictsWith, (Object)conflictsWith);
                conflictsWithLabel.setText(text);
                shortenedText = SWTUtil.shortenText((Control)enabledByLabel, text, Messages.featureConflictsWith.length());
                conflictsWithLabel.setToolTipText(conflictsWith);
                conflictsWithLabel.setEnabled(enabled);
                conflictsWithLabel.setVisible(true);
                List<FeatureConflictDialog.ConflictInfo> infos = ((FeatureConflictDialog.FeatureItemData)items[0].getData()).getConflictInfo();
                FeatureUI.setupConflictLink(conflictLink, infos, wsRuntime);
                conflictLink.setVisible(true);
            } else {
                conflictsWithLabel.setVisible(false);
                conflictLink.setVisible(false);
            }
        }
    }

    private static void setupConflictLink(final Link link, final List<FeatureConflictDialog.ConflictInfo> infos, final WebSphereRuntime wsRuntime) {
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().asyncExec(new Runnable(){
                    final String detailsText;
                    final String infoText;
                    {
                        this.detailsText = FeatureUI.getDetails(infos);
                        this.infoText = FeatureUI.getInfo(infos, wsRuntime);
                    }

                    @Override
                    public void run() {
                        new PopupDialog(link.getShell(), 4, true, false, false, false, false, null, null){
                            private static final int OFFSET_X = 30;
                            private static final int OFFSET_Y = 5;

                            protected Point getInitialLocation(Point initialSize) {
                                Display display = this.getShell().getDisplay();
                                Point location = display.getCursorLocation();
                                location.x += 30;
                                location.y += 5;
                                return location;
                            }

                            protected Control createDialogArea(Composite parent) {
                                Label label = new Label(parent, 64);
                                label.setText(detailsText + "\n\n" + infoText);
                                label.addFocusListener((FocusListener)new FocusAdapter(){

                                    public void focusLost(FocusEvent event) {
                                        this.close();
                                    }
                                });
                                GridData data = new GridData(1809);
                                data.widthHint = 500;
                                data.grabExcessVerticalSpace = true;
                                data.horizontalIndent = 1;
                                data.verticalIndent = 1;
                                label.setLayoutData((Object)data);
                                return label;
                            }
                        }.open();
                    }
                });
            }
        });
    }

    static String getInfo(List<FeatureConflictDialog.ConflictInfo> infos, WebSphereRuntime wsRuntime) {
        StringBuffer sb = new StringBuffer();
        for (FeatureConflictDialog.ConflictInfo info : infos) {
            String dependencyStringA = RuntimeFeatureResolver.getDependencyChainString((List)info.getFeatureConflict().getDependencyChainA(), (WebSphereRuntime)wsRuntime);
            String dependencyStringB = RuntimeFeatureResolver.getDependencyChainString((List)info.getFeatureConflict().getDependencyChainB(), (WebSphereRuntime)wsRuntime);
            sb.append(Messages.featureConflictDependencyChainMessage + ":\n");
            sb.append(dependencyStringA);
            sb.append("\n");
            sb.append(dependencyStringB);
            sb.append("\n\n");
        }
        return sb.toString();
    }

    static String getDetails(List<FeatureConflictDialog.ConflictInfo> infos) {
        StringBuffer sb = new StringBuffer();
        for (FeatureConflictDialog.ConflictInfo info : infos) {
            sb.append(info.getDetails() + "\n");
        }
        return sb.toString();
    }

    private static String getItemText(TableItem tableItem) {
        String text = tableItem.getText();
        Object obj = tableItem.getData();
        if (obj != null && obj instanceof FeatureConflictDialog.FeatureItemData) {
            text = ((FeatureConflictDialog.FeatureItemData)obj).getFeatureName();
        }
        return text;
    }

    public static class AddDialog
    extends TitleAreaDialog {
        protected final Set<String> configuredFeatures;
        protected Set<String> availableFeatures;
        protected WebSphereRuntime wsRuntime;
        protected Set<String> newFeatures;
        protected SearchPattern pattern = new SearchPattern(35);
        protected Text filterText;
        protected Table featureTable;
        protected Text descriptionLabel;
        protected Text enablesLabel;
        protected Text enabledByLabel;
        protected Link addAdditionalContentLink;

        public AddDialog(Shell parent, Set<String> runtimeFeatures, Set<String> configuredFeatures, WebSphereRuntime wsRuntime) {
            super(parent);
            this.availableFeatures = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String str1, String str2) {
                    return str1.compareToIgnoreCase(str2);
                }
            });
            this.availableFeatures.addAll(runtimeFeatures);
            this.availableFeatures.removeAll(configuredFeatures);
            this.configuredFeatures = configuredFeatures;
            this.wsRuntime = wsRuntime;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.addFeatureTitle);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            IRuntime runtime;
            IRuntimeInfo core;
            this.setTitle(Messages.addFeatureLabel);
            this.setTitleImage(Activator.getImage("wizServer"));
            this.setMessage(Messages.addFeatureMessage);
            final Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setFont(parent.getFont());
            this.filterText = new Text(composite, 2048);
            this.filterText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.filterText.setMessage(Messages.filterMessage);
            this.featureTable = new Table(composite, 68354);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 300;
            this.featureTable.setLayoutData((Object)data);
            FeatureUI.createColumns(this.featureTable);
            this.createItems(this.featureTable, this.availableFeatures, "");
            FeatureUI.resizeColumns(this.featureTable);
            if (SiteHelper.downloadAndInstallSupported() && this.wsRuntime != null && this.wsRuntime.supportsInstallingAdditionalContent() && (core = DownloadHelper.getRuntimeCore(runtime = this.wsRuntime.getRuntime())).getVersion() != null && !core.getVersion().startsWith("8.5.0")) {
                this.addAdditionalContentLink = new Link(composite, 0);
                this.addAdditionalContentLink.setText("<a>" + Messages.actionInstallFeatures + "</a>");
                this.addAdditionalContentLink.setLayoutData((Object)new GridData(131072, 4, true, false));
                this.addAdditionalContentLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map = new HashMap();
                        map.put("folder", runtime.getLocation().toOSString());
                        map.put("runtimeTypeId", runtime.getRuntimeType().getId());
                        map.put("core", core);
                        ArrayList<IProduct.Type> types = new ArrayList<IProduct.Type>(1);
                        types.add(IProduct.Type.FEATURE);
                        map.put("typeFilterPreset", types);
                        TaskModel taskModel = new TaskModel();
                        taskModel.putObject("runtime", (Object)runtime);
                        taskModel.putObject("addonMap", map);
                        int result = DownloadUI.launchAddonsDialog(composite.getShell(), taskModel);
                        if (result == 0) {
                            availableFeatures.clear();
                            availableFeatures.addAll(FeatureList.getRuntimeFeatureSet((WebSphereRuntime)wsRuntime));
                            availableFeatures.removeAll(configuredFeatures);
                            String text = filterText.getText();
                            if (text == null) {
                                text = "";
                            }
                            this.createItems(featureTable, availableFeatures, text);
                        }
                    }
                });
            }
            ScrolledComposite descriptionScroll = new ScrolledComposite(composite, 512);
            this.descriptionLabel = new Text((Composite)descriptionScroll, 72);
            this.descriptionLabel.setText(NLS.bind((String)Messages.featureDescription, (Object)""));
            this.descriptionLabel.setBackground(parent.getBackground());
            descriptionScroll.setContent((Control)this.descriptionLabel);
            this.enablesLabel = new Text(composite, 8);
            this.enablesLabel.setText(NLS.bind((String)Messages.featureEnables, (Object)""));
            this.enablesLabel.setBackground(parent.getBackground());
            this.enablesLabel.setLayoutData((Object)new GridData(4, 1, true, false));
            data = new GridData(4, 4, true, false);
            int lineHeight = this.enablesLabel.computeSize((int)-1, (int)-1).y;
            data.heightHint = lineHeight * 4;
            descriptionScroll.setLayoutData((Object)data);
            descriptionScroll.getVerticalBar().setPageIncrement(lineHeight);
            descriptionScroll.getVerticalBar().setIncrement(lineHeight);
            this.enabledByLabel = new Text(composite, 8);
            this.enabledByLabel.setText(NLS.bind((String)Messages.featureEnabledBy, (Object)""));
            this.enabledByLabel.setBackground(parent.getBackground());
            this.enabledByLabel.setLayoutData((Object)new GridData(4, 1, true, false));
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String text = filterText.getText();
                    if (text == null) {
                        text = "";
                    }
                    this.createItems(featureTable, availableFeatures, text);
                    if (featureTable.getItemCount() > 0) {
                        featureTable.select(0);
                    }
                    FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, featureTable, null, wsRuntime);
                    this.enableOKButton(featureTable.getSelectionCount() > 0);
                }
            });
            this.filterText.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    if (event.keyCode == 0x1000002) {
                        if (featureTable.getItemCount() > 0) {
                            featureTable.setSelection(0);
                            featureTable.setFocus();
                        }
                        event.doit = false;
                    }
                }
            });
            this.featureTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TableItem[] items = featureTable.getSelection();
                    this.enableOKButton(items.length > 0);
                    FeatureUI.updateInfo(enablesLabel, enabledByLabel, descriptionLabel, featureTable, null, wsRuntime);
                }
            });
            this.featureTable.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    this.okPressed();
                    this.close();
                }
            });
            return composite;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.enableOKButton(false);
            return control;
        }

        public void create() {
            super.create();
            FeatureUI.updateInfo(this.enablesLabel, this.enabledByLabel, this.descriptionLabel, this.featureTable, null, this.wsRuntime);
            this.descriptionLabel.setSize(this.descriptionLabel.computeSize(-1, -1));
            this.filterText.setFocus();
        }

        protected void okPressed() {
            TableItem[] items = this.featureTable.getSelection();
            this.newFeatures = new HashSet<String>(items.length);
            for (TableItem item : items) {
                this.newFeatures.add(item.getText());
            }
            super.okPressed();
        }

        protected void enableOKButton(boolean value) {
            this.getButton(0).setEnabled(value);
        }

        protected void createItems(Table table, Set<String> features, String filter) {
            ArrayList<String> featureList = new ArrayList<String>(features.size());
            featureList.addAll(features);
            Collections.sort(featureList);
            table.removeAll();
            this.pattern.setPattern("*" + filter + "*");
            for (String feature : featureList) {
                String name = FeatureList.getFeatureDisplayName((String)feature, (WebSphereRuntime)this.wsRuntime);
                String description = FeatureList.getFeatureDescription((String)feature, (WebSphereRuntime)this.wsRuntime);
                if (!this.pattern.matches(feature) && (name == null || !this.pattern.matches(name)) && (description == null || !this.pattern.matches(description))) continue;
                TableItem item = new TableItem(table, 0);
                item.setText(0, feature);
                if (name != null) {
                    item.setText(1, name);
                }
                if (FeatureList.isFeatureSuperseded((String)feature, (WebSphereRuntime)this.wsRuntime)) {
                    item.setImage(Activator.getImage("featureSuperseded"));
                } else {
                    item.setImage(Activator.getImage("featureElement"));
                }
                if (features.contains(feature)) continue;
                item.setGrayed(true);
            }
        }

        public Set<String> getFeatures() {
            return this.newFeatures;
        }
    }
}

