/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationFolder;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import com.ibm.ws.st.ui.internal.DDETreeContentProvider;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.RuntimeExplorer;
import com.ibm.ws.st.ui.internal.Trace;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.w3c.dom.Element;

public class ShowInFilesystemAction
extends SelectionProviderAction {
    private File file;

    public ShowInFilesystemAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionOpenFolder);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        this.file = null;
        Object obj = sel.getFirstElement();
        if (obj instanceof IRuntime) {
            IRuntime runtime = (IRuntime)obj;
            this.file = runtime.getLocation().toFile();
        } else if (obj instanceof IServer) {
            IServer srv = (IServer)obj;
            WebSphereServer server = (WebSphereServer)srv.loadAdapter(WebSphereServer.class, null);
            if (server != null && server.getServerPath() != null) {
                this.file = server.getServerPath().toFile();
            }
        } else if (obj instanceof ConfigurationFolder) {
            ConfigurationFolder folder = (ConfigurationFolder)obj;
            this.file = folder.getPath().toFile();
        } else if (obj instanceof ConfigurationFile) {
            ConfigurationFile configFile = (ConfigurationFile)obj;
            this.file = configFile.getPath().toFile().getParentFile();
        } else if (obj instanceof ExtendedConfigFile) {
            ExtendedConfigFile configFile = (ExtendedConfigFile)obj;
            this.file = configFile.getFile().getParentFile();
        } else if (obj instanceof Element) {
            Element element = (Element)obj;
            URI uri = DDETreeContentProvider.getURI(element);
            this.file = new File(uri).getParentFile();
        } else if (obj instanceof UserDirectory) {
            UserDirectory userDir = (UserDirectory)obj;
            this.file = userDir.getPath().toFile();
        } else if (obj instanceof RuntimeExplorer.Node) {
            RuntimeExplorer.Node node = (RuntimeExplorer.Node)obj;
            UserDirectory userDir = node.getUserDirectory();
            if (RuntimeExplorer.NodeType.SHARED_APPLICATIONS == node.getType()) {
                this.file = userDir.getSharedAppsPath().toFile();
            } else if (RuntimeExplorer.NodeType.SHARED_CONFIGURATIONS == node.getType()) {
                this.file = userDir.getSharedConfigPath().toFile();
            } else if (RuntimeExplorer.NodeType.SERVERS == node.getType()) {
                this.file = userDir.getServersPath().toFile();
            }
        } else if (obj instanceof WebSphereServerInfo) {
            WebSphereServerInfo server = (WebSphereServerInfo)obj;
            this.file = server.getServerPath().toFile();
        }
        this.setEnabled(this.file != null);
    }

    public void run() {
        if (this.file == null) {
            return;
        }
        try {
            Desktop.getDesktop().open(this.file);
        }
        catch (IOException e) {
            Trace.logError("Error opening folder " + this.file.toString(), e);
        }
    }
}

