/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IServer;

public class NewExtendedConfigAction
extends SelectionProviderAction {
    private final Shell shell;
    private final String fileName;
    private final StructuredViewer viewer;
    private Object selectedObj;
    private WebSphereServerInfo server;
    private final String in;

    public NewExtendedConfigAction(String fileName, ISelectionProvider selectionProvider, StructuredViewer viewer, String in) {
        super(selectionProvider, fileName);
        this.shell = viewer.getControl().getShell();
        this.fileName = fileName;
        this.viewer = viewer;
        this.in = in;
        this.setImageDescriptor(Activator.getImageDescriptor(fileName));
        this.selectionChanged(this.getStructuredSelection());
        if (in != null) {
            this.setText(NLS.bind((String)Messages.menuJVMOptionsIn, (Object)in));
        }
    }

    public NewExtendedConfigAction(String fileName, ISelectionProvider selectionProvider, StructuredViewer viewer) {
        this(fileName, selectionProvider, viewer, null);
        this.setText(fileName);
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        this.server = null;
        for (Object this.selectedObj : sel) {
            if (this.selectedObj instanceof IServer) {
                IServer srv = (IServer)this.selectedObj;
                WebSphereServer wsServer = (WebSphereServer)srv.loadAdapter(WebSphereServer.class, null);
                if (wsServer == null) continue;
                this.server = wsServer.getServerInfo();
                continue;
            }
            if (this.selectedObj instanceof WebSphereServerInfo) {
                this.server = (WebSphereServerInfo)this.selectedObj;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        if (this.server == null) {
            this.setEnabled(false);
            return;
        }
        IPath remoteUserDir = this.server.getUserDirectory().getRemoteUserPath();
        if (remoteUserDir != null && this.in != null && this.in.contains("shared")) {
            this.setEnabled(false);
            return;
        }
        IFolder folder = this.getFolder();
        if (folder != null && folder.isAccessible()) {
            this.setEnabled(!folder.getFile(this.fileName).exists());
        } else {
            IPath path = this.getPath().append(this.fileName);
            this.setEnabled(!path.toFile().exists());
        }
    }

    public boolean isApplicable() {
        return this.server != null;
    }

    private IPath getPath() {
        IPath path = this.in == null ? this.server.getServerPath() : (this.in.contains("shared") ? this.server.getUserDirectory().getSharedPath() : (this.in.contains("defaults") ? this.server.getConfigDefaultDropinsPath() : (this.in.contains("overrides") ? this.server.getConfigOverrideDropinsPath() : this.server.getServerPath())));
        return path;
    }

    private IFolder getFolder() {
        IFolder folder = this.in == null ? this.server.getServerFolder() : (this.in.contains("shared") ? this.server.getUserDirectory().getSharedFolder() : (this.in.contains("defaults") ? this.server.getConfigDefaultDropinsFolder() : (this.in.contains("overrides") ? this.server.getConfigOverrideDropinsFolder() : this.server.getServerFolder())));
        return folder;
    }

    public void run() {
        if (this.server == null) {
            return;
        }
        try {
            IFile file = null;
            URI uri = null;
            IFolder folder = this.getFolder();
            if (folder != null) {
                IProject project = folder.getProject();
                if (!project.isOpen() && !MessageDialog.openQuestion((Shell)this.shell, (String)Messages.title, (String)NLS.bind((String)Messages.confirmProjectOpen, (Object)project.getName()))) {
                    IPath path = this.getPath();
                    if (FileUtil.makeDir((IPath)path)) {
                        File f = WebSphereUtil.createFile((File)path.toFile(), (String)this.fileName, null);
                        uri = f.toURI();
                        this.server.updateCache();
                    }
                } else {
                    this.createFolder(folder);
                    file = WebSphereUtil.createFile((IFolder)folder, (String)this.fileName, null);
                    uri = file.getLocationURI();
                    this.server.updateCache();
                }
            } else {
                IPath path = this.getPath();
                if (FileUtil.makeDir((IPath)path)) {
                    File f = WebSphereUtil.createFile((File)path.toFile(), (String)this.fileName, null);
                    uri = f.toURI();
                    this.server.updateCache();
                }
            }
            if (uri == null || !new File(uri).exists()) {
                throw new Exception();
            }
            Activator.openEditor(file, uri);
            this.viewer.refresh(this.selectedObj);
            this.setEnabled(false);
        }
        catch (Exception e) {
            this.setEnabled(true);
            Trace.logError((String)("Error creating " + this.getText()), (Throwable)e);
        }
    }

    private void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (this.in.contains("configDropins")) {
                IFolder dropinsFolder = this.server.getServerFolder().getFolder("configDropins");
                if (!dropinsFolder.exists()) {
                    dropinsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                if (!(dropinsFolder = dropinsFolder.getFolder(folder.getName())).exists()) {
                    dropinsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            } else {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

