/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.wizard.NewConfigDropinWizard;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IServer;

public class NewConfigDropinAction
extends SelectionProviderAction {
    private final Shell shell;
    private final DropinType type;
    private final StructuredViewer viewer;
    private WebSphereServerInfo server;

    public NewConfigDropinAction(DropinType type, ISelectionProvider selectionProvider, StructuredViewer viewer) {
        super(selectionProvider, type.getLabel());
        this.shell = viewer.getControl().getShell();
        this.type = type;
        this.viewer = viewer;
        this.setImageDescriptor(Activator.getImageDescriptor("configFile"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        this.server = null;
        for (Object obj : sel) {
            if (obj instanceof IServer) {
                IServer srv = (IServer)obj;
                WebSphereServer wsServer = (WebSphereServer)srv.loadAdapter(WebSphereServer.class, null);
                if (wsServer == null) continue;
                this.server = wsServer.getServerInfo();
                continue;
            }
            if (obj instanceof WebSphereServerInfo) {
                this.server = (WebSphereServerInfo)obj;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        if (this.server == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.isApplicable());
    }

    public boolean isApplicable() {
        if (this.server == null) {
            return false;
        }
        WebSphereRuntime runtime = this.server.getWebSphereRuntime();
        return runtime != null && WebSphereUtil.isGreaterOrEqualVersion((String)"8.5.5.6", (String)runtime.getRuntimeVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.server == null) {
            return;
        }
        String fileName = null;
        try {
            File f;
            IPath serverPath = this.server.getServerPath();
            IPath path = serverPath.append("configDropins").append(this.type.getFolder());
            NewConfigDropinWizard wizard = new NewConfigDropinWizard(path, this.type);
            WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
            dialog.setPageSize(200, 100);
            if (dialog.open() == 1) {
                return;
            }
            fileName = wizard.getFileName();
            IFile file = null;
            URI uri = null;
            IFolder serverFolder = this.server.getServerFolder();
            if (serverFolder != null) {
                IProject project = serverFolder.getProject();
                if (!project.isOpen() && !MessageDialog.openQuestion((Shell)this.shell, (String)Messages.title, (String)NLS.bind((String)Messages.confirmProjectOpen, (Object)project.getName()))) {
                    FileUtil.makeDir((IPath)path);
                    File f2 = WebSphereUtil.createFile((File)path.toFile(), (String)fileName, null);
                    uri = f2.toURI();
                    this.server.updateCache();
                } else {
                    IFolder dropinsFolder = serverFolder.getFolder("configDropins");
                    if (!dropinsFolder.exists()) {
                        dropinsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (!(dropinsFolder = dropinsFolder.getFolder(this.type.getFolder())).exists()) {
                        dropinsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    file = WebSphereUtil.createFile((IFolder)dropinsFolder, (String)fileName, null);
                    uri = file.getLocationURI();
                }
            } else {
                FileUtil.makeDir((IPath)path);
                f = WebSphereUtil.createFile((File)path.toFile(), (String)fileName, null);
                uri = f.toURI();
                this.server.updateCache();
            }
            if (file != null) {
                ByteArrayInputStream initialContent = new ByteArrayInputStream("<server>\n    \n</server>".getBytes());
                file.appendContents((InputStream)initialContent, true, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                f = new File(uri);
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(f);
                    outputStream.write("<server>\n    \n</server>".getBytes());
                }
                finally {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            Activator.openConfigurationEditor(file, uri);
            this.viewer.refresh((Object)this.server);
        }
        catch (Exception e) {
            Trace.logError((String)("Error creating new config dropins file: " + this.type.getFolder() + (fileName == null ? "" : "/" + fileName)), (Throwable)e);
        }
    }

    public static enum DropinType {
        DEFAULTS(Messages.newConfigDropinDefaults, "defaults", Messages.newConfigDropinWizardDefaultsTitle, Messages.newConfigDropinWizardDefaultsDesc),
        OVERRIDES(Messages.newConfigDropinOverrides, "overrides", Messages.newConfigDropinWizardOverridesTitle, Messages.newConfigDropinWizardOverridesDesc);

        private final String label;
        private final String folder;
        private final String title;
        private final String desc;

        private DropinType(String label, String folder, String title, String desc) {
            this.label = label;
            this.folder = folder;
            this.title = title;
            this.desc = desc;
        }

        public String getLabel() {
            return this.label;
        }

        public String getFolder() {
            return this.folder;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

