/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.actions.OpenMessagesAction;
import com.ibm.ws.st.ui.internal.actions.OpenTraceLogAction;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class LogActionProvider
extends CommonActionProvider {
    protected OpenMessagesAction openMessagesAction;
    protected OpenTraceLogAction openTraceLogAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        Shell shell = aSite.getViewSite().getShell();
        StructuredViewer selectionProvider = aSite.getStructuredViewer();
        this.openMessagesAction = new OpenMessagesAction((ISelectionProvider)selectionProvider, shell);
        this.openTraceLogAction = new OpenTraceLogAction((ISelectionProvider)selectionProvider, shell);
    }

    public void fillContextMenu(IMenuManager menu) {
        MenuManager openLogs = new MenuManager(Messages.menuOpenLogFiles, "OpenLogFiles");
        openLogs.add((IAction)this.openMessagesAction);
        File[] logFileList = this.openMessagesAction.getFileList();
        if (logFileList != null && logFileList.length > 0) {
            MenuManager subMenu = new MenuManager(Messages.menuPreviousMessageLogs);
            for (File currentFile : logFileList) {
                LocalFileAction logFileAction = new LocalFileAction(currentFile);
                subMenu.add((IAction)logFileAction);
            }
            openLogs.add((IContributionItem)subMenu);
        }
        openLogs.add((IAction)this.openTraceLogAction);
        File[] traceFileList = this.openTraceLogAction.getFileList();
        if (traceFileList != null && traceFileList.length > 0) {
            MenuManager subMenu = new MenuManager(Messages.menuPreviousTraceLogs);
            for (File currentFile : traceFileList) {
                LocalFileAction logFileAction = new LocalFileAction(currentFile);
                subMenu.add((IAction)logFileAction);
            }
            openLogs.add((IContributionItem)subMenu);
        }
        menu.appendToGroup("additions", (IContributionItem)openLogs);
    }

    private class LocalFileAction
    extends Action {
        private final File file;

        public String getText() {
            Path path = new Path(this.file.getPath());
            return path.lastSegment();
        }

        public LocalFileAction(File file) {
            this.file = file;
        }

        public void run() {
            Path path = new Path(this.file.getAbsolutePath());
            final IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
            Display.getDefault().asyncExec(new Runnable(){
                final /* synthetic */ IPath val$path;
                {
                    this.val$path = iPath;
                }

                @Override
                public void run() {
                    IWorkbenchPage page = null;
                    if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        page = window.getActivePage();
                    }
                    try {
                        if (page != null) {
                            IDE.openEditorOnFileStore(page, (IFileStore)fileStore);
                        }
                    }
                    catch (PartInitException e) {
                        Trace.logError("Error Opening " + this.val$path.toOSString(), e);
                    }
                }
            });
        }
    }
}

