/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.FeatureConflictHandler;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.MessageHandler;
import com.ibm.ws.st.core.internal.MissingKeystoreHandler;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PublishWithErrorHandler;
import com.ibm.ws.st.core.internal.RuntimeFeatureResolver;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.URILocation;
import com.ibm.ws.st.ui.internal.ErrorPageListener;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.PromptDialog;
import com.ibm.ws.st.ui.internal.PublishWithErrorDialog;
import com.ibm.ws.st.ui.internal.StorageEditorInput;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.AddSecurityElementsDialog;
import com.ibm.ws.st.ui.internal.config.FeatureConflictDialog;
import com.ibm.ws.st.ui.internal.config.FileConfigEditorInput;
import com.ibm.ws.st.ui.internal.config.FileStoreConfigEditorInput;
import com.ibm.ws.st.ui.internal.config.IConfigEditorInput;
import com.ibm.ws.st.ui.internal.merge.MergedConfigResourceListener;
import com.ibm.ws.st.ui.internal.merge.MergedEditorFileStorage;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.ws.st.ui";
    public static final String CONFIGURATION_EDITOR = "com.ibm.ws.st.ui.configuration.editor";
    private static final String CONFIGURATION_DOC_URL = "http://www14.software.ibm.com/webapp/wsbroker/redirect?version=cord&product=was-nd-dist&topic=cwlp_config";
    private static final String SCHEMA_BROWSER_ID = "wasSchema";
    private static final String DELIM = ",";
    private static final String TEXT_EDITOR = "org.eclipse.ui.DefaultTextEditor";
    private static final String EXPLORER_VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    private static Activator instance;
    protected Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();
    private static URL ICON_BASE_URL;
    private static final String URL_OBJ = "obj16/";
    private static final String URL_WIZBAN = "wizban/";
    public static final String IMG_CONFIG_FILE = "configFile";
    public static final String IMG_CONFIG_ELEMENT = "configElement";
    public static final String IMG_SERVER_CONFIG = "serverConfig";
    public static final String IMG_RUNTIME = "runtime";
    public static final String IMG_SERVER = "server";
    public static final String IMG_SERVER_FOLDER = "serverFolder";
    public static final String IMG_CONFIG_FOLDER = "configFolder";
    public static final String IMG_APP_FOLDER = "appFolder";
    public static final String IMG_WIZ_RUNTIME = "wizRuntime";
    public static final String IMG_WIZ_SERVER = "wizServer";
    public static final String IMG_REFRESH = "refresh";
    public static final String IMG_RELATIVE_PATH = "relativePath";
    public static final String IMG_ABSOLUTE_PATH = "absolutePath";
    public static final String IMG_USER_PROJECT = "userProject";
    public static final String IMG_USER_FOLDER = "userFolder";
    public static final String IMG_MENU_DOWN = "menuDown";
    public static final String IMG_BOOTSTRAP_PROPS = "bootstrap.properties";
    public static final String IMG_JVM_OPTIONS = "jvm.options";
    public static final String IMG_SERVER_ENV = "server.env";
    public static final String IMG_VARIABLE_REF = "variableRef";
    public static final String IMG_FEATURE_ELEMENT = "featureElement";
    public static final String IMG_FEATURE_SUPERSEDED = "featureSuperseded";
    public static final String IMG_FACTORY_REF = "factoryRef";
    public static final String IMG_ERROR_OVERLAY = "errorOverlay";
    public static final String IMG_IGNORE_FILTER = "ignoreFilter";
    public static final String IMG_WIZ_ADD_ON = "addOnWizard";
    public static final String IMG_ADD_ON = "addOn";
    public static final String IMG_ADD_ON_SAMPLE = "addOnSample";
    public static final String IMG_ADD_ON_FEATURE = "addOnFeature";
    public static final String IMG_ADD_ON_CONFIG_SNIPPET = "addOnConfigSnippet";
    public static final String IMG_ADD_ON_OPEN_SOURCE = "addOnOpenSource";
    public static final String IMG_ENUMERATOR = "enumerator";
    public static final String IMG_ENUMERATOR_DEFAULT = "enumeratorDefault";
    public static final String IMG_INFORMATION = "information";
    public static final String PUBLISH_WITH_ERROR = "publishWithError";
    public static final String IMG_LICENSE = "license";
    public static final String IMG_CONFIG_ELEM = "configElem";
    public static final String IMG_SECURITY_ELEM = "securityElem";
    public static final String IMG_INCLUDE_ELEM = "includeElem";
    public static final String IMG_FEATURES_ELEM = "featuresElem";
    public static final String IMG_APP_MONITOR_ELEM = "appMonitorElem";
    public static final String IMG_APP_MANAGER_ELEM = "appManagerElem";
    public static final String IMG_DATASOURCE_ELEM = "datasourceElem";
    public static final String IMG_LOGGING_ELEM = "loggingElem";
    public static final String IMG_VARIABLE_ELEM = "variableElem";
    public static final String IMG_SSL_ELEM = "sslElem";
    public static final String IMG_HTTP_ELEM = "httpElem";
    private boolean initComplete = false;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        Trace.ENABLED = this.isDebugging();
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)Trace.TS, props);
        ErrorPageListener epl = ErrorPageListener.getInstance();
        LaunchUtil.setErrorPage((String)(epl.getPort() + "/" + epl.hashCode()));
        Activator.addRequiredFeatureListener();
        MergedConfigResourceListener.start();
    }

    private static void addRequiredFeatureListener() {
        com.ibm.ws.st.core.internal.Activator.setPromptHandler((PromptHandler)new PromptHandler(){

            public IPromptResponse getResponse(final String message, final PromptHandler.AbstractPrompt[] prompts, final int style) {
                final PromptDialog[] dialog = new PromptDialog[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        dialog[0] = new PromptDialog(shell, message, prompts, style);
                        dialog[0].open();
                    }
                });
                if (dialog[0].getReturnCode() != 0) {
                    return null;
                }
                return dialog[0].getResponses();
            }

            public boolean handleConfirmPrompt(final String title, final String message, boolean defaultVal) {
                final boolean[] response = new boolean[]{defaultVal};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        response[0] = MessageDialog.openConfirm((Shell)shell, (String)title, (String)message);
                    }
                });
                return response[0];
            }
        });
        com.ibm.ws.st.core.internal.Activator.setFeatureConflictHandler((FeatureConflictHandler)new FeatureConflictHandler(){

            public boolean handleFeatureConflicts(WebSphereServerInfo wsServerInfo, Map<String, List<String>> requiredFeatures, Set<RuntimeFeatureResolver.FeatureConflict> conflicts, boolean quickFixMode) {
                return this.invokeDialog(wsServerInfo, null, null, requiredFeatures, conflicts, quickFixMode);
            }

            public boolean handleFeatureConflicts(WebSphereRuntime wsRuntime, ConfigurationFile file, Map<String, List<String>> requiredFeatures, Set<RuntimeFeatureResolver.FeatureConflict> conflicts, boolean quickFixMode) {
                return this.invokeDialog(null, wsRuntime, file, requiredFeatures, conflicts, quickFixMode);
            }

            private boolean invokeDialog(final WebSphereServerInfo wsServerInfo, final WebSphereRuntime wsRuntime, final ConfigurationFile configFile, final Map<String, List<String>> requiredFeatures, final Set<RuntimeFeatureResolver.FeatureConflict> conflicts, final boolean quickFixMode) {
                WebSphereServer wsServer;
                final FeatureConflictDialog[] dialog = new FeatureConflictDialog[1];
                final int[] response = new int[]{-1};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        dialog[0] = wsRuntime != null && configFile != null ? new FeatureConflictDialog(shell, wsRuntime, configFile, requiredFeatures, conflicts) : new FeatureConflictDialog(shell, wsServerInfo, requiredFeatures, conflicts);
                        dialog[0].setShowIgnoreButton(!quickFixMode);
                        response[0] = dialog[0].open();
                    }
                });
                if (wsServerInfo != null && (wsServer = WebSphereUtil.getWebSphereServer((WebSphereServerInfo)wsServerInfo)) != null) {
                    if (response[0] == 9) {
                        wsServer.saveIgnoredFeatureConflicts(dialog[0].getConflicts());
                    } else if (!quickFixMode || quickFixMode && dialog[0].getRemainingConflictsSize() == 0) {
                        wsServer.saveIgnoredFeatureConflicts(null);
                    }
                }
                if (dialog[0].getReturnCode() != 0) {
                    return false;
                }
                return dialog[0].isChanged();
            }
        });
        com.ibm.ws.st.core.internal.Activator.setMissingKeystoreHandler((MissingKeystoreHandler)new MissingKeystoreHandler(){

            public boolean handleMissingKeystore(final WebSphereServerInfo wsServerInfo, final boolean appSecurityEnabled) {
                final AddSecurityElementsDialog[] dialog = new AddSecurityElementsDialog[1];
                final int[] response = new int[]{-1};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        dialog[0] = new AddSecurityElementsDialog(shell, wsServerInfo, appSecurityEnabled);
                        response[0] = dialog[0].open();
                    }
                });
                return dialog[0].getReturnCode() == 0;
            }
        });
        com.ibm.ws.st.core.internal.Activator.setPublishWithErrorHandler((PublishWithErrorHandler)new PublishWithErrorHandler(){

            public boolean handlePublishWithError(final ArrayList<String> projectName, final WebSphereServer server) {
                final PublishWithErrorDialog[] dialog = new PublishWithErrorDialog[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        dialog[0] = new PublishWithErrorDialog(shell, projectName);
                        dialog[0].open();
                        this.setReturnCode(dialog[0].getReturnCode());
                        if (this.getReturnCode() == 0) {
                            IServerWorkingCopy wc = server.getServer().createWorkingCopy();
                            wc.setAttribute(Activator.PUBLISH_WITH_ERROR, dialog[0].getToggleState());
                            try {
                                wc.save(false, null);
                            }
                            catch (CoreException e) {
                                Trace.logError("Unable to save changes to Server", e);
                            }
                        }
                    }
                });
                return this.getReturnCode() == 0;
            }
        });
        com.ibm.ws.st.core.internal.Activator.setMessageHandler((MessageHandler)new MessageHandler(){

            public boolean handleMessage(final MessageHandler.MessageType type, final String title, final String message) {
                final Boolean[] answer = new Boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean result = false;
                        Shell shell = Display.getDefault().getActiveShell();
                        switch (type) {
                            case INFORMATION: {
                                result = MessageDialog.open((int)2, (Shell)shell, (String)title, (String)message, (int)0);
                                break;
                            }
                            case WARNING: {
                                result = MessageDialog.open((int)4, (Shell)shell, (String)title, (String)message, (int)0);
                                break;
                            }
                            case ERROR: {
                                result = MessageDialog.open((int)1, (Shell)shell, (String)title, (String)message, (int)0);
                            }
                        }
                        answer[0] = result ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return answer[0];
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        MergedConfigResourceListener.stop();
        com.ibm.ws.st.core.internal.Activator.setPromptHandler(null);
        instance = null;
        super.stop(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Activator getInstance() {
        Activator activator = instance;
        synchronized (activator) {
            if (!Activator.instance.initComplete) {
                Activator.instance.initComplete = true;
                PlatformUI.getWorkbench().getProgressService().registerIconForFamily(Activator.getImageDescriptor(IMG_RUNTIME), (Object)"com.ibm.ws.st.core.job.family");
            }
        }
        return instance;
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        block2: {
            try {
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
                registry.put(key, id);
                this.imageDescriptors.put(key, id);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block2;
                Trace.trace((byte)1, "Error registering image", e);
            }
        }
    }

    protected ImageRegistry createImageRegistry() {
        final ImageRegistry[] tempRegistryArray = new ImageRegistry[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                tempRegistryArray[0] = new ImageRegistry();
            }
        });
        ImageRegistry registry = tempRegistryArray[0];
        if (ICON_BASE_URL == null) {
            ICON_BASE_URL = instance.getBundle().getEntry("icons/");
        }
        this.registerImage(registry, IMG_CONFIG_FILE, "obj16/configurationFile.gif");
        this.registerImage(registry, IMG_CONFIG_ELEMENT, "obj16/configElement.gif");
        this.registerImage(registry, IMG_SERVER_CONFIG, "obj16/serverConfiguration.gif");
        this.registerImage(registry, IMG_RUNTIME, "obj16/liberty-was-lp-16.png");
        this.registerImage(registry, IMG_SERVER, "obj16/liberty-was-lp-16.png");
        this.registerImage(registry, IMG_SERVER_FOLDER, "obj16/serversFolder.gif");
        this.registerImage(registry, IMG_CONFIG_FOLDER, "obj16/sharedConfigFolder.gif");
        this.registerImage(registry, IMG_APP_FOLDER, "obj16/sharedAppsFolder.gif");
        this.registerImage(registry, IMG_WIZ_RUNTIME, "wizban/liberty-banner.png");
        this.registerImage(registry, IMG_WIZ_SERVER, "wizban/liberty-server-banner.png");
        this.registerImage(registry, IMG_REFRESH, "obj16/refresh.gif");
        this.registerImage(registry, IMG_RELATIVE_PATH, "obj16/relativePath.gif");
        this.registerImage(registry, IMG_ABSOLUTE_PATH, "obj16/absolutePath.gif");
        this.registerImage(registry, IMG_USER_PROJECT, "obj16/userProject.gif");
        this.registerImage(registry, IMG_USER_FOLDER, "obj16/serversFolder.gif");
        this.registerImage(registry, IMG_MENU_DOWN, "obj16/menuDown.gif");
        this.registerImage(registry, IMG_BOOTSTRAP_PROPS, "obj16/bootstrapPropertiesFile.gif");
        this.registerImage(registry, IMG_JVM_OPTIONS, "obj16/bootstrapPropertiesFile.gif");
        this.registerImage(registry, IMG_SERVER_ENV, "obj16/bootstrapPropertiesFile.gif");
        this.registerImage(registry, IMG_VARIABLE_REF, "obj16/variableRef.gif");
        this.registerImage(registry, IMG_FEATURE_ELEMENT, "obj16/featureElement.gif");
        this.registerImage(registry, IMG_FACTORY_REF, "obj16/factoryRef.gif");
        this.registerImage(registry, IMG_ERROR_OVERLAY, "obj16/error.gif");
        this.registerImage(registry, IMG_IGNORE_FILTER, "obj16/bootstrapProperties.gif");
        this.registerImage(registry, IMG_WIZ_ADD_ON, "wizban/liberty-addon-banner.png");
        this.registerImage(registry, IMG_ADD_ON, "obj16/addon-was-lpn-48.png");
        this.registerImage(registry, IMG_ADD_ON_SAMPLE, "obj16/addOnSample.png");
        this.registerImage(registry, IMG_ADD_ON_FEATURE, "obj16/addOnFeature.png");
        this.registerImage(registry, IMG_ADD_ON_CONFIG_SNIPPET, "obj16/addOnConfigSnippet.png");
        this.registerImage(registry, IMG_ADD_ON_OPEN_SOURCE, "obj16/addOnOpenSource.png");
        this.registerImage(registry, IMG_ENUMERATOR, "obj16/enum.gif");
        this.registerImage(registry, IMG_ENUMERATOR_DEFAULT, "obj16/enumDefault.gif");
        this.registerImage(registry, IMG_INFORMATION, "obj16/information.gif");
        this.registerImage(registry, IMG_LICENSE, "obj16/liberty-was-lp-16.png");
        this.registerImage(registry, IMG_CONFIG_ELEM, "obj16/configElement.gif");
        this.registerImage(registry, IMG_SECURITY_ELEM, "obj16/securityElement.gif");
        this.registerImage(registry, IMG_INCLUDE_ELEM, "obj16/includeElement.gif");
        this.registerImage(registry, IMG_FEATURES_ELEM, "obj16/featuresElement.gif");
        this.registerImage(registry, IMG_APP_MONITOR_ELEM, "obj16/appMonitorElement.gif");
        this.registerImage(registry, IMG_APP_MANAGER_ELEM, "obj16/applicationElement.gif");
        this.registerImage(registry, IMG_DATASOURCE_ELEM, "obj16/datasourceElement.gif");
        this.registerImage(registry, IMG_LOGGING_ELEM, "obj16/trace.gif");
        this.registerImage(registry, IMG_VARIABLE_ELEM, "obj16/variable.gif");
        this.registerImage(registry, IMG_SSL_ELEM, "obj16/sslElement.gif");
        this.registerImage(registry, IMG_HTTP_ELEM, "obj16/httpElement.gif");
        ImageDescriptor warn = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
        DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(registry.get(IMG_FEATURE_ELEMENT), warn, 2);
        registry.put(IMG_FEATURE_SUPERSEDED, (ImageDescriptor)decoratedImage);
        return registry;
    }

    public static Image getImage(String key) {
        return Activator.getInstance().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            Activator.getInstance().getImageRegistry();
            return Activator.getInstance().imageDescriptors.get(key);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Missing image", e);
            }
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static String getBundleVersion() {
        return Activator.getInstance().getBundle().getVersion().toString();
    }

    public static String getPreference(String key, String defaultValue) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).get(key, defaultValue);
    }

    public static boolean getPreferenceBoolean(String key, boolean defaultValue) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).getBoolean(key, defaultValue);
    }

    public static void setPreferenceBoolean(String key, boolean value) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            prefs.putBoolean(key, value);
            prefs.flush();
        }
        catch (Exception e) {
            Trace.logError("Error setting preference: " + key, e);
        }
    }

    public static void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        prefs.addPreferenceChangeListener(listener);
    }

    public static void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        prefs.removePreferenceChangeListener(listener);
    }

    public static List<String> getPreferenceList(String key) {
        String value = Activator.getPreference(key, null);
        if (value == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(5);
        StringTokenizer st = new StringTokenizer(value, DELIM);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static void setPreference(String key, String value) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            if (value == null) {
                prefs.remove(key);
            } else {
                prefs.put(key, value);
            }
            prefs.flush();
        }
        catch (Exception e) {
            Trace.logError("Error setting preference: " + key, e);
        }
    }

    public static void addToPreferenceList(String key, String value) {
        if (key == null || key.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        String previousLocations = Activator.getPreference(key, null);
        if (previousLocations == null) {
            Activator.setPreference(key, value);
            return;
        }
        ArrayList<String> list = new ArrayList<String>(4);
        list.add(value);
        StringTokenizer st = new StringTokenizer(previousLocations, DELIM);
        for (int count = 0; st.hasMoreTokens() && count < 4; ++count) {
            String s = st.nextToken();
            if (list.contains(s)) continue;
            list.add(s);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(DELIM);
            }
            sb.append(s);
        }
        Activator.setPreference(key, sb.toString());
    }

    public static IEditorPart openConfigurationEditor(IFile file, final URI uri, String xpath) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = null;
        try {
            IConfigEditorInput editorInput = null;
            if (file != null && file.isAccessible()) {
                editorInput = new FileConfigEditorInput(file, file.getLocation().toFile().toURI(), xpath);
            } else {
                if (file != null && !Activator.externalEditorConfirmation()) {
                    return null;
                }
                editorInput = new FileStoreConfigEditorInput(EFS.getStore((URI)uri), xpath);
            }
            IEditorReference[] editors = page.getEditorReferences();
            if (editors != null) {
                for (IEditorReference ref : editors) {
                    if (!ref.getEditorInput().equals(editorInput)) continue;
                    editorPart = ref.getEditor(true);
                    if (xpath != null && editorPart instanceof DDEMultiPageEditorPart) {
                        ((DDEMultiPageEditorPart)editorPart).setSelection(xpath, null);
                    }
                    page.activate((IWorkbenchPart)editorPart);
                    return editorPart;
                }
            }
            editorPart = page.openEditor((IEditorInput)editorInput, CONFIGURATION_EDITOR, true);
            if (file == null || !file.isAccessible()) {
                final File f = new File(uri);
                final long[] lastModified = new long[]{f.lastModified()};
                editorPart.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object arg0, int arg1) {
                        long newLastModified = f.lastModified();
                        if (newLastModified != lastModified[0]) {
                            WebSphereServerInfo[] servers;
                            lastModified[0] = newLastModified;
                            for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
                                ConfigurationFile configFile = server.getConfigurationFileFromURI(uri);
                                if (configFile == null) continue;
                                server.updateCache();
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Trace.logError("Error opening editor for " + (file != null && file.isAccessible() ? file.getLocationURI() : uri), e);
        }
        return editorPart;
    }

    public static IEditorPart openEditor(IFile file, URI uri) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = null;
        try {
            FileEditorInput editorInput = null;
            if (file != null && file.isAccessible()) {
                editorInput = new FileEditorInput(file);
            } else {
                if (file != null && !Activator.externalEditorConfirmation()) {
                    return null;
                }
                editorInput = new FileStoreEditorInput(EFS.getStore((URI)uri));
            }
            IEditorReference[] editors = page.getEditorReferences();
            if (editors != null) {
                for (IEditorReference ref : editors) {
                    if (!ref.getEditorInput().equals(editorInput)) continue;
                    editorPart = ref.getEditor(true);
                    page.activate((IWorkbenchPart)editorPart);
                    return editorPart;
                }
            }
            editorPart = page.openEditor((IEditorInput)editorInput, TEXT_EDITOR, true);
        }
        catch (Exception e) {
            Trace.logError("Error opening editor for " + (file != null && file.isAccessible() ? file.getLocationURI() : uri), e);
        }
        return editorPart;
    }

    public static IEditorPart openConfigurationEditor(IFile file, URI uri) {
        return Activator.openConfigurationEditor(file, uri, null);
    }

    public static IEditorPart openEditor(DocumentLocation location) {
        if (location.isConfigFile()) {
            return Activator.openConfigurationEditor(location.getFile(), location.getURI(), location.getXPath());
        }
        return Activator.openEditor(location.getFile(), location.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void goToLocation(IEditorPart editorPart, DocumentLocation location) {
        if (editorPart == null || location == null) {
            return;
        }
        IFile file = location.getFile();
        if (file != null && (location.getLine() != -1 || location.getStartOffset() != -1)) {
            IMarker marker = null;
            try {
                marker = file.createMarker("org.eclipse.core.resources.marker");
                if (location.getLine() != -1) {
                    marker.setAttribute("lineNumber", location.getLine());
                }
                if (location.getStartOffset() != -1) {
                    marker.setAttribute("charStart", location.getStartOffset());
                    if (location.getEndOffset() != -1) {
                        marker.setAttribute("charEnd", location.getEndOffset());
                    }
                }
                IDE.gotoMarker((IEditorPart)editorPart, (IMarker)marker);
            }
            catch (CoreException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Failed to create marker for: " + file.getFullPath().toString(), e);
                }
            }
            finally {
                block19: {
                    if (marker != null) {
                        try {
                            marker.delete();
                        }
                        catch (CoreException e) {
                            if (!Trace.ENABLED) break block19;
                            Trace.trace((byte)1, "Failed to delete marker.", e);
                        }
                    }
                }
            }
        }
    }

    public static void open(URILocation location) {
        if (location instanceof DocumentLocation) {
            Activator.openEditor((DocumentLocation)location);
        } else {
            IResource resource = location.getResource();
            if (resource != null) {
                Activator.showResource(resource);
            } else {
                Activator.showExternalFile(location.getURI());
            }
        }
    }

    public static void showResource(IResource resource) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart part = page.findView(EXPLORER_VIEW_ID);
            if (part == null) {
                try {
                    part = page.showView(EXPLORER_VIEW_ID);
                }
                catch (PartInitException e) {
                    Trace.logError("Could not open the project explorer view", e);
                }
            }
            if (part != null) {
                page.activate((IWorkbenchPart)part);
                CommonNavigator view = (CommonNavigator)part.getAdapter(CommonNavigator.class);
                if (view != null) {
                    view.setFocus();
                    view.selectReveal((ISelection)new StructuredSelection((Object)resource));
                }
            }
        }
    }

    public static void showExternalFile(URI uri) {
        File file = new File(uri);
        try {
            Desktop.getDesktop().open(file);
        }
        catch (IOException e) {
            Trace.logError("Error opening file " + file.toString(), e);
        }
    }

    public static void openMergedConfiguration(URI uri) {
        ConfigurationFile config = Activator.getConfigFile(uri);
        if (config == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.errorDialogTitleOpenMergedView, (String)Messages.errorDialogMessageOpenMergedView);
            Trace.logError("Error opening merged editor - no configuration file for: " + uri, null);
            return;
        }
        IFile fileResource = config.getIFile();
        if (fileResource == null) {
            Trace.logError("Error opening merged editor - no IFile for: " + uri, null);
        }
        try {
            IPath filePath = ConfigUtils.getMergedConfigLocation((IResource)fileResource);
            if (filePath == null) {
                Trace.logError("Error opening merged editor - could not determine location for: " + uri, null);
                return;
            }
            File file = filePath.toFile();
            if (file.exists()) {
                if (!file.delete()) {
                    Trace.logError("Failed to delete existing merged configuration file: " + file.getPath(), null);
                    return;
                }
            } else {
                IPath dirPath = filePath.removeLastSegments(1);
                File dir = dirPath.toFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    Trace.logError("Failed to create directory " + file.getPath() + " for writing merged configuration.", null);
                    return;
                }
            }
            config.flatten(file);
            file.setReadOnly();
            String name = NLS.bind((String)Messages.mergedEditorTitle, (Object)config.getName());
            MergedEditorFileStorage store = new MergedEditorFileStorage(file, name);
            StorageEditorInput storageInput = new StorageEditorInput((IStorage)store, file.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            page.openEditor((IEditorInput)storageInput, CONFIGURATION_EDITOR, true);
        }
        catch (Throwable t) {
            Trace.logError("Error opening merged editor for: " + uri, t);
        }
    }

    private static ConfigurationFile getConfigFile(URI uri) {
        block5: {
            ConfigurationFile configFile = ConfigUtils.getConfigFile((URI)uri);
            if (configFile != null) {
                return configFile;
            }
            configFile = ConfigUtils.getMappedConfigFile((URI)uri);
            if (configFile != null) {
                return configFile;
            }
            UserDirectory userDir = ConfigUtils.getUserDirectory((URI)uri);
            if (userDir != null) {
                try {
                    return new ConfigurationFile(uri, userDir);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block5;
                    Trace.trace((byte)1, "Failed to create configuration file for: " + uri);
                }
            }
        }
        return null;
    }

    public static void openSchemaBrowser(URI uri) {
        try {
            URL url = new URL(CONFIGURATION_DOC_URL);
            IWorkbenchBrowserSupport bs = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser b = bs.createBrowser(32, SCHEMA_BROWSER_ID, Messages.configSchemaBrowserName, Messages.configSchemaBrowserToolTip);
            b.openURL(url);
        }
        catch (Exception e) {
            Trace.logError("Error opening schema browser", e);
        }
    }

    private static boolean externalEditorConfirmation() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return MessageDialog.openQuestion((Shell)shell, (String)Messages.title, (String)Messages.openEditorOnExternalFile);
    }
}

