/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.ws.kernel.feature.internal.util.LazySupplier;
import com.ibm.ws.kernel.feature.internal.util.VerifyDelta;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VerifyData {
    public final List<VerifyCase> cases;

    public VerifyData add(VerifyData other) {
        Map<String, VerifyCase> mappedCases = this.mapCases();
        Map<String, VerifyCase> otherMappedCases = other.mapCases();
        mappedCases.putAll(otherMappedCases);
        return new VerifyData(mappedCases.values());
    }

    public VerifyData splice(VerifyData output) {
        int outputSize;
        Map<String, VerifyCase> inputCases = this.mapCases();
        Map<String, VerifyCase> outputCases = output.mapCases();
        int inputSize = inputCases.size();
        int maxCases = inputSize > (outputSize = outputCases.size()) ? inputSize : outputSize;
        HashMap<String, VerifyCase> mergedCases = new HashMap<String, VerifyCase>(maxCases);
        for (Map.Entry<String, VerifyCase> inputEntry : inputCases.entrySet()) {
            VerifyCase mergedCase;
            String inputKey = inputEntry.getKey();
            VerifyCase inputCase = inputEntry.getValue();
            VerifyCase outputCase = outputCases.get(inputKey);
            if (outputCase == null) {
                System.out.println("Stubbing [ " + inputCase.name + " ]: No output case");
                mergedCase = inputCase;
            } else {
                mergedCase = inputCase.splice(outputCase);
            }
            mergedCases.put(inputKey, mergedCase);
        }
        return new VerifyData(mergedCases.values());
    }

    public VerifyData() {
        this.cases = new ArrayList<VerifyCase>();
    }

    public VerifyData(Collection<? extends LazySupplier<VerifyCase>> cases) {
        this.cases = new ArrayList<VerifyCase>(cases.size());
        for (LazySupplier<VerifyCase> lazySupplier : cases) {
            this.cases.add(lazySupplier.supply());
        }
    }

    public List<? extends VerifyCase> getCases() {
        return this.cases;
    }

    public Map<String, VerifyCase> mapCases() {
        LinkedHashMap<String, VerifyCase> mappedCases = new LinkedHashMap<String, VerifyCase>(this.cases.size());
        StringBuilder keyBuilder = new StringBuilder();
        for (VerifyCase verifyCase : this.cases) {
            String caseKey = verifyCase.asKey(keyBuilder);
            VerifyCase priorCase = mappedCases.put(caseKey, verifyCase);
            if (priorCase == null) continue;
            System.out.println("ERROR: Key duplication [ " + caseKey + " ]");
        }
        return mappedCases;
    }

    private static void append(StringBuilder builder, String text, char sep) {
        if (builder.length() != 0) {
            builder.append(sep);
        }
        builder.append(text);
    }

    public VerifyCase addCase(String name, String description, boolean isMultiple) {
        VerifyCase verifyCase = new VerifyCase(name, description, isMultiple);
        this.cases.add(verifyCase);
        return verifyCase;
    }

    public VerifyCase addCase() {
        VerifyCase verifyCase = new VerifyCase();
        this.cases.add(verifyCase);
        return verifyCase;
    }

    public void addCase(VerifyCase verifyCase) {
        this.cases.add(verifyCase);
    }

    public static long getTimeNs() {
        return System.nanoTime();
    }

    public static class VerifyCase
    implements LazySupplier<VerifyCase> {
        public String name;
        public String description;
        public long durationNs;
        public final VerifyInput input;
        public final VerifyOutput output;

        public VerifyCase() {
            this.input = new VerifyInput();
            this.output = new VerifyOutput();
        }

        public VerifyCase(String name, String description, boolean isMultiple) {
            this.name = name;
            this.description = description;
            this.input = new VerifyInput(isMultiple);
            this.output = new VerifyOutput();
        }

        public VerifyCase(VerifyCase inputCase, FeatureResolver.Result result, long durationNs) {
            this.name = inputCase.name;
            this.description = inputCase.description;
            this.durationNs = durationNs;
            this.input = inputCase.input.copy();
            this.output = new VerifyOutput(result);
        }

        public void setDurationNs(long durationNs) {
            this.durationNs = durationNs;
        }

        public String asKey(StringBuilder keyBuilder) {
            char spaceSep = ' ';
            char colonSep = ':';
            if (this.input.isMultiple) {
                VerifyData.append(keyBuilder, "Multiple", spaceSep);
            }
            if (!this.input.kernel.isEmpty()) {
                VerifyData.append(keyBuilder, "Kernel", spaceSep);
                for (String string : this.input.kernel) {
                    VerifyData.append(keyBuilder, string, colonSep);
                }
            }
            if (!this.input.roots.isEmpty()) {
                VerifyData.append(keyBuilder, "Roots", spaceSep);
                for (String string : this.input.roots) {
                    VerifyData.append(keyBuilder, string, colonSep);
                }
            }
            if (!this.input.platforms.isEmpty()) {
                VerifyData.append(keyBuilder, "Platforms", spaceSep);
                for (String string : this.input.platforms) {
                    VerifyData.append(keyBuilder, string, colonSep);
                }
            }
            if (!this.input.envMap.isEmpty()) {
                VerifyData.append(keyBuilder, "Environment", spaceSep);
                for (Map.Entry entry : this.input.envMap.entrySet()) {
                    VerifyData.append(keyBuilder, (String)entry.getKey(), colonSep);
                    VerifyData.append(keyBuilder, (String)entry.getValue(), colonSep);
                }
            }
            String key = keyBuilder.toString();
            keyBuilder.setLength(0);
            return key;
        }

        public void kernelAdjust(boolean usedKernel, Set<String> altResolved, boolean altUsedKernel) {
            VerifyDelta.kernelAdjust(this, usedKernel, altResolved, altUsedKernel);
        }

        @Override
        public VerifyCase produce() {
            return this;
        }

        @Override
        public VerifyCase supply() {
            return this;
        }

        @Override
        public VerifyCase getSupplied() {
            return this;
        }

        public VerifyCase splice(VerifyCase other) {
            return new VerifyCase(this, other);
        }

        public VerifyCase(VerifyCase thisCase, VerifyCase otherCase) {
            this.name = thisCase.name;
            this.description = thisCase.description;
            this.input = thisCase.input.copy();
            this.output = otherCase.output.copy();
        }
    }

    public static class VerifyOutput {
        public EnumMap<ResultData, List<String>> resultData = new EnumMap(ResultData.class);
        public Map<String, String> versionlessResolved = new HashMap<String, String>();
        public final List<String> kernelOnly = new ArrayList<String>();
        public final List<String> kernelBlocked = new ArrayList<String>();

        public VerifyOutput() {
        }

        public VerifyOutput copy() {
            return new VerifyOutput(this);
        }

        public VerifyOutput(VerifyOutput other) {
            for (ResultData valueType : ResultData.values()) {
                if (valueType == ResultData.FEATURE_VERSIONLESS_RESOLVED) {
                    this.putAllVersionlessResolved(other.getVersionlessResolved());
                    continue;
                }
                this.addAll(valueType, other.get(valueType));
            }
        }

        public List<String> get(ResultData dataType) {
            List<String> result = this.resultData.get((Object)dataType);
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }

        public void add(ResultData dataType, String value) {
            List<String> values = this.resultData.get((Object)dataType);
            if (values == null) {
                values = new ArrayList<String>();
                this.resultData.put(dataType, values);
            }
            values.add(value);
        }

        public void addAll(ResultData dataType, Collection<String> newValues) {
            List<String> values = this.resultData.get((Object)dataType);
            if (values == null) {
                values = new ArrayList<String>(newValues.size());
                this.resultData.put(dataType, values);
            }
            values.addAll(newValues);
        }

        public void addResolved(String feature) {
            this.add(ResultData.FEATURE_RESOLVED, feature);
        }

        public List<String> getResolved() {
            return this.get(ResultData.FEATURE_RESOLVED);
        }

        public Map<String, String> getVersionlessResolved() {
            return this.versionlessResolved;
        }

        public void putVersionlessResolved(String versionless, String versioned) {
            this.versionlessResolved.put(versionless, versioned);
        }

        public void putAllVersionlessResolved(Map<String, String> resolved) {
            for (Map.Entry<String, String> resolvedEntry : resolved.entrySet()) {
                System.out.println("Versionless resolution [ " + resolvedEntry.getKey() + "=" + resolvedEntry.getValue() + " ]");
            }
            this.versionlessResolved.putAll(resolved);
        }

        public String getVersionlessResolved(String versionless) {
            return this.versionlessResolved.get(versionless);
        }

        public void addKernelOnly(String feature) {
            this.kernelOnly.add(feature);
        }

        public void addKernelBlocked(String feature) {
            this.kernelBlocked.add(feature);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            sb.append("VerifyOutput [");
            for (ResultData valueType : ResultData.values()) {
                if (valueType == ResultData.FEATURE_VERSIONLESS_RESOLVED) {
                    this.list(sb, valueType.description, this.getVersionlessResolved());
                    continue;
                }
                this.list(sb, valueType.description, this.get(valueType));
            }
            this.list(sb, "Kernel only", this.kernelOnly);
            this.list(sb, "Kernel Blocked", this.kernelBlocked);
            sb.append(']');
            sb.append('\n');
            return sb.toString();
        }

        protected void list(StringBuilder sb, String description, Collection<?> values) {
            if (values.isEmpty()) {
                return;
            }
            sb.append('\n');
            sb.append(description);
            sb.append(':');
            sb.append('\n');
            for (Object value : values) {
                sb.append(value);
                sb.append('\n');
            }
        }

        protected void list(StringBuilder sb, String description, Map<?, ?> map) {
            if (map.isEmpty()) {
                return;
            }
            sb.append('\n');
            sb.append(description);
            sb.append(':');
            sb.append('\n');
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue());
                sb.append('\n');
            }
        }

        public VerifyOutput(FeatureResolver.Result result) {
            this();
            this.copy(result);
        }

        public void copy(FeatureResolver.Result result) {
            this.addAll(ResultData.PLATFORM_RESOLVED, result.getResolvedPlatforms());
            this.addAll(ResultData.PLATFORM_MISSING, result.getMissingPlatforms());
            for (Set<String> platforms : result.getDuplicatePlatforms().values()) {
                this.addAll(ResultData.PLATFORM_DUPLICATE, platforms);
            }
            this.putAllVersionlessResolved(result.getVersionlessFeatures());
            for (Set<String> versionlessFeatures : result.getNoPlatformVersionless().values()) {
                this.addAll(ResultData.FEATURE_VERSIONLESS_NO_PLATFORM, versionlessFeatures);
            }
            this.addAll(ResultData.FEATURE_RESOLVED, result.getResolvedFeatures());
            this.addAll(ResultData.FEATURE_MISSING, result.getMissing());
            this.addAll(ResultData.FEATURE_NON_PUBLIC, result.getNonPublicRoots());
            this.addAll(ResultData.FEATURE_WRONG_PROCESS, result.getWrongProcessTypes().keySet());
            this.addAll(ResultData.FEATURE_CONFLICT, result.getConflicts().keySet());
        }
    }

    public static enum ResultData {
        PLATFORM_RESOLVED("Resolved platforms"),
        PLATFORM_MISSING("Missing platforms"),
        PLATFORM_DUPLICATE("Conflicted platforms"),
        FEATURE_VERSIONLESS_RESOLVED("Versionless feature resolutions"),
        FEATURE_VERSIONLESS_NO_PLATFORM("Versionless features without platforms"),
        FEATURE_RESOLVED("Resolved features"),
        FEATURE_MISSING("Missing features"),
        FEATURE_NON_PUBLIC("Non-public features"),
        FEATURE_WRONG_PROCESS("Wrong process type features"),
        FEATURE_CONFLICT("Conflicted features");

        public final String description;

        private ResultData(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class VerifyInput {
        public boolean isMultiple = false;
        public final List<String> kernel = new ArrayList<String>();
        public final List<String> roots = new ArrayList<String>();
        public final List<String> platforms = new ArrayList<String>();
        public final Map<String, String> envMap = new HashMap<String, String>();

        public VerifyInput(boolean isMultiple) {
            this();
            this.isMultiple = isMultiple;
        }

        public VerifyInput() {
        }

        public void addKernel(Collection<String> features) {
            this.kernel.addAll(features);
        }

        public void addRoots(Collection<String> newRoots) {
            this.roots.addAll(newRoots);
        }

        public void putEnv(Map<String, String> newEnv) {
            this.envMap.putAll(newEnv);
        }

        public void addKernel(String feature) {
            this.kernel.add(feature);
        }

        public void addRoot(String name) {
            this.roots.add(name);
        }

        public void addPlatForms(Collection<String> newPlatforms) {
            this.platforms.addAll(newPlatforms);
        }

        public void addPlatform(String name) {
            this.platforms.add(name);
        }

        public void putEnv(String name, String value) {
            this.envMap.put(name, value);
        }

        public void putAllEnv(Map<String, String> map) {
            this.envMap.putAll(map);
        }

        public void putEnvironment(String name, String value) {
            this.envMap.put(name, value);
        }

        public void putAllEnvironment(Map<String, String> map) {
            this.envMap.putAll(map);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            sb.append("VerifyInput [");
            sb.append('\n');
            sb.append('\n');
            if (this.isMultiple) {
                sb.append("Multiple");
                sb.append('\n');
            }
            sb.append('\n');
            sb.append("Kernel features:");
            sb.append('\n');
            for (String string : this.kernel) {
                sb.append(string + "\n");
            }
            sb.append("\nRoot features:\n");
            for (String string : this.roots) {
                sb.append(string);
                sb.append('\n');
            }
            sb.append('\n');
            sb.append("Platforms:");
            sb.append('\n');
            for (String string : this.platforms) {
                sb.append(string);
                sb.append('\n');
            }
            sb.append('\n');
            sb.append("Environment:");
            sb.append('\n');
            for (Map.Entry entry : this.envMap.entrySet()) {
                sb.append((String)entry.getKey());
                sb.append('=');
                sb.append((String)entry.getValue());
                sb.append('\n');
            }
            sb.append(']');
            sb.append('\n');
            return sb.toString();
        }

        public VerifyInput copy() {
            return new VerifyInput(this);
        }

        public VerifyInput(VerifyInput other) {
            this(other.isMultiple);
            this.addKernel(other.kernel);
            this.addRoots(other.roots);
            this.addPlatForms(other.platforms);
            this.putAllEnvironment(other.envMap);
        }
    }
}

