/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.servertype;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.util.SocketUtil;

public abstract class AbstractServerExtension {
    public String[] getServiceInfoKeys() {
        return new String[0];
    }

    public void cleanup(IServer server) {
        ILaunch l = server.getLaunch();
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        if (l != null && lm != null) {
            lm.removeLaunch(l);
        }
    }

    public String getServerDisplayName(IServer server) {
        return server.getName();
    }

    public String getBaseURL(IServer server, int port) {
        String hostAddress = server.getHost();
        return this.getBaseURL(server, hostAddress, port);
    }

    protected String getBaseURL(IServer server, String host, int port) {
        StringBuilder sb = new StringBuilder("http://");
        if (host != null && host.contains(":")) {
            sb.append("[" + host + "]");
        } else {
            sb.append(host);
        }
        int port2 = ServerUtil.getMonitoredPort((IServer)server, (int)port, (String)"web");
        if (port2 != 80) {
            sb.append(":");
            sb.append(port2);
        }
        return sb.toString();
    }

    public boolean requiresRemoteStartSettings(IServer server) {
        return !SocketUtil.isLocalhost((String)server.getHost());
    }

    public String getConnectionPort(IServer server, String port) {
        return port;
    }

    public String getConnectionHost(IServer server, String host, String port) {
        return host;
    }

    public IStatus preModifyModules(IServer server, IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public Boolean isLocalSetup(IServer server) {
        return null;
    }

    public void serverConfigChanged(IServer server, IProgressMonitor monitor) {
    }
}

