/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.APIVisibility;
import com.ibm.ws.st.core.internal.OutOfSyncModuleInfo;
import com.ibm.ws.st.core.internal.ServerExtension;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.jee.core.internal.SharedLibertyUtils;
import com.ibm.ws.st.jee.core.internal.UtilitySharedLibInfo;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;

public class SharedLibServerExtension
extends ServerExtension {
    private static final String JST_UTILITY = "jst.utility";

    public IStatus canAddModule(IModule module) {
        if (SharedLibertyUtils.isValidSharedLibrary(module)) {
            return Status.OK_STATUS;
        }
        return null;
    }

    public IModule[] getChildModules(IModule[] module) {
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if (SharedLibertyUtils.isValidSharedLibrary(module)) {
            return new IModule[]{module};
        }
        return new IModule[0];
    }

    public boolean modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        UtilitySharedLibInfo settings;
        ConfigurationFile config = this.getWebSphereServer().getConfiguration();
        for (IModule module : add) {
            if (!SharedLibertyUtils.isSharedLibrary(module)) continue;
            settings = SharedLibertyUtils.getUtilPrjSharedLibInfo(module.getProject());
            config.addSharedLibrary(settings.getLibId(), settings.getLibDir(), module.getName() + ".jar", APIVisibility.getAPIVisibilityFromProperties((Properties)settings));
        }
        for (IModule module : remove) {
            if (!SharedLibertyUtils.isSharedLibrary(module)) continue;
            settings = SharedLibertyUtils.getUtilPrjSharedLibInfo(module.getProject());
            config.removeSharedLibrary(settings.getLibId(), settings.getLibDir(), module.getName() + ".jar");
            if (module.getProject() == null || module.getProject().getLocation() != null) continue;
            SharedLibertyUtils.removeSharedLibInfo(module.getProject());
        }
        return true;
    }

    public boolean isPublishRequired(IModule[] modules, IResourceDelta delta) {
        if (modules.length == 0) {
            return false;
        }
        WebSphereServerBehaviour behaviour = (WebSphereServerBehaviour)this.getServer().loadAdapter(WebSphereServerBehaviour.class, null);
        if (behaviour == null) {
            return true;
        }
        boolean inPublishedModules = false;
        for (IModule module : modules) {
            List modulesOnServer = behaviour.getPublishedModules();
            for (IModule[] pModule : modulesOnServer) {
                String id;
                if (pModule.length != 1 || !JST_UTILITY.equals(id = pModule[0].getModuleType().getId()) || !module.equals(pModule[0]) || !SharedLibertyUtils.isSharedLibrary(module)) continue;
                inPublishedModules = true;
                break;
            }
            if (inPublishedModules) break;
        }
        if (!inPublishedModules) {
            return false;
        }
        boolean looseConfig = this.getWebSphereServer().getServer().getAttribute("looseConfig", false);
        if (!looseConfig) {
            return true;
        }
        if (delta.getFullPath().segmentCount() >= 2) {
            IPath path = delta.getFullPath();
            if (path.segment(1).equalsIgnoreCase(".settings")) {
                if (delta.getFullPath().segmentCount() >= 3) {
                    return path.segment(2).equalsIgnoreCase("org.eclipse.wst.common.component");
                }
                return false;
            }
            if (path.segment(1).equalsIgnoreCase(".apt_generated")) {
                return false;
            }
        }
        return !"debug".equals(this.getWebSphereServer().getServer().getMode());
    }

    public boolean canRestartModule(IModule[] module) {
        return false;
    }

    public OutOfSyncModuleInfo checkModuleConfigOutOfSync(IModule module) {
        if (SharedLibertyUtils.isSharedLibrary(module)) {
            ConfigurationFile configFile = this.getConfiguration();
            String[] ids = configFile.getSharedLibraryIds();
            String sharedLibId = SharedLibertyUtils.getUtilPrjSharedLibInfo(module.getProject()).getLibId();
            for (String id : ids) {
                if (!id.equals(sharedLibId)) continue;
                return null;
            }
            return new OutOfSyncModuleInfo(OutOfSyncModuleInfo.Type.SHARED_LIB_ENTRY_MISSING);
        }
        return null;
    }
}

