/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.viewers;

import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.data.AtomicAttributeDetailItem;
import com.ibm.xwt.dde.internal.data.AtomicDetailItem;
import com.ibm.xwt.dde.internal.data.AtomicElementDetailItem;
import com.ibm.xwt.dde.internal.data.DetailItem;
import com.ibm.xwt.dde.internal.data.RepeatableAtomicDetailItemSet;
import com.ibm.xwt.dde.internal.data.SimpleDetailItem;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DetailsContentProvider {
    private CustomizationManager.Customization customization;
    private boolean doSchemaSort = false;

    public DetailsContentProvider(CustomizationManager.Customization customization) {
        this.customization = customization;
    }

    public DetailItem[] getItems(Object input) {
        CMElementDeclaration cmElementDeclaration;
        Element element;
        ModelQuery modelQuery;
        if (input instanceof Element && (modelQuery = ModelQueryUtil.getModelQuery((Document)(element = (Element)input).getOwnerDocument())) != null && (cmElementDeclaration = modelQuery.getCMElementDeclaration(element)) != null) {
            return this.getDetailItemsForElement(element, cmElementDeclaration, true);
        }
        return new DetailItem[0];
    }

    public void setSchemaSort(boolean doSchemaSort) {
        this.doSchemaSort = doSchemaSort;
    }

    private DetailItem[] getDetailItemsForElement(Element elementOrParentElement, CMElementDeclaration cmElementDeclaration, boolean elementExists) {
        ArrayList<AtomicDetailItem> detailItems = new ArrayList<AtomicDetailItem>();
        CMNamedNodeMap attributes = cmElementDeclaration.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            CMAttributeDeclaration cmAttributeDelcaration = (CMAttributeDeclaration)attributes.item(i);
            AtomicAttributeDetailItem atomicAttributeDetailItem = null;
            String attributeNamespace = ModelUtil.getNamespaceURI((CMNode)cmAttributeDelcaration);
            String attributePath = null;
            if (elementExists) {
                atomicAttributeDetailItem = new AtomicAttributeDetailItem(elementOrParentElement, cmAttributeDelcaration);
                attributePath = ModelUtil.getNodeFullPath(elementOrParentElement, (CMNode)cmAttributeDelcaration);
            } else {
                atomicAttributeDetailItem = new AtomicAttributeDetailItem(elementOrParentElement, cmElementDeclaration, cmAttributeDelcaration);
                attributePath = ModelUtil.getNodeFullPath(elementOrParentElement, cmElementDeclaration, (CMNode)cmAttributeDelcaration);
            }
            DetailItemCustomization detailItemCustomization = null;
            if (this.customization != null) {
                detailItemCustomization = this.customization.getItemCustomization(attributeNamespace, attributePath);
            }
            if (detailItemCustomization == null && this.customization != null) {
                detailItemCustomization = this.customization.getTypeCustomizationConsideringUnions((CMNode)cmAttributeDelcaration, attributePath);
            }
            if (detailItemCustomization != null && detailItemCustomization.isHidden()) continue;
            atomicAttributeDetailItem.setDetailItemCustomization(detailItemCustomization);
            detailItems.add(atomicAttributeDetailItem);
        }
        if (cmElementDeclaration.getContentType() == 4 || cmElementDeclaration.getContentType() == 3) {
            AtomicElementDetailItem atomicElementDetailItem = null;
            String elementNamespace = ModelUtil.getNamespaceURI((CMNode)cmElementDeclaration);
            String elementPath = null;
            if (elementExists) {
                atomicElementDetailItem = new AtomicElementDetailItem(elementOrParentElement);
                elementPath = ModelUtil.getElementFullPath(elementOrParentElement) + "/.";
            } else {
                atomicElementDetailItem = new AtomicElementDetailItem(elementOrParentElement, cmElementDeclaration);
                elementPath = ModelUtil.getNodeFullPath(elementOrParentElement, (CMNode)cmElementDeclaration) + "/.";
            }
            DetailItemCustomization detailItemCustomization = null;
            if (this.customization != null) {
                detailItemCustomization = this.customization.getItemCustomization(elementNamespace, elementPath);
            }
            if (detailItemCustomization == null || !detailItemCustomization.isHidden()) {
                atomicElementDetailItem.setDetailItemCustomization(detailItemCustomization);
                detailItems.add(atomicElementDetailItem);
            }
        }
        ElementContentVisitor visitor = null;
        visitor = elementExists ? new ElementContentVisitor(elementOrParentElement, this.customization) : new ElementContentVisitor(elementOrParentElement, cmElementDeclaration, this.customization);
        visitor.visitCMNode((CMNode)cmElementDeclaration.getContent());
        detailItems.addAll(visitor.getResult());
        if (this.doSchemaSort) {
            XSDElementDeclaration elemDecl;
            XSDTypeDefinition typeDefinition;
            XSDImpl.XSDElementDeclarationAdapter adapter;
            Notifier target;
            ArrayList schemaOrderedDetailItems = new ArrayList();
            if (cmElementDeclaration instanceof XSDImpl.XSDElementDeclarationAdapter && (target = (adapter = (XSDImpl.XSDElementDeclarationAdapter)cmElementDeclaration).getTarget()) instanceof XSDElementDeclaration && (typeDefinition = (elemDecl = (XSDElementDeclaration)target).getTypeDefinition()) instanceof XSDComplexTypeDefinition) {
                return this.analyzeComplexType(detailItems, schemaOrderedDetailItems, typeDefinition);
            }
        }
        return detailItems.toArray(new DetailItem[detailItems.size()]);
    }

    private DetailItem[] analyzeComplexType(List detailItems, List schemaOrderedDetailItems, XSDTypeDefinition typeDefinition) {
        XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)typeDefinition;
        while (ct instanceof XSDComplexTypeDefinition) {
            this.traverseHierarchy(ct, schemaOrderedDetailItems, detailItems);
            if (!"anyType".equals((ct = ct.getBaseType()).getName())) continue;
        }
        schemaOrderedDetailItems.addAll(detailItems);
        return schemaOrderedDetailItems.toArray(new DetailItem[schemaOrderedDetailItems.size()]);
    }

    public DetailItem[] sortItemsBySchema(Object input, List detailItems) {
        XSDElementDeclaration elemDecl;
        XSDTypeDefinition typeDefinition;
        XSDImpl.XSDElementDeclarationAdapter adapter;
        Notifier target;
        CMElementDeclaration cmElementDeclaration;
        Element element;
        ModelQuery modelQuery;
        ArrayList schemaOrderedDetailItems = new ArrayList();
        if (input instanceof Element && (modelQuery = ModelQueryUtil.getModelQuery((Document)(element = (Element)input).getOwnerDocument())) != null && (cmElementDeclaration = modelQuery.getCMElementDeclaration(element)) != null && (target = (adapter = (XSDImpl.XSDElementDeclarationAdapter)cmElementDeclaration).getTarget()) instanceof XSDElementDeclaration && (typeDefinition = (elemDecl = (XSDElementDeclaration)target).getTypeDefinition()) instanceof XSDComplexTypeDefinition) {
            return this.analyzeComplexType(detailItems, schemaOrderedDetailItems, typeDefinition);
        }
        return detailItems.toArray(new DetailItem[detailItems.size()]);
    }

    private void traverseHierarchy(XSDComplexTypeDefinition ct, List schemaOrderedDetailItems, List detailItems) {
        block0: for (XSDAttributeGroupContent gc : ct.getAttributeContents()) {
            Object aadi;
            if (gc instanceof XSDAttributeUse) {
                XSDAttributeUse au = (XSDAttributeUse)gc;
                String targetName = au.getAttributeDeclaration().getName();
                for (Object di : detailItems) {
                    String s;
                    if (!(di instanceof AtomicAttributeDetailItem) || (s = ((AtomicAttributeDetailItem)(aadi = (AtomicAttributeDetailItem)di)).getName()) == null || !s.equals(targetName)) continue;
                    schemaOrderedDetailItems.add(di);
                    detailItems.remove(di);
                    continue block0;
                }
                continue;
            }
            if (!(gc instanceof XSDAttributeGroupDefinition)) continue;
            XSDAttributeGroupDefinition agd = ((XSDAttributeGroupDefinition)gc).getResolvedAttributeGroupDefinition();
            block2: for (XSDAttributeUse au : agd.getAttributeUses()) {
                String targetName = au.getAttributeDeclaration().getName();
                aadi = detailItems.iterator();
                while (aadi.hasNext()) {
                    AtomicAttributeDetailItem aadi2;
                    String s;
                    Object di = aadi.next();
                    if (!(di instanceof AtomicAttributeDetailItem) || (s = (aadi2 = (AtomicAttributeDetailItem)di).getName()) == null || !s.equals(targetName)) continue;
                    schemaOrderedDetailItems.add(di);
                    detailItems.remove(di);
                    continue block2;
                }
            }
        }
        XSDComplexTypeContent content = ct.getContent();
        if (content instanceof XSDParticle) {
            XSDParticleContent xsdParticleContent = ((XSDParticle)content).getContent();
            if (xsdParticleContent instanceof XSDModelGroup) {
                XSDModelGroup mg = (XSDModelGroup)xsdParticleContent;
                this.checkModelGroup(mg, schemaOrderedDetailItems, detailItems);
            } else if (xsdParticleContent instanceof XSDModelGroupDefinition) {
                XSDModelGroupDefinition groupDef = (XSDModelGroupDefinition)xsdParticleContent;
                groupDef = groupDef.getResolvedModelGroupDefinition();
                XSDModelGroup mg = groupDef.getModelGroup();
                EList contents = mg.getContents();
                for (XSDParticle p : contents) {
                    XSDParticleContent content2 = p.getContent();
                    if (!(content2 instanceof XSDModelGroup)) continue;
                    this.checkModelGroup((XSDModelGroup)content2, schemaOrderedDetailItems, detailItems);
                }
            }
        }
    }

    private void checkModelGroup(XSDModelGroup mg, List schemaOrderedDetailItems, List detailItems) {
        EList particles = mg.getParticles();
        block0: for (XSDParticle part : particles) {
            XSDParticleContent content2 = part.getContent();
            if (content2 instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdElem = (XSDElementDeclaration)content2;
                String targetName = xsdElem.getName();
                for (Object di : detailItems) {
                    SimpleDetailItem adi;
                    String s;
                    if (di instanceof AtomicElementDetailItem) {
                        AtomicElementDetailItem aedi = (AtomicElementDetailItem)di;
                        s = aedi.getName();
                        if (s == null || !s.equals(targetName)) continue;
                        schemaOrderedDetailItems.add(di);
                        detailItems.remove(di);
                        continue block0;
                    }
                    if (!(di instanceof SimpleDetailItem) || (s = (adi = (SimpleDetailItem)di).getName()) == null || !s.equals(targetName)) continue;
                    schemaOrderedDetailItems.add(di);
                    detailItems.remove(di);
                    continue block0;
                }
                continue;
            }
            if (!(content2 instanceof XSDModelGroupDefinition)) continue;
            XSDModelGroupDefinition groupDef = (XSDModelGroupDefinition)content2;
            groupDef = groupDef.getResolvedModelGroupDefinition();
            XSDModelGroup mg2 = groupDef.getModelGroup();
            this.checkModelGroup(mg2, schemaOrderedDetailItems, detailItems);
        }
    }

    private class ElementContentVisitor
    extends CMVisitor {
        private ModelQuery modelQuery;
        private Element parentElement;
        private Element element;
        private CMElementDeclaration cmElementDeclaration;
        private List detailItems;
        private CustomizationManager.Customization customization;

        public ElementContentVisitor(Element element, CustomizationManager.Customization customization) {
            this.element = element;
            this.modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
            this.cmElementDeclaration = this.modelQuery.getCMElementDeclaration(element);
            this.detailItems = new ArrayList();
            this.customization = customization;
        }

        public ElementContentVisitor(Element parentElement, CMElementDeclaration cmElementDeclaration, CustomizationManager.Customization customization) {
            this.parentElement = parentElement;
            this.modelQuery = ModelQueryUtil.getModelQuery((Document)parentElement.getOwnerDocument());
            this.cmElementDeclaration = cmElementDeclaration;
            this.detailItems = new ArrayList();
            this.customization = customization;
        }

        public void visitCMElementDeclaration(CMElementDeclaration currentCMElementDeclaration) {
            String elementNamespace = ModelUtil.getNamespaceURI((CMNode)currentCMElementDeclaration);
            String elementPath = null;
            elementPath = this.element != null ? ModelUtil.getNodeFullPath(this.element, (CMNode)currentCMElementDeclaration) : ModelUtil.getNodeFullPath(this.parentElement, this.cmElementDeclaration, (CMNode)currentCMElementDeclaration);
            DetailItemCustomization detailItemCustomization = null;
            if (this.customization != null) {
                detailItemCustomization = this.customization.getItemCustomization(elementNamespace, elementPath);
            }
            boolean elementIsAbstract = false;
            Object object = currentCMElementDeclaration.getProperty("Abstract");
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                elementIsAbstract = true;
            }
            if (!elementIsAbstract && (detailItemCustomization == null || !detailItemCustomization.isHidden() && detailItemCustomization.getStyle() != 5)) {
                if (detailItemCustomization != null && detailItemCustomization.getStyle() != 0) {
                    Element[] instances;
                    AtomicElementDetailItem atomicDetailItem = null;
                    atomicDetailItem = this.element != null ? ((instances = ModelUtil.getInstancesOfElement(this.element, currentCMElementDeclaration)).length >= 1 ? new AtomicElementDetailItem(instances[0]) : new AtomicElementDetailItem(this.element, currentCMElementDeclaration)) : new AtomicElementDetailItem(this.parentElement, this.cmElementDeclaration, currentCMElementDeclaration);
                    atomicDetailItem.setDetailItemCustomization(detailItemCustomization);
                    this.detailItems.add(atomicDetailItem);
                } else {
                    this.processElementDeclarationByDefault(currentCMElementDeclaration, detailItemCustomization);
                }
            }
        }

        List getResult() {
            return this.detailItems;
        }

        private void processElementDeclarationByDefault(CMElementDeclaration currentCMElementDeclaration, DetailItemCustomization detailItemCustomization) {
            boolean singleOccurrence = false;
            if (detailItemCustomization != null) {
                singleOccurrence = detailItemCustomization.isSingleOccurrence();
            }
            if ((ModelUtil.getGroupTypesInBetween(this.cmElementDeclaration, currentCMElementDeclaration) & 0x14) == 0 || singleOccurrence) {
                boolean isAtomic = false;
                isAtomic = this.element != null ? ModelUtil.isAtomicCMElementDeclaration(this.customization, this.element, currentCMElementDeclaration) : ModelUtil.isAtomicCMElementDeclaration(this.customization, this.parentElement, this.cmElementDeclaration, currentCMElementDeclaration);
                if (isAtomic) {
                    if (ModelUtil.isCMNodeRepeatable((CMNode)currentCMElementDeclaration) && !singleOccurrence) {
                        RepeatableAtomicDetailItemSet repeatableAtomicDetailItemSet = null;
                        repeatableAtomicDetailItemSet = this.element != null ? new RepeatableAtomicDetailItemSet(this.element, currentCMElementDeclaration) : new RepeatableAtomicDetailItemSet(this.parentElement, this.cmElementDeclaration, currentCMElementDeclaration);
                        repeatableAtomicDetailItemSet.setDetailItemCustomization(detailItemCustomization);
                        this.detailItems.add(repeatableAtomicDetailItemSet);
                    } else {
                        Element[] instances = null;
                        if (this.element != null) {
                            instances = ModelUtil.getInstancesOfElement(this.element, currentCMElementDeclaration);
                        }
                        if (instances != null && instances.length > 0) {
                            for (int i = 0; i < instances.length; ++i) {
                                AtomicElementDetailItem atomicElementDetailItem = new AtomicElementDetailItem(instances[i]);
                                atomicElementDetailItem.setDetailItemCustomization(detailItemCustomization);
                                this.detailItems.add(atomicElementDetailItem);
                            }
                        } else {
                            AtomicElementDetailItem atomicElementDetailItem = null;
                            atomicElementDetailItem = this.element != null ? new AtomicElementDetailItem(this.element, currentCMElementDeclaration) : new AtomicElementDetailItem(this.parentElement, this.cmElementDeclaration, currentCMElementDeclaration);
                            atomicElementDetailItem.setDetailItemCustomization(detailItemCustomization);
                            this.detailItems.add(atomicElementDetailItem);
                        }
                    }
                } else if (this.element != null && ModelUtil.isSimpleCMElementDeclaration(this.customization, this.element, currentCMElementDeclaration) && (!ModelUtil.isCMNodeRepeatable((CMNode)currentCMElementDeclaration) || singleOccurrence)) {
                    Element[] instances = ModelUtil.getInstancesOfElement(this.element, currentCMElementDeclaration);
                    if (instances.length > 0) {
                        for (int i = 0; i < instances.length; ++i) {
                            DetailItem[] atomicDetailItems = DetailsContentProvider.this.getDetailItemsForElement(instances[i], currentCMElementDeclaration, true);
                            SimpleDetailItem simpleDetailItem = new SimpleDetailItem(currentCMElementDeclaration, instances[i], atomicDetailItems);
                            simpleDetailItem.setDetailItemCustomization(detailItemCustomization);
                            this.detailItems.add(simpleDetailItem);
                        }
                    } else {
                        DetailItem[] atomicDetailItems = DetailsContentProvider.this.getDetailItemsForElement(this.element, currentCMElementDeclaration, false);
                        SimpleDetailItem simpleDetailItem = new SimpleDetailItem(currentCMElementDeclaration, atomicDetailItems);
                        simpleDetailItem.setDetailItemCustomization(detailItemCustomization);
                        this.detailItems.add(simpleDetailItem);
                    }
                }
            }
        }
    }
}

