/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.viewers;

import com.ibm.xwt.dde.DDEPlugin;
import com.ibm.xwt.dde.customization.ICustomElementListSelectionDialog;
import com.ibm.xwt.dde.customization.ICustomLabelObject;
import com.ibm.xwt.dde.customization.ICustomMultipleDeletionObject;
import com.ibm.xwt.dde.customization.ICustomPreSelectedTreeObject;
import com.ibm.xwt.dde.internal.actions.AddElementAction;
import com.ibm.xwt.dde.internal.actions.MoveAction;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.data.DetailItem;
import com.ibm.xwt.dde.internal.data.SimpleDetailItem;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.validation.ValidationManager;
import com.ibm.xwt.dde.internal.viewers.DetailsContentProvider;
import com.ibm.xwt.dde.internal.viewers.DetailsViewer;
import com.ibm.xwt.dde.internal.viewers.ErrorMessageSummaryPopupDialog;
import com.ibm.xwt.dde.internal.viewers.TreeContentProvider;
import com.ibm.xwt.dde.internal.viewers.TreeItemMenuListener;
import com.ibm.xwt.dde.internal.viewers.TreeLabelProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DDEViewer
extends Viewer
implements IPostSelectionProvider {
    private static final String sseErrorAnnotation1 = "org.eclipse.wst.sse.ui.temp.error";
    private static final String sseErrorAnnotation2 = "org.eclipse.ui.workbench.texteditor.error";
    private static final int IDLE_DELAY = 1500;
    private Timer timer = new Timer();
    private TimerTask timerTask;
    private Object input;
    private TreeViewer treeViewer;
    private DetailsViewer detailsViewer;
    private CustomizationManager.Customization customization;
    private ScrolledComposite mainComposite;
    private Composite detailsComposite;
    private Composite missingGrammarMessageComposite;
    private ScrolledComposite rightContentOuterScrolledComposite;
    private ToolBar overviewToolBar;
    private ToolBar detailSectionToolBar;
    private Composite treeButtonsComposite;
    private Composite treeComposite;
    private IEditorPart editorPart;
    private Section detailsSection;
    private SashForm sashForm;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button removeButton;
    private Button addButton;
    private boolean missingGrammarMessageVisible;
    private Form form;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private FormToolkit formToolkit;
    private Text filterText;
    private ToolBar clearTreeFilterToolBar;
    private TreeFilter treeFilter;
    private TreeFilterProcessor treeFilterProcessor;
    private Section overviewSection;
    private Text overviewSectionDescriptionText;
    private Text detailSectionDescriptionText;
    private Composite overviewSectionContentComposite;
    private Composite rightContentInnerComposite;
    private Composite detailsViewerContainer;
    private ToolItem expandSectionsToolItem;
    private ValidationManager validationManager;
    private boolean validationDirtyFlag = true;
    private boolean designViewDirtyFlag;
    private TreeLabelProvider treeLabelProvider;
    private IStructuredTextUndoManager undoManager;
    private boolean designViewActive;
    private IHyperlinkListener formMessageHyperlinkListener;
    private boolean sourceViewContainsErrors;
    private Node firstSourceViewErrorNode;
    private IResource resource;
    private boolean fireSelections;
    private FilterHandlerThread filterHandlerThread;
    private boolean readOnlyMode;
    private boolean designViewDirtySelectionFlag;
    private CommandStackListener commandStackListener;

    public DDEViewer(Composite parent, CustomizationManager.Customization customization, IEditorPart editorPart) {
        this.customization = customization;
        this.editorPart = editorPart;
        this.treeFilterProcessor = new TreeFilterProcessor();
        IEditorInput editorInput = null;
        if (editorPart != null) {
            editorInput = editorPart.getEditorInput();
        }
        if (editorInput != null) {
            this.resource = (IResource)editorInput.getAdapter(IResource.class);
        }
        this.validationManager = new ValidationManager(customization, this.resource, 0);
        this.validationManager.setEditorInput(editorInput);
        this.treeLabelProvider = new TreeLabelProvider(customization, this.treeFilterProcessor, this.validationManager, this.resource);
        this.fireSelections = true;
        this.filterHandlerThread = new FilterHandlerThread();
    }

    public Control getControl() {
        return this.mainComposite;
    }

    public Composite getFormHead() {
        return this.form.getHead();
    }

    public void createContents(Composite parent) {
        boolean isWindows;
        this.widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.mainComposite = this.widgetFactory.createScrolledComposite(parent, 0x800300);
        this.mainComposite.setExpandHorizontal(true);
        this.mainComposite.setExpandVertical(true);
        this.mainComposite.setMinWidth(500);
        this.mainComposite.setMinHeight(250);
        if (this.customization != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mainComposite, this.customization.getHelpContextId());
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
        this.mainComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DDEViewer.this.widgetFactory.dispose();
                DDEViewer.this.formToolkit.dispose();
                ((TreeLabelProvider)DDEViewer.this.treeViewer.getLabelProvider()).dispose();
            }
        });
        this.formToolkit = new FormToolkit(this.mainComposite.getDisplay());
        this.form = this.formToolkit.createForm((Composite)this.mainComposite);
        GridData gridData = new GridData(1808);
        this.form.setLayoutData((Object)gridData);
        this.formToolkit.decorateFormHeading(this.form);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 0;
        this.form.getBody().setLayout((Layout)gridLayout);
        boolean hideOverviewSection = false;
        if (this.customization != null) {
            hideOverviewSection = this.customization.isHideOverviewSection();
        }
        this.formMessageHyperlinkListener = new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ErrorMessageSummaryPopupDialog popupDialog = new ErrorMessageSummaryPopupDialog(DDEViewer.this.mainComposite.getShell(), DDEViewer.this);
                popupDialog.create();
                Hyperlink hyperlink = (Hyperlink)e.widget;
                Point point = DDEViewer.this.form.toDisplay(hyperlink.getLocation());
                Rectangle clientArea = popupDialog.getShell().getClientArea();
                Point ShellSize = popupDialog.getShell().getSize();
                Point actualClientArea = popupDialog.getClientAreaActualSize();
                int horizontalBorder = ShellSize.x - clientArea.width;
                int verticalBorder = ShellSize.y - clientArea.height;
                popupDialog.getShell().setSize(actualClientArea.x + horizontalBorder, actualClientArea.y + verticalBorder);
                if (popupDialog.getShell().getBounds().height > 350) {
                    popupDialog.getShell().setSize(ShellSize.x, 350);
                }
                popupDialog.getShell().setLocation(point);
                popupDialog.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        };
        this.form.addMessageHyperlinkListener(this.formMessageHyperlinkListener);
        this.updateHeader();
        this.sashForm = new SashForm(this.form.getBody(), 256);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.verticalIndent = 12;
        this.sashForm.setLayoutData((Object)gridData);
        this.sashForm.setForeground(this.widgetFactory.getColors().getForeground());
        this.sashForm.setBackground(this.widgetFactory.getColors().getBackground());
        if (hideOverviewSection) {
            this.sashForm.SASH_WIDTH = 0;
        }
        Composite leftContent = this.widgetFactory.createComposite((Composite)this.sashForm, 0x800000);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginRight = 9;
        gridLayout.marginLeft = 8;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        leftContent.setLayout((Layout)gridLayout);
        this.overviewSection = this.widgetFactory.createSection(leftContent, 256);
        this.overviewSection.setLayoutData((Object)new GridData(1808));
        this.overviewSection.clientVerticalSpacing = 0;
        this.overviewToolBar = new ToolBar((Composite)this.overviewSection, 0x800000);
        this.overviewSection.setTextClient((Control)this.overviewToolBar);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        this.overviewToolBar.setCursor(handCursor);
        this.overviewToolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        ToolItem toolItem = new ToolItem(this.overviewToolBar, 32);
        Image image = DDEPlugin.getDefault().getImage("icons/alphab_sort.gif");
        toolItem.setImage(image);
        toolItem.setToolTipText(Messages.LABEL_SORT_ALPHABETICALLY);
        int treeSortingPreference = 0;
        if (this.customization != null) {
            treeSortingPreference = this.customization.getTreeSortingPreference();
        }
        String preferenceKeyForEditor = ModelUtil.getPreferenceKeyForEditor(this.editorPart.getSite().getId(), "PreferenceSortTreeAlphabetically");
        if (treeSortingPreference == 3) {
            DDEPlugin.getDefault().getPreferenceStore().setValue(preferenceKeyForEditor, true);
        } else if (treeSortingPreference == 4) {
            DDEPlugin.getDefault().getPreferenceStore().setValue(preferenceKeyForEditor, false);
        } else {
            boolean valueAlreadyInitialized = DDEPlugin.getDefault().getPreferenceStore().contains(preferenceKeyForEditor);
            if (!valueAlreadyInitialized) {
                switch (treeSortingPreference) {
                    case 0: {
                        boolean defaultValue = DDEPlugin.getDefault().getPreferenceStore().getBoolean("PreferenceSortTreeAlphabetically");
                        DDEPlugin.getDefault().getPreferenceStore().setDefault(preferenceKeyForEditor, defaultValue);
                        break;
                    }
                    case 1: {
                        DDEPlugin.getDefault().getPreferenceStore().setDefault(preferenceKeyForEditor, true);
                        break;
                    }
                    case 2: {
                        DDEPlugin.getDefault().getPreferenceStore().setDefault(preferenceKeyForEditor, false);
                    }
                }
            }
        }
        if (treeSortingPreference != 4 && (treeSortingPreference == 3 || DDEPlugin.getDefault().getPreferenceStore().getBoolean(preferenceKeyForEditor))) {
            toolItem.setSelection(true);
        }
        final boolean keepPreferenceStorageUpdated = treeSortingPreference != 3 && treeSortingPreference != 4;
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore preferenceStore = DDEPlugin.getDefault().getPreferenceStore();
                String preferenceKey = "PreferenceSortTreeAlphabetically";
                preferenceKey = ModelUtil.getPreferenceKeyForEditor(DDEViewer.this.editorPart.getSite().getId(), preferenceKey);
                boolean sort = DDEViewer.this.treeViewer.getSorter() == null;
                String confirmationMessage = null;
                if (DDEViewer.this.customization != null) {
                    confirmationMessage = sort ? DDEViewer.this.customization.getTreeSortConfirmationMessage() : DDEViewer.this.customization.getTreeUnsortConfirmationMessage();
                }
                if (confirmationMessage != null && !MessageDialog.openQuestion((Shell)DDEViewer.this.getControl().getShell(), (String)Messages.LABEL_SORT_ALPHABETICALLY, (String)confirmationMessage)) {
                    ((ToolItem)e.widget).setSelection(!((ToolItem)e.widget).getSelection());
                    return;
                }
                if (sort) {
                    DDEViewer.this.treeViewer.setSorter(new ViewerSorter());
                    if (keepPreferenceStorageUpdated) {
                        preferenceStore.setValue(preferenceKey, true);
                    }
                } else {
                    DDEViewer.this.treeViewer.setSorter(null);
                    if (keepPreferenceStorageUpdated) {
                        preferenceStore.setValue(preferenceKey, false);
                    }
                }
                DDEViewer.this.treeViewer.refresh(true);
                DDEViewer.this.refreshTreeButtons();
            }
        });
        toolItem = new ToolItem(this.overviewToolBar, 8);
        image = DDEPlugin.getDefault().getImage("icons/expand_all.gif");
        toolItem.setImage(image);
        toolItem.setToolTipText(Messages.LABEL_EXPAND_ALL);
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ModelUtil.getInstances((Document)DDEViewer.this.input, "");
                DDEViewer.this.treeViewer.expandAll();
            }
        });
        toolItem = new ToolItem(this.overviewToolBar, 8);
        image = DDEPlugin.getDefault().getImage("icons/collapse_all.gif");
        toolItem.setImage(image);
        toolItem.setToolTipText(Messages.LABEL_COLLAPSE_ALL);
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DDEViewer.this.treeViewer.collapseAll();
            }
        });
        this.overviewToolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String toolTipText;
                ToolItem toolbarItem;
                int childId = e.childID;
                if (childId != -1 && (toolbarItem = DDEViewer.this.overviewToolBar.getItem(childId)) != null && (toolTipText = toolbarItem.getToolTipText()) != null) {
                    e.result = toolTipText;
                }
            }
        });
        this.overviewSectionContentComposite = new Composite((Composite)this.overviewSection, 0);
        this.overviewSectionContentComposite.setBackground(this.widgetFactory.getColors().getBackground());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.overviewSectionContentComposite.setLayout((Layout)gridLayout);
        this.overviewSectionDescriptionText = new Text(this.overviewSectionContentComposite, 72);
        this.overviewSectionDescriptionText.setBackground(this.widgetFactory.getColors().getBackground());
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.exclude = true;
        this.overviewSectionDescriptionText.setLayoutData((Object)gridData);
        this.overviewSection.clientVerticalSpacing = 0;
        this.treeComposite = this.widgetFactory.createComposite(this.overviewSectionContentComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 1;
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 1;
        gridLayout.marginLeft = 1;
        gridLayout.marginRight = 3;
        gridLayout.marginBottom = 16;
        this.treeComposite.setLayout((Layout)gridLayout);
        this.treeComposite.setLayoutData((Object)new GridData(1808));
        this.filterText = this.widgetFactory.createText(this.treeComposite, Messages.TYPE_FILTER_TEXT);
        this.filterText.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (DDEViewer.this.filterText.getData("FOCUS") == null) {
                    DDEViewer.this.filterText.setData("FOCUS", (Object)"focus");
                    DDEViewer.this.filterText.selectAll();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.filterText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DDEViewer.this.filterText.selectAll();
            }

            public void focusLost(FocusEvent e) {
                DDEViewer.this.filterText.setData("FOCUS", null);
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String text = DDEViewer.this.filterText.getText();
                if (Messages.TYPE_FILTER_TEXT.equals(text) || "".equals(text)) {
                    if (DDEViewer.this.clearTreeFilterToolBar.isVisible()) {
                        DDEViewer.this.treeFilterProcessor.setFilterText(null);
                        DDEViewer.this.treeFilterProcessor.clearMatches();
                        DDEViewer.this.treeViewer.removeFilter((ViewerFilter)DDEViewer.this.treeFilter);
                        DDEViewer.this.treeViewer.refresh();
                        DDEViewer.this.treeViewer.expandToLevel(2);
                        DDEViewer.this.clearTreeFilterToolBar.setVisible(false);
                        DDEViewer.this.detailsViewer.refresh();
                    }
                } else {
                    DDEViewer.this.getControl().getDisplay().timerExec(250, (Runnable)DDEViewer.this.filterHandlerThread);
                }
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    DDEViewer.this.treeViewer.getTree().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        gridData = new GridData(768);
        gridData.verticalIndent = 1;
        gridData.verticalAlignment = 1;
        this.filterText.setLayoutData((Object)gridData);
        this.clearTreeFilterToolBar = new ToolBar(this.treeComposite, 0x800000);
        this.clearTreeFilterToolBar.setBackground(this.widgetFactory.getColors().getBackground());
        toolItem = new ToolItem(this.clearTreeFilterToolBar, 8);
        image = DDEPlugin.getDefault().getImage("icons/clear.gif");
        toolItem.setImage(image);
        toolItem.setToolTipText(Messages.LABEL_CLEAR);
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DDEViewer.this.filterText.setText("");
                DDEViewer.this.treeFilterProcessor.setFilterText(null);
                DDEViewer.this.treeFilterProcessor.clearMatches();
                DDEViewer.this.clearTreeFilterToolBar.setVisible(false);
                DDEViewer.this.treeViewer.removeFilter((ViewerFilter)DDEViewer.this.treeFilter);
                DDEViewer.this.treeViewer.refresh(false);
                DDEViewer.this.treeViewer.expandToLevel(2);
                DDEViewer.this.detailsViewer.refresh();
            }
        });
        gridData = new GridData();
        gridData.verticalIndent = 1;
        gridData.horizontalIndent = 4;
        this.clearTreeFilterToolBar.setLayoutData((Object)gridData);
        this.clearTreeFilterToolBar.setVisible(false);
        new Label(this.treeComposite, 0);
        this.treeViewer = new TreeViewer(this.widgetFactory.createTree(this.treeComposite, 770));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.verticalIndent = 7;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.treeViewer.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                TreeItem treeItem;
                Object object;
                TreeItem[] selection = ((Tree)e.widget).getSelection();
                if (selection.length == 1 && (object = (treeItem = selection[0]).getData()) instanceof Element) {
                    String helpContextId;
                    DetailItemCustomization itemCustomization;
                    Element element = (Element)object;
                    String elementFullPath = ModelUtil.getElementFullPath(element);
                    if (DDEViewer.this.customization != null && (itemCustomization = DDEViewer.this.customization.getItemCustomization(ModelUtil.getNodeNamespace(element), elementFullPath)) != null && (helpContextId = itemCustomization.getHelpContextId()) != null) {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpContextId);
                        return;
                    }
                }
                PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
            }
        });
        this.treeButtonsComposite = new Composite(this.treeComposite, 0);
        this.treeButtonsComposite.setLayoutData((Object)new GridData(2));
        this.treeButtonsComposite.setBackground(this.widgetFactory.getColors().getBackground());
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.marginTop = 2;
        rowLayout.marginBottom = 0;
        rowLayout.marginLeft = 7;
        rowLayout.marginRight = 0;
        rowLayout.fill = true;
        rowLayout.spacing = 4;
        this.treeButtonsComposite.setLayout((Layout)rowLayout);
        this.addButton = new Button(this.treeButtonsComposite, 0x800000);
        this.addButton.setText(Messages.LABEL_ADD_DOTS);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DDEViewer.this.triggerAddButton();
            }
        });
        this.removeButton = new Button(this.treeButtonsComposite, 0x800000);
        this.removeButton.setText(Messages.LABEL_REMOVE);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DDEViewer.this.performDelete();
                ((Button)e.widget).setFocus();
            }
        });
        Composite composite = new Composite(this.treeButtonsComposite, 0);
        composite.setBackground(this.widgetFactory.getColors().getBackground());
        RowData rowData = new RowData();
        rowData.height = 0;
        composite.setLayoutData((Object)rowData);
        this.moveUpButton = new Button(this.treeButtonsComposite, 0x800000);
        this.moveUpButton.setText(Messages.LABEL_UP);
        this.moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MoveAction moveAction = new MoveAction(DDEViewer.this, true);
                moveAction.run();
                ((Button)e.widget).setFocus();
            }
        });
        this.moveDownButton = new Button(this.treeButtonsComposite, 0x800000);
        this.moveDownButton.setText(Messages.LABEL_DOWN);
        this.moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MoveAction moveAction = new MoveAction(DDEViewer.this, false);
                moveAction.run();
                ((Button)e.widget).setFocus();
            }
        });
        MenuManager menuManager = new MenuManager();
        this.treeViewer.getTree().setMenu(menuManager.createContextMenu((Control)this.treeViewer.getTree()));
        menuManager.addMenuListener((IMenuListener)new TreeItemMenuListener(this, this.customization, this.editorPart));
        menuManager.setRemoveAllWhenShown(true);
        if (treeSortingPreference != 4 && (treeSortingPreference == 3 || DDEPlugin.getDefault().getPreferenceStore().getBoolean(preferenceKeyForEditor))) {
            this.treeViewer.setSorter(new ViewerSorter());
        }
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider(this.customization));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!DDEViewer.this.missingGrammarMessageVisible) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof StructuredSelection) {
                        StructuredSelection structuredSelection = (StructuredSelection)selection;
                        if (structuredSelection.size() == 1) {
                            Object object = structuredSelection.getFirstElement();
                            if (object instanceof Element) {
                                Element element = (Element)object;
                                DDEViewer.this.updateDetailSectionHeaderText(element);
                                DDEViewer.this.detailsViewer.setInput(element);
                                Control currentControl = DDEViewer.this.detailsViewer.getCurrentControl();
                                if (currentControl == null) {
                                    DDEViewer.this.rightContentOuterScrolledComposite.setOrigin(0, 0);
                                }
                                DDEViewer.this.updateDetailsViewScrolling();
                                DDEViewer.this.updateDetailSectionTitle(element);
                                if (DDEViewer.this.fireSelections) {
                                    DDEViewer.this.fireSelectionChanged(event);
                                }
                            }
                        } else if (structuredSelection.size() > 1) {
                            DDEViewer.this.updateDetailSectionTitle(null);
                            DDEViewer.this.detailsViewer.setInput(Messages.MULTIPLE_ITEMS_ARE_CURRENTLY_SELECTED);
                            DDEViewer.this.updateDetailsViewScrolling();
                        } else {
                            DDEViewer.this.detailsViewer.setInput(null);
                            DDEViewer.this.updateDetailsViewScrolling();
                        }
                    }
                    if (ModelUtil.isDesignViewPageActiveAndInFocus()) {
                        DDEViewer.this.refreshTreeButtons();
                    } else {
                        DDEViewer.this.designViewDirtySelectionFlag = true;
                    }
                }
            }
        });
        this.treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 && DDEViewer.this.removeButton.isEnabled()) {
                    DDEViewer.this.performDelete();
                }
            }

            public void keyReleased(KeyEvent event) {
            }
        });
        this.overviewSection.setClient((Control)this.overviewSectionContentComposite);
        Composite rightContentOutter = this.widgetFactory.createComposite((Composite)this.sashForm);
        gridLayout = new GridLayout();
        gridLayout.marginRight = 7;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        rightContentOutter.setLayout((Layout)gridLayout);
        rightContentOutter.setLayoutData((Object)new GridData(1808));
        this.rightContentOuterScrolledComposite = this.widgetFactory.createScrolledComposite(rightContentOutter, 0x800300);
        this.rightContentOuterScrolledComposite.setExpandHorizontal(true);
        this.rightContentOuterScrolledComposite.setExpandVertical(true);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.rightContentOuterScrolledComposite.setLayoutData((Object)gridData);
        this.rightContentOuterScrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DDEViewer.this.updateDetailsViewScrolling();
            }
        });
        this.rightContentInnerComposite = this.widgetFactory.createComposite((Composite)this.rightContentOuterScrolledComposite, 0x800000);
        gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 4;
        gridLayout.marginLeft = 9;
        gridLayout.marginRight = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.rightContentInnerComposite.setLayout((Layout)gridLayout);
        this.rightContentOuterScrolledComposite.setContent((Control)this.rightContentInnerComposite);
        this.detailsSection = this.widgetFactory.createSection(this.rightContentInnerComposite, 256);
        this.detailsSection.setText(Messages.LABEL_DETAILS);
        this.detailsSection.setLayoutData((Object)new GridData(1808));
        this.detailsSection.clientVerticalSpacing = 0;
        this.detailSectionToolBar = new ToolBar((Composite)this.detailsSection, 0x800000);
        this.detailsSection.setTextClient((Control)this.detailSectionToolBar);
        this.detailSectionToolBar.setCursor(handCursor);
        this.detailSectionToolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        this.expandSectionsToolItem = new ToolItem(this.detailSectionToolBar, 32);
        image = DDEPlugin.getDefault().getImage("icons/expand_sections.gif");
        this.expandSectionsToolItem.setImage(image);
        this.expandSectionsToolItem.setDisabledImage(DDEPlugin.getDefault().getImage("icons/expand_sections_disabled.gif"));
        this.expandSectionsToolItem.setToolTipText(Messages.LABEL_EXPAND_SECTIONS);
        if (DDEPlugin.getDefault().getPreferenceStore().getBoolean("PreferenceExpandSections")) {
            this.expandSectionsToolItem.setSelection(true);
        }
        this.expandSectionsToolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore preferenceStore = DDEPlugin.getDefault().getPreferenceStore();
                boolean value = !DDEViewer.this.detailsViewer.getExpandSections();
                DDEViewer.this.detailsViewer.setExpandSections(value);
                preferenceStore.setValue("PreferenceExpandSections", value);
                DDEViewer.this.updateDetailsViewScrolling();
            }
        });
        this.detailSectionToolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String toolTipText;
                ToolItem toolbarItem;
                int childId = e.childID;
                if (childId != -1 && (toolbarItem = DDEViewer.this.detailSectionToolBar.getItem(childId)) != null && (toolTipText = toolbarItem.getToolTipText()) != null) {
                    e.result = toolTipText;
                }
            }
        });
        this.detailsComposite = new Composite((Composite)this.detailsSection, 0);
        gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.detailsComposite.setLayout((Layout)gridLayout);
        this.detailSectionDescriptionText = new Text(this.detailsComposite, 72);
        this.detailSectionDescriptionText.setBackground(this.widgetFactory.getColors().getBackground());
        gridData = new GridData(768);
        gridData.exclude = true;
        this.detailSectionDescriptionText.setLayoutData((Object)gridData);
        this.detailsViewerContainer = this.widgetFactory.createComposite(this.detailsComposite);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.detailsViewerContainer.setLayout((Layout)gridLayout);
        this.detailsViewerContainer.setLayoutData((Object)new GridData(1808));
        this.detailsViewer = new DetailsViewer(this.detailsViewerContainer, this.widgetFactory, this.editorPart, this.customization, this.treeFilterProcessor, this);
        this.detailsViewer.setContentProvider(new DetailsContentProvider(this.customization));
        this.detailsViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.detailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DDEViewer.this.fireSelections) {
                    DDEViewer.this.fireSelectionChanged(event);
                }
            }
        });
        if (hideOverviewSection) {
            this.sashForm.setWeights(new int[]{0, 100});
            this.sashForm.pack();
        } else {
            this.sashForm.setWeights(new int[]{45, 55});
            this.sashForm.pack();
            Control[] controls = this.sashForm.getChildren();
            if (controls != null && controls.length > 2) {
                final Sash sash = (Sash)this.sashForm.getChildren()[2];
                sash.addMouseTrackListener(new MouseTrackListener(){

                    public void mouseEnter(MouseEvent e) {
                        sash.setBackground(DDEViewer.this.widgetFactory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START"));
                    }

                    public void mouseExit(MouseEvent e) {
                        sash.setBackground(DDEViewer.this.widgetFactory.getColors().getBackground());
                    }

                    public void mouseHover(MouseEvent e) {
                    }
                });
            }
        }
        this.detailsSection.setClient((Control)this.detailsComposite);
        this.mainComposite.setContent((Control)this.form);
        this.treeFilter = new TreeFilter();
        String osName = System.getProperty("os.name").toLowerCase();
        boolean bl = osName != null ? osName.indexOf("win") >= 0 : (isWindows = true);
        if (!isWindows) {
            ScrolledComposite tabFolder = this.mainComposite;
            while (!((tabFolder = tabFolder.getParent()) == null || tabFolder instanceof CTabFolder && tabFolder.getSize().x != 0 && tabFolder.getSize().y != 0 || tabFolder.getParent() == null)) {
            }
            this.mainComposite.setSize(tabFolder.getSize());
        }
    }

    public void updateDetailsViewScrolling() {
        if (this.rightContentOuterScrolledComposite != null && this.rightContentInnerComposite != null) {
            ScrollBar vs;
            this.rightContentOuterScrolledComposite.layout(true, true);
            int innerHeight = this.detailsViewerContainer.computeSize((int)this.detailsViewerContainer.getSize().x, (int)-1).y;
            int toolbarHeight = this.detailSectionToolBar.computeSize((int)this.detailsViewerContainer.getSize().x, (int)-1).y;
            int newHeight = innerHeight + toolbarHeight;
            int vsWidth = this.rightContentOuterScrolledComposite.getVerticalBar().getSize().x + 8;
            if (this.rightContentOuterScrolledComposite.getMinHeight() != newHeight) {
                this.rightContentOuterScrolledComposite.setMinHeight(newHeight);
                if (this.detailsViewer != null && this.detailsViewer.getScrolledComposite() != null) {
                    this.rightContentOuterScrolledComposite.setMinWidth(this.detailsViewer.getScrolledComposite().getMinWidth() + vsWidth);
                }
                this.updateDetailsViewScrolling();
            }
            if ((vs = this.rightContentOuterScrolledComposite.getVerticalBar()) != null) {
                vs.setPageIncrement(vs.getMaximum() / 3);
                vs.setIncrement(vs.getMaximum() / 10);
            }
        }
    }

    public void setInput(Object input) {
        if (this.input != input) {
            this.input = input;
            Object object = this.editorPart.getAdapter(ITextEditor.class);
            if (object instanceof StructuredTextEditor) {
                StructuredTextEditor structuredTextEditor = (StructuredTextEditor)object;
                boolean bl = this.readOnlyMode = !structuredTextEditor.isEditable();
            }
            if (input instanceof Node) {
                Node node = (Node)input;
                this.treeViewer.setInput((Object)node);
                this.treeViewer.expandToLevel(2);
                if (node.getNodeType() == 9) {
                    Document document = (Document)node;
                    ICustomPreSelectedTreeObject preSelectedObject = null;
                    if (this.customization != null) {
                        preSelectedObject = this.customization.getCustomPreSelectedTreeObject();
                    }
                    if (preSelectedObject == null) {
                        for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                            if (childNode.getNodeType() != 1) continue;
                            Element rootElement = (Element)childNode;
                            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)rootElement));
                            this.validationManager.setDocument(document);
                            this.updateValidationInformation();
                            break;
                        }
                    } else {
                        Element preSelectedElement = preSelectedObject.getPreSelectedTreeElement(document, this.editorPart.getEditorInput());
                        if (preSelectedElement == null) {
                            for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                                if (childNode.getNodeType() != 1) continue;
                                preSelectedElement = (Element)childNode;
                            }
                        }
                        if (preSelectedElement != null) {
                            int i = 0;
                            for (Node parent = preSelectedElement; parent != document.getDocumentElement() && parent != null && i < 100; parent = parent.getParentNode()) {
                                this.treeViewer.expandToLevel((Object)parent, ++i);
                            }
                            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)preSelectedElement));
                        }
                        this.validationManager.setDocument(document);
                        this.updateValidationInformation();
                    }
                }
                this.refreshHeaderLabel();
                this.updateOverviewSectionTitle();
                this.updateOverviewSectionHeaderText();
                this.refreshTreeButtons();
                this.updateDetailsViewScrolling();
            }
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        ISelection selection = null;
        selection = this.detailsViewer.getSelection();
        if (selection == null) {
            selection = this.treeViewer.getSelection();
        }
        return selection;
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean forceRefresh) {
        if (ModelUtil.isSourceViewPageActiveAndInFocus()) {
            this.designViewDirtyFlag = true;
        } else if (!this.missingGrammarMessageVisible && !this.getControl().isDisposed()) {
            IStructuredSelection structuredSelection;
            Object object;
            this.treeViewer.refresh(true);
            ISelection selection = this.treeViewer.getSelection();
            if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Element) {
                Element element = (Element)object;
                this.updateDetailSectionTitle(element);
                this.updateDetailSectionHeaderText(element);
            }
            if (forceRefresh) {
                this.updateHeader();
            }
            this.refreshHeaderLabel();
            this.updateOverviewSectionTitle();
            this.updateOverviewSectionHeaderText();
            if (forceRefresh || !this.designViewActive) {
                this.detailsViewer.refresh();
                this.updateDetailsViewScrolling();
            }
            if (!this.validationDirtyFlag) {
                this.updateValidationInformation();
            }
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        List selections;
        if (selection instanceof IStructuredSelection && (selections = ((IStructuredSelection)selection).toList()).size() >= 1) {
            Object object = selections.get(0);
            Element selectedElement = null;
            if (object instanceof Element) {
                selectedElement = (Element)object;
            } else if (object instanceof Attr) {
                Attr attr = (Attr)object;
                selectedElement = attr.getOwnerElement();
            }
            if (selectedElement != null) {
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)selectedElement.getOwnerDocument());
                if (ModelUtil.isRootElement(selectedElement)) {
                    StructuredSelection structuredSelection = new StructuredSelection((Object)selectedElement);
                    this.treeViewer.setSelection((ISelection)structuredSelection, reveal);
                } else {
                    Element element = selectedElement;
                    Node selectedElementParentNode = element.getParentNode();
                    if (selectedElementParentNode instanceof Element) {
                        Element parentElement = (Element)selectedElementParentNode;
                        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(element);
                        CMElementDeclaration parentCMElementDeclaration = modelQuery.getCMElementDeclaration(parentElement);
                        if (cmElementDeclaration != null && parentCMElementDeclaration != null) {
                            Node currentParentNode;
                            while (!ModelUtil.elementMustAppearInTree(this.customization, parentElement, parentCMElementDeclaration, cmElementDeclaration) && !ModelUtil.isRootElement(element = parentElement) && (currentParentNode = element.getParentNode()) instanceof Element) {
                                parentElement = (Element)currentParentNode;
                                cmElementDeclaration = modelQuery.getCMElementDeclaration(element);
                                parentCMElementDeclaration = modelQuery.getCMElementDeclaration(parentElement);
                            }
                            Stack<Node> nodes = new Stack<Node>();
                            Node parentNode = element.getParentNode();
                            while (parentNode.getNodeType() == 1) {
                                nodes.push(parentNode);
                                parentNode = parentNode.getParentNode();
                            }
                            while (!nodes.empty()) {
                                this.treeViewer.setExpandedState(nodes.pop(), true);
                            }
                            StructuredSelection structuredSelection = new StructuredSelection((Object)element);
                            this.treeViewer.setSelection((ISelection)structuredSelection, reveal);
                        }
                    }
                }
                this.detailsViewer.setScrolledComposite(this.rightContentOuterScrolledComposite);
                this.detailsViewer.setSelection(selection, reveal);
            }
        }
    }

    public void activate() {
        this.designViewActive = true;
        if (this.designViewDirtyFlag) {
            this.refresh(true);
            this.designViewDirtyFlag = false;
        }
        this.updateValidation();
        this.updateValidationInformation();
        this.detailsViewer.activate();
        if (this.designViewDirtySelectionFlag) {
            this.designViewDirtySelectionFlag = false;
            this.refreshTreeButtons();
            this.updateDetailsViewScrolling();
        }
    }

    public void deActivate() {
        this.designViewActive = false;
    }

    private void updateDetailSectionTitle(Element element) {
        String title = null;
        if (element != null) {
            String path = ModelUtil.getElementFullPath(element);
            if (this.customization != null) {
                DetailItemCustomization detailItemCustomization = this.customization.getItemCustomization(ModelUtil.getNodeNamespace(element), path);
                if (detailItemCustomization != null) {
                    Class detailSectionTitleClass = detailItemCustomization.getDetailSectionTitleClass();
                    if (detailSectionTitleClass != null) {
                        try {
                            Object object = detailSectionTitleClass.newInstance();
                            if (object instanceof ICustomLabelObject) {
                                ICustomLabelObject customLabelObject = (ICustomLabelObject)object;
                                title = customLabelObject.getLabel(element, this.resource);
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    } else {
                        String detailSectionTitle = detailItemCustomization.getDetailSectionTitle();
                        if (detailSectionTitle != null) {
                            if (detailSectionTitle.indexOf(36) != -1) {
                                detailSectionTitle = ModelUtil.processLabelDistinguishers(element, detailSectionTitle);
                            }
                            title = detailSectionTitle;
                        }
                    }
                } else {
                    Class detailSectionTitleClass = this.customization.getDetailSectionTitleClass();
                    if (detailSectionTitleClass != null) {
                        try {
                            Object object = detailSectionTitleClass.newInstance();
                            if (object instanceof ICustomLabelObject) {
                                ICustomLabelObject customLabelObject = (ICustomLabelObject)object;
                                title = customLabelObject.getLabel(element, this.resource);
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (title == null) {
            title = Messages.LABEL_DETAILS;
        }
        if (!this.detailsSection.getText().equals(title)) {
            this.detailsSection.setText(title);
            this.detailsSection.layout();
        }
    }

    private void updateDetailSectionHeaderText(Element element) {
        DetailItemCustomization detailItemCustomization;
        String path = ModelUtil.getElementFullPath(element);
        String sectionHeaderText = null;
        if (this.customization != null && (detailItemCustomization = this.customization.getItemCustomization(ModelUtil.getNodeNamespace(element), path)) != null && (sectionHeaderText = detailItemCustomization.getSectionHeaderText()) != null) {
            sectionHeaderText = ModelUtil.formatHeaderOrFooterText(sectionHeaderText);
        }
    }

    public void hideMissingGrammarMessage() {
        if (this.missingGrammarMessageVisible) {
            this.missingGrammarMessageComposite.dispose();
            GridData gridData = (GridData)this.form.getLayoutData();
            gridData.exclude = false;
            this.mainComposite.setContent((Control)this.form);
            this.mainComposite.setMinWidth(500);
            this.mainComposite.setMinHeight(250);
            this.form.setVisible(true);
            this.mainComposite.layout();
            this.missingGrammarMessageVisible = false;
            this.refresh();
        }
    }

    public void showMissingGrammarMessage() {
        if (!this.missingGrammarMessageVisible) {
            GridData gridData = (GridData)this.form.getLayoutData();
            gridData.exclude = true;
            this.form.setVisible(false);
            this.missingGrammarMessageComposite = new Composite((Composite)this.mainComposite, 0);
            GridLayout gridLayout = new GridLayout();
            this.missingGrammarMessageComposite.setLayout((Layout)gridLayout);
            this.missingGrammarMessageComposite.setBackground(this.widgetFactory.getColors().getBackground());
            Composite innerComposite = new Composite(this.missingGrammarMessageComposite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            innerComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            gridData.verticalAlignment = 0x1000000;
            gridData.horizontalAlignment = 0x1000000;
            innerComposite.setLayoutData((Object)gridData);
            innerComposite.setBackground(this.widgetFactory.getColors().getBackground());
            Label warningIcon = new Label(innerComposite, 0);
            warningIcon.setBackground(this.widgetFactory.getColors().getBackground());
            warningIcon.setImage(DDEPlugin.getDefault().getImageDescriptor("icons/warning.gif").createImage());
            Label label = new Label(innerComposite, 64);
            label.setBackground(this.widgetFactory.getColors().getBackground());
            label.setText(Messages.MISSING_GRAMMAR_MESSAGE);
            this.missingGrammarMessageComposite.pack();
            this.mainComposite.setMinSize(this.missingGrammarMessageComposite.getSize());
            this.mainComposite.setContent((Control)this.missingGrammarMessageComposite);
            this.mainComposite.layout();
            this.missingGrammarMessageVisible = true;
        }
    }

    private void refreshTreeButtons() {
        if (!this.readOnlyMode) {
            boolean enableAdd = false;
            boolean enableRemove = true;
            boolean enableMoveUp = false;
            boolean enableMoveDown = false;
            TreeItem[] treeItems = this.treeViewer.getTree().getSelection();
            if (treeItems.length == 1) {
                CMElementDeclaration cmElementDeclaration;
                TreeItem treeItem = treeItems[0];
                TreeItem parentTreeItem = treeItem.getParentItem();
                Element element = (Element)treeItem.getData();
                Node node = element.getParentNode();
                enableRemove = node.getNodeType() != 9 ? ModelUtil.canDeleteElement(element, this.customization, this.editorPart) : false;
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
                if (modelQuery != null && (cmElementDeclaration = modelQuery.getCMElementDeclaration(element)) != null && ModelUtil.insertActionsAvailable(element, cmElementDeclaration, modelQuery, this.customization, this.editorPart)) {
                    enableAdd = true;
                }
                if (this.treeViewer.getSorter() == null && parentTreeItem != null) {
                    TreeItem[] childItems = parentTreeItem.getItems();
                    if (!childItems[0].equals(treeItem)) {
                        enableMoveUp = true;
                    }
                    if (!childItems[childItems.length - 1].equals(treeItem)) {
                        enableMoveDown = true;
                    }
                }
            } else if (treeItems.length > 1) {
                for (int i = 0; i < treeItems.length && enableRemove; ++i) {
                    Object object = treeItems[i].getData();
                    if (!(object instanceof Element)) continue;
                    Element currentElement = (Element)object;
                    enableRemove = ModelUtil.canDeleteElement(currentElement, this.customization, this.editorPart);
                }
            } else if (treeItems.length == 0) {
                enableRemove = false;
            }
            this.addButton.setEnabled(enableAdd);
            this.removeButton.setEnabled(enableRemove);
            this.moveUpButton.setEnabled(enableMoveUp);
            this.moveDownButton.setEnabled(enableMoveDown);
        } else {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
    }

    private void updateHeader() {
        if (this.customization != null) {
            Image headerIcon = this.customization.getHeaderIcon();
            if (headerIcon != null) {
                this.form.setImage(headerIcon);
            }
            this.form.getToolBarManager().removeAll();
            this.form.updateToolBar();
            Action[] actions = this.customization.getHeaderActions();
            if (actions != null) {
                for (int i = 0; i < actions.length; ++i) {
                    this.form.getToolBarManager().add((IAction)actions[i]);
                }
            }
            this.form.updateToolBar();
        }
    }

    private void refreshHeaderLabel() {
        String headerLabel = null;
        if (this.customization != null && this.input != null) {
            ICustomLabelObject customLabelObject = this.customization.getHeaderLabelObject();
            if (customLabelObject != null) {
                Document document = (Document)this.input;
                Element element = document.getDocumentElement();
                if (element != null) {
                    headerLabel = customLabelObject.getLabel(element, this.resource);
                }
            } else {
                Document document;
                Element element;
                headerLabel = this.customization.getHeaderLabel();
                if (headerLabel != null && headerLabel.indexOf(36) != -1 && (element = (document = (Document)this.input).getDocumentElement()) != null) {
                    headerLabel = ModelUtil.processLabelDistinguishers(element, headerLabel);
                }
            }
        }
        if (headerLabel == null) {
            headerLabel = this.editorPart.getEditorSite().getRegisteredName();
        }
        if (!headerLabel.equals(this.form.getText())) {
            this.form.setText(headerLabel);
        }
    }

    public TreeFilterProcessor getTreeFilterProcessor() {
        return this.treeFilterProcessor;
    }

    private void updateOverviewSectionTitle() {
        String overviewSectionTitle = null;
        if (this.customization != null) {
            Document document = (Document)this.input;
            Element element = document.getDocumentElement();
            ICustomLabelObject object = this.customization.getOverviewSectionTitleObject();
            if (object instanceof ICustomLabelObject) {
                ICustomLabelObject customLabelObject = object;
                if (element != null) {
                    overviewSectionTitle = customLabelObject.getLabel(element, this.resource);
                }
            } else {
                overviewSectionTitle = this.customization.getOverviewSectionTitle();
                if (overviewSectionTitle != null && overviewSectionTitle.indexOf(36) != -1 && element != null) {
                    overviewSectionTitle = ModelUtil.processLabelDistinguishers(element, overviewSectionTitle);
                }
            }
        }
        if (overviewSectionTitle == null) {
            overviewSectionTitle = Messages.LABEL_OVERVIEW;
        }
        if (!overviewSectionTitle.equals(this.overviewSection.getText())) {
            this.overviewSection.setText(overviewSectionTitle);
            this.overviewSection.layout();
        }
    }

    private void updateOverviewSectionHeaderText() {
        if (this.customization != null) {
            String overviewSectionDescription = null;
            Document document = (Document)this.input;
            Element element = document.getDocumentElement();
            ICustomLabelObject object = this.customization.getOverviewSectionDescriptionObject();
            if (object instanceof ICustomLabelObject) {
                ICustomLabelObject customLabelObject = object;
                if (element != null) {
                    overviewSectionDescription = customLabelObject.getLabel(element, this.resource);
                }
            } else {
                overviewSectionDescription = this.customization.getOverviewSectionDescription();
                if (overviewSectionDescription != null && overviewSectionDescription.indexOf(36) != -1 && element != null) {
                    overviewSectionDescription = ModelUtil.processLabelDistinguishers(element, overviewSectionDescription);
                }
            }
            GridData gridData = (GridData)this.overviewSectionDescriptionText.getLayoutData();
            if (overviewSectionDescription != null) {
                if (gridData.exclude) {
                    this.overviewSectionDescriptionText.setVisible(true);
                    gridData.exclude = false;
                    ((GridLayout)this.treeComposite.getLayout()).marginTop = 9;
                    this.overviewSection.layout();
                }
                if (!overviewSectionDescription.equals(this.overviewSectionDescriptionText.getText())) {
                    this.overviewSectionDescriptionText.setText(overviewSectionDescription);
                    this.overviewSection.layout();
                }
            } else if (!gridData.exclude) {
                ((GridData)this.overviewSectionDescriptionText.getLayoutData()).exclude = true;
                this.overviewSectionDescriptionText.setVisible(false);
                ((GridLayout)this.treeComposite.getLayout()).marginTop = 3;
                this.overviewSection.layout();
            }
        }
    }

    public void setExpandSectionsToolItemEnabled(boolean enabled) {
        this.expandSectionsToolItem.setEnabled(enabled);
    }

    public ValidationManager getValidationManager() {
        return this.validationManager;
    }

    public void updateValidationInformation() {
        Tree tree;
        int messageType = 0;
        String newMessage = null;
        int messageCount = this.validationManager.getMessageManager().getDocumentMessageCount(1);
        if (messageCount > 0) {
            messageType = 3;
            newMessage = messageCount == 1 ? Messages.ERROR_DETECTED : MessageFormat.format(Messages.ERRORS_DETECTED, new Integer(messageCount));
        } else if (messageCount == 0 && this.sourceViewContainsErrors) {
            messageType = 3;
            newMessage = Messages.SOURCE_ERROR_DETECTED;
        } else {
            messageCount = this.validationManager.getMessageManager().getDocumentMessageCount(0);
            if (messageCount > 0) {
                messageType = 2;
                newMessage = messageCount == 1 ? Messages.WARNING_DETECTED : MessageFormat.format(Messages.WARNINGS_DETECTED, Integer.toString(messageCount));
            }
        }
        if (newMessage == null) {
            if (this.form.getMessage() != null) {
                this.form.setMessage(null);
            }
        } else if (!newMessage.equals(this.form.getMessage())) {
            this.form.setMessage(newMessage, messageType);
        }
        if (this.treeViewer != null && (tree = this.treeViewer.getTree()) != null && !tree.isDisposed()) {
            this.treeViewer.refresh(true);
            this.detailsViewer.upadteDecorators();
        }
    }

    public void setUndoManager(IStructuredTextUndoManager undoManager) {
        this.undoManager = undoManager;
        final CommandStack commandStack = undoManager.getCommandStack();
        this.commandStackListener = new CommandStackListener(){
            private Command lastRedoCommand;

            public void commandStackChanged(EventObject event) {
                Command executedCommand = commandStack.getMostRecentCommand();
                Command undoCommand = commandStack.getUndoCommand();
                Command RedoCommand = commandStack.getRedoCommand();
                if (!executedCommand.equals(undoCommand) || executedCommand.equals(this.lastRedoCommand)) {
                    DDEViewer.this.validationManager.validateDocument();
                    DDEViewer.this.refresh(true);
                }
                this.lastRedoCommand = RedoCommand;
            }
        };
        commandStack.addCommandStackListener(this.commandStackListener);
    }

    public void setValidationDirty() {
        if (!this.validationDirtyFlag) {
            this.validationManager.getMessageManager().clearMessages();
            this.updateValidationInformation();
            this.form.removeMessageHyperlinkListener(this.formMessageHyperlinkListener);
            this.form.setMessage(Messages.THE_DOCUMENT_HAS_BEEN_MODIFIED_OUTSIDE_THE_EDITOR, 1);
            this.validationDirtyFlag = true;
        }
    }

    public void updateValidation() {
        this.validationManager.validateDocument();
        this.form.addMessageHyperlinkListener(this.formMessageHyperlinkListener);
        this.updateValidationInformation();
        this.validationDirtyFlag = false;
    }

    public CustomizationManager.Customization getCustomization() {
        return this.customization;
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public DetailsViewer getDetailsViewer() {
        return this.detailsViewer;
    }

    public TreeLabelProvider getTreeLabelProvider() {
        return this.treeLabelProvider;
    }

    public IStructuredTextUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void updateErrorsFromAnnotationModel(final IAnnotationModel model) {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Node node = DDEViewer.this.getSourceViewFirstNodeWithErrors(model);
                if (node != null) {
                    DDEViewer.this.firstSourceViewErrorNode = node;
                    DDEViewer.this.setSourceViewContainsErrors(true);
                } else {
                    DDEViewer.this.setSourceViewContainsErrors(false);
                }
            }
        };
        this.timer.schedule(this.timerTask, 1500L);
    }

    private Node getSourceViewFirstNodeWithErrors(IAnnotationModel model) {
        Iterator annotationIterator = model.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            String annotationType = annotation.getType();
            if (!sseErrorAnnotation1.equals(annotationType) && !sseErrorAnnotation2.equals(annotationType) || !(annotation instanceof TemporaryAnnotation)) continue;
            TemporaryAnnotation temporaryAnnotation = (TemporaryAnnotation)annotation;
            Position position = temporaryAnnotation.getPosition();
            IDOMModel domModel = ((IDOMNode)this.input).getModel();
            IndexedRegion indexedregion = domModel.getIndexedRegion(position.offset);
            if (indexedregion == null) continue;
            return (Node)indexedregion;
        }
        return null;
    }

    public void setSourceViewContainsErrors(boolean sourceViewContainsErrors) {
        if (this.sourceViewContainsErrors != sourceViewContainsErrors && !this.detailsViewer.getIsEditingTableContent()) {
            this.sourceViewContainsErrors = sourceViewContainsErrors;
            if (this.designViewActive) {
                this.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DDEViewer.this.updateValidation();
                        DDEViewer.this.updateValidationInformation();
                    }
                });
            }
        }
    }

    public boolean getSourceViewContainsErrors() {
        return this.sourceViewContainsErrors;
    }

    public Node getFirstSourceViewErrorNode() {
        return this.firstSourceViewErrorNode;
    }

    public boolean isValidationDirty() {
        return this.validationDirtyFlag;
    }

    public void performDelete() {
        TreeItem[] treeItems = this.treeViewer.getTree().getSelection();
        int selectedItemCount = treeItems.length;
        if (selectedItemCount == 1) {
            Object object = treeItems[0].getData();
            if (object instanceof Element) {
                Element element = (Element)object;
                Action deleteAction = ModelUtil.getDeletionAction(element, this, this.customization, this.editorPart);
                deleteAction.run();
            }
        } else if (selectedItemCount > 1) {
            boolean confirmation;
            this.fireSelections = false;
            this.undoManager.beginRecording((Object)this, Messages.REMOVE_ALL_SELECTED_ITEMS);
            ArrayList<Object> elementList = new ArrayList<Object>();
            for (int i = 0; i < treeItems.length; ++i) {
                Object object = treeItems[i].getData();
                if (!(object instanceof Element)) continue;
                elementList.add(object);
            }
            ICustomMultipleDeletionObject customMultipleDeletionObject = this.customization != null ? this.customization.getCustomMultipleDeletionObject() : null;
            int response = 1;
            if (customMultipleDeletionObject != null) {
                Element[] elements = elementList.toArray(new Element[elementList.size()]);
                response = customMultipleDeletionObject.multipleDelete(elements, this.editorPart);
            }
            if (response == 1 && !(confirmation = MessageDialog.openQuestion((Shell)this.getControl().getShell(), (String)Messages.LABEL_REMOVE, (String)Messages.REMOVE_ALL_SELECTED_ITEMS_QUESTION))) {
                response = -1;
            }
            if (response > -1) {
                for (Object e : elementList) {
                    Element currentElement;
                    if (!(e instanceof Element) || !ModelUtil.isNodeInDocument((Document)this.input, currentElement = (Element)e)) continue;
                    Action deleteAction = ModelUtil.getDeletionAction(currentElement, this, this.customization, this.editorPart);
                    deleteAction.run();
                }
            }
            this.undoManager.endRecording((Object)this);
            this.fireSelections = true;
        }
    }

    public boolean isReadOnlyMode() {
        return this.readOnlyMode;
    }

    public void dispose() {
        if (this.undoManager != null && this.commandStackListener != null) {
            CommandStack commandStack = this.undoManager.getCommandStack();
            commandStack.removeCommandStackListener(this.commandStackListener);
        }
        this.detailsViewer.dispose();
        this.input = null;
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addPostSelectionChangedListener(listener);
        this.detailsViewer.addPostSelectionChangedListener(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.treeViewer != null) {
            this.treeViewer.removePostSelectionChangedListener(listener);
        }
        if (this.detailsViewer != null) {
            this.detailsViewer.removePostSelectionChangedListener(listener);
        }
    }

    public void triggerAddButton() {
        TreeItem treeItem = this.treeViewer.getTree().getSelection()[0];
        Element element = (Element)treeItem.getData();
        List insertActions = ModelUtil.getInsertActions(element, this.customization, this, this.editorPart);
        Class addButtonClass = this.customization.getAddButtonClass();
        if (addButtonClass != null) {
            Object object = null;
            try {
                object = addButtonClass.newInstance();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            ICustomElementListSelectionDialog customElementListSelectionDialog = object;
            customElementListSelectionDialog.invoke(element);
        } else {
            Object result;
            ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getControl().getShell(), new ILabelProvider(){

                public Image getImage(Object element) {
                    AddElementAction action = (AddElementAction)((Object)element);
                    return action.getImage();
                }

                public String getText(Object element) {
                    Action action = (Action)element;
                    return action.getText();
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            elementListSelectionDialog.setTitle(Messages.ADD_ITEM);
            elementListSelectionDialog.setIgnoreCase(true);
            elementListSelectionDialog.setElements(insertActions.toArray());
            elementListSelectionDialog.setHelpAvailable(false);
            String message = MessageFormat.format(Messages.ADD_ITEM_MESSAGE, treeItem.getText());
            elementListSelectionDialog.setMessage(message);
            if (elementListSelectionDialog.open() == 0 && (result = elementListSelectionDialog.getFirstResult()) instanceof Action) {
                Action action = (Action)result;
                action.run();
            }
        }
    }

    private class FilterHandlerThread
    extends Thread {
        private FilterHandlerThread() {
        }

        @Override
        public void run() {
            String filterValue = DDEViewer.this.filterText.getText();
            DDEViewer.this.treeFilterProcessor.setFilterText(filterValue);
            DDEViewer.this.treeFilterProcessor.updateMatchingElements();
            if (DDEViewer.this.treeViewer.getFilters().length == 0 && filterValue.length() > 0) {
                DDEViewer.this.treeViewer.addFilter((ViewerFilter)DDEViewer.this.treeFilter);
                DDEViewer.this.clearTreeFilterToolBar.setVisible(true);
            }
            DDEViewer.this.treeViewer.refresh();
            DDEViewer.this.treeViewer.expandAll();
            DDEViewer.this.detailsViewer.refresh();
        }
    }

    private class TreeFilter
    extends ViewerFilter {
        private TreeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Element) {
                Element domElement = (Element)element;
                if (DDEViewer.this.treeFilterProcessor.isMatchedElement(domElement)) {
                    return true;
                }
                TreeContentProvider treeContentProvider = (TreeContentProvider)DDEViewer.this.treeViewer.getContentProvider();
                Stack<Object> stack = new Stack<Object>();
                stack.addAll(Arrays.asList(treeContentProvider.getChildren(element)));
                while (!stack.isEmpty()) {
                    Object object = stack.pop();
                    if (!(object instanceof Element)) continue;
                    Element childElement = (Element)object;
                    if (DDEViewer.this.treeFilterProcessor.isMatchedElement(childElement)) {
                        return true;
                    }
                    stack.addAll(Arrays.asList(treeContentProvider.getChildren(childElement)));
                }
            }
            return false;
        }
    }

    public class TreeFilterProcessor {
        private HashMap matchedElements = new HashMap();
        private String filterText;

        public boolean isMatchedElement(Element element) {
            return "true".equals(this.matchedElements.get(element));
        }

        public void clearMatches() {
            this.matchedElements.clear();
        }

        public void setFilterText(String filterText) {
            this.filterText = filterText;
        }

        public String getFilterText() {
            return this.filterText;
        }

        public void updateMatchingElements() {
            this.matchedElements.clear();
            if (this.filterText != null && !"".equals(this.filterText)) {
                Stack<Object> elementStack = new Stack<Object>();
                NodeList nodeList = ((Document)DDEViewer.this.input).getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    elementStack.add(node);
                }
                while (!elementStack.isEmpty()) {
                    Element element = (Element)elementStack.pop();
                    elementStack.addAll(Arrays.asList(((TreeContentProvider)DDEViewer.this.treeViewer.getContentProvider()).getChildren(element)));
                    this.matchedElements.put(element, this.elementMatches(element) ? "true" : "false");
                }
            }
        }

        private boolean elementMatches(Element domElement) {
            DetailItemCustomization detailItemCustomization;
            String filterTextValue = this.filterText.toLowerCase();
            if (domElement.getNodeName().toLowerCase().indexOf(filterTextValue) != -1) {
                return true;
            }
            if (ModelUtil.getTreeNodeLabel(domElement, DDEViewer.this.customization, DDEViewer.this.resource).toLowerCase().indexOf(filterTextValue) != -1) {
                return true;
            }
            if (DDEViewer.this.customization != null && (detailItemCustomization = DDEViewer.this.customization.getItemCustomization(ModelUtil.getNodeNamespace(domElement), ModelUtil.getElementFullPath(domElement))) != null && this.customizationItemMatches(filterTextValue, detailItemCustomization)) {
                return true;
            }
            DetailItem[] detailItems = DDEViewer.this.detailsViewer.getContentProvider().getItems(domElement);
            for (int i = 0; i < detailItems.length; ++i) {
                DetailItemCustomization detailItemCustomization2;
                DetailItem detailItem = detailItems[i];
                if (detailItem.getName().indexOf(filterTextValue) != -1) {
                    return true;
                }
                if (detailItem instanceof SimpleDetailItem) {
                    SimpleDetailItem simpleDetailItem = (SimpleDetailItem)detailItem;
                    DetailItem[] childDetailItems = simpleDetailItem.getAtomicDetailItems();
                    for (int j = 0; j < childDetailItems.length; ++j) {
                        DetailItem childDetailItem = childDetailItems[j];
                        if (childDetailItem.getName().indexOf(filterTextValue) != -1) {
                            return true;
                        }
                        DetailItemCustomization childDetailItemCustomization = childDetailItem.getDetailItemCustomization();
                        if (childDetailItemCustomization == null || !this.customizationItemMatches(filterTextValue, childDetailItemCustomization)) continue;
                        return true;
                    }
                }
                if ((detailItemCustomization2 = detailItem.getDetailItemCustomization()) == null || !this.customizationItemMatches(filterTextValue, detailItemCustomization2)) continue;
                return true;
            }
            return false;
        }

        private boolean customizationItemMatches(String filterTextValue, DetailItemCustomization detailItemCustomization) {
            String value = null;
            if (detailItemCustomization != null) {
                value = detailItemCustomization.getLabel();
                if (value != null && value.toLowerCase().indexOf(filterTextValue) != -1) {
                    return true;
                }
                value = detailItemCustomization.getTreeLabel();
                if (value != null && value.toLowerCase().indexOf(filterTextValue) != -1) {
                    return true;
                }
                value = detailItemCustomization.getCheckBoxText();
                if (value != null && value.toLowerCase().indexOf(filterTextValue) != -1) {
                    return true;
                }
                value = detailItemCustomization.getDetailSectionTitle();
                if (value != null && value.toLowerCase().indexOf(filterTextValue) != -1) {
                    return true;
                }
                value = detailItemCustomization.getSectionHeaderText();
                if (value != null && value.toLowerCase().indexOf(filterTextValue) != -1) {
                    return true;
                }
                value = detailItemCustomization.getHeaderText();
                if (value != null && value.toLowerCase().indexOf(filterTextValue) != -1) {
                    return true;
                }
                value = detailItemCustomization.getFooterText();
                if (value != null && value.toLowerCase().indexOf(filterTextValue) != -1) {
                    return true;
                }
            }
            return false;
        }
    }
}

