/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.security;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.security.LibertySecurityHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;

public class LibertyX509CertRegistry {
    private static LibertyX509CertRegistry instance_;
    private static final String USER_KEYSTORE = "libertycertsKeystore";
    private static final String SECURE_STORAGE_NODE = "com.ibm.ws.st.core.internal.security.LibertyX509CertRegistry";
    private static final String SECURE_STORAGE_PASSWORD_KEY = "password";
    private File keyStoreFile_ = null;
    private KeyStore transientKeyStore_ = null;
    private KeyStore persistentKeyStore_ = null;

    private LibertyX509CertRegistry() {
    }

    public static LibertyX509CertRegistry instance() {
        if (instance_ == null) {
            instance_ = new LibertyX509CertRegistry();
        }
        return instance_;
    }

    public void trustCertificateTransiently(Certificate certificate) throws KeyStoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "certificate=[" + certificate + "]");
        }
        if (certificate != null) {
            String alias = this.transientKeyStore().getCertificateAlias(certificate);
            if (Trace.ENABLED) {
                Trace.trace((byte)9, "prior transient alias=[" + alias + "]");
            }
            if (alias == null) {
                this.transientKeyStore_.setCertificateEntry(this.newAlias(), certificate);
            }
            alias = this.persistentKeyStore().getCertificateAlias(certificate);
            if (Trace.ENABLED) {
                Trace.trace((byte)9, "prior persistent alias=[" + alias + "]");
            }
            if (alias != null) {
                this.persistentKeyStore_.deleteEntry(alias);
                this.store();
            }
        }
    }

    public void trustCertificatePersistently(Certificate certificate) throws KeyStoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "certificate=[" + certificate + "]");
        }
        if (certificate != null) {
            String alias = this.persistentKeyStore().getCertificateAlias(certificate);
            if (Trace.ENABLED) {
                Trace.trace((byte)9, "prior persistent alias=[" + alias + "]");
            }
            if (alias == null) {
                this.persistentKeyStore_.setCertificateEntry(this.newAlias(), certificate);
                this.store();
            }
            if (this.transientKeyStore_ != null) {
                alias = this.transientKeyStore_.getCertificateAlias(certificate);
                if (Trace.ENABLED) {
                    Trace.trace((byte)9, "prior transient alias=[" + alias + "]");
                }
                if (alias != null) {
                    this.transientKeyStore_.deleteEntry(alias);
                }
            }
        }
    }

    public void removeCertificate(Certificate certificate) throws KeyStoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "certificate=[" + certificate + "]");
        }
        if (certificate != null) {
            String alias;
            if (this.transientKeyStore_ != null) {
                alias = this.transientKeyStore_.getCertificateAlias(certificate);
                if (Trace.ENABLED) {
                    Trace.trace((byte)9, "prior transient alias=[" + alias + "]");
                }
                if (alias != null) {
                    this.transientKeyStore_.deleteEntry(alias);
                }
            }
            alias = this.persistentKeyStore().getCertificateAlias(certificate);
            if (Trace.ENABLED) {
                Trace.trace((byte)9, "prior persistent alias=[" + alias + "]");
            }
            if (alias != null) {
                this.persistentKeyStore_.deleteEntry(alias);
                this.store();
            }
        }
    }

    public Certificate[] getCertificatesTrustedTransiently() throws KeyStoreException {
        return this.transientKeyStore_ == null ? new Certificate[]{} : this.certificates(this.transientKeyStore_);
    }

    public Certificate[] getCertificatesTrustedPersistently() throws KeyStoreException {
        return this.certificates(this.persistentKeyStore());
    }

    public boolean isTrusted(Certificate certificate) throws KeyStoreException {
        boolean trusted;
        boolean bl = trusted = certificate != null && (this.transientKeyStore_ != null && this.transientKeyStore_.getCertificateAlias(certificate) != null || this.persistentKeyStore().getCertificateAlias(certificate) != null);
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "certificate=[" + certificate + "] trusted=[" + trusted + "]");
        }
        return trusted;
    }

    public boolean isTrusted(CertPath certPath) throws KeyStoreException {
        boolean trusted = false;
        if (certPath != null) {
            for (Certificate certificate : certPath.getCertificates()) {
                if (!this.isTrusted(certificate)) continue;
                trusted = true;
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "certPath=[" + certPath + "] trusted=[" + trusted + "]");
        }
        return trusted;
    }

    public void purge(boolean removeTransientCertificates) {
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "removeTransientCertificates=[" + removeTransientCertificates + "]");
        }
        this.persistentKeyStore_ = null;
        if (removeTransientCertificates) {
            this.transientKeyStore_ = null;
        }
    }

    private String newAlias() {
        String alias = UUID.randomUUID().toString();
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "alias=[" + alias + "]");
        }
        return alias;
    }

    private KeyStore transientKeyStore() throws KeyStoreException {
        if (this.transientKeyStore_ == null) {
            this.transientKeyStore_ = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                this.transientKeyStore_.load(null, LibertyX509CertRegistry.getPassword().toCharArray());
            }
            catch (Exception e) {
                Trace.logError(e.getMessage(), e);
                throw new KeyStoreException(Messages.X509_CANNOT_LOAD_TRANSIENT_KEYSTORE, e);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "transientKeyStore_=[" + this.transientKeyStore_ + "]");
        }
        return this.transientKeyStore_;
    }

    private KeyStore persistentKeyStore() throws KeyStoreException {
        if (this.persistentKeyStore_ == null) {
            File keyStoreFile = this.keyStoreFile();
            this.persistentKeyStore_ = KeyStore.getInstance(KeyStore.getDefaultType());
            if (keyStoreFile.exists()) {
                try {
                    FileInputStream inputStream = new FileInputStream(keyStoreFile);
                    this.persistentKeyStore_.load(inputStream, LibertyX509CertRegistry.getPassword().toCharArray());
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {
                    Trace.logError(e.getMessage(), e);
                    throw new KeyStoreException(NLS.bind((String)Messages.X509_CANNOT_READ_PERSISTENT_KEYSTORE, (Object)keyStoreFile), e);
                }
            }
            try {
                this.persistentKeyStore_.load(null, LibertyX509CertRegistry.getPassword().toCharArray());
            }
            catch (Exception e) {
                Trace.logError(e.getMessage(), e);
                throw new KeyStoreException(Messages.X509_CANNOT_LOAD_PERSISTENT_KEYSTORE, e);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "persistentKeyStore_=[" + this.persistentKeyStore_ + "]");
        }
        return this.persistentKeyStore_;
    }

    private void store() throws KeyStoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "persistentKeyStore_=[" + this.persistentKeyStore_ + "]");
        }
        if (this.persistentKeyStore_ != null) {
            File keyStoreFile = this.keyStoreFile();
            try {
                FileOutputStream outputStream = new FileOutputStream(keyStoreFile);
                this.persistentKeyStore_.store(outputStream, LibertyX509CertRegistry.getPassword().toCharArray());
                ((OutputStream)outputStream).close();
            }
            catch (Exception e) {
                Trace.logError(e.getMessage(), e);
                throw new KeyStoreException(NLS.bind((String)Messages.X509_CANNOT_WRITE_PERSISTENT_KEYSTORE, (Object)keyStoreFile));
            }
        }
    }

    private File keyStoreFile() throws KeyStoreException {
        if (this.keyStoreFile_ == null) {
            IPath stateLocation = Activator.getInstance().getStateLocation();
            if (stateLocation != null) {
                this.keyStoreFile_ = stateLocation.append(USER_KEYSTORE).toFile();
            } else {
                throw new KeyStoreException(Messages.X509_CANNOT_GET_PLUGIN_STATE_LOCATION);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "keyStoreFile_=[" + this.keyStoreFile_ + "]");
        }
        return this.keyStoreFile_;
    }

    private Certificate[] certificates(KeyStore keyStore) throws KeyStoreException {
        LinkedList<Certificate> certificates = new LinkedList<Certificate>();
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            Certificate certificate = keyStore.getCertificate(alias);
            if (certificate == null) continue;
            certificates.add(certificate);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "keystore=[" + keyStore + "] certificates=[" + certificates + "]");
        }
        return certificates.toArray(new Certificate[0]);
    }

    private static void savePassword(String password) {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = preferences.node(SECURE_STORAGE_NODE);
        try {
            node.put(SECURE_STORAGE_PASSWORD_KEY, password, true);
            preferences.flush();
        }
        catch (Exception e) {
            Trace.logError("Failed to store server password", e);
        }
    }

    static String getPassword() {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = preferences.node(SECURE_STORAGE_NODE);
        String password = null;
        try {
            password = node.get(SECURE_STORAGE_PASSWORD_KEY, "");
        }
        catch (StorageException e) {
            Trace.logError("Failed to retrieve server password", e);
        }
        if (password == null || password.isEmpty()) {
            password = LibertySecurityHelper.generatePassword();
            LibertyX509CertRegistry.savePassword(password);
        }
        return password;
    }
}

