/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.repository;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.ProcessHelper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.repository.AbstractInstaller;
import com.ibm.ws.st.core.internal.repository.IProduct;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.osgi.util.NLS;

public class FeatureInstaller
extends AbstractInstaller {
    private static final String ASSET_LOCATION_OVERRIDE_PROP_NAME = "repository.description.url";
    private static final String REPOSITORIES_LOCATION_OVERRIDE_PROP_NAME = "WLP_REPOSITORIES_PROPS";
    private static final String FEATURE_MANAGER_CMD = "featureManager";

    @Override
    public IStatus install(IProduct product, PasswordAuthentication pa, Map<String, Object> settings, IProgressMonitor monitor2) {
        Map<String, Object> installKernel;
        IPath installPath = (IPath)settings.get("runtimeLocation");
        if (installPath == null) {
            return new Status(4, "com.ibm.ws.st.core", 0, Messages.errorRuntimeLocationMissing, (Throwable)new IOException(Messages.errorRuntimeLocationMissing));
        }
        if (product.getProductType() == IProduct.ProductType.MASSIVE_TYPE && (installKernel = this.getInstallKernel(installPath.toFile())) != null) {
            return this.installWithKernel(installKernel, product, pa, settings, monitor2);
        }
        return this.installWithCommand(product, pa, settings, monitor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus installWithKernel(final Map<String, Object> installKernel, IProduct product, PasswordAuthentication pa, Map<String, Object> settings, IProgressMonitor monitor2) {
        IProgressMonitor monitor;
        String repoPropsURL = (String)settings.get("repoPropsLocation");
        installKernel.put("license.accept", Boolean.TRUE);
        if (repoPropsURL != null) {
            installKernel.put("repositories.properties", new File(repoPropsURL));
        }
        if ((monitor = monitor2) == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100);
            SubProgressMonitor subMonitor1 = new SubProgressMonitor(monitor, 20);
            subMonitor1.beginTask(Messages.taskProductInfo, 100);
            subMonitor1.subTask(Messages.taskProductInfo);
            final ArrayList<String> featureList = new ArrayList<String>(2);
            featureList.add(product.getProvideFeature().get(0));
            final boolean[] done = new boolean[]{false};
            final IStatus[] status = new IStatus[]{Status.OK_STATUS};
            Thread thread = new Thread(Messages.taskProductInfo){

                @Override
                public void run() {
                    try {
                        if (installKernel.put("action.install", featureList) == null) {
                            status[0] = new Status(4, "com.ibm.ws.st.core", 0, (String)installKernel.get("action.error.message"), null);
                        }
                    }
                    finally {
                        done[0] = true;
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            int i = 0;
            while (!done[0] && !subMonitor1.isCanceled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i + 5 >= 100) continue;
                i += 5;
                subMonitor1.subTask(Messages.taskProductInfo);
                subMonitor1.worked(5);
            }
            subMonitor1.done();
            if (status[0] != Status.OK_STATUS) {
                Status status2 = new Status(4, "com.ibm.ws.st.core", 0, (String)installKernel.get("action.error.message"), null);
                return status2;
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            final SubProgressMonitor subMonitor2 = new SubProgressMonitor(monitor, 80);
            final int[] currentTicks = new int[]{0};
            Integer monitorSize = (Integer)installKernel.get("progress.monitor.size");
            final int totalTicks = monitorSize * 10;
            subMonitor2.beginTask(Messages.taskInstallFeature, totalTicks);
            installKernel.put("progress.monitor.message", new ArrayList<Object>(){
                private static final long serialVersionUID = 6897631470994089079L;

                @Override
                public boolean add(Object e) {
                    subMonitor2.subTask(e.toString());
                    if (currentTicks[0] + 10 <= totalTicks) {
                        subMonitor2.worked(10);
                        currentTicks[0] = currentTicks[0] + 10;
                    }
                    return true;
                }
            });
            installKernel.put("progress.monitor.canceled", new ArrayList<Boolean>(){
                private static final long serialVersionUID = 1062495457758809852L;

                @Override
                public Boolean get(int location) {
                    return subMonitor2.isCanceled() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            Integer rc = (Integer)installKernel.get("action.result");
            subMonitor2.done();
            if (rc != 0) {
                Status status3 = new Status(4, "com.ibm.ws.st.core", 0, (String)installKernel.get("action.error.message"), null);
                return status3;
            }
        }
        catch (Throwable t) {
            Status status = new Status(4, "com.ibm.ws.st.core", 0, t.getLocalizedMessage(), t);
            return status;
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus installWithCommand(IProduct product, PasswordAuthentication pa, Map<String, Object> settings, IProgressMonitor monitor2) {
        IPath installPath = (IPath)settings.get("runtimeLocation");
        long time = System.currentTimeMillis();
        int per = (int)(product.getSize() / 10240L);
        int ticks = per * 11;
        IProgressMonitor monitor = monitor2;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        boolean toAddExtraProps = product.getProductType() == IProduct.ProductType.MASSIVE_TYPE;
        try {
            monitor.beginTask(product.getName(), ticks);
            monitor.subTask(product.getName());
            String[] command = this.getCommand(product, pa, installPath, false);
            ProcessBuilder builder = this.createProcessBuilder(settings, toAddExtraProps, installPath.append("bin").toFile(), command);
            Process p = builder.start();
            monitor.worked(30);
            int waitTicks = toAddExtraProps ? (ticks - 60) / 2 : ticks - 30;
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(p, 1000, 900.0f, waitTicks, monitor);
            int exitValue = result.getExitValue();
            if (exitValue != 0) {
                if (!toAddExtraProps) {
                    throw new IOException(NLS.bind((String)Messages.errorInstallProcessFailed, (Object)(Integer.valueOf(exitValue) + ": " + result.getOutput())));
                }
                command = this.getCommand(product, null, installPath, true);
                builder = this.createProcessBuilder(settings, toAddExtraProps, installPath.append("bin").toFile(), command);
                p = builder.start();
                monitor.worked(30);
                result = ProcessHelper.waitForProcess(p, 1000, 900.0f, waitTicks, monitor);
                exitValue = result.getExitValue();
                if (exitValue != 0) {
                    throw new IOException(NLS.bind((String)Messages.errorInstallProcessFailed, (Object)(Integer.valueOf(exitValue) + ": " + result.getOutput())));
                }
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.ws.st.core", 0, e.getLocalizedMessage(), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
            Trace.tracePerf("Feature install", time);
        }
        return Status.OK_STATUS;
    }

    private String[] getCommand(IProduct p, PasswordAuthentication pa, IPath installPath, boolean isUseLocation) {
        String batch = this.getBatchCommand(installPath);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(batch);
        commandList.add("install");
        commandList.add("--acceptLicense");
        if (batch.contains(FEATURE_MANAGER_CMD)) {
            commandList.add("--when-file-exists=replace");
        }
        if (pa != null) {
            commandList.add("--user=" + pa.getUserName());
            commandList.add("--password=" + new String(pa.getPassword()));
        }
        if (isUseLocation || p.getProductType() != IProduct.ProductType.MASSIVE_TYPE) {
            commandList.add(p.getSource().getLocation());
        } else {
            commandList.add(p.getProvideFeature().get(0));
        }
        String[] command = new String[commandList.size()];
        return commandList.toArray(command);
    }

    protected ProcessBuilder createProcessBuilder(Map<String, Object> settings, boolean isAddExtraProps, File workDir, String ... command) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(workDir);
        Map<String, String> env = builder.environment();
        IVMInstall vmInstall = (IVMInstall)settings.get("vmInstall");
        if (vmInstall != null) {
            File javaHome = LaunchUtil.getJavaHome(vmInstall.getInstallLocation());
            env.put("JAVA_HOME", javaHome.getAbsolutePath());
            String jvmArgs = "";
            if (LaunchUtil.isIBMJRE(vmInstall)) {
                jvmArgs = "-Xquickstart";
            }
            if (isAddExtraProps) {
                String assetLoc = System.getProperty(ASSET_LOCATION_OVERRIDE_PROP_NAME);
                if (assetLoc != null) {
                    jvmArgs = jvmArgs + " -Drepository.description.url=" + assetLoc;
                }
                jvmArgs = jvmArgs + " -Duser.agent=OLT/" + Activator.getBundleVersion();
                String repoPropsURL = (String)settings.get("repoPropsLocation");
                if (repoPropsURL != null) {
                    jvmArgs = jvmArgs + " -DWLP_REPOSITORIES_PROPS=" + repoPropsURL;
                }
            }
            if (jvmArgs.length() > 0) {
                env.put("JVM_ARGS", jvmArgs);
            }
        }
        env.put("EXIT_ALL", "1");
        builder.command(command);
        return builder;
    }

    private String getBatchCommand(IPath installPath) {
        IPath batchPath;
        String batch = "installUtility";
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            batch = batch + ".bat";
        }
        if ((batchPath = installPath.append("bin").append(batch)).toFile().exists()) {
            return batchPath.toOSString();
        }
        batch = FEATURE_MANAGER_CMD;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            batch = batch + ".bat";
        }
        return installPath.append("bin").append(batch).toOSString();
    }

    protected Map<String, Object> getInstallKernel(File wlpDir) {
        Map<String, Object> mapBasedInstallKernel = null;
        final File installJarFile = new File(wlpDir, "bin/tools/ws-installUtility.jar");
        if (installJarFile.exists()) {
            try {
                mapBasedInstallKernel = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> run() throws Exception {
                        URLClassLoader loader = new URLClassLoader(new URL[]{installJarFile.toURI().toURL()}, null);
                        Class<?> clazz = loader.loadClass("com.ibm.ws.install.MapBasedInstallKernel");
                        return (Map)clazz.newInstance();
                    }
                });
                if (mapBasedInstallKernel != null) {
                    mapBasedInstallKernel.put("runtime.install.dir", wlpDir);
                    Integer rc = (Integer)mapBasedInstallKernel.get("install.kernel.init.code");
                    if (rc == 0) {
                        return mapBasedInstallKernel;
                    }
                    Trace.logError((String)mapBasedInstallKernel.get("install.kernel.init.error.message"), null);
                }
            }
            catch (Throwable t) {
                Trace.logError("Failed to create the install kernel", t);
            }
        }
        return null;
    }
}

