/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.UtilityExtension;
import com.ibm.ws.st.core.internal.UtilityExtensionFactory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.launch.LibertyRemoteUtilityExecutionDelegate;
import com.ibm.ws.st.core.internal.launch.RemoteCreateSSLCertificate;
import com.ibm.ws.st.core.internal.launch.RemoteDumpServer;
import com.ibm.ws.st.core.internal.launch.RemoteJavaDump;
import com.ibm.ws.st.core.internal.launch.RemotePackageServer;
import com.ibm.ws.st.core.internal.launch.RemoteUtility;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class UtilityLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_RUNTIME = "runtime";
    public static final String ATTR_COMMAND = "command";
    public static final String ATTR_WORK_DIR = "workDir";
    public static final String ATTR_USER_DIR = "userDir";
    public static final String ATTR_JVM_ARGS = "jvmArgs";
    public static final String ATTR_SERVER_ID = "serverID";

    protected static IProcess newProcess(ILaunch launch, Process p, String label) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(IProcess.ATTR_PROCESS_TYPE, "websphere.utility");
        return new RuntimeProcess(launch, p, label, attributes);
    }

    protected static String renderCmdLine(ProcessBuilder pb) {
        List<String> cmdLine = pb.command();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String cmd : cmdLine) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            if (cmd.contains(" ")) {
                sb.append("\"" + cmd + "\"");
                continue;
            }
            sb.append(cmd);
        }
        return sb.toString();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = null;
        String serverID = configuration.getAttribute(ATTR_SERVER_ID, (String)null);
        if (serverID != null) {
            server = ServerCore.findServer((String)serverID);
        }
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Launch configuration could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptCannotRunRemoteUtility));
        }
        WebSphereServer websphereServer = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null));
        WebSphereServerBehaviour websphereServerBehaviour = (WebSphereServerBehaviour)((Object)server.loadAdapter(WebSphereServerBehaviour.class, null));
        IRuntime runtime = server.getRuntime();
        if (runtime == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "The runtime is null");
            }
            return;
        }
        WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        if (websphereServer == null || websphereServerBehaviour == null || wsRuntime == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Launch configuration could not find WebSphere server");
            }
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        IStatus status2 = websphereServer.validate();
        if (status2 != null && !status2.isOK()) {
            throw new CoreException(status2);
        }
        websphereServerBehaviour.setLaunch(launch);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            if (websphereServer.isLocalSetup()) {
                this.launchLocal(configuration, mode, launch, monitor);
            } else {
                this.launchRemote(configuration, mode, launch, monitor, websphereServerBehaviour);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    protected void launchLocal(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException, IOException {
        String runtimeId = configuration.getAttribute(ATTR_RUNTIME, (String)null);
        File workDir = new File(configuration.getAttribute(ATTR_WORK_DIR, (String)null));
        int userDirNum = configuration.getAttribute(ATTR_USER_DIR, 0);
        List commandList = configuration.getAttribute(ATTR_COMMAND, (List)null);
        String label = configuration.getAttribute(ATTR_LABEL, (String)null);
        String jvmArgs = configuration.getAttribute(ATTR_JVM_ARGS, (String)null);
        IRuntime runtime = ServerCore.findRuntime((String)runtimeId);
        WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        UserDirectory userDir = null;
        if (userDirNum >= 0) {
            userDir = wsRuntime.getUserDirectories().get(userDirNum);
        }
        String[] command = new String[commandList.size()];
        int i = 0;
        for (String s : commandList) {
            command[i++] = s;
        }
        ProcessBuilder pb = wsRuntime.createProcessBuilder(userDir, workDir, jvmArgs, command);
        Process p = pb.start();
        String cmd = pb.command().get(0) + " " + pb.command().get(1);
        IProcess process = UtilityLaunchConfigurationDelegate.newProcess(launch, p, LaunchUtil.getProcessLabel(cmd));
        process.setAttribute(IProcess.ATTR_CMDLINE, UtilityLaunchConfigurationDelegate.renderCmdLine(pb));
        process.setAttribute(IProcess.ATTR_PROCESS_LABEL, label);
        launch.addProcess(process);
    }

    protected void launchRemote(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, WebSphereServerBehaviour websphereServerBehaviour) throws CoreException {
        Map commandVariables = configuration.getAttribute(ATTR_COMMAND, (Map)null);
        int timeout = websphereServerBehaviour.getServer().getStopTimeout() * 10000;
        String utilityType = (String)commandVariables.get("utilityType");
        try {
            if (utilityType != null) {
                if (utilityType.equals("createSSLCertificate")) {
                    RemoteCreateSSLCertificate remoteLauncher = new RemoteCreateSSLCertificate(commandVariables, timeout, new LibertyRemoteUtilityExecutionDelegate());
                    remoteLauncher.execute(websphereServerBehaviour.getWebSphereServer(), mode, launch, monitor);
                } else if (utilityType.equals("package")) {
                    RemotePackageServer remoteLauncher = new RemotePackageServer(commandVariables, timeout, new LibertyRemoteUtilityExecutionDelegate());
                    remoteLauncher.execute(websphereServerBehaviour.getWebSphereServer(), mode, launch, monitor);
                } else if (utilityType.equals("dump")) {
                    RemoteDumpServer remoteLauncher = new RemoteDumpServer(commandVariables, timeout, new LibertyRemoteUtilityExecutionDelegate());
                    remoteLauncher.execute(websphereServerBehaviour.getWebSphereServer(), mode, launch, monitor);
                } else if (utilityType.equals("javadump")) {
                    RemoteJavaDump remoteLauncher = new RemoteJavaDump(commandVariables, timeout, new LibertyRemoteUtilityExecutionDelegate());
                    remoteLauncher.execute(websphereServerBehaviour.getWebSphereServer(), mode, launch, monitor);
                } else {
                    UtilityExtension utilityExt = UtilityExtensionFactory.getExtensionClass(utilityType);
                    RemoteUtility utility = utilityExt.getRemoteUtility(commandVariables, timeout, new LibertyRemoteUtilityExecutionDelegate());
                    utility.execute(websphereServerBehaviour.getWebSphereServer(), mode, launch, monitor);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", e.getLocalizedMessage(), (Throwable)e));
        }
    }
}

