/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.launch.IUtilityExecutionDelegate;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;

public class RemoteJavaDump {
    int timeout;
    String zipFilePath;
    String include;
    IUtilityExecutionDelegate executionDelegate = null;
    String serverName = null;
    private final String Expected_Sys_Out = "dump complete";

    public RemoteJavaDump(Map<String, String> commandVariables, int timeout, IUtilityExecutionDelegate helper) {
        this.timeout = timeout;
        this.executionDelegate = helper;
        if (commandVariables != null && !commandVariables.isEmpty()) {
            this.include = commandVariables.get("--include=");
        }
    }

    public void execute(WebSphereServer server, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)"Executing generate java dumps command for remote server");
        }
        try {
            this.serverName = server.getServerName();
            this.executionDelegate.initialize(server.getServer(), monitor);
            this.executionDelegate.startExecution();
            IPlatformHandler.ExecutionOutput result = this.executionDelegate.execute(server, launch.getLaunchMode(), launch, this.getCommand(), NLS.bind((String)Messages.taskJavaDump, (Object)this.serverName), this.getTimeout(), monitor, true);
            if (!this.executionDelegate.isExecutionSuccessful(result, "dump complete")) {
                Trace.logError((String)("Remote command failed: " + this.getCommand() + ", exit value: " + result.getReturnCode() + ", output: " + result.getOutput() + ", error: " + result.getError()), null);
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", result.getError()));
            }
        }
        catch (CoreException ce) {
            Trace.logError((String)"javaDump utility failed", (Throwable)ce);
            if (ce.getLocalizedMessage() == null) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServer_ErrorUtilityAction));
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServer_ErrorUtilityAction, (Throwable)ce));
        }
        finally {
            this.executionDelegate.endExecution();
        }
    }

    int getTimeout() {
        return this.timeout;
    }

    protected String getCommand() {
        StringBuilder command = new StringBuilder();
        command.append(this.executionDelegate.getServerScriptFilePath());
        command.append("javadump " + this.serverName);
        if (this.include != null) {
            command.append(" --include=" + this.include);
        }
        return command.toString();
    }
}

