/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.generation.AbstractFeatureListMetadata;
import com.ibm.ws.st.core.internal.generation.FeatureListExtMetadata;
import com.ibm.ws.st.core.internal.generation.IMetadataGenerator;
import com.ibm.ws.st.core.internal.generation.SchemaMetadata;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class GeneratorJob
extends Job {
    static final int NUMBER_OF_ATTEMPTS = 120;
    static final GeneratorSchedulingRule GENERATOR_RULE = new GeneratorSchedulingRule();
    IMetadataGenerator metadataGen;
    final Helper[] helpers;
    final Map<Helper, IPath> helperPathMap = new HashMap<Helper, IPath>();
    static int numberOfAttempts = 120;

    public static void generate(IMetadataGenerator metadataGen, Helper[] helpers, IJobChangeListener[] listeners) {
        GeneratorJob job = new GeneratorJob(metadataGen, helpers);
        if (listeners != null) {
            for (IJobChangeListener listener : listeners) {
                job.addJobChangeListener(listener);
            }
        }
        job.setPriority(20);
        job.setRule(GENERATOR_RULE);
        job.schedule();
    }

    public static int setNumberOfAttempts(int n) {
        int rc = numberOfAttempts;
        numberOfAttempts = n;
        return rc;
    }

    private GeneratorJob(IMetadataGenerator metadataGen, Helper[] helpers) {
        super(NLS.bind((String)Messages.jobRuntimeCache, (Object)metadataGen.getGeneratorId()));
        this.metadataGen = metadataGen;
        this.helpers = helpers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        long time = System.currentTimeMillis();
        int singleUnitTicks = 25;
        final IProgressMonitor monitor2 = monitor;
        int totalWork = this.helpers.length * 25;
        monitor.beginTask(NLS.bind((String)Messages.jobRuntimeCache, (Object)this.metadataGen.getGeneratorId()), totalWork);
        final IStatus[] finalStatus = new IStatus[]{Status.OK_STATUS};
        ArrayList<1> threads = new ArrayList<1>();
        this.associateTempFiles();
        this.deleteTempFiles();
        for (final Helper helper : this.helpers) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Thread t = new Thread(helper.getClass().getName()){

                @Override
                public void run() {
                    IStatus status = GeneratorJob.this.generate(helper, (IProgressMonitor)new SubProgressMonitor(monitor2, 25));
                    if (finalStatus[0].isOK()) {
                        finalStatus[0] = status;
                    }
                }
            };
            threads.add(t);
            t.start();
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Generator Job: All metadata generation threads started");
        }
        for (Thread thread : threads) {
            try {
                thread.join();
                Trace.trace((byte)0, "Thread " + thread.getName() + " completed.");
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                monitor.worked(100 / this.helpers.length);
            }
        }
        if (monitor.isCanceled()) {
            this.deleteTempFiles();
            return Status.CANCEL_STATUS;
        }
        if (!finalStatus[0].isOK()) {
            this.deleteTempFiles();
            Trace.logError(NLS.bind((String)Messages.metadataGenerationFailedDetails, (Object)this.metadataGen.getGeneratorId()), finalStatus[0].getException());
        } else {
            finalStatus[0] = this.renameTempFiles();
            if (!finalStatus[0].isOK()) {
                this.deleteTempFiles();
            }
        }
        monitor.done();
        if (Trace.ENABLED) {
            Trace.tracePerf("Generator job: All metadata generation threads finished", time);
        }
        return finalStatus[0];
    }

    protected IStatus generate(Helper helper, IProgressMonitor monitor) {
        String generatorId = this.metadataGen.getGeneratorId();
        IPath tempPath = this.helperPathMap.get(helper);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            if (helper instanceof SchemaMetadata) {
                this.metadataGen.generateSchema(tempPath.toOSString(), monitor, 120);
            } else if (this.metadataGen.supportsFeatureListGeneration()) {
                this.metadataGen.generateFeatureList(tempPath.toOSString(), monitor, 120, ((AbstractFeatureListMetadata)helper).getCommandOptions());
            }
        }
        catch (CoreException ce) {
            Trace.logError("Generation job failed", ce);
            return ce.getStatus();
        }
        catch (Exception ce) {
            return new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.metadataGenerationFailedDetails, (Object)generatorId), (Throwable)ce);
        }
        return Status.OK_STATUS;
    }

    private void associateTempFiles() {
        for (Helper helper : this.helpers) {
            IPath path = helper.getTarget(this.metadataGen);
            this.helperPathMap.put(helper, path.removeLastSegments(1).append(path.lastSegment() + ".tmp"));
        }
    }

    private void deleteTempFiles() {
        for (Helper helper : this.helpers) {
            IPath tempPath = this.helperPathMap.get(helper);
            File tempFile = tempPath.toFile();
            FileUtil.deleteFile(tempFile);
        }
    }

    protected IStatus renameTempFiles() {
        String generatorId = this.metadataGen.getGeneratorId();
        for (Helper helper : this.helpers) {
            if (!(helper instanceof SchemaMetadata) && !this.metadataGen.supportsFeatureListGeneration()) continue;
            IPath path = helper.getTarget(this.metadataGen);
            IPath tempPath = this.helperPathMap.get(helper);
            File tempFile = tempPath.toFile();
            if (tempFile.exists()) {
                File toFile = path.toFile();
                FileUtil.deleteFile(toFile);
                if (WebSphereRuntime.rename(tempFile, toFile)) continue;
                Trace.logError("Failed to generate " + helper.getTarget(this.metadataGen).toOSString() + " because the temporary file could not be renamed", null);
                return new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.metadataGenerationFailedDetails, (Object)generatorId));
            }
            if (helper instanceof FeatureListExtMetadata) continue;
            return new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.metadataGenerationFailedDetails, (Object)generatorId));
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return "com.ibm.ws.st.core.job.family".equals(family);
    }

    public static interface Helper {
        public IPath getTarget(IMetadataGenerator var1);
    }

    private static class GeneratorSchedulingRule
    implements ISchedulingRule {
        GeneratorSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == GENERATOR_RULE;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == GENERATOR_RULE;
        }
    }
}

