/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.URILocation;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class DocumentLocation
extends URILocation {
    private final Type type;
    private final String xpath;
    private final int line;
    private final int column;
    private final int startOffset;
    private final int endOffset;

    private DocumentLocation(URI uri, Type type, String xpath) {
        this(uri, type, xpath, -1, -1, -1, -1);
    }

    private DocumentLocation(URI uri, Type type, String xpath, int line, int column, int startOffset, int endOffset) {
        super(uri);
        this.type = type;
        this.xpath = xpath;
        this.line = line;
        this.column = column;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public static DocumentLocation createDocumentLocation(URI uri, Type type) {
        return new DocumentLocation(uri, type, null);
    }

    public static DocumentLocation createDocumentLocation(URI uri, Type type, int lineNo) {
        return new DocumentLocation(uri, type, null, lineNo, -1, -1, -1);
    }

    public static DocumentLocation createDocumentLocation(URI uri, Node node) {
        if (node instanceof IDOMNode) {
            return DocumentLocation.createDocumentLocation(uri, (IDOMNode)node);
        }
        return new DocumentLocation(uri, Type.SERVER_XML, DOMUtils.createXPath(node));
    }

    public static DocumentLocation createDocumentLocation(Node node) {
        return DocumentLocation.createDocumentLocation(null, node);
    }

    private static DocumentLocation createDocumentLocation(URI uri, IDOMNode node) {
        int endOffset;
        int startOffset;
        int column;
        int line;
        String xpath;
        URI locationURI;
        block11: {
            locationURI = uri;
            xpath = DOMUtils.createXPath((Node)node);
            line = -1;
            column = -1;
            IDOMDocument document = (IDOMDocument)node.getOwnerDocument();
            startOffset = node.getStartOffset();
            endOffset = node.getEndOffset();
            if (document != null) {
                IStructuredDocument structuredDocument;
                block10: {
                    String uriData;
                    if (locationURI == null && (uriData = (String)document.getUserData("uri")) != null) {
                        try {
                            locationURI = new URI(uriData);
                        }
                        catch (URISyntaxException e) {
                            if (!Trace.ENABLED) break block10;
                            Trace.trace((byte)1, "Invalid uri in DOM user data: " + uriData, e);
                        }
                    }
                }
                if ((structuredDocument = document.getStructuredDocument()) != null) {
                    try {
                        int sdLine = structuredDocument.getLineOfOffset(startOffset);
                        if (sdLine >= 0) {
                            line = sdLine + 1;
                            int lineOffset = structuredDocument.getLineOffset(sdLine);
                            column = startOffset - lineOffset + 1;
                        }
                        if (node.getNodeType() == 2) {
                            char c;
                            int i;
                            int length = endOffset - startOffset;
                            String value = structuredDocument.get(startOffset, length);
                            for (i = length - 1; i >= 0 && ((c = value.charAt(i)) == ' ' || c == '\t' || c == '\n' || c == '\r'); --i) {
                            }
                            endOffset -= length - i - 1;
                        }
                    }
                    catch (BadLocationException e) {
                        if (!Trace.ENABLED) break block11;
                        Trace.trace((byte)1, "Could not calculate line or column number", e);
                    }
                }
            }
        }
        return new DocumentLocation(locationURI, Type.SERVER_XML, xpath, line, column, startOffset, endOffset);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isConfigFile() {
        return this.type == Type.SERVER_XML;
    }

    public IFile getFile() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(this.getURI());
        if (files != null && files.length > 0 && files[0].exists()) {
            return files[0];
        }
        return null;
    }

    public String getXPath() {
        return this.xpath;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public IResource getResource() {
        return this.getFile();
    }

    public static enum Type {
        SERVER_XML,
        BOOTSTRAP,
        SERVER_ENV;

    }
}

