/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class WebSphereSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IModule[] mods;
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        ArrayList<IProject> projects = new ArrayList<IProject>();
        ArrayList<IModule> modules = new ArrayList<IModule>();
        for (IModule m : mods = server.getModules()) {
            modules.add(m);
        }
        while (!modules.isEmpty()) {
            IModule[] children;
            IModule module = (IModule)modules.remove(0);
            for (IModule m : children = server.getChildModules(new IModule[]{module}, monitor)) {
                modules.add(m);
            }
            IProject project = module.getProject();
            if (project == null || projects.contains(project) || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
            projects.add(project);
        }
        ArrayList<IRuntimeClasspathEntry> runtimeClasspath = new ArrayList<IRuntimeClasspathEntry>();
        for (IProject project : projects) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            runtimeClasspath.add(JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)javaProject));
        }
        runtimeClasspath.addAll(Arrays.asList(JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)configuration)));
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])runtimeClasspath.toArray(new IRuntimeClasspathEntry[runtimeClasspath.size()]), (ILaunchConfiguration)configuration);
        ArrayList<ISourceContainer> containersList = new ArrayList<ISourceContainer>();
        containersList.addAll(Arrays.asList(JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved)));
        ISourcePathComputerDelegate[] spcs = null;
        try {
            for (ISourcePathComputerDelegate delegate : spcs = Activator.getInstance().getSourcePathComputers()) {
                ISourceContainer[] extendedContainers = delegate.computeSourceContainers(configuration, monitor);
                containersList.addAll(Arrays.asList(extendedContainers));
            }
        }
        catch (Exception e) {
            Trace.trace((byte)0, "No source path extensions were found.");
        }
        ISourceContainer[] containers = new ISourceContainer[containersList.size()];
        containersList.toArray(containers);
        return containers;
    }
}

