/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.LibertySSLCreateCertificationUtility;
import com.ibm.ws.st.core.internal.LibertyServerDumpUtility;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.ProcessHelper;
import com.ibm.ws.st.core.internal.SchemaLocationProvider;
import com.ibm.ws.st.core.internal.ServerListenerUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.URIUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntimeClasspathHelper;
import com.ibm.ws.st.core.internal.WebSphereRuntimeProductInfoCacheUtil;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.config.SchemaHelper;
import com.ibm.ws.st.core.internal.crypto.CustomPasswordEncryptionInfo;
import com.ibm.ws.st.core.internal.generation.FeatureListCoreMetadata;
import com.ibm.ws.st.core.internal.generation.FeatureListExtMetadata;
import com.ibm.ws.st.core.internal.generation.IMetadataGenerator;
import com.ibm.ws.st.core.internal.generation.Metadata;
import com.ibm.ws.st.core.internal.generation.SchemaMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.eclipse.wst.server.core.util.PublishHelper;

public class WebSphereRuntime
extends RuntimeDelegate
implements IJavaRuntime,
IMetadataGenerator {
    private static final String SHARED_FOLDER = "usr/shared";
    private static final String SHARED_CONFIG_FOLDER = "usr/shared/config";
    private static final String SHARED_APP_FOLDER = "usr/shared/apps";
    private static final String SHARED_RESOURCES_FOLDER = "usr/shared/resources";
    private static final String SERVERS_FOLDER = "usr/servers";
    private static final String SECURITY_UTILITY = "securityUtility";
    private static final String ENCODE = "encode";
    private static final String SU_OPTION_LISTCUSTOM = "--listCustom";
    public static final String RUNTIME_MARKER = "lib/versions/WebSphereApplicationServer.properties";
    public static final String OPEN_RUNTIME_MARKER = "lib/versions/openliberty.properties";
    protected static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    protected static final String PROP_VM_INSTALL_ID = "vm-install-id";
    protected static final String PROP_USER_DIRS = "user-dirs";
    public static final String PROP_USER_DIRECTORY = "userDirectory";
    protected static final String PROP_USER_DIR_NAME_MAP = "user-dir-name-map";
    private static final String USER_DIR_METADATA_PATH = "OLT__UserDirectory__";
    private static byte userDirCounter = 0;
    protected List<WebSphereServerInfo> serverInfo;
    protected List<UserDirectory> userDirCache;
    protected List<String> customEncryptionAlgoList = null;
    protected Map<String, CustomPasswordEncryptionInfo> customPasswordEncryptionInfoMap = null;
    protected int serverCacheHash = -1;
    protected int userDirHash = -1;
    protected String runtimeVersion = null;
    protected String runtimeEdition = null;
    private SchemaHelper schemaHelper = null;
    private WebSphereRuntimeClasspathHelper classpathHelper;
    IPath savedMetadataDirectoryInCaseLocationIsMoved = null;
    private JAVAEESUPPORT earSupported = null;

    public WebSphereRuntime() {
        SchemaLocationProvider.setTempRuntime(this);
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            for (int i = 0; i < size; ++i) {
                if (!id.equals(vmInstalls[i].getId())) continue;
                return vmInstalls[i];
            }
        }
        catch (Exception e) {
            Trace.logError("Could not resolve VM install", e);
        }
        return null;
    }

    protected void initialize() {
        if (this.metadataDirectoryExists()) {
            this.setSavedMetadataDirectory(this.buildMetadataDirectoryPath());
        }
        if (this.getRuntime().isWorkingCopy()) {
            return;
        }
        if (ServerCore.findRuntime((String)this.getRuntime().getId()) != null) {
            this.createProject(null);
        }
        this.initializeClasspathHelper();
    }

    public List<String> getSupportedCustomEncryption() {
        if (this.customEncryptionAlgoList != null) {
            return this.customEncryptionAlgoList;
        }
        if (this.customPasswordEncryptionInfoMap == null) {
            this.customPasswordEncryptionInfoMap = this.listCustomEncryption((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.customPasswordEncryptionInfoMap != null) {
            this.customEncryptionAlgoList = new ArrayList<String>();
            this.customEncryptionAlgoList.addAll(this.customPasswordEncryptionInfoMap.keySet());
        }
        return this.customEncryptionAlgoList;
    }

    public Map<String, CustomPasswordEncryptionInfo> listCustomEncryption() {
        if (this.customPasswordEncryptionInfoMap == null) {
            this.customPasswordEncryptionInfoMap = this.listCustomEncryption((IProgressMonitor)new NullProgressMonitor());
        }
        return this.customPasswordEncryptionInfoMap;
    }

    protected static IStatus validateLocation(IPath path) {
        if (!WebSphereRuntime.isValidLocation(path)) {
            return new Status(4, "com.ibm.ws.st.core", 0, Messages.errorInstallDirMissing, null);
        }
        return Status.OK_STATUS;
    }

    public static boolean isValidLocation(IPath path) {
        return WebSphereRuntime.getRuntimePropertiesPath(path) != null;
    }

    public static List<IPath> findValidLocations(IPath path) {
        if (path == null) {
            return null;
        }
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IPath parentPath = path.removeLastSegments(1);
        if (WebSphereRuntime.isValidLocation(parentPath)) {
            paths.add(parentPath);
        }
        String lastSegment = path.lastSegment();
        String[] files = parentPath.toFile().list();
        if (files != null && lastSegment != null) {
            lastSegment = lastSegment.toLowerCase();
            for (String s : files) {
                if (!s.toLowerCase().startsWith(lastSegment)) continue;
                IPath childPath = parentPath.append(s);
                if (WebSphereRuntime.isValidLocation(childPath)) {
                    paths.add(childPath);
                }
                if (!WebSphereRuntime.isValidLocation(childPath = parentPath.append(s).append("wlp"))) continue;
                paths.add(childPath);
            }
        }
        return paths;
    }

    public IStatus validate() {
        String javaVersion;
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        status = WebSphereRuntime.validateLocation(this.getRuntime().getLocation());
        if (!status.isOK()) {
            return status;
        }
        if (this.getRuntime().getLocation().hasTrailingSeparator()) {
            return new Status(4, "com.ibm.ws.st.core", 0, Messages.errorInstallDirTrailingSlash, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "com.ibm.ws.st.core", 0, Messages.errorJRE, null);
        }
        IVMInstall vmInstall = this.getVMInstall();
        if (vmInstall instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)vmInstall).getJavaVersion()) != null && javaVersion.compareTo("1.6") < 0) {
            return new Status(4, "com.ibm.ws.st.core", 0, Messages.errorJRE60, null);
        }
        return Status.OK_STATUS;
    }

    public void setDefaults(IProgressMonitor monitor) {
        IRuntimeType type = this.getRuntimeWorkingCopy().getRuntimeType();
        String lastLocation = Activator.getPreference(type.getId() + ".folder", null);
        IRuntimeWorkingCopy wc = this.getRuntimeWorkingCopy();
        if (lastLocation != null) {
            int i = lastLocation.indexOf(",");
            if (i >= 0) {
                lastLocation = lastLocation.substring(0, i);
            }
            wc.setLocation((IPath)new Path(lastLocation));
        }
        String name = wc.getName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String newName = name;
        int i = 2;
        while (root.exists((IPath)new Path(newName))) {
            newName = name + " (" + i + ')';
            ++i;
        }
        if (i != 2) {
            wc.setName(newName);
        }
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }

    public synchronized List<UserDirectory> getUserDirectories() {
        List list;
        int hash = this.getRuntimeHash();
        if (this.userDirCache != null && hash == this.userDirHash) {
            return this.userDirCache;
        }
        this.userDirHash = hash;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<UserDirectory> userDirs = new ArrayList<UserDirectory>(2);
        IPath runtimeLocation = this.getRuntime().getLocation();
        if (runtimeLocation == null) {
            return userDirs;
        }
        IPath runtimeUserPath = runtimeLocation.append("usr");
        if (runtimeUserPath.toFile().exists()) {
            IProject project = null;
            for (IProject p : projects) {
                if (!runtimeUserPath.equals((Object)p.getLocation())) continue;
                project = p;
                break;
            }
            if (project == null) {
                project = this.getProject();
            }
            userDirs.add(new UserDirectory(this, runtimeUserPath, project));
        }
        if ((list = this.getAttribute(PROP_USER_DIRS, null)) == null || list.isEmpty()) {
            this.userDirCache = userDirs;
            return this.userDirCache;
        }
        for (Object o : list) {
            if (!(o instanceof String)) continue;
            String s = (String)o;
            if (!s.contains("/")) {
                IProject project = root.getProject(s);
                IPath location = project.getLocation();
                if (location == null) {
                    location = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getName());
                }
                userDirs.add(new UserDirectory(this, location, project));
                continue;
            }
            Path path = new Path(s);
            IProject project = null;
            for (IProject p : projects) {
                if (!p.getLocation().equals((Object)path)) continue;
                project = p;
                break;
            }
            userDirs.add(new UserDirectory(this, (IPath)path, project));
        }
        this.userDirCache = userDirs;
        return this.userDirCache;
    }

    public UserDirectory getUserDir(String id) {
        List<UserDirectory> userDirs = this.getUserDirectories();
        for (UserDirectory userDir : userDirs) {
            if (!userDir.matchesId(id)) continue;
            return userDir;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Could not find user directory for id: " + id + " and runtime: " + this.getRuntime().getName());
        }
        return null;
    }

    public synchronized String[] getServerTemplates() {
        if (this.getRuntime().getLocation() == null) {
            return new String[0];
        }
        File[] fList = this.getRuntime().getLocation().append("templates/servers").toFile().listFiles();
        if (fList == null) {
            return new String[0];
        }
        ArrayList<String> tplList = new ArrayList<String>();
        File f = null;
        for (int i = 0; i < fList.length; ++i) {
            f = new File(fList[i].getAbsolutePath() + File.separator + "server.xml");
            if (!fList[i].isDirectory() || !f.exists()) continue;
            tplList.add(fList[i].getName());
        }
        Collections.sort(tplList);
        String[] ret = new String[tplList.size()];
        for (int i = 0; i < tplList.size(); ++i) {
            ret[i] = (String)tplList.get(i);
        }
        return ret;
    }

    public synchronized void addUserDirectory(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("Project cannot be null");
        }
        this.addUserDirectory(project.getLocation(), project, null);
    }

    public synchronized void addUserDirectory(IPath path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        this.addUserDirectory(path, null, null);
    }

    public void addUserDirectory(UserDirectory userDir) {
        if (userDir == null) {
            throw new IllegalArgumentException("UserDir cannot be null");
        }
        this.addUserDirectory(userDir.getPath(), userDir.getProject(), userDir);
    }

    private void addUserDirectory(IPath path, IProject project, UserDirectory userDir) {
        List list = this.getAttribute(PROP_USER_DIRS, null);
        int size = list == null ? 2 : list.size() + 1;
        ArrayList<String> newList = new ArrayList<String>(size);
        if (list != null) {
            for (Object o : list) {
                if (!(o instanceof String)) continue;
                newList.add((String)o);
            }
        }
        UserDirectory userDirectory = null;
        if (project != null) {
            newList.add(project.getName());
        } else {
            newList.add(path.toPortableString());
        }
        userDirectory = userDir != null ? userDir : new UserDirectory(this, path, project);
        this.setAttribute(PROP_USER_DIRS, newList);
        this.getUserDirectories();
        this.userDirCache.add(userDirectory);
    }

    public synchronized void removeUserDirectory(UserDirectory userDir) {
        List list = this.getAttribute(PROP_USER_DIRS, null);
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<String> newList = new ArrayList<String>(list.size());
        for (Object o : list) {
            if (!(o instanceof String)) continue;
            String s = (String)o;
            boolean ok = true;
            if (userDir.getProject() != null && !s.contains("/")) {
                if (userDir.getProject().getName().equals(s)) {
                    ok = false;
                }
            } else if (userDir.getPath().equals((Object)new Path(s))) {
                ok = false;
            }
            if (!ok) continue;
            newList.add((String)o);
        }
        this.setAttribute(PROP_USER_DIRS, newList);
        this.getUserDirectories();
        this.userDirCache.remove(userDir);
    }

    public synchronized String[] getServerNames() {
        this.updateServerCache(false);
        int length = this.serverInfo.size();
        String[] serverNames = new String[length];
        for (int i = 0; i < length; ++i) {
            serverNames[i] = this.serverInfo.get(i).getServerName();
        }
        Arrays.sort(serverNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        return serverNames;
    }

    public synchronized void refresh() {
        this.updateServerCache(true);
        this.schemaHelper = null;
        this.customEncryptionAlgoList = null;
        this.customPasswordEncryptionInfoMap = null;
        this.fireRefreshEvent();
    }

    private int getRuntimeHash() {
        IPath runtimeLocation = this.getRuntime().getLocation();
        if (runtimeLocation == null) {
            return 0;
        }
        int hash = runtimeLocation.hashCode() + this.getRuntime().getName().hashCode() * 7;
        if (runtimeLocation.append("usr").toFile().exists()) {
            ++hash;
        }
        return hash;
    }

    public synchronized void updateServerCache(boolean force) {
        int hash = this.getRuntimeHash();
        if (this.serverInfo != null && !force && this.serverCacheHash == hash) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.serverInfo == null) {
            this.serverInfo = new ArrayList<WebSphereServerInfo>(5);
        }
        IPath runtimePath = this.getRuntime().getLocation();
        this.serverCacheHash = hash;
        if (runtimePath == null) {
            return;
        }
        boolean changed = false;
        ArrayList<WebSphereServerInfo> found = new ArrayList<WebSphereServerInfo>(5);
        List<UserDirectory> userDirs = this.getUserDirectories();
        for (UserDirectory userDir : userDirs) {
            File[] folders;
            IPath path = userDir.getServersPath();
            if (!path.toFile().exists()) continue;
            for (File f : folders = path.toFile().listFiles()) {
                File serverFile;
                if (!f.isDirectory() || !(serverFile = new File(f, "server.xml")).exists()) continue;
                String serverName = f.getName();
                WebSphereServerInfo info = null;
                for (WebSphereServerInfo existing : this.serverInfo) {
                    if (!existing.getServerName().equals(serverName) || !existing.getUserDirectory().equals(userDir)) continue;
                    info = existing;
                }
                if (info == null) {
                    info = new WebSphereServerInfo(serverName, userDir, this);
                    this.serverInfo.add(info);
                    changed = true;
                }
                found.add(info);
                try {
                    info.updateCache();
                }
                catch (Exception e) {
                    Trace.logError("Error updating runtime cache: " + info.getServerName(), e);
                }
            }
        }
        ArrayList<WebSphereServerInfo> delete = new ArrayList<WebSphereServerInfo>(1);
        for (WebSphereServerInfo info : this.serverInfo) {
            if (found.contains(info)) continue;
            delete.add(info);
            changed = true;
        }
        for (WebSphereServerInfo info : delete) {
            this.serverInfo.remove(info);
        }
        if (changed) {
            this.fireRefreshEvent();
            this.refreshProjectView();
        }
        if (Trace.ENABLED) {
            Trace.tracePerf("Update runtime cache", time);
        }
    }

    private void refreshProjectView() {
        Job job = new Job("Server Project View Updater"){

            protected IStatus run(IProgressMonitor monitor) {
                List<UserDirectory> userDirs = WebSphereRuntime.this.getUserDirectories();
                for (UserDirectory userDir : userDirs) {
                    IFolder servers = userDir.getServersFolder();
                    if (servers == null || !servers.exists()) continue;
                    try {
                        servers.refreshLocal(2, null);
                    }
                    catch (CoreException ce) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "Couldn't refresh workspace after updating runtime: " + WebSphereRuntime.this.getRuntime().getId(), ce);
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "com.ibm.ws.st.core.job.family".equals(family);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void fireRefreshEvent() {
        IRuntimeWorkingCopy wc;
        IRuntime runtime;
        IRuntime theRuntime = this.getRuntime();
        if (theRuntime.isWorkingCopy() && (runtime = (wc = (IRuntimeWorkingCopy)theRuntime).getOriginal()) != null) {
            theRuntime = runtime;
        }
        ServerListenerUtil.getInstance().fireRuntimeChangedEvent(theRuntime);
    }

    public void fireMetadataRefreshEvent() {
        IRuntimeWorkingCopy wc;
        IRuntime runtime;
        IRuntime theRuntime = this.getRuntime();
        if (theRuntime.isWorkingCopy() && (runtime = (wc = (IRuntimeWorkingCopy)theRuntime).getOriginal()) != null) {
            theRuntime = runtime;
        }
        ServerListenerUtil.getInstance().fireMetadataChangedEvent(theRuntime);
    }

    public synchronized WebSphereServerInfo getServerInfo(String serverName, UserDirectory userDir) {
        this.updateServerCache(false);
        for (WebSphereServerInfo info : this.serverInfo) {
            if (!info.getServerName().equals(serverName) || userDir == null || !userDir.equals(info.getUserDirectory())) continue;
            return info;
        }
        return null;
    }

    public synchronized List<WebSphereServerInfo> getWebSphereServerInfos(UserDirectory userDir) {
        this.updateServerCache(false);
        ArrayList<WebSphereServerInfo> list = new ArrayList<WebSphereServerInfo>(this.serverInfo.size());
        for (WebSphereServerInfo info : this.serverInfo) {
            if (!info.getUserDirectory().equals(userDir)) continue;
            list.add(info);
        }
        return list;
    }

    public synchronized boolean hasServers() {
        this.updateServerCache(false);
        return this.serverInfo.size() > 0;
    }

    public synchronized List<WebSphereServerInfo> getWebSphereServerInfos() {
        this.updateServerCache(false);
        return new ArrayList<WebSphereServerInfo>(this.serverInfo);
    }

    public ProcessBuilder createProcessBuilder(String option, WebSphereServerInfo server, String ... command) {
        File workDir = server.getServerOutputPath().toFile();
        UserDirectory userDir = server.getUserDirectory();
        if (!workDir.exists()) {
            workDir = userDir.getPath().toFile();
        }
        String[] command2 = new String[command.length + 3];
        command2[0] = "server";
        command2[1] = option;
        command2[2] = server.getServerName();
        System.arraycopy(command, 0, command2, 3, command.length);
        return this.createProcessBuilder(userDir, workDir, null, command2);
    }

    public ProcessBuilder createProcessBuilder(UserDirectory userDir, File workDir, String extraJvmArgs, String ... command) {
        IVMInstall vmInstall;
        String batch = command[0];
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            batch = batch + ".bat";
        }
        command[0] = this.getRuntime().getLocation().append("bin").append(batch).toOSString();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(workDir);
        Map<String, String> env = builder.environment();
        if (userDir != null) {
            env.put("WLP_USER_DIR", userDir.getPath().toOSString());
            env.put("WLP_OUTPUT_DIR", userDir.getOutputPath().toOSString());
        }
        if ((vmInstall = this.getVMInstall()) != null) {
            File javaHome = LaunchUtil.getJavaHome(vmInstall.getInstallLocation());
            env.put("JAVA_HOME", javaHome.getAbsolutePath());
            String jvmArgs = extraJvmArgs;
            if (LaunchUtil.isIBMJRE(vmInstall)) {
                String string = jvmArgs = jvmArgs == null ? "-Xquickstart" : jvmArgs + " " + "-Xquickstart";
            }
            if (jvmArgs != null) {
                env.put("JVM_ARGS", jvmArgs);
            }
        }
        env.put("EXIT_ALL", "1");
        builder.command(command);
        return builder;
    }

    protected ProcessBuilder createProcessBuilder(String ... command) {
        String batch = command[0];
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            batch = batch + ".bat";
        }
        IPath location = this.getRuntime().getLocation().append("bin");
        command[0] = location.append(batch).toOSString();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(location.toFile());
        builder.redirectErrorStream(true);
        Map<String, String> env = builder.environment();
        IVMInstall vmInstall = this.getVMInstall();
        if (vmInstall != null) {
            File javaHome = LaunchUtil.getJavaHome(vmInstall.getInstallLocation());
            env.put("JAVA_HOME", javaHome.getAbsolutePath());
            if (LaunchUtil.isIBMJRE(vmInstall)) {
                env.put("JVM_ARGS", "-Xquickstart");
            }
        }
        builder.command(command);
        return builder;
    }

    protected ProcessBuilder createJavaProcessBuilder(String jar, String[] options) {
        String javaCmd;
        IVMInstall vmInstall = this.getVMInstall();
        if (vmInstall != null) {
            File javaHome = LaunchUtil.getJavaHome(vmInstall.getInstallLocation());
            Path javaPath = new Path(javaHome.getAbsolutePath());
            javaPath = javaPath.append("bin").append("java");
            javaCmd = javaPath.toOSString();
        } else {
            javaCmd = "java";
        }
        int size = options != null ? options.length : 0;
        String[] command = new String[3 + size];
        command[0] = javaCmd;
        command[1] = "-jar";
        command[2] = jar;
        if (options != null) {
            for (int i = 0; i < size; ++i) {
                command[i + 3] = options[i];
            }
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.getRuntime().getLocation().append("bin").append("tools").toFile());
        builder.redirectErrorStream(true);
        Map<String, String> env = builder.environment();
        if (vmInstall != null) {
            File javaHome = LaunchUtil.getJavaHome(vmInstall.getInstallLocation());
            env.put("JAVA_HOME", javaHome.getAbsolutePath());
            if (LaunchUtil.isIBMJRE(vmInstall)) {
                env.put("JVM_ARGS", "-Xquickstart");
            }
        }
        builder.command(command);
        return builder;
    }

    public void createServer(String serverName, String template, IPath userDirPath, IProgressMonitor monitor) throws CoreException {
        if (serverName == null) {
            throw new IllegalArgumentException("Server name cannot be null");
        }
        List<WebSphereServerInfo> existing = this.getWebSphereServerInfos();
        for (WebSphereServerInfo info : existing) {
            if (!info.getUserDirectory().getPath().equals((Object)userDirPath) || !info.getServerName().equals(serverName)) continue;
            throw new IllegalArgumentException("Server already exists");
        }
        long time = System.currentTimeMillis();
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        monitor2.beginTask(NLS.bind((String)Messages.taskServerCreate, (Object)serverName), 230);
        try {
            WebSphereServerInfo info = new WebSphereServerInfo(serverName, new UserDirectory(this, userDirPath, null), this);
            Process p = null;
            String version = this.getRuntimeVersion();
            p = template == null || version != null && version.startsWith("8.5.0") || version == null && template.equals("defaultServer") ? this.createProcessBuilder("create", info, new String[0]).start() : this.createProcessBuilder("create", info, "--template=" + template).start();
            monitor2.worked(30);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(p, 150, 10.0f, 200, monitor2);
            if (result.getExitValue() != 0) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorServerCreate, (Object)(Integer.valueOf(result.getExitValue()) + ": " + result.getOutput()))));
            }
        }
        catch (TimeoutException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorTimeout));
        }
        catch (IOException e) {
            Trace.logError("Error creating server: " + serverName, e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorServerCreate, (Object)e.getLocalizedMessage())));
        }
        finally {
            this.updateServerCache(true);
            monitor2.done();
            if (Trace.ENABLED) {
                Trace.tracePerf("Create server", time);
            }
        }
    }

    public void deleteServer(WebSphereServerInfo server, IProgressMonitor monitor) throws CoreException {
        if (server == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        IPath path = this.getRuntime().getLocation();
        if (path == null) {
            return;
        }
        server.removeMetadata(null, true, true);
        try {
            path = server.getServerPath();
            if (!path.toFile().exists()) {
                throw new IllegalArgumentException("Server does not exist");
            }
            IStatus[] status = PublishHelper.deleteDirectory((File)path.toFile(), (IProgressMonitor)monitor);
            if (status != null && status.length > 0) {
                if (status.length == 1) {
                    throw new CoreException(status[0]);
                }
                throw new CoreException((IStatus)new MultiStatus("com.ibm.ws.st.core", 0, status, Messages.errorDeletingServer, null));
            }
        }
        catch (CoreException ce) {
            Trace.logError("Error deleting server: " + server.getServerName(), ce);
            throw ce;
        }
        catch (Exception e) {
            Trace.logError("Error deleting server: " + server.getServerName(), e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", e.getLocalizedMessage()));
        }
        finally {
            this.updateServerCache(true);
        }
    }

    public boolean isServerStarted(WebSphereServerInfo server, IProgressMonitor monitor) throws CoreException {
        return this.getServerStatus(server, 8.0f, monitor) == 0;
    }

    public int getServerStatus(WebSphereServerInfo server, float timeout, IProgressMonitor monitor) throws CoreException {
        int r;
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        this.verifyServerExists(server);
        String serverName = server.getServerName();
        monitor2.beginTask(NLS.bind((String)Messages.taskServerStatus, (Object)serverName), 230);
        long time = 0L;
        if (Trace.ENABLED_DETAILS) {
            time = System.currentTimeMillis();
        }
        try {
            Process p = this.createProcessBuilder("status:fast", server, new String[0]).start();
            monitor2.worked(30);
            r = ProcessHelper.waitForProcess(p, 50, timeout, 200, monitor2).getExitValue();
        }
        catch (TimeoutException t) {
            r = -1;
        }
        catch (Throwable t) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorServerStatus, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
        }
        if (Trace.ENABLED_DETAILS) {
            Trace.trace((byte)8, "runtime server status: " + r);
            Trace.tracePerf("get runtime server status", time);
        }
        return r;
    }

    public ILaunchConfiguration createUtilityLaunchConfig(WebSphereServerInfo serverInfo, String jvmArgs, String ... command) throws CoreException {
        return this.createUtilityLaunchConfig("com.ibm.ws.st.core.utilityLaunchConfiguration", serverInfo, jvmArgs, command);
    }

    public ILaunchConfiguration createUtilityLaunchConfig(String launchConfigType, WebSphereServerInfo serverInfo, String jvmArgs, String ... command) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(serverInfo);
        String serverID = wsServer.getServer().getId();
        ILaunchConfigurationType lct = launchManager.getLaunchConfigurationType(launchConfigType);
        ILaunchConfigurationWorkingCopy wc = lct.newInstance(null, this.getRuntime().getName());
        wc.setAttribute("runtime", this.getRuntime().getId());
        wc.setAttribute("workDir", serverInfo.getServerOutputPath().toOSString());
        wc.setAttribute("userDir", this.getUserDirectories().indexOf(serverInfo.getUserDirectory()));
        wc.setAttribute("label", LaunchUtil.getProcessLabelAttr(serverInfo.getWebSphereRuntime().getRuntime().getName(), serverInfo.getServerName()));
        if (jvmArgs != null) {
            wc.setAttribute("jvmArgs", jvmArgs);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : command) {
            list.add(s);
        }
        wc.setAttribute("command", list);
        wc.setAttribute("serverID", serverID);
        return wc.doSave();
    }

    public ILaunchConfiguration createRemoteUtilityLaunchConfig(WebSphereServerInfo serverInfo, Map<String, String> commandVariables) throws CoreException {
        return this.createRemoteUtilityLaunchConfig("com.ibm.ws.st.core.utilityLaunchConfiguration", serverInfo, commandVariables);
    }

    public ILaunchConfiguration createRemoteUtilityLaunchConfig(String launchConfigType, WebSphereServerInfo serverInfo, Map<String, String> commandVariables) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(serverInfo);
        String serverID = wsServer.getServer().getId();
        ILaunchConfigurationType lct = launchManager.getLaunchConfigurationType(launchConfigType);
        ILaunchConfigurationWorkingCopy wc = lct.newInstance(null, this.getRuntime().getName());
        wc.setAttribute("command", commandVariables);
        wc.setAttribute("serverID", serverID);
        return wc.doSave();
    }

    public void callPackageServerCommand(WebSphereServerInfo server, File zipFile, String include, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("server");
        command.add("package");
        command.add(server.getServerName());
        command.add("--archive=" + zipFile.getPath());
        if (include != null) {
            command.add("--include=" + include);
        }
        ILaunchConfiguration lc = this.createUtilityLaunchConfig(server, null, command.toArray(new String[command.size()]));
        ILaunch launch = lc.launch("run", monitor);
        while (!monitor.isCanceled() && !launch.isTerminated()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
        monitor.done();
    }

    public void packageServer(final WebSphereServerInfo server, final File archiveFile, final String include, final boolean publishServer, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        this.verifyServerExists(server);
        final WebSphereServer ws = WebSphereUtil.getWebSphereServer(server);
        if (ws == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptServerNotFound));
        }
        if (ws.isLocalSetup() ? this.isServerStarted(server, monitor2) : ws.getServer().getServerState() != 4) {
            throw new IllegalArgumentException(Messages.serverMustBeStopped);
        }
        if (archiveFile == null || archiveFile.isDirectory()) {
            throw new IllegalArgumentException(Messages.invalidZipFile);
        }
        final String serverName = server.getServerName();
        Job job = new Job(NLS.bind((String)Messages.taskPackageServer, (Object)server.getServerName())){
            IStatus opStatus;
            boolean isAutoPublish;
            int autoPublishSettings;
            {
                super(arg0);
                this.opStatus = null;
                this.isAutoPublish = ServerCore.isAutoPublishing();
                this.autoPublishSettings = ws.getServer().getAttribute("auto-publish-setting", 2);
            }

            public boolean belongsTo(Object family) {
                return "com.ibm.ws.st.core.job.family".equals(family);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(NLS.bind((String)Messages.taskPackageServer, (Object)serverName), 100);
                boolean republishAndChangeConfig = false;
                String version = WebSphereRuntime.this.getRuntimeVersion();
                if ((version == null || "8.5.0.0".equals(version)) && ws.isLooseConfigEnabled()) {
                    republishAndChangeConfig = true;
                }
                monitor.worked(10);
                try {
                    IStatus status = null;
                    if (republishAndChangeConfig) {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "The runtime version is " + version + ". Republishing the server with non loose config ");
                        }
                        status = this.republishServer(false, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    } else if (publishServer) {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "The runtime version is " + version + ". Republishing with loose config: " + ws.isLooseConfigEnabled());
                        }
                        status = this.republishServer(ws.isLooseConfigEnabled(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    }
                    if (status != null && (status.getSeverity() == 8 || status.getSeverity() == 4)) {
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    monitor.subTask(Messages.taskPackaging);
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Start to use the launcher to call the package command. ");
                    }
                    ILaunchConfiguration lc = null;
                    ILaunch launch = null;
                    if (!ws.isLocalSetup()) {
                        HashMap<String, String> commandVariables = new HashMap<String, String>();
                        commandVariables.put("utilityType", "package");
                        commandVariables.put("--archive=", archiveFile.getPath());
                        commandVariables.put("--include=", include);
                        lc = WebSphereRuntime.this.createRemoteUtilityLaunchConfig(server, commandVariables);
                    } else {
                        ArrayList<String> command = new ArrayList<String>();
                        command.add("server");
                        command.add("package");
                        command.add(server.getServerName());
                        command.add("--archive=" + archiveFile.getPath());
                        if (include != null) {
                            command.add("--include=" + include);
                        }
                        lc = WebSphereRuntime.this.createUtilityLaunchConfig(server, null, command.toArray(new String[command.size()]));
                    }
                    if (lc != null) {
                        launch = lc.launch("run", monitor);
                    }
                    boolean count = false;
                    int cmdRemain = 50;
                    monitor.worked(cmdRemain);
                }
                catch (Throwable t) {
                    Trace.logError("Exception when running package server " + server.getServerName(), t);
                    Status status = new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorPackagingServer, (Object)t.getLocalizedMessage()));
                    return status;
                }
                finally {
                    try {
                        if (republishAndChangeConfig) {
                            IStatus status;
                            if (Trace.ENABLED) {
                                Trace.trace((byte)0, "Done packaging the server. The server version is " + version + ". Republish the server again with looseConfig");
                            }
                            if ((status = this.republishServer(true, (IProgressMonitor)new SubProgressMonitor(monitor, 20))).getSeverity() == 8 || status.getSeverity() == 4) {
                                IStatus iStatus = status;
                                return iStatus;
                            }
                        }
                    }
                    catch (Throwable t) {
                        Trace.logError("Exception when running package server " + server.getServerName(), t);
                        Status e = new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorPackagingServer, (Object)t.getLocalizedMessage()));
                        return e;
                    }
                    finally {
                        IServerWorkingCopy wc = ws.getServer().createWorkingCopy();
                        wc.setAttribute("auto-publish-setting", this.autoPublishSettings);
                        try {
                            wc.save(true, monitor);
                            ws.getWebSphereServerBehaviour().setWebSphereServerPublishState(1);
                            ServerPreferences.getInstance().setAutoPublishing(this.isAutoPublish);
                        }
                        catch (CoreException e) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)1, "Failed to change the auto publish setting back.");
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }
                if (!Trace.ENABLED) return Status.OK_STATUS;
                Trace.trace((byte)0, "Server package completed.");
                return Status.OK_STATUS;
            }

            private IStatus republishServer(boolean looseConfig, IProgressMonitor monitor2) throws CoreException {
                IProgressMonitor monitor = monitor2;
                if (monitor2 == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(Messages.taskPackagePublish, 20);
                monitor.subTask(Messages.taskPackagePublish);
                monitor.worked(5);
                IServer iServer = ws.getServer();
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Change the loose config mode for server packaging.");
                }
                ServerPreferences.getInstance().setAutoPublishing(false);
                IServerWorkingCopy wc = iServer.createWorkingCopy();
                wc.setAttribute("looseConfig", looseConfig);
                if (!looseConfig) {
                    wc.setAttribute("auto-publish-setting", 1);
                }
                iServer = wc.save(true, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(5);
                IJobManager jobManager = Job.getJobManager();
                ISchedulingRule packageRule = MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{ResourcesPlugin.getWorkspace().getRoot(), iServer});
                jobManager.beginRule(packageRule, monitor);
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Publish the server for server packaging.");
                }
                this.opStatus = iServer.publish(1, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.opStatus.getSeverity() == 4) {
                    return this.opStatus;
                }
                jobManager.endRule(packageRule);
                monitor.worked(10);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public ILaunch dumpServer(WebSphereServerInfo server, File archiveFile, String include, IProgressMonitor monitor) throws CoreException {
        this.verifyServerExists(server);
        if (archiveFile != null && archiveFile.isDirectory()) {
            throw new IllegalArgumentException(Messages.invalidZipFile);
        }
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(server);
        if (wsServer == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptServerNotFound));
        }
        LibertyServerDumpUtility utility = new LibertyServerDumpUtility();
        return utility.dumpServer(this, server, archiveFile, include, monitor);
    }

    public ILaunch javadumpServer(WebSphereServerInfo server, String include, IProgressMonitor monitor) throws CoreException {
        this.verifyServerExists(server);
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(server);
        if (wsServer == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptServerNotFound));
        }
        LibertyServerDumpUtility utility = new LibertyServerDumpUtility();
        return utility.javadumpServer(this, server, include, monitor);
    }

    public ILaunch createSSLCertificate(WebSphereServerInfo serverInfo, String password, String passwordEncoding, String passwordKey, int validity, String subject, String includeFileName, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        this.verifyServerExists(serverInfo);
        String serverName = serverInfo.getServerName();
        monitor2.beginTask(NLS.bind((String)Messages.taskCreateSSLCertificate, (Object)serverName), 200);
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer(serverInfo);
        if (wsServer == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptServerNotFound));
        }
        LibertySSLCreateCertificationUtility utility = new LibertySSLCreateCertificationUtility();
        return utility.createSSLCertificate(this, serverInfo, password, passwordEncoding, passwordKey, validity, subject, includeFileName, monitor2);
    }

    public String encodePassword(String password, IProgressMonitor monitor) throws CoreException {
        return this.encodePassword("xor", null, password, monitor);
    }

    public String encryptPassword(String algorithm, String key, String password, IProgressMonitor monitor) throws CoreException {
        return this.encodePassword(algorithm, key, password, monitor);
    }

    private String encodePassword(String encoding, String key, String password, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        long time = System.currentTimeMillis();
        if ("xor".equals(encoding)) {
            monitor2.beginTask(Messages.taskEncodePassword, 130);
        } else {
            monitor2.beginTask(Messages.taskEncryptPassword, 130);
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(SECURITY_UTILITY);
            list.add(ENCODE);
            if (this.getRuntimeVersion().startsWith("8.5.0")) {
                if (!"xor".equals(encoding)) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorEncodePasswordUnsupportedEncoding, (Object)encoding)));
                }
            } else if (encoding != null) {
                list.add("--encoding=" + encoding);
            }
            if (key != null && !key.trim().isEmpty()) {
                list.add("--key=" + key);
            }
            list.add(password);
            ProcessBuilder builder = this.createProcessBuilder(list.toArray(new String[list.size()]));
            Process p = builder.start();
            monitor2.worked(30);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(p, 100, 10.0f, 100, monitor2);
            int exitValue = result.getExitValue();
            String sb = result.getOutput();
            if (exitValue != 0) {
                Trace.logError("Error running securityUtility. exitValue=" + Integer.valueOf(exitValue) + ": " + sb, null);
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorEncodePassword, (Object)(Integer.valueOf(exitValue) + ": " + sb))));
            }
            String string = sb.toString().trim();
            return string;
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Throwable t) {
            Trace.logError("Error running securityUtility", t);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorEncodePassword, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
            Trace.tracePerf("Encode password", time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CustomPasswordEncryptionInfo> listCustomEncryption(IProgressMonitor monitor) {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        Map<String, CustomPasswordEncryptionInfo> cpeiMap = new LinkedHashMap<String, CustomPasswordEncryptionInfo>();
        long time = System.currentTimeMillis();
        monitor2.beginTask(Messages.taskListEncryption, 130);
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(SECURITY_UTILITY);
            list.add(ENCODE);
            list.add(SU_OPTION_LISTCUSTOM);
            ProcessBuilder builder = this.createProcessBuilder(list.toArray(new String[list.size()]));
            Process p = builder.start();
            monitor2.worked(30);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(p, 100, 10.0f, 100, monitor2);
            int exitValue = result.getExitValue();
            String sb = result.getOutput();
            if (exitValue != 0 && Trace.ENABLED) {
                Trace.logError("Error running securityUtility. exitValue=" + Integer.valueOf(exitValue) + ": " + sb, null);
            }
            cpeiMap = this.parseListCustom(cpeiMap, JSONArray.parse((String)sb));
        }
        catch (IOException list) {
        }
        catch (TimeoutException e) {
            if (Trace.ENABLED) {
                Trace.logError("Error running securityUtility", e);
            }
        }
        finally {
            monitor2.done();
            Trace.tracePerf("List custom Encryption", time);
        }
        return cpeiMap;
    }

    protected Map<String, CustomPasswordEncryptionInfo> parseListCustom(Map<String, CustomPasswordEncryptionInfo> map, JSONArray customEncryptions) {
        if (customEncryptions != null) {
            for (int i = 0; i < customEncryptions.size(); ++i) {
                JSONObject object = (JSONObject)customEncryptions.get(i);
                map.put((String)object.get((Object)"name"), new CustomPasswordEncryptionInfo((String)object.get((Object)"name"), (String)object.get((Object)"featurename"), (String)object.get((Object)"description")));
            }
        }
        return map;
    }

    @Override
    public void generateSchema(String file, IProgressMonitor monitor, int timeout) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        monitor2.beginTask(NLS.bind((String)Messages.jobRuntimeCache, (Object)this.getRuntime().getName()), 330);
        long time = System.currentTimeMillis();
        try {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Generating schema to " + file);
            }
            String locale = "--locale=" + Locale.getDefault().toString();
            String version = this.getRuntimeVersion();
            String[] params = version == null || WebSphereUtil.isGreaterOrEqualVersion("8.5.5.2", version) ? new String[]{locale, "--schemaVersion=1.1", "--outputVersion=2", file} : new String[]{locale, file};
            ProcessBuilder builder = this.createJavaProcessBuilder("ws-schemagen.jar", params);
            Process p = builder.start();
            monitor2.worked(30);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(p, 100, timeout, 300, monitor2);
            int exitValue = result.getExitValue();
            String sb = result.getOutput();
            if (exitValue != 0) {
                Trace.logError("Error generating schema. exitValue=" + Integer.valueOf(exitValue) + ": " + sb, null);
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.metadataGenerationFailedDetails, (Object)(Integer.valueOf(exitValue) + ": " + sb))));
            }
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Throwable t) {
            Trace.logError("Error generating schema", t);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.metadataGenerationFailedDetails, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
            Trace.tracePerf("Schema gen", time);
        }
    }

    @Override
    public void generateFeatureList(String file, IProgressMonitor monitor, int timeout, String ... options) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        monitor2.beginTask(NLS.bind((String)Messages.jobRuntimeCache, (Object)this.getRuntime().getName()), 330);
        long time = System.currentTimeMillis();
        try {
            ProcessBuilder builder;
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Generating feature list to " + file);
            }
            String locale = "--locale=" + Locale.getDefault().toString();
            if (options == null || options.length == 0) {
                builder = this.createJavaProcessBuilder("ws-featurelist.jar", new String[]{locale, file});
            } else {
                ArrayList<String> cmds = new ArrayList<String>(options.length + 2);
                cmds.add(locale);
                for (String o : options) {
                    cmds.add(o);
                }
                cmds.add(file);
                builder = this.createJavaProcessBuilder("ws-featurelist.jar", cmds.toArray(new String[cmds.size()]));
            }
            Process p = builder.start();
            monitor2.worked(30);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(p, 100, timeout, 300, monitor2);
            int exitValue = result.getExitValue();
            String sb = result.getOutput();
            if (exitValue != 0) {
                Trace.logError("Error generating feature list. exitValue=" + Integer.valueOf(exitValue) + ": " + sb, null);
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.metadataGenerationFailedDetails, (Object)(Integer.valueOf(exitValue) + ": " + sb))));
            }
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Throwable t) {
            Trace.logError("Error generating feature list", t);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.metadataGenerationFailedDetails, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
            Trace.tracePerf("Feature list gen", time);
        }
    }

    public String getProductInfo(String command, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        long time = System.currentTimeMillis();
        monitor2.beginTask(Messages.taskProductInfo, 230);
        try {
            String runtimeVersion = this.getRuntimeVersion();
            if (runtimeVersion != null && runtimeVersion.startsWith("8.5.0.0")) {
                String string = null;
                return string;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("productInfo");
            list.add(command);
            ProcessBuilder builder = this.createProcessBuilder(list.toArray(new String[list.size()]));
            Process p = builder.start();
            monitor2.worked(30);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(p, 100, 30.0f, 200, monitor2);
            int exitValue = result.getExitValue();
            String sb = result.getOutput();
            if (exitValue != 0) {
                Trace.logError("Error running productInfo " + command + ". exitValue=" + Integer.valueOf(exitValue) + ": " + sb, null);
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorProductInfo, (Object)(Integer.valueOf(exitValue) + ": " + sb.toString()))));
            }
            String string = sb.toString().trim();
            return string;
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Throwable t) {
            Trace.logError("Error running productInfo " + command, t);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorProductInfo, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
            Trace.tracePerf("Product info " + command, time);
        }
    }

    public void verifyServerExists(WebSphereServerInfo server) {
        if (server == null || server.getServerName() == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        IPath path = this.getRuntime().getLocation();
        if (path == null) {
            throw new IllegalArgumentException("Runtime does not exist");
        }
        if (!server.getServerPath().toFile().exists()) {
            throw new IllegalArgumentException("Server does not exist");
        }
    }

    public synchronized URL getConfigurationSchemaURL(URI fileURI) {
        this.updateServerCache(false);
        for (WebSphereServerInfo info : this.serverInfo) {
            if (info.getConfigurationFileFromURI(fileURI) == null) continue;
            return this.getConfigurationSchemaURL();
        }
        Path path = new Path(fileURI.getPath());
        if ("xml".equals(path.getFileExtension())) {
            List<UserDirectory> userDirs = this.getUserDirectories();
            for (UserDirectory ud : userDirs) {
                URI userDirURI = ud.getPath().toFile().toURI();
                URI relative = URIUtil.canonicalRelativize(userDirURI, fileURI);
                if (relative.isAbsolute() || !ConfigUtils.isServerConfigFile(fileURI)) continue;
                return this.getConfigurationSchemaURL();
            }
            IPath runtimePath = this.getRuntime().getLocation();
            if (runtimePath != null && (runtimePath = runtimePath.append("templates")).isPrefixOf((IPath)path)) {
                return this.getConfigurationSchemaURL();
            }
            if (this.buildMetadataDirectoryPath().isPrefixOf((IPath)path)) {
                return this.getConfigurationSchemaURL();
            }
        }
        return null;
    }

    public synchronized void createMetadata(IJobChangeListener listener) {
        SchemaMetadata.getInstance().generateIfMissingOrRemoved(this, listener);
        this.setSavedMetadataDirectory(this.buildMetadataDirectoryPath());
    }

    public synchronized void runtimeChanged() {
        IPath oldDir = this.getSavedMetadataDirectory();
        this.runtimeVersion = null;
        this.runtimeEdition = null;
        IPath newDir = this.buildMetadataDirectoryPath();
        if (oldDir == null || !oldDir.equals((Object)newDir)) {
            this.removeMetadata(oldDir, oldDir != null && !oldDir.equals((Object)newDir), false);
        } else {
            WebSphereServerInfo.removeOutOfSyncMetadata(this);
            List<WebSphereServerInfo> serverInfos = this.getWebSphereServerInfos();
            for (WebSphereServerInfo serverInfo : serverInfos) {
                IPath metadataDirectory = newDir.append(serverInfo.getMetadataRelativePath());
                serverInfo.removeMetadata(metadataDirectory, true, true);
            }
        }
        this.generateMetadata(null, true);
        this.setSavedMetadataDirectory(newDir);
        if (this.classpathHelper != null) {
            this.classpathHelper.refresh();
        }
        this.schemaHelper = null;
    }

    public void setSavedMetadataDirectory(IPath dir) {
        this.savedMetadataDirectoryInCaseLocationIsMoved = dir;
    }

    public IPath getSavedMetadataDirectory() {
        return this.savedMetadataDirectoryInCaseLocationIsMoved;
    }

    public synchronized void generateMetadata(IJobChangeListener listener, boolean isRegenInfoCache, int metadataTypes) {
        final WebSphereRuntime wsr = this;
        JobChangeAdapter restoreListener = new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                try {
                    String generatorId = WebSphereRuntime.this.getGeneratorId();
                    SchemaMetadata schemaMetadata = SchemaMetadata.getInstance();
                    FeatureListCoreMetadata coreMetadata = FeatureListCoreMetadata.getInstance();
                    FeatureListExtMetadata[] extMetadata = FeatureListExtMetadata.getInstances(wsr);
                    schemaMetadata.generationComplete(generatorId, schemaMetadata.getPayload(wsr));
                    coreMetadata.generationComplete(generatorId, coreMetadata.getPayload(wsr));
                    for (FeatureListExtMetadata exts : extMetadata) {
                        exts.generationComplete(generatorId, exts.getPayload(wsr));
                    }
                }
                finally {
                    event.getJob().removeJobChangeListener((IJobChangeListener)this);
                }
            }
        };
        IJobChangeListener[] listeners = listener != null ? new IJobChangeListener[]{listener, restoreListener} : new IJobChangeListener[]{restoreListener};
        if (isRegenInfoCache) {
            FeatureListExtMetadata.clearRuntimeInstances(wsr.getRuntime().getId());
        }
        Metadata.generateMetadata(this, listeners, metadataTypes);
        if (isRegenInfoCache) {
            WebSphereRuntimeProductInfoCacheUtil.saveProductInfoCache(this, null);
        }
        this.earSupported = null;
    }

    public IPath buildMetadataDirectoryPath() {
        return Activator.getInstance().getStateLocation().append(this.getRuntime().getId());
    }

    public boolean metadataDirectoryExists() {
        IPath dirPath = this.buildMetadataDirectoryPath();
        File dir = dirPath.toFile();
        return dir.exists();
    }

    @Override
    public String getGeneratorId() {
        IRuntime runtime = this.getRuntime();
        return runtime.getId();
    }

    @Override
    public IPath getBasePath(IPath root) {
        return root.append(this.getGeneratorId());
    }

    @Override
    public WebSphereRuntime getWebSphereRuntime() {
        return this;
    }

    @Override
    public boolean supportsFeatureListGeneration() {
        IVMInstall vmInstall = this.getVMInstall();
        String version = this.getRuntimeVersion();
        if ((version == null || "8.5.0.0".equals(version)) && vmInstall != null && !LaunchUtil.isIBMJRE(vmInstall)) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Skip feature list generation for non-IBM JRE for 8.5.0.0.");
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void generateMetadata(IJobChangeListener listener, boolean isRegenInfoCache) {
        IPath dirPath = this.buildMetadataDirectoryPath();
        File dir = dirPath.toFile();
        if (!dir.exists() && !dir.mkdirs()) {
            if (Trace.ENABLED) {
                Throwable t = new Throwable();
                t.fillInStackTrace();
                Trace.trace((byte)1, "Unable to create " + dir.getAbsolutePath() + " so metadata generation aborted.", t);
            }
            return;
        }
        this.generateMetadata(listener, isRegenInfoCache, 15);
    }

    @Override
    public synchronized void removeMetadata(IPath dir, boolean deleteDirectory, boolean destroy) {
        WebSphereServerInfo.removeOutOfSyncMetadata(this);
        List<WebSphereServerInfo> serverInfos = this.getWebSphereServerInfos();
        for (WebSphereServerInfo webSphereServerInfo : serverInfos) {
            IPath metadataDirectory = dir == null ? null : dir.append(webSphereServerInfo.getMetadataRelativePath());
            webSphereServerInfo.removeMetadata(metadataDirectory, deleteDirectory, destroy);
        }
        IPath metadataDirectory = dir != null ? dir : this.buildMetadataDirectoryPath();
        this.removeFile(metadataDirectory, "server.xsd");
        this.removeFile(metadataDirectory, "featureList.xml");
        for (FeatureListExtMetadata ext : FeatureListExtMetadata.getInstances(this)) {
            this.removeFile(metadataDirectory, ext.getFeatureListXMLName());
        }
        Metadata.removeMetadata(this.getGeneratorId(), destroy);
        WebSphereRuntimeProductInfoCacheUtil.deleteProductInfoCache(this);
        if (deleteDirectory) {
            IPath iPath = metadataDirectory.append("serversMetadata");
            File file = iPath.toFile();
            if (file.exists() && !file.delete()) {
                Trace.logError("Unable to delete servers metadata directory " + iPath, null);
            }
            if ((file = metadataDirectory.toFile()).exists() && !file.delete()) {
                Trace.logError("Unable to delete metadata directory " + metadataDirectory, null);
            }
        }
        ServerListenerUtil.getInstance().fireRuntimeChangedEvent(this.getRuntime());
    }

    public synchronized void removeFile(IPath dir, String fileName) {
        IPath path = dir.append(fileName);
        File file = path.toFile();
        FileUtil.deleteFile(file);
    }

    public static boolean rename(File fromFile, File toFile) {
        int retryLimit = 10;
        int count = 1;
        while (!fromFile.renameTo(toFile) && count < 10) {
            if (Trace.ENABLED) {
                Throwable t = new Throwable();
                t.fillInStackTrace();
                Trace.trace((byte)1, "Unable to rename file " + fromFile.getAbsolutePath() + " to " + toFile.getAbsolutePath(), t);
                Trace.trace((byte)1, "Retry attempt: " + count);
            }
            ++count;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (count < 10) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Done renaming file " + fromFile.getAbsolutePath() + " to " + toFile.getAbsolutePath());
            }
            return true;
        }
        return false;
    }

    public URL getConfigurationSchemaURL() {
        return SchemaMetadata.getInstance().getSchemaPath(this);
    }

    public static URL getFallbackSchema() {
        return SchemaMetadata.getFallbackSchema();
    }

    public IPath getDefaultUserDirPath() {
        return this.getRuntimePath("usr");
    }

    public IPath getDefaultServersPath() {
        return this.getRuntimePath(SERVERS_FOLDER);
    }

    public IPath getDefaultSharedApplicationPath() {
        return this.getRuntimePath(SHARED_APP_FOLDER);
    }

    public IPath getDefaultSharedConfigurationPath() {
        return this.getRuntimePath(SHARED_CONFIG_FOLDER);
    }

    public IPath getDefaultSharedResourcesPath() {
        return this.getRuntimePath(SHARED_RESOURCES_FOLDER);
    }

    private IPath getRuntimePath(String folder) {
        IPath path = this.getRuntime().getLocation();
        if (path == null) {
            return null;
        }
        return path.append(folder);
    }

    public String getRuntimeVersion() {
        if (this.runtimeVersion != null) {
            return this.runtimeVersion;
        }
        IPath path = this.getRuntimePropertiesPath();
        if (path == null) {
            return null;
        }
        Properties prop = new Properties();
        FileUtil.loadProperties(prop, path);
        String s = prop.getProperty("com.ibm.websphere.productVersion");
        if (s == null) {
            return null;
        }
        this.runtimeVersion = s.trim();
        return this.runtimeVersion;
    }

    public String getRuntimeEdition() {
        if (this.runtimeEdition != null) {
            return this.runtimeEdition;
        }
        IPath path = this.getRuntimePropertiesPath();
        if (path == null) {
            return null;
        }
        Properties prop = new Properties();
        FileUtil.loadProperties(prop, path);
        String s = prop.getProperty("com.ibm.websphere.productEdition");
        if (s == null) {
            return null;
        }
        this.runtimeEdition = s.trim();
        return this.runtimeEdition;
    }

    public IProject getProject() {
        IPath runtimeUserPath;
        IPath runtimeLocation = this.getRuntime().getLocation();
        if (runtimeLocation != null && (runtimeUserPath = runtimeLocation.append("usr")).toFile().exists()) {
            IProject[] projects;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (IProject p : projects = root.getProjects()) {
                if (!runtimeUserPath.equals((Object)p.getLocation())) continue;
                return p;
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getRuntime().getName());
    }

    public String getProperty(String id, String defaultValue) {
        return this.getAttribute(id, defaultValue);
    }

    public void setProperty(String id, String value) {
        this.setAttribute(id, value);
    }

    public FeatureSet getInstalledFeatures() {
        List<String> features = FeatureList.getFeatures(false, this);
        return new FeatureSet(this, features);
    }

    public List<String> getInstalledFeaturesList() {
        return FeatureList.getFeatures(false, this);
    }

    public boolean isContainedBy(String feature1, String feature2) {
        return FeatureList.isContainedBy(feature1, feature2, this);
    }

    public UserDirectory createDefaultUserDirectory(IProgressMonitor monitor) {
        UserDirectory userDir = this.getDefaultUserDir();
        if (userDir != null) {
            this.createProject(monitor);
            return userDir;
        }
        IPath path = this.getDefaultUserDirPath();
        if (path == null) {
            Trace.logError("The default user directory path is null. ", null);
            return null;
        }
        File file = path.toFile();
        if (!file.exists()) {
            if (!file.mkdirs()) {
                Trace.logError("Failed to create default user directory: " + file.getPath(), null);
                return null;
            }
        } else if (!file.isDirectory()) {
            Trace.logError("The default user directory already exists but is not a directory: " + file.getPath(), null);
            return null;
        }
        this.createProject(monitor);
        this.addUserDirectory(this.getProject());
        return this.getDefaultUserDir();
    }

    public UserDirectory getDefaultUserDir() {
        IPath path = this.getDefaultUserDirPath();
        if (path == null) {
            return null;
        }
        List<UserDirectory> userDirs = this.getUserDirectories();
        for (UserDirectory userDir : userDirs) {
            if (!userDir.getPath().equals((Object)path)) continue;
            return userDir;
        }
        return null;
    }

    public void createProject(IProgressMonitor monitor) {
        try {
            IProject project = this.getProject();
            if (project.isAccessible()) {
                return;
            }
            if (!this.getDefaultUserDirPath().toFile().exists()) {
                return;
            }
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor2) throws CoreException {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Creating default user dir project");
                    }
                    try {
                        IRuntime runtime = WebSphereRuntime.this.getRuntime();
                        WebSphereUtil.createUserProject(runtime.getName(), WebSphereRuntime.this.getDefaultUserDirPath(), monitor2);
                        WebSphereRuntime.this.updateServerCache(true);
                    }
                    catch (Exception e) {
                        Trace.logError("Could not create default user dir project", e);
                    }
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Done creating default user dir project");
                    }
                }
            }, monitor);
        }
        catch (CoreException ce) {
            Trace.logError("Error creating default user dir project", ce);
        }
    }

    public void deleteProject(IProgressMonitor monitor) {
        try {
            final IProject project = this.getProject();
            if (!project.exists()) {
                return;
            }
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor2) throws CoreException {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Deleting default user dir project");
                    }
                    try {
                        project.delete(false, true, monitor2);
                    }
                    catch (Exception e) {
                        Trace.logError("Could not delete default user dir project", e);
                    }
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Done deleting default user dir project");
                    }
                }
            }, monitor);
        }
        catch (CoreException ce) {
            Trace.logError("Error deleting default user dir project", ce);
        }
    }

    public void getVariables(ConfigVars vars) {
        IPath installPath = this.getRuntime().getLocation();
        if (installPath != null) {
            vars.add("wlp.install.dir", installPath.toOSString(), ConfigVars.LOCATION_TYPE);
        }
    }

    public void setConstantId(String name) {
        if (name != null) {
            this.setAttribute("id", name);
        }
        this.setAttribute("id-set", true);
    }

    public String toString() {
        return "WebSphereRuntime[" + this.getRuntime().getLocation() + "]";
    }

    public SchemaHelper getSchemaHelper() {
        if (this.schemaHelper == null) {
            this.schemaHelper = new SchemaHelper(this.getConfigurationSchemaURL());
        }
        return this.schemaHelper;
    }

    public WebSphereRuntimeClasspathHelper getClasspathHelper() {
        if (this.classpathHelper == null) {
            this.classpathHelper = new WebSphereRuntimeClasspathHelper(this);
            this.classpathHelper.refresh();
        }
        return this.classpathHelper;
    }

    public void updateFeature(IPath featureArchivePath, int ticks, String existingFileOption, IProgressMonitor monitor) throws CoreException {
        String option = this.isValidExistsOption(existingFileOption) ? existingFileOption.toLowerCase() : "ignore";
        this.installFeature(featureArchivePath, ticks, new String[]{"featureManager", "install", "--acceptLicense", "--when-file-exists=" + option, featureArchivePath.toOSString()}, monitor);
    }

    public void installFeature(IPath featureArchivePath, int ticks, IProgressMonitor monitor) throws CoreException {
        this.installFeature(featureArchivePath, ticks, new String[]{"featureManager", "install", "--acceptLicense", featureArchivePath.toOSString()}, monitor);
    }

    private boolean isValidExistsOption(String option) {
        return "ignore".equalsIgnoreCase(option) || "replace".equalsIgnoreCase(option);
    }

    private void installFeature(IPath featureArchivePath, int ticks, String[] command, IProgressMonitor monitor) throws CoreException {
        long time = System.currentTimeMillis();
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        monitor2.beginTask(Messages.taskInstallFeature, ticks);
        monitor2.subTask(Messages.taskInstallFeature);
        try {
            ProcessBuilder builder = this.createProcessBuilder(null, this.getRuntime().getLocation().append("bin").toFile(), null, command);
            Process p = builder.start();
            monitor2.worked(30);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(p, 100, 60.0f, ticks, monitor2);
            int exitValue = result.getExitValue();
            if (exitValue != 0) {
                Trace.logError("Error installing feature. exitValue=" + Integer.valueOf(exitValue) + ": " + result.getOutput(), null);
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.featureInstallFailedMsg, (Object)(Integer.valueOf(exitValue) + ": " + result.getOutput()))));
            }
        }
        catch (CoreException ce) {
            Trace.logError("CoreException during install feature: " + featureArchivePath, ce);
            throw ce;
        }
        catch (Throwable t) {
            Trace.logError("Error installing feature: " + featureArchivePath, t);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.featureInstallFailedMsg, (Object)t.getLocalizedMessage())));
        }
        finally {
            monitor2.done();
            Trace.tracePerf("Feature install", time);
        }
    }

    public void resetRuntimeServerInfo() {
        this.serverInfo = new ArrayList<WebSphereServerInfo>();
        this.serverCacheHash = -1;
        this.userDirCache = new ArrayList<UserDirectory>();
        this.userDirHash = -1;
    }

    public IPath getRuntimeLocation() {
        return this.getRuntime().getLocation();
    }

    public IPath getRemoteUsrMetadataPath() {
        return this.buildMetadataDirectoryPath().append("remoteUsr");
    }

    public void initializeClasspathHelper() {
        if (this.classpathHelper == null) {
            this.classpathHelper = new WebSphereRuntimeClasspathHelper(this);
            this.classpathHelper.refresh();
        }
    }

    @Override
    public boolean isReadyToGenerateMetadata() {
        return this.getRuntimeLocation().append("bin").toFile().exists();
    }

    public boolean isOnPremiseSupported() {
        String batch = "installUtility";
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            batch = batch + ".bat";
        }
        return this.getRuntimeLocation().append("bin").append(batch).toFile().exists();
    }

    public void setJAVAEESupportLevel() {
        List<String> features = FeatureList.getFeatures(true, this);
        for (String feature : features) {
            Set<String> categoryElements = FeatureList.getFeatureCategory(feature, this);
            if (categoryElements == null || categoryElements.isEmpty()) continue;
            if (categoryElements.contains("JavaEE8Application")) {
                this.earSupported = JAVAEESUPPORT.JAVAEE8;
                break;
            }
            if (!categoryElements.contains("JavaEE7Application")) continue;
            this.earSupported = JAVAEESUPPORT.JAVAEE7;
        }
        if (this.earSupported == null) {
            this.earSupported = JAVAEESUPPORT.JAVAEE6;
        }
    }

    public boolean isEARSupported(String version) {
        if (version == null) {
            return false;
        }
        float f = Float.parseFloat(version);
        if (f >= 1.2f) {
            if (this.earSupported == null) {
                this.setJAVAEESupportLevel();
            }
            if (f <= this.earSupported.getVersion()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean metadataExists() {
        return SchemaMetadata.getInstance().metadataExists(this);
    }

    public String getRuntimeName() {
        return this.getRuntime().getName();
    }

    public String getMetaDataDirName(UserDirectory userDir) {
        String name;
        block9: {
            IProject project = userDir.getProject();
            if (project != null) {
                return project.getName();
            }
            HashMap<String, String> map = this.getAttribute(PROP_USER_DIR_NAME_MAP, null);
            name = null;
            if (map == null) {
                map = new HashMap<String, String>(5);
            } else {
                name = (String)map.get(userDir.getUniqueId());
            }
            if (name == null) {
                String dirName;
                do {
                    userDirCounter = (byte)(userDirCounter + 1);
                } while (map.containsValue(dirName = USER_DIR_METADATA_PATH + userDirCounter));
                map.put(userDir.getUniqueId(), dirName);
                name = dirName;
                if (this.getRuntime().isWorkingCopy()) {
                    this.setAttribute(PROP_USER_DIR_NAME_MAP, map);
                } else {
                    IRuntimeWorkingCopy wc = this.getRuntime().createWorkingCopy();
                    WebSphereRuntime wsRuntime = (WebSphereRuntime)wc.loadAdapter(WebSphereRuntime.class, null);
                    wsRuntime.setAttribute(PROP_USER_DIR_NAME_MAP, map);
                    try {
                        wc.save(true, null);
                    }
                    catch (CoreException e) {
                        if (!Trace.ENABLED) break block9;
                        Trace.trace((byte)1, "Failed to save the user directory name map.", e);
                    }
                }
            }
        }
        return name;
    }

    public UserDirectory getUserDirForMetadataDir(String dirName) {
        Map map;
        for (UserDirectory userDir : this.getUserDirectories()) {
            if (userDir.getProject() == null || !dirName.equals(userDir.getProject().getName())) continue;
            return userDir;
        }
        UserDirectory userDir = this.getUserDir(dirName);
        if (userDir == null && (map = this.getAttribute(PROP_USER_DIR_NAME_MAP, null)) != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!dirName.equals(entry.getValue())) continue;
                userDir = this.getUserDir((String)entry.getKey());
                break;
            }
        }
        return userDir;
    }

    public boolean supportsInstallingAdditionalContent() {
        String cmdSuffix = WebSphereRuntime.getCommandSuffixForOS();
        String cmd = "installUtility" + cmdSuffix;
        IPath binPath = this.getRuntimeLocation().append("bin");
        boolean hasInstallUtilCmd = binPath.append(cmd).toFile().exists();
        boolean hasInstallUtilJar = binPath.append("tools").append("ws-installUtility.jar").toFile().exists();
        if (hasInstallUtilCmd && hasInstallUtilJar) {
            return true;
        }
        cmd = "featureManager" + cmdSuffix;
        if (binPath.append(cmd).toFile().exists()) {
            return true;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Installing additional content not supported for runtime at: " + this.getRuntimeLocation().toOSString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean supportsInstallingAdditionalContent(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            ZipFile zip = null;
            try {
                String cmdSuffix = WebSphereRuntime.getCommandSuffixForOS();
                zip = new ZipFile(file);
                String cmd = "installUtility" + cmdSuffix;
                ZipEntry installUtilCmd = zip.getEntry("wlp/bin/" + cmd);
                ZipEntry installUtilJar = zip.getEntry("wlp/bin/tools/ws-installUtility.jar");
                if (installUtilCmd != null && installUtilJar != null) {
                    boolean bl = true;
                    return bl;
                }
                cmd = "featureManager" + cmdSuffix;
                ZipEntry featureManagerCmd = zip.getEntry("wlp/bin/" + cmd);
                if (featureManagerCmd != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                Trace.logError("Could not read the runtime archive in order to determine if installing additional content is supported", e);
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Installing additional content not supported for: " + archive);
        }
        return false;
    }

    private static String getCommandSuffixForOS() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return ".bat";
        }
        return "";
    }

    public List<IPath> getRuntimePropertiesPaths() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IPath runtimeLocation = this.getRuntime().getLocation();
        if (runtimeLocation == null || runtimeLocation.isEmpty()) {
            return paths;
        }
        IPath path = runtimeLocation.append(RUNTIME_MARKER);
        if (path.toFile().exists()) {
            paths.add(path);
        }
        if ((path = runtimeLocation.append(OPEN_RUNTIME_MARKER)).toFile().exists()) {
            paths.add(path);
        }
        return paths;
    }

    private IPath getRuntimePropertiesPath() {
        return WebSphereRuntime.getRuntimePropertiesPath(this.getRuntime().getLocation());
    }

    private static IPath getRuntimePropertiesPath(IPath runtimeLocation) {
        if (runtimeLocation == null || runtimeLocation.isEmpty()) {
            return null;
        }
        IPath markerPath = runtimeLocation.append(RUNTIME_MARKER);
        if (markerPath.toFile().exists()) {
            return markerPath;
        }
        markerPath = runtimeLocation.append(OPEN_RUNTIME_MARKER);
        if (markerPath.toFile().exists()) {
            return markerPath;
        }
        return null;
    }

    static enum JAVAEESUPPORT {
        JAVAEE6(6.0f),
        JAVAEE7(7.0f),
        JAVAEE8(8.0f);

        private final float version;

        private JAVAEESUPPORT(float version) {
            this.version = version;
        }

        public float getVersion() {
            return this.version;
        }
    }

    static interface ServerIterator2 {
        public void iter(IPath var1, File var2);
    }
}

