/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.IWebSphereMetadataListener;
import com.ibm.ws.st.core.internal.IWebSphereServerListener;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.server.core.IRuntime;

public class ServerListenerUtil {
    private final transient List<IWebSphereServerListener> listeners = new ArrayList<IWebSphereServerListener>(2);
    private final transient List<IWebSphereMetadataListener> mlisteners = new ArrayList<IWebSphereMetadataListener>(1);
    private static ServerListenerUtil instance;

    private ServerListenerUtil() {
    }

    public static synchronized ServerListenerUtil getInstance() {
        if (instance == null) {
            instance = new ServerListenerUtil();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerListener(IWebSphereServerListener listener) {
        List<IWebSphereServerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerListener(IWebSphereServerListener listener) {
        if (this.listeners != null) {
            List<IWebSphereServerListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetadataListener(IWebSphereMetadataListener mlistener) {
        List<IWebSphereMetadataListener> list = this.mlisteners;
        synchronized (list) {
            if (!this.mlisteners.contains(mlistener)) {
                this.mlisteners.add(mlistener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadataListener(IWebSphereMetadataListener mlistener) {
        if (this.mlisteners != null) {
            List<IWebSphereMetadataListener> list = this.mlisteners;
            synchronized (list) {
                this.mlisteners.remove(mlistener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerChangedEvent(WebSphereServerInfo server) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        IWebSphereServerListener[] iWebSphereServerListenerArray = this.listeners;
        synchronized (this.listeners) {
            IWebSphereServerListener[] list = this.listeners.toArray(new IWebSphereServerListener[this.listeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (IWebSphereServerListener listener : list) {
                try {
                    listener.serverChanged(server);
                }
                catch (Exception e) {
                    Trace.logError("Error firing server changed event for server: " + server.getServerName(), e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRuntimeChangedEvent(IRuntime runtime) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        IWebSphereServerListener[] iWebSphereServerListenerArray = this.listeners;
        synchronized (this.listeners) {
            IWebSphereServerListener[] list = this.listeners.toArray(new IWebSphereServerListener[this.listeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (IWebSphereServerListener listener : list) {
                try {
                    listener.runtimeChanged(runtime);
                }
                catch (Exception e) {
                    Trace.logError("Error firing runtime changed event for runtime: " + runtime.getId(), e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMetadataChangedEvent(IRuntime runtime) {
        if (this.mlisteners == null || this.mlisteners.isEmpty()) {
            return;
        }
        IWebSphereMetadataListener[] iWebSphereMetadataListenerArray = this.mlisteners;
        synchronized (this.mlisteners) {
            IWebSphereMetadataListener[] list = this.mlisteners.toArray(new IWebSphereMetadataListener[this.mlisteners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (IWebSphereMetadataListener mlistener : list) {
                try {
                    mlistener.runtimeMetadataChanged(runtime);
                }
                catch (Exception e) {
                    Trace.logError("Error firing metadata changed event for runtime: " + runtime.getId(), e);
                }
            }
            return;
        }
    }
}

