/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.core.internal;

import com.ibm.ws.st.docker.core.internal.AbstractFlattenImageHandler;
import com.ibm.ws.st.docker.core.internal.AbstractModeSwitchHandler;
import com.ibm.ws.st.docker.core.internal.AbstractServerCleanupHandler;
import com.ibm.ws.st.docker.core.internal.Trace;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "com.ibm.ws.st.docker.core";
    private static Activator instance;
    private static AbstractServerCleanupHandler serverCleanupHandler;
    private static AbstractModeSwitchHandler modeSwitchHandler;
    private static AbstractFlattenImageHandler flattenImageHandler;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        Trace.ENABLED = this.isDebugging();
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)Trace.TS, props);
        Activator.initHandlers();
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        super.stop(context);
    }

    public static Activator getInstance() {
        return instance;
    }

    protected static void initHandlers() {
        block9: {
            IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ws.st.docker.core.libertyDockerHandlers");
            if (configElements.length > 0) {
                IConfigurationElement elem;
                block8: {
                    block7: {
                        elem = configElements[0];
                        try {
                            serverCleanupHandler = (AbstractServerCleanupHandler)elem.createExecutableExtension("serverCleanupHandlerClass");
                        }
                        catch (CoreException e) {
                            if (!Trace.ENABLED) break block7;
                            Trace.trace((byte)1, "Failed to create the server cleanup handler.", e);
                        }
                    }
                    try {
                        modeSwitchHandler = (AbstractModeSwitchHandler)elem.createExecutableExtension("modeSwitchHandlerClass");
                    }
                    catch (CoreException e) {
                        if (!Trace.ENABLED) break block8;
                        Trace.trace((byte)1, "Failed to create the mode switch handler.", e);
                    }
                }
                try {
                    flattenImageHandler = (AbstractFlattenImageHandler)elem.createExecutableExtension("flattenImageHandlerClass");
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) break block9;
                    Trace.trace((byte)1, "Failed to create the flatten image handler.", e);
                }
            }
        }
    }

    public static AbstractServerCleanupHandler getServerCleanupHandler() {
        return serverCleanupHandler;
    }

    public static AbstractModeSwitchHandler getModeSwitchHandler() {
        return modeSwitchHandler;
    }

    public static AbstractFlattenImageHandler getFlattenImageHandler() {
        return flattenImageHandler;
    }
}

