/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.util.BaseXML;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class RepoXML
extends BaseXML {
    public static final boolean IS_PUBLIC_FEATURE = true;
    public static final boolean IS_VERSIONLESS_FEATURE = true;
    public static final boolean IS_TEST_FEATURE = true;
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> PUBLIC_NOT_TEST = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){

        @Override
        public boolean test(ProvisioningFeatureDefinition def) {
            return RepoXML.isPublic(def) && !RepoXML.isTest(def);
        }
    };
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> IS_NOT_TEST = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){

        @Override
        public boolean test(ProvisioningFeatureDefinition def) {
            return !RepoXML.isTest(def);
        }
    };
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> IS_PUBLIC = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){

        @Override
        public boolean test(ProvisioningFeatureDefinition def) {
            return RepoXML.isPublic(def);
        }
    };
    public static final String VERSIONLESS_PREFIX = "io.openliberty.versionless.";
    public static final String VERSIONLESS_PREFIX2 = "com.ibm.websphere.appserver.versionless.";
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> IS_CLIENT = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){

        @Override
        public boolean test(ProvisioningFeatureDefinition def) {
            return RepoXML.isClient(def);
        }
    };
    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> IS_SERVER = new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){

        @Override
        public boolean test(ProvisioningFeatureDefinition def) {
            return RepoXML.isServer(def);
        }
    };
    private static Comparator<ProvisioningFeatureDefinition> COMPARE = new Comparator<ProvisioningFeatureDefinition>(){

        @Override
        public int compare(ProvisioningFeatureDefinition def1, ProvisioningFeatureDefinition def2) {
            return def1.getSymbolicName().compareToIgnoreCase(def2.getSymbolicName());
        }
    };

    public static FeatureResolver.Selector<ProvisioningFeatureDefinition> featureSelector(final boolean isPublic, final boolean isVersionless, final boolean isTest) {
        return new FeatureResolver.Selector<ProvisioningFeatureDefinition>(){

            @Override
            public boolean test(ProvisioningFeatureDefinition def) {
                return isPublic == RepoXML.isPublic(def) && isVersionless == RepoXML.isVersionless(def) && isTest == RepoXML.isTest(def);
            }
        };
    }

    public static boolean isVersionless(ProvisioningFeatureDefinition def) {
        return def.getSymbolicName().startsWith(VERSIONLESS_PREFIX) || def.getSymbolicName().startsWith(VERSIONLESS_PREFIX2);
    }

    public static boolean isPublic(ProvisioningFeatureDefinition def) {
        return def.getVisibility() == Visibility.PUBLIC;
    }

    public static boolean isTest(ProvisioningFeatureDefinition def) {
        String symbolicName = def.getSymbolicName();
        return symbolicName.startsWith("test.") || symbolicName.startsWith("txtest-");
    }

    public static boolean isClient(ProvisioningFeatureDefinition def) {
        return def.getProcessTypes().contains((Object)ProcessType.CLIENT);
    }

    public static boolean isServer(ProvisioningFeatureDefinition def) {
        return def.getProcessTypes().contains((Object)ProcessType.SERVER);
    }

    public static void write(File file, final List<ProvisioningFeatureDefinition> features) throws Exception {
        RepoXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){

            @Override
            public void accept(PrintWriter pW) throws Exception {
                RepoXMLWriter xW = new RepoXMLWriter(pW);
                try {
                    xW.write(features);
                }
                finally {
                    xW.flush();
                }
            }
        });
    }

    public static void write(File file, final FeatureResolver.Repository repo) throws Exception {
        RepoXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){

            @Override
            public void accept(PrintWriter pW) throws Exception {
                RepoXMLWriter xW = new RepoXMLWriter(pW);
                try {
                    xW.write(repo);
                }
                finally {
                    xW.flush();
                }
            }
        });
    }

    public static class RepoXMLWriter
    extends BaseXML.BaseXMLWriter {
        public RepoXMLWriter(PrintWriter pW) {
            super(pW);
        }

        public void write(List<ProvisioningFeatureDefinition> features) {
            this.openElement("repository");
            this.upIndent();
            for (ProvisioningFeatureDefinition def : features) {
                this.write(def);
            }
            this.downIndent();
            this.closeElement("repository");
        }

        public void write(FeatureResolver.Repository repo) {
            List<ProvisioningFeatureDefinition> features = repo.getFeatures();
            ProvisioningFeatureDefinition[] featuresArray = features.toArray(new ProvisioningFeatureDefinition[features.size()]);
            Arrays.sort(featuresArray, COMPARE);
            this.openElement("repository");
            this.upIndent();
            for (ProvisioningFeatureDefinition def : featuresArray) {
                this.write(def);
            }
            this.downIndent();
            this.closeElement("repository");
        }

        public void write(ProvisioningFeatureDefinition def) {
            this.openElement("feature");
            this.upIndent();
            this.printElement("file", def.getFeatureDefinitionFile().getName());
            this.printElement("name", def.getFeatureName());
            this.printElement("symbolic-name", def.getSymbolicName());
            this.printOptionalElement("short-name", def.getIbmShortName());
            this.printElement("version", def.getVersion().toString());
            this.printElement("ibm-version", Integer.toString(def.getIbmFeatureVersion()));
            this.printOptionalElement("supported-version", def.isSupportedFeatureVersion());
            this.printElement("visibility", def.getVisibility().toString());
            this.printOptionalElement("auto", def.isAutoFeature());
            this.printOptionalElement("singleton", def.isSingleton());
            this.printOptionalElement("server", def.getProcessTypes().contains("server"));
            this.printOptionalElement("client", def.getProcessTypes().contains("client"));
            this.printElement("restart", def.getAppForceRestart().toString());
            for (FeatureResource resource : def.getConstituents(null)) {
                this.write(resource);
            }
            this.printDelimited("platforms", ", ", def.getPlatformNames());
            this.downIndent();
            this.closeElement("feature");
        }

        public void write(FeatureResource resource) {
            this.openElement("constituent");
            this.upIndent();
            this.printOptionalElement("symbolic-name", resource.getSymbolicName());
            this.printOptionalElement("location", resource.getLocation());
            this.printOptionalElement("start-level", resource.getStartLevel());
            this.printOptionalElement("activation-type", (Object)resource.getActivationType());
            this.printOptionalElement("type", (Object)resource.getType());
            this.printOptionalElement("java-range", resource.getJavaRange());
            this.printOptionalElement("version-range", resource.getVersionRange());
            List<String> tolerates = resource.getTolerates();
            if (tolerates != null && !tolerates.isEmpty()) {
                for (String tolerate : tolerates) {
                    this.printElement("tolerate", tolerate);
                }
            }
            this.downIndent();
            this.closeElement("constituent");
        }
    }
}

