/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.ws.kernel.feature.internal.util.BaseXML;
import com.ibm.ws.kernel.feature.internal.util.ImageInfo;
import com.ibm.ws.kernel.feature.internal.util.Images;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ImageXML
extends BaseXML {
    private static Comparator<ImageInfo> COMPARE = new Comparator<ImageInfo>(){

        @Override
        public int compare(ImageInfo i0, ImageInfo i1) {
            return i0.getName().compareToIgnoreCase(i1.getName());
        }
    };

    public static void sort(List<ImageInfo> images) {
        Collections.sort(images, COMPARE);
    }

    public static void write(File file, final Images images) throws Exception {
        ImageXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){

            @Override
            public void accept(PrintWriter pW) throws Exception {
                ImagesXMLWriter xW = new ImagesXMLWriter(pW);
                try {
                    xW.write(images);
                }
                finally {
                    xW.flush();
                }
            }
        });
    }

    public static class ImagesXMLWriter
    extends BaseXML.BaseXMLWriter {
        public ImagesXMLWriter(PrintWriter pW) {
            super(pW);
        }

        public void write(Images images) {
            this.openElement("images");
            this.upIndent();
            for (ImageInfo image : images.getImages().values()) {
                this.write(image);
            }
            this.downIndent();
            this.closeElement("images");
        }

        public void write(ImageInfo image) {
            this.openElement("image");
            this.upIndent();
            this.printElement("name", image.getName());
            for (String featureName : image.getFeatures()) {
                this.printElement("feature", featureName);
            }
            this.downIndent();
            this.closeElement("image");
        }
    }
}

