/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import java.util.List;

public class ImageInfo {
    private final int hashCode;
    private final String toString;
    private final String name;
    private final String baseName;
    private final String version;
    private final List<String> features;

    private static String[] parse(String name) {
        int digitOffset;
        String[] parsedName = new String[2];
        for (digitOffset = name.length(); digitOffset > 0 && Character.isDigit(name.charAt(digitOffset - 1)); --digitOffset) {
        }
        parsedName[0] = name.substring(0, digitOffset);
        parsedName[1] = name.substring(digitOffset);
        return parsedName;
    }

    public ImageInfo(String name, List<String> features) {
        this.name = name;
        String[] parsedName = ImageInfo.parse(name);
        this.baseName = parsedName[0];
        this.version = parsedName[1];
        this.features = features;
        this.hashCode = name.hashCode();
        this.toString = this.getClass().getSimpleName() + "(" + name + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageInfo)) {
            return false;
        }
        ImageInfo other = (ImageInfo)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        String thisName = this.getName();
        String otherName = other.getName();
        if (thisName == null) {
            return otherName == null;
        }
        if (otherName == null) {
            return false;
        }
        return thisName.equals(otherName);
    }

    public String toString() {
        return this.toString;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getFeatures() {
        return this.features;
    }
}

