/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class BaseXML {
    public static final boolean DO_APPEND = true;
    public static final long NS_IN_S = 1000000000L;
    private static final long[] GAP_LIMIT = new long[]{100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L};
    private static final String[] GAPS = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000"};

    public static void write(PrintStream output, FailableConsumer<PrintWriter, Exception> writer) throws Exception {
        PrintWriter pW = new PrintWriter(output);
        try {
            writer.accept(pW);
        }
        finally {
            pW.flush();
        }
    }

    public static void write(File file, FailableConsumer<PrintWriter, Exception> writer) throws Exception {
        try (FileWriter fW = new FileWriter(file, false);
             PrintWriter pW = new PrintWriter(fW);){
            writer.accept(pW);
        }
    }

    public static void read(File file, ContentHandler contentHandler, ErrorHandler errorHandler) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(contentHandler);
        xmlReader.setErrorHandler(errorHandler);
        xmlReader.parse(file.toURI().toASCIIString());
    }

    public static String gap(long value) {
        int limitNo;
        for (limitNo = 0; limitNo < GAP_LIMIT.length && value < GAP_LIMIT[limitNo]; ++limitNo) {
        }
        return GAPS[limitNo];
    }

    public static interface FailableConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    public static class BaseErrorHandler
    implements ErrorHandler {
        private final List<SAXParseException> captured;
        private final PrintStream printer;

        BaseErrorHandler(PrintStream printer) {
            this.printer = printer;
            this.captured = new ArrayList<SAXParseException>();
        }

        protected void capture(SAXParseException e) {
            this.captured.add(e);
        }

        public List<? extends SAXParseException> getCaptured() {
            return this.captured;
        }

        public void println(String message) {
            this.printer.println(message);
        }

        public String println(String severity, SAXParseException e) {
            String message = severity + ": " + BaseErrorHandler.getMessage(e);
            this.println(message);
            e.printStackTrace(this.printer);
            return message;
        }

        protected static String getMessage(SAXParseException e) {
            String systemId = e.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            return "URI [ " + systemId + " ] Line [ " + e.getLineNumber() + " ]: " + e.getMessage();
        }

        @Override
        public void warning(SAXParseException e) throws SAXParseException {
            this.println("Warning", e);
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXParseException {
            this.println("Error", e);
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXParseException {
            this.println("Fatal", e);
            throw e;
        }
    }

    public static class BaseContentHandler
    implements ContentHandler {
        private Locator locator = null;
        private final List<String> elementStack = new ArrayList<String>();
        private String lastElement = null;
        private final List<StringBuilder> builderPool = new ArrayList<StringBuilder>();
        private final List<Boolean> whitespaceStack = new ArrayList<Boolean>();
        private boolean lastWhitespace = true;
        private final List<StringBuilder> builderStack = new ArrayList<StringBuilder>();
        private StringBuilder lastBuilder = null;
        protected static final boolean WHITESPACE_ONLY = true;

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public Locator getDocumentLocator() {
            return this.locator;
        }

        public long parseSAsNS(String text) throws SAXException {
            long ns;
            long s;
            int len = text.length();
            if (len < 3 || text.charAt(len - 1) != 's' || text.charAt(len - 2) != ' ') {
                throw new SAXParseException("Incorrect seconds format [ " + text + " ]", this.getDocumentLocator());
            }
            int dot = text.indexOf(46);
            if (dot == -1 || dot == 0 || dot == (len -= 2) - 1) {
                throw new SAXParseException("Incorrect seconds format [ " + text + " ]", this.getDocumentLocator());
            }
            try {
                s = Long.parseLong(text.substring(0, dot), 10);
                ns = Long.parseLong(text.substring(dot + 1, len), 10);
            }
            catch (NumberFormatException e) {
                throw new SAXParseException("Incorrect seconds format [ " + text + " ]", this.getDocumentLocator(), e);
            }
            return s * 1000000000L + ns;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        protected String popElement() throws SAXParseException {
            String oldLast = this.lastElement;
            if (oldLast == null) {
                throw new SAXParseException("Pop with no element", this.getDocumentLocator());
            }
            int size = this.elementStack.size();
            this.lastElement = size == 0 ? null : this.elementStack.remove(size - 1);
            return oldLast;
        }

        protected void pushElement(String newLastElement) {
            if (this.lastElement != null) {
                this.elementStack.add(this.lastElement);
            }
            this.lastElement = newLastElement;
        }

        protected void pushElement(String newLastElement, String requiredElement) throws SAXParseException {
            String errorMsg = requiredElement == null ? (this.lastElement != null ? "Element [ " + newLastElement + " ] within [ " + this.lastElement + " ] but root is required" : null) : (this.lastElement == null ? "Element [ " + newLastElement + " ] as root but [ " + requiredElement + " ] is required" : (!this.lastElement.equals(requiredElement) ? "Element [ " + newLastElement + " ] beneath [ " + this.lastElement + " ] but [ " + requiredElement + " ] is required" : null));
            if (errorMsg != null) {
                throw new SAXParseException(errorMsg, this.getDocumentLocator());
            }
            this.pushElement(newLastElement);
        }

        protected boolean pushElement(String qName, String elementName, String requiredElement) throws SAXParseException {
            if (qName.equals(elementName)) {
                this.pushElement(qName, requiredElement);
                return true;
            }
            return false;
        }

        protected StringBuilder acquireBuilder() {
            if (this.builderPool.isEmpty()) {
                return new StringBuilder();
            }
            return this.builderPool.remove(this.builderPool.size() - 1);
        }

        protected String releaseBuilder(StringBuilder builder) {
            String text = builder.toString();
            builder.setLength(0);
            this.builderPool.add(builder);
            return text;
        }

        protected void pushBuilder(boolean whitespaceOnly) {
            this.whitespaceStack.add(this.lastWhitespace);
            this.lastWhitespace = whitespaceOnly;
            if (!whitespaceOnly) {
                if (this.lastBuilder != null) {
                    this.builderStack.add(this.lastBuilder);
                }
                this.lastBuilder = this.acquireBuilder();
            }
        }

        protected String popBuilder() {
            boolean oldWhitespace = this.lastWhitespace;
            int whiteSize = this.whitespaceStack.size();
            this.lastWhitespace = whiteSize == 0 ? true : this.whitespaceStack.remove(whiteSize - 1);
            if (oldWhitespace) {
                return null;
            }
            StringBuilder oldBuilder = this.lastBuilder;
            int builderSize = this.builderStack.size();
            this.lastBuilder = builderSize == 0 ? null : this.builderStack.remove(builderSize - 1);
            return this.releaseBuilder(oldBuilder);
        }

        protected void addText(String text) throws SAXParseException {
            if (this.lastWhitespace) {
                if (text.trim().isEmpty()) {
                    return;
                }
                throw new SAXParseException("Unexpected non-whitespace text [ " + text + " ]", this.getDocumentLocator());
            }
            if (this.lastBuilder == null) {
                throw new SAXParseException("Unexpected text [ " + text + " ]", this.getDocumentLocator());
            }
            this.lastBuilder.append(text);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            throw new SAXParseException("Unknown element [ " + qName + " ]", this.getDocumentLocator());
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            throw new SAXParseException("Unknown element [ " + qName + " ]", this.getDocumentLocator());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String text = new String(ch, start, length);
            this.addText(text);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    public static class BaseXMLWriter
    implements Closeable {
        private final PrintWriter pW;
        private int indent;
        protected static final String INDENT_0 = "";
        protected static final String INDENT_4 = "    ";
        protected static final String INDENT_8 = "        ";
        protected static final String INDENT_12 = "            ";
        protected final StringBuilder lineBuilder = new StringBuilder();
        public static final char OPEN_BRACE_CHAR = '<';
        public static final char SLASH_CHAR = '/';
        public static final char CLOSE_BRACE_CHAR = '>';
        protected static final boolean DO_CLOSE = true;
        private final StringBuilder builder = new StringBuilder();

        public BaseXMLWriter(PrintWriter pW) {
            this.pW = pW;
            this.indent = 0;
        }

        protected void println() {
            this.pW.println();
        }

        protected void println(String line) {
            this.pW.println(line);
        }

        public void flush() {
            this.pW.flush();
        }

        @Override
        public void close() throws IOException {
            this.pW.close();
        }

        protected void upIndent() {
            ++this.indent;
        }

        protected void downIndent() {
            --this.indent;
        }

        protected String getIndentation() {
            if (this.indent == 0) {
                return INDENT_0;
            }
            if (this.indent == 1) {
                return INDENT_4;
            }
            if (this.indent == 2) {
                return INDENT_8;
            }
            return INDENT_12;
        }

        protected String assembleLine(String element) {
            this.lineBuilder.append(this.getIndentation());
            this.lineBuilder.append('<');
            this.lineBuilder.append(element);
            this.lineBuilder.append('/');
            this.lineBuilder.append('>');
            String line = this.lineBuilder.toString();
            this.lineBuilder.setLength(0);
            return line;
        }

        protected String assembleLine(String element, boolean doClose) {
            this.lineBuilder.append(this.getIndentation());
            this.lineBuilder.append('<');
            if (doClose) {
                this.lineBuilder.append('/');
            }
            this.lineBuilder.append(element);
            this.lineBuilder.append('>');
            String line = this.lineBuilder.toString();
            this.lineBuilder.setLength(0);
            return line;
        }

        protected String assembleLine(String element, String value) {
            this.lineBuilder.append(this.getIndentation());
            this.lineBuilder.append('<');
            this.lineBuilder.append(element);
            this.lineBuilder.append('>');
            this.lineBuilder.append(value);
            this.lineBuilder.append('<');
            this.lineBuilder.append('/');
            this.lineBuilder.append(element);
            this.lineBuilder.append('>');
            String line = this.lineBuilder.toString();
            this.lineBuilder.setLength(0);
            return line;
        }

        protected String assembleMultiLine(String element, String ... values) {
            this.lineBuilder.append(this.getIndentation());
            this.lineBuilder.append('<');
            this.lineBuilder.append(element);
            this.lineBuilder.append('>');
            for (String value : values) {
                this.lineBuilder.append(value);
            }
            this.lineBuilder.append('<');
            this.lineBuilder.append('/');
            this.lineBuilder.append(element);
            this.lineBuilder.append('>');
            String line = this.lineBuilder.toString();
            this.lineBuilder.setLength(0);
            return line;
        }

        public void openElement(String element) {
            this.println(this.assembleLine(element, false));
        }

        public void closeElement(String element) {
            this.println(this.assembleLine(element, true));
        }

        public void printElement(String element) {
            this.println(this.assembleLine(element));
        }

        public void printElement(String element, String value) {
            this.println(this.assembleLine(element, value));
        }

        public void printMultiElement(String element, String ... values) {
            this.println(this.assembleMultiLine(element, values));
        }

        public void printElement(String element, long value) {
            this.printElement(element, Long.toString(value));
        }

        public void printElementNsAsS(String element, long valueNs) {
            long ns = valueNs % 1000000000L;
            long s = (valueNs - ns) / 1000000000L;
            String nsText = Long.toString(ns);
            String sText = Long.toString(s);
            this.printMultiElement(element, sText, ".", BaseXML.gap(ns), nsText, " s");
        }

        public void printElement(String element, boolean value) {
            this.println(this.assembleLine(element, Boolean.toString(value)));
        }

        public String optionalToString(Object value) {
            return value == null ? null : value.toString();
        }

        public void printOptionalElement(String element, Object value) {
            if (value == null) {
                return;
            }
            String valueString = value.toString();
            if (valueString.isEmpty()) {
                return;
            }
            this.println(this.assembleLine(element, valueString));
        }

        public void printOptionalElement(String element, boolean value) {
            if (value) {
                this.printElement(element);
            }
        }

        public void printElements(String element, Collection<String> values) {
            for (String value : values) {
                this.printElement(element, value);
            }
        }

        public void printElements(String element, String[] values) {
            for (String value : values) {
                this.printElement(element, value);
            }
        }

        public void printDelimited(String element, String delimiter, Collection<String> values) {
            if (values == null || values.isEmpty()) {
                return;
            }
            boolean isFirst = true;
            for (String value : values) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.builder.append(delimiter);
                }
                this.builder.append(value);
            }
            String line = this.builder.toString();
            this.builder.setLength(0);
            this.printElement(element, line);
        }

        public void withinElement(String element, Runnable action) {
            this.openElement(element);
            this.upIndent();
            action.run();
            this.downIndent();
            this.closeElement(element);
        }
    }
}

