/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.service.setup;

import com.ibm.ws.st.common.core.ext.internal.AbstractServerSetup;
import com.ibm.ws.st.common.core.ext.internal.Activator;
import com.ibm.ws.st.common.core.ext.internal.Messages;
import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.producer.AbstractServerProducer;
import com.ibm.ws.st.common.core.ext.internal.producer.ServerCreationException;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.generation.Feature;
import com.ibm.ws.st.core.internal.generation.FeatureInfoHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.w3c.dom.Document;

public class LibertySetup
extends AbstractServerSetup {
    public static long DEFAULT_TIMEOUT = 10000L;
    private IPlatformHandler setup = null;
    private String serviceType = null;
    protected Map<String, String> serviceInfo = null;
    private IRuntime rt = null;
    private File serverXML = null;
    protected boolean includesDownloaded = false;
    protected boolean configDropinsDownloaded = false;
    protected Map<File, String> includesMap = new HashMap<File, String>();
    protected Map<File, String> configDropinsMap = new HashMap<File, String>();
    protected ToUpdateTuple toUpdate = null;
    protected final Object configLock = this;

    public void initialize(String serviceType, Map<String, String> serviceInfo, IRuntime runtime) throws ServerCreationException, UnsupportedServiceException {
        this.serviceType = serviceType;
        this.serviceInfo = serviceInfo;
        this.rt = runtime;
        if ("WASLibertyCorePlan".equals(serviceType)) {
            this.getPlatformHandler(PlatformHandlerFactory.PlatformType.SSH_KEYLESS);
        } else if ("LibertyDockerLocal".equals(serviceType)) {
            this.getPlatformHandler(PlatformHandlerFactory.PlatformType.DOCKER);
        } else {
            Trace.trace((byte)1, (String)("Unsupported service type: " + serviceType));
        }
        this.startUp();
        this.getServerXML();
    }

    public void setup(IProgressMonitor monitor) throws ServerCreationException, UnsupportedServiceException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Environment setup started...");
            }
            this.environmentSetup(this.setup);
            if (mon.isCanceled()) {
                return;
            }
            mon.worked(10);
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Environment setup complete.");
            }
            ArrayList<Integer> portsToAdd = new ArrayList<Integer>();
            portsToAdd.add(7777);
            try {
                if (this.serviceInfo.get("libertyHttpsPort") != null) {
                    int httpsPort = Integer.parseInt(this.serviceInfo.get("libertyHttpsPort"));
                    portsToAdd.add(httpsPort);
                }
            }
            catch (NumberFormatException e) {
                Trace.logError((String)"Error parsing the https port", (Throwable)e);
                throw new ServerCreationException(Messages.errorServerSetupFailed, (Throwable)e);
            }
            this.setupIPTables(this.setup, portsToAdd);
            if (mon.isCanceled()) {
                return;
            }
            mon.worked(30);
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Finished firewall setup steps.");
            }
            this.serverSetup(this.setup, (IProgressMonitor)mon.newChild(60));
            if (mon.isCanceled()) {
                return;
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Finished setup steps.");
            }
        }
        catch (Exception e) {
            Trace.logError((String)"Failed to setup", (Throwable)e);
            throw new ServerCreationException(Messages.errorServerSetupFailed, (Throwable)e);
        }
        finally {
            this.tearDown();
        }
    }

    private IPlatformHandler getPlatformHandler(PlatformHandlerFactory.PlatformType platformType) throws UnsupportedServiceException {
        if (this.setup != null) {
            return this.setup;
        }
        this.setup = PlatformHandlerFactory.getPlatformHandler(this.serviceInfo, (PlatformHandlerFactory.PlatformType)platformType);
        return this.setup;
    }

    private void environmentSetup(IPlatformHandler setup) throws ServerCreationException {
        try {
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Starting environment setup...");
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Connecting remote session...");
            }
            Path serverConfigPath = new Path(this.serviceInfo.get("libertyServerConfigPath"));
            String defaultsConfigDropinsPath = serverConfigPath.append("configDropins").append("defaults").toString();
            boolean found = setup.directoryExists(defaultsConfigDropinsPath);
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Remote session started.");
            }
            if (!found) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)7, (String)"defaults directory not found.");
                    Trace.trace((byte)7, (String)("Creating directory: " + defaultsConfigDropinsPath));
                }
                setup.createDirectory(defaultsConfigDropinsPath);
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Finished environment setup.");
            }
        }
        catch (Exception e) {
            Trace.logError((String)"Failed to setup environment", (Throwable)e);
            throw new ServerCreationException(Messages.errorServerSetupFailed, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void serverSetup(IPlatformHandler setup, IProgressMonitor monitor) throws ServerCreationException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        File remoteAdministrationTempFile = null;
        InputStream in = null;
        FileOutputStream fos = null;
        if (Trace.ENABLED) {
            Trace.trace((byte)7, (String)"Starting server setup steps.");
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, (String)"Copying remote administration config...");
        }
        try {
            int len;
            URL remoteAdministrationFileURL = Activator.getInstance().getBundle().getEntry("config/remoteAdministration.xml");
            in = remoteAdministrationFileURL.openStream();
            String[] prefixSuffix = "remoteAdministration.xml".split("\\.");
            remoteAdministrationTempFile = File.createTempFile(prefixSuffix[0], prefixSuffix[1]);
            fos = new FileOutputStream(remoteAdministrationTempFile);
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            Trace.logError((String)"Failed to retrieve configuration file from plugin.", (Throwable)e);
            throw new ServerCreationException(Messages.errorFailedRemoteConfigUpload, (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        if (mon.isCanceled()) {
            return;
        }
        mon.worked(20);
        try {
            String restConnectorFeature = LibertySetup.resolveFeature(setup, this.serviceInfo, "restConnector");
            if (mon.isCanceled()) {
                return;
            }
            mon.worked(30);
            Path serverConfigPath = new Path(this.serviceInfo.get("libertyServerConfigPath"));
            ConfigUtils.updateRemoteFileAccess(ConfigUtils.documentLoad(remoteAdministrationTempFile), remoteAdministrationTempFile, setup.getEnvValue("LOG_DIR"), restConnectorFeature);
            String oldPath = this.serviceInfo.get("libertyServerConfigPath") + "/configDropins/defaults/" + "st_remoteAdministration_st.xml";
            if (setup.fileExists(oldPath)) {
                setup.deleteFile(oldPath);
            }
            setup.uploadFile(remoteAdministrationTempFile.getAbsolutePath(), serverConfigPath.append("/configDropins/defaults/remoteAdministration.xml").toString());
            if (mon.isCanceled()) {
                return;
            }
            mon.worked(30);
        }
        catch (Exception e) {
            Trace.logError((String)"Failed to upload remote administration config", (Throwable)e);
            throw new ServerCreationException(Messages.errorFailedRemoteConfigUpload, (Throwable)e);
        }
        finally {
            try {
                if (remoteAdministrationTempFile != null) {
                    remoteAdministrationTempFile.delete();
                }
            }
            catch (Exception exception) {}
        }
        try {
            String command = this.getStartCommand(this.serviceInfo);
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)("Starting server using command: " + command));
            }
            IPlatformHandler.ExecutionOutput output = setup.executeCommand(command);
            if (Trace.ENABLED) {
                int returnCode = output.getReturnCode();
                Trace.trace((byte)7, (String)("Return code: " + returnCode));
                Trace.trace((byte)7, (String)output.getOutput());
                Trace.trace((byte)7, (String)output.getError());
            }
        }
        catch (Exception e) {
            Trace.logError((String)"Failed to upload remote administration config", (Throwable)e);
            throw new ServerCreationException(Messages.errorFailedRemoteConfigUpload, (Throwable)e);
        }
        if (mon.isCanceled()) {
            return;
        }
        mon.worked(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String resolveFeature(IPlatformHandler handler, Map<String, String> serviceInfo, String featureName) {
        if (featureName == null) {
            return null;
        }
        IPath featureManagerScript = new Path(serviceInfo.get("LibertyRuntimeInstallPath")).append("/bin/featureManager");
        IPath featureListJar = new Path(serviceInfo.get("LibertyRuntimeInstallPath")).append("/bin/tools/ws-featurelist.jar");
        IPath featureListFile = new Path(serviceInfo.get("libertyServerConfigPath")).append("/st_featureList_st.xml");
        try {
            String command;
            block34: {
                if (handler.fileExists(featureListFile.toString())) {
                    handler.deleteFile(featureListFile.toString());
                }
                command = "java -jar " + featureListJar + " " + featureListFile;
                try {
                    if (handler.fileExists(featureManagerScript.toString())) {
                        command = featureManagerScript + " featureList " + featureListFile;
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block34;
                    Trace.trace((byte)1, (String)("Could not determine if the feature manager script exists: " + featureManagerScript.toString()), (Throwable)e);
                }
            }
            IPlatformHandler.ExecutionOutput output = handler.executeCommand(command, 30000L);
            if (output.getError() != null && output.getError().length() > 0) {
                throw new IOException("Failed to generate feature list: " + output.getError());
            }
            File tempFeatureListFile = File.createTempFile("featureList", ".xml");
            handler.downloadFile(featureListFile.toString(), tempFeatureListFile.getAbsolutePath());
            if (!tempFeatureListFile.exists()) return null;
            FileInputStream is = null;
            is = new FileInputStream(tempFeatureListFile);
            HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> map = FeatureInfoHandler.parseFeatureListXML(is);
            HashMap<String, Feature> featureMap = map.get((Object)FeatureList.FeatureMapType.PUBLIC_FEATURES_KEYED_BY_NAME);
            String string = FeatureSet.resolve(featureName, featureMap.keySet().toArray(new String[featureMap.size()]));
            if (is == null) return string;
            try {
                ((InputStream)is).close();
                return string;
            }
            catch (IOException e) {
                if (!Trace.ENABLED) return string;
                Trace.trace((byte)1, (String)("Error closing featurelist file: " + tempFeatureListFile.getAbsolutePath()), (Throwable)e);
            }
            return string;
            catch (Throwable t) {
                try {
                    try {
                        Trace.logError((String)("Error parsing featurelist file: " + tempFeatureListFile.getAbsolutePath()), (Throwable)t);
                        return null;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block35: {
                            if (is != null) {
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (IOException e) {
                                    if (!Trace.ENABLED) break block35;
                                    Trace.trace((byte)1, (String)("Error closing featurelist file: " + tempFeatureListFile.getAbsolutePath()), (Throwable)e);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) return null;
                    Trace.logError((String)"Rest Connector feature detection failed", (Throwable)e);
                    return null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            block36: {
                try {
                    if (handler.fileExists(featureListFile.toString())) {
                        handler.deleteFile(featureListFile.toString());
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block36;
                    Trace.logError((String)"Failed to delete the generated feature list file", (Throwable)e);
                }
            }
        }
    }

    private void setupIPTables(IPlatformHandler setup, List<Integer> ports) throws Exception {
        int port;
        String portArg;
        ArrayList<Integer> inputPortsToChange = new ArrayList<Integer>();
        ArrayList<Integer> outputPortsToChange = new ArrayList<Integer>();
        boolean rulesChanged = false;
        String checkRuleHeader = "iptables-save | grep ";
        String inputRuleCheckHeader = "-A INPUT -p tcp";
        String dportCheck = "--dport";
        String outputRuleCheckHeader = "-A OUTPUT -p tcp";
        String sportCheck = "--sport";
        String acceptRule = " -j ACCEPT";
        String multi = "--match multiport ";
        String inputRuleHeader = "iptables -I INPUT -p tcp ";
        String outputRuleHeader = "iptables -I OUTPUT -p tcp ";
        String saveIPTable = "service iptables save";
        String restartIPTable = "service iptables restart";
        String regex = "\\r?\\n";
        for (int port2 : ports) {
            String[] outputLines;
            String checkRule = checkRuleHeader + port2;
            IPlatformHandler.ExecutionOutput output = setup.executeCommand(checkRule);
            boolean inputContains = false;
            boolean outputContains = false;
            for (String line : outputLines = output.getOutput().split(regex)) {
                if (!line.contains(String.valueOf(port2)) || !line.contains(acceptRule)) continue;
                if (line.contains(inputRuleCheckHeader) && line.contains(dportCheck)) {
                    inputContains = true;
                }
                if (!line.contains(outputRuleCheckHeader) || !line.contains(sportCheck)) continue;
                outputContains = true;
            }
            if (!inputContains) {
                inputPortsToChange.add(port2);
            }
            if (outputContains) continue;
            outputPortsToChange.add(port2);
        }
        if (inputPortsToChange.size() > 0) {
            boolean multiInput;
            StringBuilder inputChange = new StringBuilder();
            inputChange.append(inputRuleHeader);
            boolean bl = multiInput = inputPortsToChange.size() > 1;
            if (multiInput) {
                inputChange.append(multi);
            }
            portArg = multiInput ? "--dports " : "--dport ";
            inputChange.append(portArg);
            String inputPort = "";
            Iterator iterator = inputPortsToChange.iterator();
            while (iterator.hasNext()) {
                port = (Integer)iterator.next();
                if (inputPort == "") {
                    inputPort = String.valueOf(port);
                    continue;
                }
                inputPort = inputPort + "," + String.valueOf(port);
            }
            inputChange.append(inputPort);
            inputChange.append(acceptRule);
            setup.executeCommand(inputChange.toString());
            rulesChanged = true;
        }
        if (outputPortsToChange.size() > 0) {
            boolean multiOutput;
            StringBuilder outputChange = new StringBuilder();
            outputChange.append(outputRuleHeader);
            boolean bl = multiOutput = outputPortsToChange.size() > 1;
            if (multiOutput) {
                outputChange.append(multi);
            }
            portArg = multiOutput ? "--sports " : "--sport ";
            outputChange.append(portArg);
            String outputPort = "";
            Iterator iterator = outputPortsToChange.iterator();
            while (iterator.hasNext()) {
                port = (Integer)iterator.next();
                if (outputPort == "") {
                    outputPort = String.valueOf(port);
                    continue;
                }
                outputPort = outputPort + "," + String.valueOf(port);
            }
            outputChange.append(outputPort);
            outputChange.append(acceptRule);
            setup.executeCommand(outputChange.toString());
            rulesChanged = true;
        }
        if (rulesChanged) {
            setup.executeCommand(saveIPTable);
            setup.executeCommand(restartIPTable);
        }
    }

    private String getStartCommand(Map<String, String> serviceInfo) {
        StringBuilder sb = new StringBuilder();
        Path serverInstallPath = new Path(serviceInfo.get("LibertyRuntimeInstallPath"));
        String execPath = serverInstallPath.append("bin").append("server").toString();
        String[] commandArgs = new String[]{"start", serviceInfo.get("libertyServerName")};
        sb.append("\"");
        sb.append(execPath);
        sb.append("\"");
        for (String arg : commandArgs) {
            sb.append(" ");
            sb.append(arg);
        }
        return sb.toString();
    }

    public void createServer() throws ServerCreationException, UnsupportedServiceException {
        String runtimeType;
        AbstractServerProducer producer;
        if (Trace.ENABLED) {
            Trace.trace((byte)7, (String)"Creating server...");
        }
        if ((producer = Activator.getServerProducer((String)(runtimeType = this.rt.getRuntimeType().getId()))) == null) {
            throw new UnsupportedServiceException(NLS.bind((String)Messages.errorNoServerProducersFound, (Object)this.serviceType));
        }
        producer.createServer(this.rt, this.serviceInfo);
        if (Trace.ENABLED) {
            Trace.trace((byte)7, (String)"Finished creating server.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteSecurity(String user, String password, int code, IProgressMonitor monitor) {
        Object object = this.configLock;
        synchronized (object) {
            if (this.setup != null) {
                try {
                    monitor.worked(10);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (this.toUpdate != null) {
                        File tempXML = this.toUpdate.tempFile;
                        Document doc = ConfigUtils.documentLoad(tempXML);
                        ConfigUtils.updateRemoteSecurity(doc, tempXML, user, password, code);
                        if (monitor.isCanceled()) {
                            return;
                        }
                        this.setup.uploadFile(tempXML.getAbsolutePath(), this.toUpdate.destinationPath);
                        monitor.worked(40);
                    } else {
                        Path serverConfigPath = new Path(this.serviceInfo.get("libertyServerConfigPath"));
                        String defaultsConfigDropinsPath = serverConfigPath.append("/configDropins/defaults/").toString();
                        if (!this.setup.directoryExists(defaultsConfigDropinsPath)) {
                            this.setup.createDirectory(defaultsConfigDropinsPath);
                        }
                        if (monitor.isCanceled()) {
                            return;
                        }
                        String oldBasicRegConfig = defaultsConfigDropinsPath + "st_basicRegistry_st.xml";
                        if (this.setup.fileExists(oldBasicRegConfig)) {
                            this.setup.deleteFile(oldBasicRegConfig);
                        }
                        this.setup.uploadFile(ConfigUtils.createBasicRegConfig(user, password).getAbsolutePath(), defaultsConfigDropinsPath + "basicRegistry.xml");
                        monitor.worked(40);
                    }
                }
                catch (Exception e) {
                    Trace.logError((String)"Error updaing the server config files", (Throwable)e);
                }
            }
        }
    }

    public int validateRemoteSecurity(String user, String password, IProgressMonitor mon) {
        int result = -1;
        int serverResult = -1;
        int includeResult = -1;
        int configDropinResult = -1;
        Document doc = null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        if (this.setup != null && this.serverXML != null) {
            try {
                int current;
                Document tempDoc;
                File tempFile;
                doc = ConfigUtils.documentLoad(this.serverXML);
                if (monitor.isCanceled()) {
                    return -1;
                }
                monitor.worked(10);
                if (doc != null) {
                    serverResult = ConfigUtils.validateRemoteSecurity(doc, user, password);
                    if (serverResult == 0) {
                        return 0;
                    }
                    if (serverResult > result) {
                        result = serverResult;
                    }
                }
                if (monitor.isCanceled()) {
                    return -1;
                }
                monitor.worked(10);
                this.getIncludes();
                if (monitor.isCanceled()) {
                    return -1;
                }
                monitor.worked(20);
                for (Map.Entry<File, String> entry : this.includesMap.entrySet()) {
                    tempFile = entry.getKey();
                    if (!tempFile.exists() || tempFile.getTotalSpace() <= 0L) continue;
                    tempDoc = ConfigUtils.documentLoad(tempFile);
                    current = ConfigUtils.validateRemoteSecurity(tempDoc, user, password);
                    if (current == 0) {
                        return 0;
                    }
                    if (current <= includeResult || (includeResult = current) <= result) continue;
                    result = includeResult;
                    this.toUpdate = new ToUpdateTuple(tempFile, entry.getValue());
                }
                if (monitor.isCanceled()) {
                    return -1;
                }
                monitor.worked(10);
                this.getConfigDropins();
                if (monitor.isCanceled()) {
                    return -1;
                }
                monitor.worked(20);
                for (Map.Entry<File, String> entry : this.configDropinsMap.entrySet()) {
                    tempFile = entry.getKey();
                    if (!tempFile.exists() || tempFile.getTotalSpace() <= 0L) continue;
                    tempDoc = ConfigUtils.documentLoad(tempFile);
                    current = ConfigUtils.validateRemoteSecurity(tempDoc, user, password);
                    if (current == 0) {
                        return 0;
                    }
                    if (current <= configDropinResult || (configDropinResult = current) <= result) continue;
                    result = configDropinResult;
                    this.toUpdate = new ToUpdateTuple(tempFile, entry.getValue());
                }
                if (monitor.isCanceled()) {
                    return -1;
                }
                monitor.worked(30);
            }
            catch (Exception e) {
                Trace.logError((String)"Error validating user security", (Throwable)e);
            }
        }
        return result;
    }

    public File getServerXML() {
        File tempServerFile = null;
        if (this.serverXML == null) {
            try {
                if (this.setup != null && (tempServerFile = File.createTempFile("server", ".xml")) != null) {
                    Path serverConfigPath = new Path(this.serviceInfo.get("libertyServerConfigPath"));
                    this.setup.downloadFile(serverConfigPath.append("/server.xml").toString(), tempServerFile.getCanonicalPath());
                    this.serverXML = tempServerFile;
                }
            }
            catch (Exception e) {
                Trace.logError((String)"Error getting the server.xml from the remote environment", (Throwable)e);
            }
        }
        return this.serverXML;
    }

    private void getIncludes() {
        if (this.includesDownloaded) {
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Include files already downloaded, skipping");
            }
            return;
        }
        Document doc = null;
        try {
            doc = ConfigUtils.documentLoad(this.serverXML);
            ArrayList<String> includes = ConfigUtils.getIncludes(doc);
            for (String include : includes) {
                boolean referenceInInclude = ConfigVarsUtils.containsReference(include);
                if (referenceInInclude) {
                    ConfigVars cv = new ConfigVars();
                    this.setVars(cv);
                    String resolvedInclude = cv.resolve(include);
                    if (this.setup != null && this.setup.fileExists(resolvedInclude)) {
                        File tempFile = File.createTempFile("include", ".xml");
                        this.setup.downloadFile(resolvedInclude, tempFile.getCanonicalPath());
                        this.includesMap.put(tempFile, resolvedInclude);
                    }
                } else {
                    String relativePath = this.serviceInfo.get("libertyServerConfigPath") + "/" + include;
                    if (this.setup != null && this.setup.fileExists(relativePath)) {
                        File tempFile = File.createTempFile("include", ".xml");
                        this.setup.downloadFile(relativePath, tempFile.getCanonicalPath());
                        this.includesMap.put(tempFile, relativePath);
                    }
                }
                this.includesDownloaded = true;
            }
        }
        catch (Exception e) {
            Trace.logError((String)"Error getting the include files from the remote environment", (Throwable)e);
        }
    }

    private void getConfigDropins() {
        if (this.configDropinsDownloaded) {
            return;
        }
        String regex = "\\r?\\n";
        Path serverConfigPath = new Path(this.serviceInfo.get("libertyServerConfigPath"));
        String defaultsConfigDropinsPath = serverConfigPath.append("configDropins").append("defaults").toString();
        String overridesConfigDropinsPath = serverConfigPath.append("configDropins").append("overrides").toString();
        if (this.setup != null) {
            try {
                File tempFile;
                String filePath;
                int i;
                String[] files;
                String output;
                if (this.setup.directoryExists(defaultsConfigDropinsPath)) {
                    output = this.setup.executeCommand("ls " + defaultsConfigDropinsPath).getOutput();
                    files = output.split(regex);
                    for (i = 0; i < files.length; ++i) {
                        filePath = defaultsConfigDropinsPath + "/" + files[i];
                        if (!this.setup.fileExists(filePath)) continue;
                        tempFile = File.createTempFile("defaultConfig", ".xml");
                        this.setup.downloadFile(filePath, tempFile.getCanonicalPath());
                        this.configDropinsMap.put(tempFile, filePath);
                    }
                }
                if (this.setup.directoryExists(overridesConfigDropinsPath)) {
                    output = this.setup.executeCommand("ls " + overridesConfigDropinsPath).getOutput();
                    files = output.split(regex);
                    for (i = 0; i < files.length; ++i) {
                        filePath = overridesConfigDropinsPath + "/" + files[i];
                        if (!this.setup.fileExists(filePath)) continue;
                        tempFile = File.createTempFile("overridesConfig", ".xml");
                        this.setup.downloadFile(filePath, tempFile.getCanonicalPath());
                        this.configDropinsMap.put(tempFile, filePath);
                    }
                }
                this.configDropinsDownloaded = true;
            }
            catch (Exception e) {
                Trace.logError((String)"Error getting the configDropins files from the remote environment", (Throwable)e);
            }
        }
    }

    public int getHTTPPort(String portType) {
        int result = -1;
        Document doc = null;
        try {
            doc = ConfigUtils.documentLoad(this.serverXML);
            if (portType.equals("libertyHttpPort")) {
                result = ConfigUtils.getHTTPPort(doc, "httpPort");
            } else if (portType.equals("libertyHttpsPort")) {
                result = ConfigUtils.getHTTPPort(doc, "httpsPort");
            }
        }
        catch (Exception e) {
            Trace.logError((String)"Error obtaining the HTTP/HTTPs port", (Throwable)e);
        }
        return result;
    }

    public void updateServiceInfo(String key, String value) {
        if (this.serviceInfo == null) {
            return;
        }
        this.serviceInfo.put(key, value);
    }

    private void setVars(ConfigVars cv) {
        String serverConfigDir = this.serviceInfo.get("libertyServerConfigPath");
        String installDir = this.serviceInfo.get("LibertyRuntimeInstallPath");
        cv.addResolved("wlp.user.dir", installDir + "/usr", null, null);
        cv.addResolved("shared.app.dir", installDir + "/usr/shared/apps", null, null);
        cv.addResolved("shared.config.dir", installDir + "usr/shared/config", null, null);
        cv.addResolved("shared.resource.dir", installDir + "usr/shared/resources", null, null);
        cv.addResolved("server.config.dir", serverConfigDir, null, null);
        cv.addResolved("server.output.dir", serverConfigDir, null, null);
    }

    private void startUp() throws ServerCreationException {
        try {
            this.setup.startSession();
        }
        catch (Exception e) {
            Trace.logError((String)"Failed to connect", (Throwable)e);
            throw new ServerCreationException(NLS.bind((String)Messages.errorFailedRemoteConnection, (Object)this.serviceInfo.get("hostname")), (Throwable)e);
        }
    }

    private void tearDown() {
        try {
            this.setup.endSession();
            if (Trace.ENABLED) {
                Trace.trace((byte)7, (String)"Remote session ended.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ToUpdateTuple {
        protected File tempFile;
        protected String destinationPath;

        public ToUpdateTuple(File file, String path) {
            this.tempFile = file;
            this.destinationPath = path;
        }
    }
}

