/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.security;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class LibertyX509CertData
implements Iterable<Entry> {
    private final List<Entry> entries_ = new LinkedList<Entry>();
    private static final String[] KEY_USAGE = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
    private static final String[] ALTERNATIVE_NAMES = new String[]{"otherName", "rfc822Name", "dNSName", "x400Address", "directoryName", "ediPartyName", "uniformResourceIdentifier", "iPAddress", "registeredID"};

    public LibertyX509CertData(Certificate certificate) {
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "certificate=[" + certificate + "]");
        }
        if (certificate != null) {
            PublicKey publicKey = certificate.getPublicKey();
            this.add(Messages.X509_CERT_LABEL_PUBLIC_KEY_FORMAT, LibertyX509CertData.getPublicKeyFormat(publicKey));
            this.add(Messages.X509_CERT_LABEL_PUBLIC_KEY_ALGORITHM, LibertyX509CertData.getPublicKeyAlgorithm(publicKey));
            if (certificate instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)certificate;
                this.add(Messages.X509_CERT_LABEL_ISSUER_DN, cert.getIssuerX500Principal().getName());
                this.add(Messages.X509_CERT_LABEL_ISSUER_ID, LibertyX509CertData.binify(cert.getIssuerUniqueID()));
                this.add(Messages.X509_CERT_LABEL_ISSUER_ALTERNATE_NAMES, LibertyX509CertData.getIssuerAlternativeNames(cert));
                this.add(Messages.X509_CERT_LABEL_SUBJECT_DN, cert.getSubjectDN().toString());
                this.add(Messages.X509_CERT_LABEL_SUBJECT_ID, LibertyX509CertData.binify(cert.getIssuerUniqueID()));
                this.add(Messages.X509_CERT_LABEL_SUBJECT_ALTERNATE_NAMES, LibertyX509CertData.getSubjectAlternativeNames(cert));
                this.add(Messages.X509_CERT_LABEL_VERSION, Integer.toString(cert.getVersion()));
                this.add(Messages.X509_CERT_LABEL_SERIAL, cert.getSerialNumber().toString());
                this.add(Messages.X509_CERT_LABEL_NOT_BEFORE, DateFormat.getDateTimeInstance().format(cert.getNotBefore()));
                this.add(Messages.X509_CERT_LABEL_NOT_AFTER, DateFormat.getDateTimeInstance().format(cert.getNotAfter()));
                this.add(Messages.X509_CERT_LABEL_SIG_ALG_NAME, cert.getSigAlgName());
                this.add(Messages.X509_CERT_LABEL_SIG_ALG_OID, cert.getSigAlgOID());
                this.add(Messages.X509_CERT_LABEL_KEY_USAGE, LibertyX509CertData.getKeyUsage(cert));
                this.add(Messages.X509_CERT_LABEL_EXT_KEY_USAGE, LibertyX509CertData.getExtKeyUsage(cert));
            }
        }
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries_.iterator();
    }

    public Entry[] entries() {
        return this.entries_.toArray(new Entry[0]);
    }

    public String toString() {
        StringBuffer b = new StringBuffer("{");
        boolean comma = false;
        for (Entry entry : this.entries_) {
            if (comma) {
                b.append(',');
            } else {
                comma = true;
            }
            b.append(entry.toString());
        }
        b.append('}');
        return b.toString();
    }

    private void add(String key, String val) {
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "key=[" + key + "] val=[" + val + "]");
        }
        this.entries_.add(new Entry(key, val));
    }

    private static String getIssuerAlternativeNames(X509Certificate cert) {
        try {
            return LibertyX509CertData.getAlternativeNames(cert.getIssuerAlternativeNames());
        }
        catch (CertificateParsingException e) {
            Trace.logError(e.getMessage(), e);
            return null;
        }
    }

    private static String getSubjectAlternativeNames(X509Certificate cert) {
        try {
            return LibertyX509CertData.getAlternativeNames(cert.getSubjectAlternativeNames());
        }
        catch (CertificateParsingException e) {
            Trace.logError(e.getMessage(), e);
            return null;
        }
    }

    private static String getAlternativeNames(Collection<List<?>> alternativeNames) {
        if (alternativeNames != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            for (List<?> alternativeName : alternativeNames) {
                int index;
                Object indexObj = alternativeName.get(0);
                if (indexObj == null || !(indexObj instanceof Integer) || (index = ((Integer)indexObj).intValue()) < 0 || index >= ALTERNATIVE_NAMES.length) continue;
                String valueAsString = null;
                Object value = alternativeName.get(1);
                if (value == null) continue;
                valueAsString = value instanceof byte[] ? LibertyX509CertData.hexify((byte[])value) : value.toString();
                if (i++ > 0) {
                    buffer.append(' ');
                }
                buffer.append(NLS.bind((String)Messages.X509_ALTERNATIVE_NAME, (Object[])new String[]{ALTERNATIVE_NAMES[index], valueAsString}));
            }
            return buffer.length() == 0 ? null : buffer.toString();
        }
        return null;
    }

    private static String getPublicKeyFormat(PublicKey publicKey) {
        return publicKey != null ? publicKey.getFormat() : null;
    }

    private static String getPublicKeyAlgorithm(PublicKey publicKey) {
        return publicKey != null ? publicKey.getAlgorithm() : null;
    }

    private static String getKeyUsage(X509Certificate cert) {
        boolean[] bits = cert.getKeyUsage();
        if (bits != null) {
            String separator = null;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < bits.length && i < KEY_USAGE.length; ++i) {
                if (!bits[i]) continue;
                if (separator == null) {
                    separator = Messages.X509_KEY_USAGE_SEPARATOR;
                } else {
                    buffer.append(separator);
                }
                buffer.append(KEY_USAGE[i]);
            }
            return buffer.length() == 0 ? null : buffer.toString();
        }
        return null;
    }

    private static String getExtKeyUsage(X509Certificate cert) {
        try {
            List<String> extendedKeyUsages = cert.getExtendedKeyUsage();
            if (extendedKeyUsages != null) {
                String separator = null;
                StringBuffer buffer = new StringBuffer();
                for (String extendedKeyUsage : extendedKeyUsages) {
                    if (separator == null) {
                        separator = Messages.X509_KEY_USAGE_SEPARATOR;
                    } else {
                        buffer.append(separator);
                    }
                    buffer.append(extendedKeyUsage);
                }
                return buffer.length() == 0 ? null : buffer.toString();
            }
            return null;
        }
        catch (CertificateParsingException e) {
            Trace.logError(e.getMessage(), e);
            return null;
        }
    }

    private static String binify(boolean[] bits) {
        if (bits == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (boolean b : bits) {
            buffer.append(b ? (char)'1' : '0');
        }
        return NLS.bind((String)Messages.X509_BINARY, (Object)buffer);
    }

    private static String hexify(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                buffer.append('0');
            }
            buffer.append(hex);
            if (i % 4 != 3) continue;
            buffer.append(' ');
        }
        return NLS.bind((String)Messages.X509_HEX, (Object)buffer);
    }

    public static class Entry {
        private final String key_;
        private final String val_;

        Entry(String key, String val) {
            this.key_ = key;
            this.val_ = val;
        }

        public String getKey() {
            return this.key_;
        }

        public String getVal() {
            return this.val_;
        }

        public String toString() {
            return "{" + this.key_ + "," + this.val_ + "}";
        }
    }
}

