/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.remote;

import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.common.core.internal.RemoteServerInfo;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.Bootstrap;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.ServerEnv;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RemoteUtils {
    public static String generateRemoteUsrDirName(WebSphereRuntime wsRuntime) {
        return RemoteUtils.generateRemoteUsrDirName(wsRuntime, "Remote");
    }

    public static String generateRemoteUsrDirName(WebSphereRuntime wsRuntime, String baseIdentifier) {
        String defaultName;
        String name = defaultName = wsRuntime.getRuntime().getName() + " (" + baseIdentifier + ")";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        boolean decided = false;
        int i = 1;
        while (!decided) {
            IProject project = root.getProject(name);
            File projectFolder = root.getLocation().append(name).toFile();
            if (project.exists() || projectFolder.exists()) {
                name = defaultName + "(" + i++ + ")";
                continue;
            }
            decided = true;
        }
        return name;
    }

    public static UserDirectory createUserDir(WebSphereServer server, String remoteUserPath, String userDirName, IProgressMonitor monitor) throws CoreException {
        UserDirectory userDir = null;
        WebSphereRuntime wsRuntime = server.getWebSphereRuntime();
        if (wsRuntime != null) {
            IRuntimeWorkingCopy runtimeWorkingCopy = wsRuntime.getRuntime().createWorkingCopy();
            WebSphereRuntime wRuntimeWorkingCopy = (WebSphereRuntime)runtimeWorkingCopy.loadAdapter(WebSphereRuntime.class, null);
            IProject remoteUsrProject = WebSphereUtil.createUserProject(userDirName, null, monitor);
            IPath outputPath = remoteUsrProject.getLocation().append("servers");
            userDir = new UserDirectory(wsRuntime, remoteUsrProject.getLocation(), remoteUsrProject, outputPath, (IPath)new Path(remoteUserPath));
            boolean found = false;
            for (UserDirectory usr : wRuntimeWorkingCopy.getUserDirectories()) {
                if (!usr.getPath().equals((Object)userDir.getPath())) continue;
                found = true;
                break;
            }
            if (!found) {
                wRuntimeWorkingCopy.addUserDirectory(userDir);
            }
            try {
                runtimeWorkingCopy.save(true, null);
            }
            catch (CoreException ce) {
                Trace.logError(ce.getMessage(), ce);
            }
            wsRuntime.updateServerCache(true);
        }
        return userDir;
    }

    public static String getServerConfigDir(JMXConnection jmxConnection) throws Exception {
        CompositeData metadata = (CompositeData)jmxConnection.getMetadata("${server.config.dir}", "a");
        String serverConfigDir = (String)metadata.get("fileName");
        serverConfigDir = serverConfigDir.replace("\\", "/");
        return serverConfigDir;
    }

    public static String getServerName(String serverConfigDir) {
        return serverConfigDir.substring(serverConfigDir.lastIndexOf(47) + 1, serverConfigDir.length());
    }

    public static String getServerName(JMXConnection jmxConnection) throws Exception {
        String serverConfigDir = RemoteUtils.getServerConfigDir(jmxConnection);
        return RemoteUtils.getServerName(serverConfigDir);
    }

    public static String getWLPInstallDir(JMXConnection jmxConnection) throws Exception {
        CompositeData metadata = (CompositeData)jmxConnection.getMetadata("${wlp.install.dir}", "a");
        String wlpInstallDir = (String)metadata.get("fileName");
        if (wlpInstallDir != null) {
            wlpInstallDir = wlpInstallDir.replace("\\", "/");
        }
        return wlpInstallDir;
    }

    public static String getUserDir(JMXConnection jmxConnection) throws Exception {
        CompositeData userDirMetadata = (CompositeData)jmxConnection.getMetadata("${wlp.user.dir}", "a");
        String remoteUserPath = (String)userDirMetadata.get("fileName");
        remoteUserPath = remoteUserPath.replace("\\", "/");
        return remoteUserPath;
    }

    public static IStatus downloadServerFiles(JMXConnection jmxConnection, IPath userMetaDataPath, String serverName, ArrayList<IPath> downloadedFiles, String remoteUserPath, String userDir) {
        Status downloadStatus = new Status(0, "com.ibm.ws.st.core", Messages.remoteDownloadingServerConfigFile);
        try {
            ArrayList<CompositeData[]> listofServerDirFiles;
            ArrayList<IncludeFile> includeFiles;
            ArrayList<String> filesToDownload;
            IPath userServersDir;
            block26: {
                List<IncludeFile> locationList;
                userServersDir = userMetaDataPath.append("servers").append(serverName);
                if (!userServersDir.toFile().exists()) {
                    FileUtil.makeDir(userServersDir);
                }
                IPath configFilePath = userServersDir.append("server.xml");
                jmxConnection.downloadFile("${server.config.dir}/server.xml", configFilePath.toOSString());
                downloadedFiles.add(configFilePath);
                filesToDownload = new ArrayList<String>();
                includeFiles = new ArrayList<IncludeFile>();
                if (configFilePath.toFile().exists() && (locationList = RemoteUtils.getIncludeFiles(configFilePath)) != null) {
                    includeFiles.addAll(locationList);
                }
                listofServerDirFiles = new ArrayList<CompositeData[]>();
                try {
                    listofServerDirFiles.add(jmxConnection.getDirectoryEntries("${server.config.dir}", false, ""));
                    if (WebSphereUtil.isDefaultRemoteUserDirectory(jmxConnection, remoteUserPath)) {
                        listofServerDirFiles.add(jmxConnection.getDirectoryEntries(remoteUserPath, false, ""));
                    }
                    listofServerDirFiles.removeAll(Collections.singleton(null));
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block26;
                    Trace.logError("Error getting the file list for remote server", e);
                }
            }
            if (!listofServerDirFiles.isEmpty()) {
                for (CompositeData[] folder : listofServerDirFiles) {
                    block11: for (CompositeData metaData : folder) {
                        CompositeData[] listOfSharedFiles;
                        block28: {
                            String filePath = (String)metaData.get("fileName");
                            String fileName = WebSphereUtil.getLastName(filePath);
                            if ("jvm.options".equals(fileName) || "server.env".equals(fileName) || "bootstrap.properties".equals(fileName)) {
                                filesToDownload.add(filePath);
                                continue;
                            }
                            if ("configDropins".equals(fileName)) {
                                CompositeData[] listOfConfigDropins;
                                block27: {
                                    listOfConfigDropins = null;
                                    try {
                                        listOfConfigDropins = jmxConnection.getDirectoryEntries(filePath, true, "");
                                    }
                                    catch (Exception e) {
                                        if (!Trace.ENABLED) break block27;
                                        Trace.logError("Error getting the file list for remote server configDropins directory", e);
                                    }
                                }
                                if (listOfConfigDropins == null) continue;
                                for (CompositeData dropinData : listOfConfigDropins) {
                                    String dropinPath = (String)dropinData.get("fileName");
                                    String[] splitPath = dropinPath.split("/");
                                    String dropinName = splitPath[splitPath.length - 1];
                                    if (dropinName == null || dropinName.isEmpty() || splitPath.length < 2) continue;
                                    String dropinFolder = splitPath[splitPath.length - 2];
                                    if (!dropinName.endsWith(".xml") && !dropinName.equals("jvm.options") || !"defaults".equals(dropinFolder) && !"overrides".equals(dropinFolder)) continue;
                                    filesToDownload.add(dropinPath);
                                }
                                continue;
                            }
                            if (!"shared".equals(fileName)) continue;
                            listOfSharedFiles = null;
                            try {
                                listOfSharedFiles = jmxConnection.getDirectoryEntries(filePath, false, "");
                            }
                            catch (Exception e) {
                                if (!Trace.ENABLED) break block28;
                                Trace.logError("Error getting the file list for remote server shared directory", e);
                            }
                        }
                        if (listOfSharedFiles == null) continue;
                        for (CompositeData sharedData : listOfSharedFiles) {
                            String sharedDataPath = (String)sharedData.get("fileName");
                            if (!sharedDataPath.contains("jvm.options")) continue;
                            filesToDownload.add(sharedDataPath);
                            continue block11;
                        }
                    }
                }
            }
            ArrayList<IPath> downloadedIncludeFiles = new ArrayList<IPath>();
            IPath downloadToPath = null;
            for (String string : filesToDownload) {
                downloadToPath = RemoteUtils.resolveAndDownload(string, jmxConnection, userMetaDataPath, remoteUserPath, userDir);
                if (downloadToPath == null) continue;
                downloadedFiles.add(downloadToPath);
            }
            while (!includeFiles.isEmpty()) {
                for (IncludeFile includeFile : includeFiles) {
                    try {
                        downloadToPath = RemoteUtils.resolveAndDownload(includeFile.filepath, jmxConnection, userServersDir, remoteUserPath, userDir);
                        if (downloadToPath == null) continue;
                        if (!downloadedIncludeFiles.contains(downloadToPath)) {
                            downloadedIncludeFiles.add(downloadToPath);
                        }
                        if (downloadedFiles.contains(downloadToPath)) continue;
                        downloadedFiles.add(downloadToPath);
                    }
                    catch (Exception e) {
                        if (includeFile.optional) {
                            if (!Trace.ENABLED) continue;
                            Trace.trace((byte)0, "Download of file " + includeFile.filepath + " was skipped because the optional include was not found.");
                            continue;
                        }
                        throw e;
                    }
                }
                includeFiles.clear();
                for (IPath iPath : downloadedIncludeFiles) {
                    List<IncludeFile> locationList = RemoteUtils.getIncludeFiles(iPath);
                    if (locationList == null) continue;
                    includeFiles.addAll(locationList);
                }
                downloadedIncludeFiles.clear();
            }
        }
        catch (Exception e) {
            Trace.logError(Messages.remoteServerDownloadFailed, e);
            return new Status(4, "com.ibm.ws.st.core", Messages.remoteServerDownloadFailed, (Throwable)e);
        }
        return downloadStatus;
    }

    private static List<IncludeFile> getIncludeFiles(IPath file) {
        if (file == null) {
            return null;
        }
        Element includeElement = null;
        Element element = null;
        ArrayList<IncludeFile> location = new ArrayList<IncludeFile>();
        Document doc = ConfigUtils.getDOMFromFile(file.toFile());
        if (doc == null) {
            return null;
        }
        element = doc.getDocumentElement();
        if (element == null) {
            return null;
        }
        includeElement = DOMUtils.getFirstChildElement(element, "include");
        if (includeElement != null) {
            Element current = includeElement;
            while (current != null) {
                String path = DOMUtils.getAttributeValue(current, "location");
                String optional = DOMUtils.getAttributeValue(current, "optional");
                boolean isOptional = optional == null ? false : Boolean.parseBoolean(optional);
                location.add(new IncludeFile(path, isOptional));
                current = DOMUtils.getNextElement(current, "include");
            }
        }
        return location;
    }

    private static IPath resolveAndDownload(String file, JMXConnection jmxConnection, IPath userServersPath, String remoteUserPath, String userDir) throws Exception {
        if (jmxConnection == null || file == null) {
            return null;
        }
        String resolvedPath = RemoteUtils.resolveRemotePath(file, jmxConnection, userServersPath, remoteUserPath, userDir);
        if (resolvedPath == null) {
            return null;
        }
        RemoteUtils.downloadRemoteFile(resolvedPath, jmxConnection, remoteUserPath, userDir);
        return new Path(resolvedPath);
    }

    private static String resolveRemotePath(String file, JMXConnection jmxConnection, IPath userServersPath, String remoteUserPath, String userDir) throws Exception {
        if (jmxConnection == null || file == null) {
            return null;
        }
        String filePath = null;
        String resolvedPath = null;
        CompositeData metadata = null;
        if (ConfigVarsUtils.containsReference(file)) {
            try {
                metadata = (CompositeData)jmxConnection.getMetadata(file, "a");
                resolvedPath = RemoteUtils.resolveRemotePath((String)metadata.get("fileName"), jmxConnection, userServersPath, remoteUserPath, userDir);
            }
            catch (Exception e) {
                Trace.logError("Unable to resolve variable: " + file, e);
                throw new Exception(e);
            }
        } else if (FileUtil.isAbsolutePath(file)) {
            filePath = file.replace("\\", "/");
            if (filePath.startsWith(remoteUserPath)) {
                resolvedPath = filePath.replace(remoteUserPath, userDir);
            }
        } else if (!new File(file).isAbsolute()) {
            if (file.contains("/") || file.startsWith("../")) {
                URI base = userServersPath.toFile().toURI();
                URI resolvedURI = base.resolve(file);
                resolvedPath = new File(resolvedURI.getPath()).toString();
            } else if (new Path(file).segmentCount() == 1) {
                resolvedPath = userServersPath.append(file).toOSString();
            }
        }
        return resolvedPath;
    }

    private static void downloadRemoteFile(String resolvedPath, JMXConnection jmxConnection, String remoteUserPath, String userDir) throws Exception {
        Path downloadTo = new Path(resolvedPath);
        String remoteDownloadPath = null;
        String key = resolvedPath.replace("\\", "/");
        String userDirResolved = userDir.replace("\\", "/");
        if (!downloadTo.removeLastSegments(1).toFile().exists()) {
            FileUtil.makeDir(downloadTo.removeLastSegments(1));
        }
        if (key.startsWith(userDirResolved)) {
            remoteDownloadPath = key.replace(userDirResolved, remoteUserPath);
        }
        jmxConnection.downloadFile(remoteDownloadPath, key);
    }

    public static void moveDownloadedFilesToUserDir(UserDirectory userDir, ArrayList<IPath> downloadedFiles, WebSphereRuntime wsRuntime, String serverName) throws CoreException {
        String metadataPath = wsRuntime.getRemoteUsrMetadataPath().toOSString();
        String workspace = userDir.getProject().getLocation().toOSString();
        try {
            userDir.getProject().getLocation().append("servers").append(serverName).toFile().mkdirs();
            for (IPath aFile : downloadedFiles) {
                String fromPath = aFile.toOSString();
                Path toPath = new Path(fromPath.replace(metadataPath, workspace));
                if (!toPath.removeLastSegments(1).toFile().exists()) {
                    FileUtil.makeDir(toPath.removeLastSegments(1));
                }
                FileUtil.move(aFile, (IPath)toPath);
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.failedCreateDefaultUserDir, (Object)userDir.getPath()), (Throwable)e));
        }
    }

    public static void discardTemporaryFiles(List<IPath> downloadedFiles, WebSphereRuntime wsRuntime, String serverName) {
        for (IPath file : downloadedFiles) {
            file.toFile().delete();
        }
        downloadedFiles.clear();
        IPath usrDir = RemoteUtils.getMetadataPath(wsRuntime, serverName);
        if (usrDir != null && usrDir.toFile().exists()) {
            try {
                FileUtil.deleteDirectory(usrDir.toOSString(), true);
            }
            catch (IOException e) {
                Trace.logError("Failed to clean up remote server temp files", e);
            }
        }
    }

    public static IPath getMetadataPath(WebSphereRuntime runtime, String serverName) {
        return runtime.getRemoteUsrMetadataPath().append("servers").append(serverName);
    }

    public static IPlatformHandler getPlatformHandler(WebSphereServer server) throws UnsupportedServiceException {
        PlatformHandlerFactory.PlatformType type = null;
        if (server.getServerType().equalsIgnoreCase("LibertyDocker")) {
            type = PlatformHandlerFactory.PlatformType.DOCKER;
        } else if (server.getServerType().equalsIgnoreCase("WASLibertyCorePlan")) {
            type = PlatformHandlerFactory.PlatformType.SSH_KEYLESS;
        } else {
            return null;
        }
        return PlatformHandlerFactory.getPlatformHandler(server.getServiceInfo(), (PlatformHandlerFactory.PlatformType)type);
    }

    public static IPath getRemoteLogDirectory(WebSphereServer server) throws UnsupportedServiceException, ConnectException, IOException {
        Path remoteLogPath = null;
        String defaultRemotePath = null;
        String logDir = null;
        if (!server.isLocalSetup()) {
            IPlatformHandler handler;
            logDir = server.getConfiguration().getLogDirectoryAttribute();
            if (logDir != null && !logDir.isEmpty()) {
                return RemoteUtils.resolveRemoteLogVariable(server, logDir);
            }
            Bootstrap bootstrap = server.getBootstrap();
            if (bootstrap != null && (logDir = bootstrap.getLogDir()) != null) {
                return RemoteUtils.resolveRemoteLogVariable(server, logDir);
            }
            ServerEnv env = (ServerEnv)server.getServerInfo().getServerEnv();
            if (env != null) {
                ConfigVars v = new ConfigVars();
                env.getVariables(v);
                logDir = v.getValue("env.LOG_DIR");
                if (logDir != null) {
                    return RemoteUtils.resolveRemoteLogVariable(server, logDir);
                }
                logDir = v.getValue("env.WLP_OUTPUT_DIR");
                if (logDir != null) {
                    return RemoteUtils.resolveRemoteLogVariable(server, logDir);
                }
            }
            if ((handler = RemoteUtils.getPlatformHandler(server)) != null && handler instanceof BaseDockerContainer) {
                logDir = handler.getEnvValue("LOG_DIR");
                if (logDir != null) {
                    return new Path(logDir);
                }
                logDir = handler.getEnvValue("WLP_OUTPUT_DIR");
                if (logDir != null) {
                    return new Path(logDir);
                }
            }
            if ((defaultRemotePath = server.getDefaultRemoteLogDirectory()) == null) {
                return null;
            }
            remoteLogPath = new Path(defaultRemotePath);
        }
        return remoteLogPath;
    }

    public static IPath resolveRemoteLogVariable(WebSphereServer server, String logdir) {
        IPath result;
        if (logdir != null && ConfigVarsUtils.containsReference(logdir) && (result = RemoteUtils.resolveRemoteConfigPath(server, logdir)) != null) {
            return result.removeLastSegments(1);
        }
        return new Path(logdir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IPath resolveRemoteConfigPath(WebSphereServer server, String remoteLog) {
        String filename = server.getServerInfo().getMessageFileName();
        String defaultRemotePath = null;
        JMXConnection jmx = null;
        Path path = null;
        try {
            jmx = server.createJMXConnection();
            defaultRemotePath = server.getWebSphereServerBehaviour().resolveConfigVar(remoteLog, jmx);
            path = new Path(defaultRemotePath);
            IPath iPath = path.append(filename);
            return iPath;
        }
        catch (Exception e) {
            Trace.logError("getMessagesFile :Connection to Remote Server failed", e);
            IPath iPath = null;
            return iPath;
        }
        finally {
            if (jmx != null) {
                jmx.disconnect();
            }
        }
    }

    public static void copyRemoteInfoToServiceInfo(RemoteServerInfo remoteInfo, Map<String, String> serviceInfo) {
        String osName;
        int os = remoteInfo.getIntegerValue("remoteStart_Platform", 0);
        switch (os) {
            case 0: {
                osName = "win";
                break;
            }
            case 3: {
                osName = "mac";
                break;
            }
            case 1: {
                osName = "linux";
                break;
            }
            case 2: {
                osName = "other";
                break;
            }
            default: {
                osName = "linux";
            }
        }
        serviceInfo.put("osName", osName);
        serviceInfo.put("debugPort", remoteInfo.getStringValue("remoteStart_debugPort"));
        int method = remoteInfo.getIntegerValue("remoteStart_LogonMethod", 0);
        if (method == 0) {
            serviceInfo.put("logonMethod", "logonMethodOS");
            serviceInfo.put("osUser", remoteInfo.getStringValue("remoteStart_OSId"));
            serviceInfo.put("osPassword", remoteInfo.getStringValue("remoteStart_OSPassword"));
        } else {
            serviceInfo.put("logonMethod", "logonMethodSSH");
            serviceInfo.put("sshKey", remoteInfo.getStringValue("remoteStart_SSHKeyFile"));
            serviceInfo.put("osUser", remoteInfo.getStringValue("remoteStart_SSHId"));
            serviceInfo.put("osPassword", remoteInfo.getStringValue("remoteStart_SSHPassphrase"));
        }
    }

    static class IncludeFile {
        String filepath;
        boolean optional;

        public IncludeFile(String path, boolean optional) {
            this.filepath = path;
            this.optional = optional;
        }
    }
}

