/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.remote;

import com.ibm.ws.st.common.core.ext.internal.Constants;
import com.ibm.ws.st.common.core.ext.internal.producer.AbstractServerProducer;
import com.ibm.ws.st.common.core.ext.internal.producer.ServerCreationException;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.jmx.JMXConnectionException;
import com.ibm.ws.st.core.internal.remote.RemoteUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class LibertyRemoteServerProducer
extends AbstractServerProducer {
    public IServer createServer(IRuntime rt, Map<String, String> serverInfo) throws ServerCreationException {
        IServer[] servers;
        if (rt == null) {
            throw new ServerCreationException(Messages.libertyProducerRuntimeNull);
        }
        this.validateServerInfo(serverInfo);
        IServer server = null;
        ArrayList<IPath> downloadedFiles = new ArrayList<IPath>(2);
        String hostname = serverInfo.get("hostname");
        String serverLabel = serverInfo.get("serverLabel");
        String libertyUser = serverInfo.get("libertyUser");
        String libertyPassword = serverInfo.get("libertyPassword");
        String libertyHTTPSPort = serverInfo.get("libertyHttpsPort");
        String debugPort = serverInfo.get("debugPort");
        String serverConfigDir = serverInfo.get("libertyServerConfigPath");
        serverConfigDir = serverConfigDir.replace("\\", "/");
        String serverName = serverConfigDir.substring(serverConfigDir.lastIndexOf(47) + 1, serverConfigDir.length());
        String installPath = serverInfo.get("LibertyRuntimeInstallPath");
        for (IServer sr : servers = ServerCore.getServers()) {
            if (!sr.getId().equals(serverName)) continue;
            throw new ServerCreationException(NLS.bind((String)Messages.libertyProducerServerExists, (Object)serverName));
        }
        JMXConnection jmxConnection = new JMXConnection(hostname, libertyHTTPSPort, libertyUser, libertyPassword);
        try {
            jmxConnection.connect();
        }
        catch (JMXConnectionException e) {
            throw new ServerCreationException(Messages.remoteJMXConnectionFailure, (Throwable)e);
        }
        try {
            boolean isLC = false;
            CompositeData userDirMetadata = (CompositeData)jmxConnection.getMetadata("${wlp.user.dir}", "a");
            String remoteUserPath = (String)userDirMetadata.get("fileName");
            remoteUserPath = remoteUserPath.replace("\\", "/");
            WebSphereRuntime wrt = (WebSphereRuntime)rt.loadAdapter(WebSphereRuntime.class, null);
            IRuntimeWorkingCopy runtimeWorkingCopy = rt.createWorkingCopy();
            WebSphereRuntime wRuntimeWorkingCopy = (WebSphereRuntime)runtimeWorkingCopy.loadAdapter(WebSphereRuntime.class, null);
            wRuntimeWorkingCopy.createDefaultUserDirectory(null);
            IProject remoteUsrProject = WebSphereUtil.createUserProject(RemoteUtils.generateRemoteUsrDirName(wrt), null, null);
            IPath outputPath = remoteUsrProject.getLocation().append("servers");
            UserDirectory userDir = new UserDirectory(wrt, remoteUsrProject.getLocation(), remoteUsrProject, outputPath, (IPath)new Path(remoteUserPath));
            String localUserPath = wrt.getRemoteUsrMetadataPath().toOSString().replace("\\", "/");
            IPath userMetaDataPath = wrt.getRemoteUsrMetadataPath();
            RemoteUtils.downloadServerFiles(jmxConnection, userMetaDataPath, serverName, downloadedFiles, remoteUserPath, localUserPath);
            RemoteUtils.moveDownloadedFilesToUserDir(userDir, downloadedFiles, wrt, serverName);
            String serverTypeId = rt.getId().endsWith(".v85.was") ? "com.ibm.ws.st.server.v85.was" : "com.ibm.ws.st.server.wlp";
            IServerType st = ServerCore.findServerType((String)serverTypeId);
            IServerWorkingCopy wc = st.createServer(hostname, null, rt, null);
            wc.setHost(hostname);
            wc.setName(serverLabel);
            boolean isRemoteServerStartEnabled = true;
            String osUser = serverInfo.get("osUser");
            String osPassword = serverInfo.get("osPassword");
            String sshKeyFile = serverInfo.get("sshKey");
            WebSphereServer wsServer = (WebSphereServer)((Object)wc.loadAdapter(WebSphereServer.class, null));
            wsServer.setDefaults((IProgressMonitor)new NullProgressMonitor());
            wsServer.setServerName(serverName);
            wsServer.setUserDir(userDir);
            wsServer.setLooseConfigEnabled(isLC);
            wsServer.setStopTimeout(60);
            wsServer.setServerUserName(libertyUser);
            wsServer.setServerPassword(libertyPassword);
            wsServer.setServerSecurePort(libertyHTTPSPort);
            if (isRemoteServerStartEnabled) {
                wsServer.setIsRemoteServerStartEnabled(isRemoteServerStartEnabled);
                int platform = serverInfo.get("osName").contains("windows") ? 0 : 2;
                wsServer.setRemoteServerStartPlatform(platform);
                wsServer.setRemoteServerStartRuntimePath(installPath.replace("\\", "/"));
                wsServer.setRemoteServerStartConfigPath(serverConfigDir.replace("\\", "/"));
                int logonMethod = sshKeyFile == null ? 0 : 1;
                wsServer.setRemoteServerStartLogonMethod(logonMethod);
                wsServer.setRemoteServerStartOSId(osUser);
                wsServer.setRemoteServerStartOSPassword(osPassword);
                if (sshKeyFile != null) {
                    wsServer.setRemoteServerStartSSHKeyFile(sshKeyFile.replace("\\", "/"));
                }
                wsServer.setRemoteServerStartDebugPort(debugPort);
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Create remote server with looseConfig: " + wsServer.isLooseConfigEnabled());
            }
            if ((wsServer = (WebSphereServer)((Object)(server = wc.save(true, null)).loadAdapter(WebSphereServer.class, null))).getServerInfo() == null) {
                boolean found = false;
                for (UserDirectory usr : wRuntimeWorkingCopy.getUserDirectories()) {
                    if (!usr.getPath().equals((Object)userDir.getPath())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    wRuntimeWorkingCopy.addUserDirectory(userDir);
                }
                runtimeWorkingCopy.save(true, null);
            }
            WebSphereRuntime wsRuntime = (WebSphereRuntime)rt.loadAdapter(WebSphereRuntime.class, null);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "updating server cache");
            }
            wsRuntime.updateServerCache(true);
            wsServer.getServerInfo().updateCache();
        }
        catch (Exception e) {
            throw new ServerCreationException("Failed to create server.", (Throwable)e);
        }
        return server;
    }

    public boolean validateServerInfo(Map<String, String> serverInfo) throws ServerCreationException {
        Set<String> keys = serverInfo.keySet();
        for (String key : Constants.LIBERTY_VALIDATION_KEYS) {
            if (keys.contains(key)) continue;
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Missing server info: " + key);
            }
            throw new ServerCreationException(NLS.bind((String)Messages.libertyProducerMissingInfo, (Object)key));
        }
        return keys.size() > 0;
    }
}

