/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.looseconfig;

import com.ibm.ws.st.core.internal.Trace;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectInfoHandler
extends DefaultHandler {
    private static final String LINKED_RESOURCES = "linkedResources";
    private static final String LINK = "link";
    private static final String NAME = "name";
    private final IProject project;
    private final List<IResource> linkedResources;
    private State currentState = State.DESCRIPTION;
    private StringBuilder chars = null;

    public ProjectInfoHandler(IProject project, List<IResource> linkedResources) {
        this.project = project;
        this.linkedResources = linkedResources;
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) {
        if (qname.equals(LINKED_RESOURCES)) {
            this.currentState = State.LINKED_RESOURCES;
        } else if (this.currentState == State.LINKED_RESOURCES && qname.equals(LINK)) {
            this.currentState = State.LINK;
        } else if (this.currentState == State.LINK && qname.equals(NAME)) {
            this.chars = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if (this.currentState == State.LINK) {
            if (qname.equals(NAME) && this.chars != null) {
                String name = this.chars.toString().trim();
                IResource resource = this.project.findMember((IPath)new Path(name));
                if (resource != null) {
                    this.linkedResources.add(resource);
                }
            } else if (qname.equals(LINK)) {
                this.currentState = State.LINKED_RESOURCES;
            }
        } else if (qname.equals(LINKED_RESOURCES)) {
            this.currentState = State.DESCRIPTION;
        }
        this.chars = null;
    }

    @Override
    public void characters(char[] c, int start, int length) {
        if (this.chars != null) {
            this.chars.append(c, start, length);
        }
    }

    static List<IResource> parseProject(IProject project) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        IFile file = project.getFile(".project");
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ProjectInfoHandler handler = new ProjectInfoHandler(project, list);
            parser.parse(file.getContents(), (DefaultHandler)handler);
        }
        catch (Exception e) {
            Trace.logError("Failed to read the project info: " + file.getLocation(), e);
        }
        return list;
    }

    private static enum State {
        DESCRIPTION,
        LINKED_RESOURCES,
        LINK;

    }
}

