/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.launch.IUtilityExecutionDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;

public class RemoteStopServer {
    int timeout;
    IUtilityExecutionDelegate execDelegate = null;
    String serverName = null;

    public RemoteStopServer(int timeout, IUtilityExecutionDelegate helper) {
        this.timeout = timeout;
        this.execDelegate = helper;
    }

    protected String getCommand() {
        StringBuilder command = new StringBuilder();
        command.append(this.execDelegate.getServerScriptFilePath());
        command.append(" stop " + this.serverName);
        return command.toString();
    }

    int getTimeout() {
        return this.timeout;
    }

    public void execute(WebSphereServer server, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)"Executing stop remote server command");
        }
        try {
            this.serverName = server.getServerName();
            this.execDelegate.initialize(server.getServer(), monitor);
            this.execDelegate.startExecution();
            this.execDelegate.execute(server, launch.getLaunchMode(), launch, this.getCommand(), NLS.bind((String)Messages.taskStopServer, (Object)this.serverName), this.getTimeout(), monitor, true);
        }
        catch (CoreException ce) {
            Trace.logError((String)"RemoteStop failed", (Throwable)ce);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", ce.getLocalizedMessage()));
        }
        finally {
            this.execDelegate.endExecution();
        }
    }
}

