/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.launch.IUtilityExecutionDelegate;
import com.ibm.ws.st.core.internal.launch.LibertyRemoteUtilityExecutionDelegate;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;

public class RemotePackageServer {
    int timeout;
    String zipFilePath;
    String include;
    IUtilityExecutionDelegate executionDelegate = null;
    String serverName = null;

    public RemotePackageServer(Map<String, String> commandVariables, int timeout, IUtilityExecutionDelegate helper) {
        this.timeout = timeout;
        this.executionDelegate = helper;
        if (commandVariables != null && !commandVariables.isEmpty()) {
            this.zipFilePath = commandVariables.get("--archive=");
            this.include = commandVariables.get("--include=");
        }
    }

    public void execute(WebSphereServer server, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)"Executing remote package server command");
        }
        try {
            this.serverName = server.getServerName();
            this.executionDelegate.initialize(server.getServer(), monitor);
            this.executionDelegate.startExecution();
            this.executionDelegate.execute(server, launch.getLaunchMode(), launch, this.getCommand(), NLS.bind((String)Messages.taskPackageServer, (Object)this.serverName), this.getTimeout(), monitor, true);
            if (!this.executionDelegate.isDockerExecutionDelegate()) {
                this.waitForCommandToFinish();
            }
            if (monitor.isCanceled()) {
                return;
            }
            this.downloadPackageServerFile((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            monitor.done();
        }
        catch (CoreException ce) {
            Trace.logError((String)"PackageServer Utility failed", (Throwable)ce);
            if (ce.getLocalizedMessage() == null) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServer_ErrorUtilityAction));
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServer_ErrorUtilityAction, (Throwable)ce));
        }
        finally {
            this.executionDelegate.endExecution();
        }
    }

    int getTimeout() {
        return this.timeout;
    }

    protected String getCommand() {
        StringBuilder command = new StringBuilder();
        command.append(this.executionDelegate.getServerScriptFilePath());
        command.append("package " + this.serverName);
        if (this.getDefaultServerPackageName() != null) {
            command.append(" --archive=" + this.getDefaultServerPackageName());
        }
        if (this.include != null) {
            command.append(" --include=" + this.include);
        }
        return command.toString();
    }

    private void waitForCommandToFinish() throws CoreException {
        this.getRemoteUtilityConfigDelegate().checkFileStatus(this.getDefaultServerPackageName(), true);
    }

    public void downloadPackageServerFile(IProgressMonitor monitor) throws CoreException {
        this.executionDelegate.downloadFile(this.getDefaultServerPackageName(), this.zipFilePath, monitor);
    }

    private IPath getDefaultServerPackageName() {
        if (this.executionDelegate.getRemoteUserDir() == null) {
            return null;
        }
        return this.executionDelegate.getRemoteUserDir().append(this.serverName).addFileExtension("zip");
    }

    private LibertyRemoteUtilityExecutionDelegate getRemoteUtilityConfigDelegate() {
        return (LibertyRemoteUtilityExecutionDelegate)this.executionDelegate;
    }
}

