/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.launch.IUtilityExecutionDelegate;
import com.ibm.ws.st.core.internal.launch.LibertyRemoteUtilityExecutionDelegate;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;

public class RemoteCreateSSLCertificate {
    int timeout;
    private String password = null;
    private String passwordEncoding = null;
    private String passwordKey = null;
    private String subject = null;
    private String includeFileName = null;
    private int validity = 0;
    boolean cleanTempFiles = false;
    String remoteKeyFilePath;
    IPath remoteSSLIncludeFilePath;
    IPath localSSLIncludeFilePath;
    IPath remoteKeystoreFile;
    IPath localKeystoreFile;
    IUtilityExecutionDelegate executionDelegate = null;
    private String serverName = null;
    private final String EXPECTED_SYS_OUT = "Created SSL certificate";

    public RemoteCreateSSLCertificate(Map<String, String> commandVariables, int timeout, IUtilityExecutionDelegate helper) {
        this.timeout = timeout;
        this.executionDelegate = helper;
        if (commandVariables != null && !commandVariables.isEmpty()) {
            this.password = commandVariables.get("--password=");
            String tempString = commandVariables.get("--passwordEncoding=");
            if (tempString != null && !tempString.isEmpty()) {
                this.passwordEncoding = tempString;
            }
            if ((tempString = commandVariables.get("--passwordKey=")) != null && !tempString.isEmpty()) {
                this.passwordKey = tempString;
            }
            if ((tempString = commandVariables.get("--createConfigFile=")) != null && !tempString.isEmpty()) {
                this.includeFileName = tempString;
            }
            if ((tempString = commandVariables.get("--validity=")) != null && !tempString.isEmpty() && Integer.parseInt(tempString) > 0) {
                this.validity = Integer.parseInt(tempString);
            }
            if ((tempString = commandVariables.get("--subject=")) != null && !tempString.isEmpty()) {
                this.subject = tempString;
            }
        }
    }

    public void execute(WebSphereServer server, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)"Executing create SSL certificate command for remote server");
        }
        try {
            this.serverName = server.getServerName();
            this.executionDelegate.initialize(server.getServer(), monitor);
            this.executionDelegate.startExecution();
            this.preExecute(server.getServer(), monitor);
            IPlatformHandler.ExecutionOutput result = this.executionDelegate.execute(server, launchMode, launch, this.getCommand(), NLS.bind((String)Messages.taskCreateSSLCertificate, (Object)this.serverName), this.getTimeout(), monitor, true);
            if (!this.executionDelegate.isExecutionSuccessful(result, "Created SSL certificate")) {
                Trace.logError((String)("Remote command failed: " + this.getCommand() + ", exit value: " + result.getReturnCode() + ", output: " + result.getOutput() + ", error: " + result.getError()), null);
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", result.getError()));
            }
            this.postExecute(monitor);
            monitor.done();
        }
        catch (CoreException ce) {
            Trace.logError((String)"Exception occured in RemoteCreateSSLCertificate", (Throwable)ce);
            try {
                if (this.cleanTempFiles) {
                    this.restoreTempFiles();
                } else {
                    this.discardTemporaryFiles();
                }
            }
            catch (Exception e) {
                Trace.logError((String)"Cleanup action failed", (Throwable)e);
            }
            if (ce.getLocalizedMessage() == null) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServer_ErrorUtilityAction));
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServer_ErrorUtilityAction, (Throwable)ce));
        }
        catch (Exception e) {
            Trace.logError((String)"CreateSSLCertificate utility failed", (Throwable)e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.E_RemoteServer_ErrorUtilityAction));
        }
        finally {
            this.executionDelegate.endExecution();
        }
    }

    int getTimeout() {
        return this.timeout;
    }

    protected String getCommand() {
        StringBuilder command = new StringBuilder();
        command.append(this.executionDelegate.getServerSecurityUtilityFilePath());
        command.append("createSSLCertificate ");
        command.append("--server=" + this.serverName + " ");
        command.append("--password=" + this.password);
        if (this.passwordEncoding != null) {
            command.append(" --passwordEncoding=" + this.passwordEncoding);
        }
        if (this.passwordKey != null) {
            command.append(" --passwordKey=" + this.passwordKey + " ");
        }
        if (this.includeFileName != null) {
            command.append(" --createConfigFile=" + this.executionDelegate.getRemoteUserDir().append(this.includeFileName));
        }
        if (this.validity > 0) {
            command.append(" --validity=" + this.validity + " ");
        }
        if (this.subject != null) {
            command.append(" --subject=" + this.subject);
        }
        return command.toString();
    }

    private void preExecute(IServer server, IProgressMonitor monitor) throws Exception {
        this.executionDelegate.initialize(server, monitor);
        this.remoteKeyFilePath = this.executionDelegate.getOSString(this.executionDelegate.getRemoteOutputDir().append("resources").append("security").append("key.jks").toString());
        this.remoteSSLIncludeFilePath = this.executionDelegate.getRemoteUserDir().append("GeneratedSSLInclude").addFileExtension("xml");
        this.remoteKeystoreFile = this.executionDelegate.getRemoteUserDir().append("configDropins").append("defaults").append("keystore").addFileExtension("xml");
        this.localKeystoreFile = this.executionDelegate.getLocalUserDir().append("configDropins").append("defaults").append("keystore").addFileExtension("xml");
        this.localSSLIncludeFilePath = this.executionDelegate.getLocalUserDir().append("GeneratedSSLInclude.xml");
        this.createTempFiles();
    }

    private void postExecute(IProgressMonitor monitor) throws Exception {
        this.cleanTempFiles = false;
        if (!this.executionDelegate.isDockerExecutionDelegate()) {
            this.waitForCommandToFinish();
        }
        if (this.executionDelegate.fileExists(this.executionDelegate.getOSString(this.remoteSSLIncludeFilePath.toString()))) {
            this.executionDelegate.downloadFile(this.remoteSSLIncludeFilePath, this.executionDelegate.getLocalUserDir().append("GeneratedSSLInclude.xml").toString(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (!this.executionDelegate.isDockerExecutionDelegate()) {
                this.updateSyncConfigInfo();
            }
            if (!this.executionDelegate.matchPasswordField(this.localSSLIncludeFilePath, this.password)) {
                this.executionDelegate.uploadFile(this.localSSLIncludeFilePath.toOSString(), this.executionDelegate.getOSString(this.remoteSSLIncludeFilePath.toString()));
                if (!this.executionDelegate.isDockerExecutionDelegate()) {
                    this.updateSyncConfigInfo();
                }
            }
            this.executionDelegate.modifyConfigFile(this.includeFileName);
            this.discardTemporaryFiles();
        } else {
            this.restoreTempFiles();
        }
    }

    private void createTempFiles() throws Exception {
        this.cleanTempFiles = true;
        String remoteKeystoreFilePath = this.executionDelegate.getOSString(this.remoteKeystoreFile.toOSString());
        String remoteSSLIncludeFile = this.executionDelegate.getOSString(this.remoteSSLIncludeFilePath.toString());
        if (this.executionDelegate.fileExists(remoteKeystoreFilePath)) {
            this.executionDelegate.renameFile(remoteKeystoreFilePath, remoteKeystoreFilePath + ".tmp");
        }
        if (this.localKeystoreFile.toFile().exists()) {
            this.localKeystoreFile.toFile().renameTo(new File(this.localKeystoreFile.toFile().getAbsolutePath() + ".tmp"));
        }
        if (this.executionDelegate.fileExists(this.remoteKeyFilePath)) {
            this.executionDelegate.renameFile(this.remoteKeyFilePath, this.remoteKeyFilePath + ".tmp");
        }
        if (this.executionDelegate.fileExists(remoteSSLIncludeFile)) {
            this.executionDelegate.renameFile(remoteSSLIncludeFile, remoteSSLIncludeFile + ".tmp");
        }
        if (this.localSSLIncludeFilePath.toFile().exists()) {
            this.localSSLIncludeFilePath.toFile().renameTo(new File(this.localSSLIncludeFilePath.toFile().getAbsolutePath() + ".tmp"));
        }
    }

    private void waitForCommandToFinish() throws CoreException {
        LibertyRemoteUtilityExecutionDelegate delegate = (LibertyRemoteUtilityExecutionDelegate)this.executionDelegate;
        delegate.checkFileStatus(this.executionDelegate.getRemoteUserDir().append(this.includeFileName), false);
    }

    private void discardTemporaryFiles() throws Exception {
        String remoteTempKeyFilePath = this.executionDelegate.getOSString(this.remoteKeyFilePath + ".tmp");
        String remoteTempKeystoreFilePath = this.executionDelegate.getOSString(this.remoteKeystoreFile + ".tmp");
        IPath localTempSSLIncludeFilePath = this.executionDelegate.getLocalUserDir().append("GeneratedSSLInclude.xml.tmp");
        String remoteTempSSLIncludeFilePath = this.executionDelegate.getOSString(this.remoteSSLIncludeFilePath + ".tmp");
        IPath localTempKeystoreFile = this.executionDelegate.getLocalUserDir().append("configDropins").append("defaults").append("keystore").addFileExtension("xml.tmp");
        if (this.executionDelegate.fileExists(remoteTempKeystoreFilePath)) {
            this.executionDelegate.deleteFile(remoteTempKeystoreFilePath, false, false);
        }
        if (this.executionDelegate.fileExists(remoteTempKeyFilePath)) {
            this.executionDelegate.deleteFile(remoteTempKeyFilePath, false, false);
        }
        if (this.executionDelegate.fileExists(remoteTempSSLIncludeFilePath)) {
            this.executionDelegate.deleteFile(remoteTempSSLIncludeFilePath, false, false);
        }
        if (localTempSSLIncludeFilePath.toFile().exists()) {
            localTempSSLIncludeFilePath.toFile().delete();
        }
        if (localTempKeystoreFile.toFile().exists()) {
            localTempKeystoreFile.toFile().delete();
        }
    }

    private void restoreTempFiles() throws Exception {
        File localKeystore = new File(this.localKeystoreFile.toOSString() + ".tmp");
        File localSSLIncludetemp = new File(this.localSSLIncludeFilePath.toOSString() + ".tmp");
        String remoteTempKeystoreFilePath = this.executionDelegate.getOSString(this.remoteKeystoreFile.toString());
        String remoteTempSSLInclude = this.executionDelegate.getOSString(this.remoteSSLIncludeFilePath.toString());
        if (this.executionDelegate.fileExists(this.remoteKeyFilePath + ".tmp")) {
            this.executionDelegate.renameFile(this.remoteKeyFilePath + ".tmp", this.remoteKeyFilePath);
        }
        if (localSSLIncludetemp.exists()) {
            localSSLIncludetemp.renameTo(new File(this.localSSLIncludeFilePath.toOSString()));
        }
        if (localKeystore.exists()) {
            localKeystore.renameTo(new File(this.localKeystoreFile.toOSString()));
        }
        if (this.executionDelegate.fileExists(remoteTempSSLInclude + ".tmp")) {
            this.executionDelegate.renameFile(remoteTempSSLInclude + ".tmp", remoteTempSSLInclude);
        }
        if (this.executionDelegate.fileExists(remoteTempKeystoreFilePath + ".tmp")) {
            this.executionDelegate.renameFile(remoteTempKeystoreFilePath + ".tmp", remoteTempKeystoreFilePath);
        }
    }

    private void updateSyncConfigInfo() throws CoreException {
        LibertyRemoteUtilityExecutionDelegate delegate = (LibertyRemoteUtilityExecutionDelegate)this.executionDelegate;
        delegate.fillLocalConfigSyncInfo(this.localSSLIncludeFilePath.toOSString());
        delegate.fillRemoteConfigSyncInfo(this.remoteSSLIncludeFilePath.toOSString());
    }
}

