/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.util.IRemoteUtilityExecutionDelegate;
import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.launch.IUtilityExecutionDelegate;
import com.ibm.ws.st.core.internal.launch.LaunchUtilities;
import com.ibm.ws.st.core.internal.launch.ServerStartInfo;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LibertyRemoteUtilityExecutionDelegate
implements IUtilityExecutionDelegate {
    public static final String ATTR_SERVER_PROCESS_MODE = "serverProcessMode";
    protected WebSphereServer wsServer;
    protected WebSphereServerBehaviour wsBehaviour;
    protected String serverPath = null;
    protected IPath remoteUserDir = null;
    protected String serverName = null;
    protected String serverId = null;
    protected ILaunch launch = null;
    protected boolean isHotMethodReplaceEnabled;
    protected String launchMode;
    protected int logonMethod = 0;
    protected boolean isWindowsPlatform;
    protected String hostName = null;
    protected static final char sQUOTE = '\'';
    protected static final char dQUOTE = '\"';
    protected char SEP;
    private String id = null;
    private String password = null;
    private String sshKeyFile = null;
    private IRemoteUtilityExecutionDelegate remoteDelegate;
    protected String displayCommand = null;
    protected Properties remoteConfigSyncInfo = null;
    protected Properties localConfigSyncInfo = null;
    protected int amountOfWork = 5;

    @Override
    public void initialize(IServer server, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor monitor2;
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)"Start to execute.");
        }
        if ((monitor2 = monitor) == null) {
            monitor2 = new NullProgressMonitor();
        }
        monitor2.beginTask(NLS.bind((String)Messages.L_RemoteExecutingCommands, (Object)server.getName()), this.amountOfWork);
        monitor2.subTask(NLS.bind((String)Messages.L_RemoteExecutingCommands, (Object)server.getName()));
        this.wsServer = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, monitor2));
        this.wsBehaviour = (WebSphereServerBehaviour)((Object)server.loadAdapter(WebSphereServerBehaviour.class, monitor2));
        this.serverPath = this.wsServer.getRemoteServerStartRuntimePath();
        this.validateFields(this.serverPath, Messages.E_RemoteServer_ProfilePathInvalid);
        this.serverName = this.wsServer.getServerName();
        this.validateFields(this.serverName, Messages.E_RemoteServer_ServerNameInvalid);
        this.hostName = server.getHost();
        this.validateFields(this.hostName, Messages.E_RemoteServer_HostNameInvalid);
        this.serverId = server.getId();
        int tempI = this.wsServer.getRemoteServerStartPlatform();
        this.isWindowsPlatform = tempI == 0;
        this.logonMethod = this.wsServer.getRemoteServerStartLogonMethod();
        this.SEP = this.isWindowsPlatform && this.logonMethod == 0 ? (char)92 : (char)47;
        this.serverPath = this.ensureEndingPathSeparator(this.serverPath, this.SEP);
        this.remoteUserDir = new Path(this.wsServer.getRemoteServerStartConfigPath());
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("Server Path is: " + this.serverPath));
        }
        if (this.logonMethod == 0) {
            this.id = this.wsServer.getRemoteServerStartOSId();
            this.validateFields(this.id, Messages.E_RemoteServer_IDInvalid);
            this.password = this.wsServer.getRemoteServerStartOSPassword();
            this.validateFields(this.password, Messages.E_RemoteServer_passwordInvalid);
        } else {
            this.id = this.wsServer.getRemoteServerStartSSHId();
            this.password = this.wsServer.getRemoteServerStartSSHPassphrase();
            this.sshKeyFile = this.wsServer.getRemoteServerStartSSHKeyFile();
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("sshKeyFile: " + this.sshKeyFile));
            }
            this.validateFields(this.sshKeyFile, Messages.E_RemoteServer_sshKeyFileInvalid);
        }
        monitor2.worked(1);
        if (monitor2.isCanceled()) {
            return;
        }
        this.initRemoteExecutionDelegate(this.wsServer);
    }

    private void initRemoteExecutionDelegate(WebSphereServer wsServer) throws CoreException {
        IConfigurationElement[] cf;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        for (IConfigurationElement ce : cf = registry.getConfigurationElementsFor("com.ibm.ws.st.common.core.ext", "remoteExecutionDelegate")) {
            try {
                this.remoteDelegate = (IRemoteUtilityExecutionDelegate)ce.createExecutableExtension("class");
                this.remoteDelegate.init(this.logonMethod, this.id, this.password, this.hostName, this.isWindowsPlatform, this.sshKeyFile);
                return;
            }
            catch (CoreException e) {
                Trace.logError((String)"Error while creating executable extension for remote execution delegate", (Throwable)e);
            }
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.remoteActionsUnavailable));
    }

    @Override
    public IPlatformHandler.ExecutionOutput execute(WebSphereServer server, String launchMode, ILaunch launch, String execCmd, String jobName, long timeout, IProgressMonitor monitor, boolean run) throws CoreException {
        IProgressMonitor monitor2;
        this.launch = launch;
        this.launchMode = launchMode;
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("execute parameters. command=>" + execCmd + "< serverName=" + this.serverName + " serverId=" + this.serverId));
        }
        if ((monitor2 = monitor) == null) {
            monitor2 = new NullProgressMonitor();
        }
        int returnCode = 0;
        IPlatformHandler.ExecutionOutput result = null;
        try {
            String jvmArgs = this.getJVMArgs();
            HashMap<String, String> envMap = new HashMap<String, String>();
            if (this.serverPath != null) {
                envMap.put("WLP_INSTALL_DIR", this.serverPath);
            }
            if (this.remoteUserDir != null && this.remoteUserDir.segmentCount() > 2) {
                envMap.put("WLP_USER_DIR", this.remoteUserDir.removeLastSegments(2).toString());
            }
            if ("debug".equals(launchMode)) {
                String debugPort = this.wsServer.getRemoteServerStartDebugPort();
                envMap.put("WLP_DEBUG_REMOTE", "y");
                envMap.put("WLP_DEBUG_ADDRESS", debugPort);
            }
            result = !run ? this.remoteDelegate.execCommand(launch, execCmd, (int)timeout, jvmArgs, envMap, monitor2) : this.remoteDelegate.runCommand(execCmd, (int)timeout, jvmArgs, envMap, monitor2);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("Return code, from execution: " + returnCode));
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)"The process cannot be launched successfully.");
            }
        }
        catch (CoreException e) {
            Trace.logError((String)("An exception occured executing the command: " + execCmd), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Trace.logError((String)("An exception occured executing the command: " + execCmd), (Throwable)e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.W_RemoteServer_Problem, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
        if (result != null && result.getReturnCode() != 0) {
            Trace.logError((String)("Execution failed for the command: " + execCmd + ", with output: " + result.getOutput() + ", and error: " + result.getError()), null);
            String msg = result.getError() != null && !result.getError().isEmpty() ? NLS.bind((String)Messages.W_RemoteServer_CommandReturnCodeWithError, (Object[])new String[]{execCmd, Integer.toString(result.getReturnCode()), result.getError()}) : NLS.bind((String)Messages.W_RemoteServer_CommandReturnCode, (Object[])new String[]{execCmd, Integer.toString(result.getReturnCode())});
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", msg));
        }
        return result;
    }

    @Override
    public String getServerScriptFilePath() {
        String filepath = this.isWindowsPlatform ? this.quote(this.ensureEndingPathSeparator(this.serverPath, this.SEP) + "bin" + this.SEP + "server.bat") + " " : this.quote(this.ensureEndingPathSeparator(this.serverPath, this.SEP) + "bin" + this.SEP + "server") + " ";
        return filepath;
    }

    @Override
    public String getServerSecurityUtilityFilePath() {
        String filepath = this.isWindowsPlatform ? this.quote(this.ensureEndingPathSeparator(this.serverPath, this.SEP) + "bin" + this.SEP + "securityUtility" + ".bat") + " " : this.quote(this.ensureEndingPathSeparator(this.serverPath, this.SEP) + "bin" + this.SEP + "securityUtility") + " ";
        return filepath;
    }

    @Override
    public String getServerUtilityFilePath(String command) {
        String filepath = this.isWindowsPlatform ? this.quote(this.ensureEndingPathSeparator(this.serverPath, this.SEP) + "bin" + this.SEP + command + ".bat") + " " : this.quote(this.ensureEndingPathSeparator(this.serverPath, this.SEP) + "bin" + this.SEP + command) + " ";
        return filepath;
    }

    protected String ensureEndingPathSeparator(String aPath, char SEP) {
        String path = aPath;
        if (path != null && path.length() > 0 && path.charAt(path.length() - 1) != SEP) {
            path = path + SEP;
        }
        return path;
    }

    protected void validateFields(String s, String msg) throws CoreException {
        if (s == null || s.trim().isEmpty()) {
            Status status = new Status(4, "com.ibm.ws.st.core", msg);
            throw new CoreException((IStatus)status);
        }
    }

    protected String quote(String in) {
        char c = this.isWindowsPlatform ? (char)'\"' : '\'';
        String s = in;
        if (in != null) {
            if (in.charAt(0) != c) {
                s = c + in;
            }
            if (in.charAt(in.length() - 1) != c) {
                s = s + c;
            }
        }
        return s;
    }

    String getJVMArgs() throws Exception {
        String args = "";
        String errorPage = LaunchUtil.getErrorPage();
        if (errorPage != null) {
            if (args.length() != 0) {
                args = args + " ";
            }
            args = args + "-Dwas4d.error.page=localhost:" + errorPage;
        }
        if ("profile".equals(this.launchMode)) {
            ILaunchConfiguration configuration = null;
            configuration = this.launch != null ? this.launch.getLaunchConfiguration() : null;
            String vmArgs = "";
            if (configuration != null) {
                vmArgs = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, (String)null);
            }
            IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
            VMRunnerConfiguration runConfig = new VMRunnerConfiguration("n/a", new String[0]);
            runConfig.setVMArguments(DebugPlugin.parseArguments((String)vmArgs));
            try {
                ServerProfilerDelegate.configureProfiling((ILaunch)this.launch, (IVMInstall)vmInstall, (VMRunnerConfiguration)runConfig, (IProgressMonitor)new NullProgressMonitor());
                String[] newVmArgs = runConfig.getVMArguments();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < newVmArgs.length; ++i) {
                    String s;
                    if (i > 0) {
                        sb.append(" ");
                    }
                    if (!(s = newVmArgs[i]).contains("\"")) {
                        sb.append("\"" + s + "\"");
                        continue;
                    }
                    sb.append(s);
                }
                vmArgs = sb.toString();
                if (!vmArgs.isEmpty()) {
                    if (args.length() != 0) {
                        args = args + " ";
                    }
                    args = args + vmArgs;
                }
            }
            catch (Exception e) {
                this.wsBehaviour.stopImpl();
                throw e;
            }
        }
        ServerStartInfo startInfo = new ServerStartInfo(this.wsServer.getServer(), this.launchMode);
        args = LaunchUtilities.processVMArguments(args, startInfo);
        return args;
    }

    @Override
    public IPath getLocalUserDir() {
        return this.wsServer.getServerInfo().getUserDirectory().getProject().getLocation().append("servers").append(this.serverName);
    }

    @Override
    public IPath getRemoteUserDir() {
        return new Path(this.wsServer.getRemoteServerStartConfigPath());
    }

    public boolean checkFileStatus(IPath remoteFilePath, boolean isLargeFile) throws CoreException {
        String[] files;
        String remoteDir = remoteFilePath.removeLastSegments(1).toOSString();
        String fileName = remoteFilePath.lastSegment();
        long remoteFileSize = -1L;
        long newRemoteFileSize = -1L;
        boolean fileExists = false;
        for (int count = 0; count <= 10 && !fileExists; ++count) {
            for (String file : files = this.remoteDelegate.listFiles(remoteDir)) {
                if (!file.equals(fileName)) continue;
                fileExists = true;
                remoteFileSize = this.remoteDelegate.getFileSize(remoteDir, fileName);
                break;
            }
            if (fileExists) continue;
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (isLargeFile && fileExists && newRemoteFileSize != 0L) {
            block6: while (remoteFileSize != newRemoteFileSize) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remoteFileSize = newRemoteFileSize;
                for (String file : files = this.remoteDelegate.listFiles(remoteDir)) {
                    if (!file.equals(fileName)) continue;
                    newRemoteFileSize = this.remoteDelegate.getFileSize(remoteDir, fileName);
                    continue block6;
                }
            }
        }
        return fileExists;
    }

    public boolean waitForDeleteOperationToComplete(IPath remoteFilePath) throws CoreException {
        String remoteDir = remoteFilePath.removeLastSegments(1).toOSString();
        String remoteFile = remoteFilePath.lastSegment();
        boolean fileExists = false;
        for (int count = 0; fileExists && count < 10; ++count) {
            String[] files;
            for (String file : files = this.remoteDelegate.listFiles(remoteDir)) {
                if (!file.equals(remoteFile)) continue;
                fileExists = true;
                break;
            }
            if (!fileExists) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return fileExists;
    }

    @Override
    public void modifyConfigFile(String includeFileName) {
        ConfigurationFile serverConfig = this.wsServer.getServerInfo().getConfigRoot();
        boolean includeExists = false;
        for (ConfigurationFile config : serverConfig.getAllIncludedFiles()) {
            if (!config.getPath().lastSegment().equals(includeFileName)) continue;
            includeExists = true;
            break;
        }
        if (!includeExists) {
            serverConfig.addInclude(false, includeFileName);
            try {
                serverConfig.save((IProgressMonitor)null);
            }
            catch (IOException e) {
                Trace.logError((String)"Error occured while executing join collective command for remote server", (Throwable)e);
            }
        }
        try {
            this.wsServer.createJMXConnection();
        }
        catch (Exception e) {
            try {
                this.uploadFile(this.getLocalUserDir().append("server.xml").toOSString(), this.remoteUserDir.append("server.xml").toOSString());
            }
            catch (CoreException e1) {
                Trace.logError((String)("Error uploading " + serverConfig.getName() + " to the remote sever."), (Throwable)e1);
            }
        }
    }

    public void fillRemoteConfigSyncInfo(String remoteFileLocation) throws CoreException {
        if (this.wsBehaviour.getTempDirectory().append("remoteConfigSyncInfo.properties").toFile().exists()) {
            this.remoteConfigSyncInfo = new Properties();
            FileUtil.loadProperties(this.remoteConfigSyncInfo, this.wsBehaviour.getTempDirectory().append("remoteConfigSyncInfo.properties"));
            String cachedTS = this.remoteConfigSyncInfo.getProperty(remoteFileLocation);
            long timeStamp = this.remoteDelegate.getTimeStamp(remoteFileLocation);
            Date date = new Date(timeStamp / 1000000L);
            String lastModified = date.toString();
            if (lastModified != null) {
                if (cachedTS != null) {
                    if (!lastModified.equals(cachedTS)) {
                        this.remoteConfigSyncInfo.put(remoteFileLocation.replace("\\", "/"), lastModified);
                    }
                } else {
                    this.remoteConfigSyncInfo.put(remoteFileLocation.replace("\\", "/"), lastModified);
                }
            }
            this.wsBehaviour.saveProperties(this.remoteConfigSyncInfo, "remoteConfigSyncInfo.properties");
        }
    }

    public void fillLocalConfigSyncInfo(String localFileLocation) {
        if (this.wsBehaviour.getTempDirectory().append("configSyncInfo.properties").toFile().exists()) {
            this.localConfigSyncInfo = new Properties();
            FileUtil.loadProperties(this.localConfigSyncInfo, this.wsBehaviour.getTempDirectory().append("configSyncInfo.properties"));
            String key = localFileLocation.replace("\\", "/");
            File file = new File(key);
            String cachedTS = this.localConfigSyncInfo.getProperty(key);
            if (cachedTS != null) {
                Date d = new Date(file.lastModified());
                String s = d.toString();
                if (!s.equals(cachedTS)) {
                    this.localConfigSyncInfo.put(key, s);
                }
            } else {
                this.localConfigSyncInfo.put(key, new Date(file.lastModified()).toString());
            }
            this.wsBehaviour.saveProperties(this.localConfigSyncInfo, "configSyncInfo.properties");
        }
    }

    @Override
    public boolean matchPasswordField(IPath filePath, String expectedPassword) {
        boolean passwordsMatch = true;
        try {
            String actualPassword;
            Element elem;
            Element keyStoreElem;
            ConfigurationFile file = new ConfigurationFile(filePath.toFile().toURI(), this.wsServer.getUserDirectory(), this.wsServer.getServerInfo());
            Document doc = file.getDocument();
            if (doc != null && (keyStoreElem = DOMUtils.getFirstChildElement(elem = doc.getDocumentElement(), "keyStore")) != null && !(actualPassword = PasswordUtil.decode((String)keyStoreElem.getAttribute("password"))).equals(expectedPassword)) {
                file.setAttribute("keyStore", "password", expectedPassword);
                file.save((IProgressMonitor)null);
                passwordsMatch = false;
            }
        }
        catch (Exception e) {
            Trace.logError((String)("Unable to fetch the keystore password in file: " + filePath), (Throwable)e);
        }
        return passwordsMatch;
    }

    @Override
    public boolean isDockerExecutionDelegate() {
        return false;
    }

    @Override
    public IPath getRemoteOutputDir() {
        return this.remoteUserDir;
    }

    @Override
    public boolean isExecutionSuccessful(IPlatformHandler.ExecutionOutput pr, String expectedSysOut) throws CoreException {
        if (pr.getReturnCode() != 0) {
            return false;
        }
        return pr.getReturnCode() != 0 || pr.getOutput().contains(expectedSysOut);
    }

    @Override
    public void startExecution() throws CoreException {
        this.remoteDelegate.startExecution();
    }

    @Override
    public void endExecution() {
        if (this.remoteDelegate != null) {
            this.remoteDelegate.endExecution();
        }
    }

    @Override
    public boolean fileExists(String remoteFilePath) throws Exception {
        return this.remoteDelegate.fileExists(remoteFilePath);
    }

    @Override
    public void renameFile(String remoteOldFileName, String newName) throws Exception {
        this.remoteDelegate.renameFile(remoteOldFileName, newName);
    }

    @Override
    public void deleteFile(String remoteFilePath, boolean recursiveDelete, boolean force) throws Exception {
        this.remoteDelegate.deleteFile(remoteFilePath, recursiveDelete, force);
    }

    @Override
    public void uploadFile(String localFile, String destinationFile) throws CoreException {
        this.remoteDelegate.uploadFile(localFile, destinationFile);
    }

    @Override
    public void downloadFile(IPath remoteFile, String destFile, IProgressMonitor monitor) throws CoreException {
        this.remoteDelegate.downloadFile(remoteFile, destFile, monitor);
    }

    @Override
    public String getOSString(String path) {
        String osPath = path;
        osPath = !this.isWindowsPlatform ? path.replace("\\", "/") : path.replace("/", "\\");
        return osPath;
    }
}

