/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.launch.StreamMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ConsoleReader {
    private static final String ERROR = "[ERROR   ]";
    private static final String FATAL = "[FATAL   ]";
    private static final String ERR = "[err]";
    private final StreamMonitor outListener;
    private final StreamMonitor errListener;
    private long size = -1L;
    private File file = null;
    private BufferedReader reader = null;
    private String charset = null;

    public ConsoleReader(File file, StreamMonitor outListener, StreamMonitor errListener) {
        this.file = file;
        this.outListener = outListener;
        this.errListener = errListener;
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Monitoring " + file.getAbsolutePath());
        }
    }

    protected void update() {
        block6: {
            try {
                if (this.reader != null && this.size != -1L && this.size > this.file.length()) {
                    this.reader.close();
                    this.reader = null;
                }
                if (this.reader == null && this.file.exists()) {
                    this.reader = this.charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.charset)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
                }
                if (this.reader == null) {
                    return;
                }
                this.size = this.file.length();
                String s = this.reader.readLine();
                while (s != null) {
                    this.append(s + "\n");
                    s = this.reader.readLine();
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block6;
                Trace.trace((byte)1, "Error updating stream monitor", e);
            }
        }
    }

    private void append(String s) {
        if (s == null) {
            return;
        }
        boolean err = false;
        if (s.startsWith(ERROR)) {
            err = true;
        } else if (s.startsWith(FATAL)) {
            err = true;
        } else if (s.startsWith(ERR)) {
            err = true;
        }
        if (err) {
            this.errListener.streamAppended(s);
        } else {
            this.outListener.streamAppended(s);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String aCharSet) {
        this.charset = aCharSet;
    }

    protected void close() {
        if (this.reader != null) {
            block3: {
                try {
                    this.reader.close();
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block3;
                    Trace.trace((byte)1, "Error closing stream monitor", e);
                }
            }
            this.reader = null;
        }
    }
}

