/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractLaunchConfigurationExtension;
import com.ibm.ws.st.core.AbstractLibertyDebugFactory;
import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.LaunchUtilities;
import com.ibm.ws.st.core.internal.launch.ServerStartInfo;
import com.ibm.ws.st.core.internal.launch.UtilityLaunchConfigurationDelegate;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdi.VirtualMachine;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class BaseLibertyLaunchConfiguration
extends AbstractLaunchConfigurationExtension {
    protected static final String VM_ERROR_PAGE = "-Dwas4d.error.page=localhost:";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Launch configuration could not find server");
            }
            return;
        }
        WebSphereServer websphereServer = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null));
        WebSphereServerBehaviour websphereServerBehaviour = (WebSphereServerBehaviour)((Object)server.loadAdapter(WebSphereServerBehaviour.class, null));
        IRuntime runtime = server.getRuntime();
        if (runtime == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "The runtime is null");
            }
            return;
        }
        WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        if (websphereServer == null || websphereServerBehaviour == null || wsRuntime == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Launch configuration could not find WebSphere server");
            }
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        IStatus status2 = websphereServer.validate();
        if (status2 != null && !status2.isOK()) {
            throw new CoreException(status2);
        }
        this.setDefaultSourceLocator(launch, configuration);
        websphereServerBehaviour.setLaunch(launch);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            if (websphereServer.isLocalSetup()) {
                websphereServerBehaviour.preLaunch(launch, mode, monitor);
                this.launchLocal(configuration, mode, launch, monitor, websphereServerBehaviour);
            } else {
                this.launchRemote(configuration, mode, launch, monitor, websphereServerBehaviour);
            }
        }
        catch (CoreException ce) {
            Trace.logError("Failed to launch process", ce);
            websphereServerBehaviour.stopImpl();
            throw ce;
        }
        catch (Exception e) {
            Trace.logError("Failed to launch process", e);
            websphereServerBehaviour.stopImpl();
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public void launchStartedServer(String launchMode, ServerBehaviourDelegate serverBehaviour) throws CoreException {
        WebSphereServer websphereServer;
        block13: {
            IServer server = serverBehaviour.getServer();
            WebSphereServerBehaviour websphereServerBehaviour = (WebSphereServerBehaviour)((Object)server.loadAdapter(WebSphereServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor()));
            if (websphereServerBehaviour == null) {
                return;
            }
            websphereServer = websphereServerBehaviour.getWebSphereServer();
            ILaunch launch = server.getLaunch();
            if (launch == null && server.getServerState() == 2) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)8, "STARTING SERVER FROM LAUNCHIT");
                }
                server.start(launchMode, (IProgressMonitor)new NullProgressMonitor());
            }
            boolean isDebugMode = "debug".equals(launchMode);
            try {
                int remoteDebugPort = -1;
                JMXConnection jmxConnection = null;
                try {
                    jmxConnection = websphereServer.createJMXConnection();
                    remoteDebugPort = jmxConnection.getDebugPortNum();
                }
                catch (Exception e) {
                    remoteDebugPort = Integer.parseInt(websphereServer.getRemoteServerStartDebugPort());
                }
                if (remoteDebugPort <= -1 || !isDebugMode || launch == null) break block13;
                if (!websphereServerBehaviour.isDebugAttached(remoteDebugPort, server)) {
                    IDebugTarget oldDebugTarget = websphereServerBehaviour.getDebugTarget();
                    LaunchUtilities.connectRemoteDebugClient(launch, remoteDebugPort, websphereServer);
                    if (oldDebugTarget != null && !websphereServerBehaviour.getDebugTarget().isDisconnected() && !websphereServerBehaviour.getDebugTarget().isTerminated()) {
                        oldDebugTarget.disconnect();
                    }
                    break block13;
                }
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Skipping the debug attach since the debug process is already attached");
                }
                try {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                }
                catch (Exception e2) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Cannot terminate the failed debug launch process.", e2);
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block13;
                Trace.trace((byte)0, "Could not attach debugger.", e);
            }
        }
        LaunchUtilities.updateServerConfig(websphereServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchRemote(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, WebSphereServerBehaviour websphereServerBehaviour) throws CoreException {
        WebSphereServer websphereServer = websphereServerBehaviour.getWebSphereServer();
        websphereServerBehaviour.ensureMonitorRunning();
        JMXConnection jmxConnection = null;
        try {
            try {
                jmxConnection = websphereServer.createJMXConnection();
                if (Trace.ENABLED) {
                    Trace.trace((byte)8, "Server is already started");
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)8, "Server is not started, attempt to start the server");
                }
                websphereServerBehaviour.start(launch, mode, monitor);
            }
            this.launchStartedServer(mode, websphereServerBehaviour);
        }
        finally {
            block13: {
                if (jmxConnection != null) {
                    try {
                        jmxConnection.disconnect();
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block13;
                        Trace.trace((byte)0, "Couldn't disconnect JMX connection", e);
                    }
                }
            }
        }
    }

    private void launchLocal(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, WebSphereServerBehaviour websphereServerBehaviour) throws CoreException, IllegalConnectorArgumentsException, IOException {
        ServerStartInfo startInfo;
        String errorPage;
        boolean useDebugScript;
        int debugPort = 7777;
        AttachingConnector connector = null;
        Map<String, Connector.Argument> map = null;
        WebSphereServer websphereServer = websphereServerBehaviour.getWebSphereServer();
        IServer server = websphereServer.getServer();
        WebSphereRuntime wsRuntime = websphereServer.getWebSphereRuntime();
        String serverName = websphereServer.getServerName();
        ProcessBuilder pb = null;
        String scriptMode = "run";
        String runtimeVersion = websphereServer.getWebSphereRuntime().getRuntimeVersion();
        boolean isDebugMode = "debug".equals(mode);
        boolean bl = useDebugScript = runtimeVersion != null && !runtimeVersion.startsWith("8.5.0");
        if (isDebugMode && useDebugScript) {
            scriptMode = "debug";
        }
        if (websphereServerBehaviour.isCleanOnStartup()) {
            pb = wsRuntime.createProcessBuilder(scriptMode, websphereServer.getServerInfo(), "--clean");
            websphereServerBehaviour.setCleanOnStartup(false);
        } else {
            pb = wsRuntime.createProcessBuilder(scriptMode, websphereServer.getServerInfo(), new String[0]);
        }
        Map<String, String> env = pb.environment();
        String vmArgs = env.get("JVM_ARGS");
        String addVmArgs = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, (String)null);
        if (addVmArgs != null && addVmArgs.length() > 0) {
            vmArgs = vmArgs == null ? "" : vmArgs + " ";
            vmArgs = vmArgs + addVmArgs;
        }
        if ((errorPage = LaunchUtil.getErrorPage()) != null) {
            vmArgs = vmArgs == null ? "" : vmArgs + " ";
            vmArgs = vmArgs + VM_ERROR_PAGE + errorPage;
        }
        if (isDebugMode) {
            if (vmArgs != null && vmArgs.contains("-Xquickstart")) {
                vmArgs = vmArgs.replace("-Xquickstart", "");
            }
            if ((debugPort = LaunchUtilities.findFreePort()) == -1) {
                this.abort("Could not find a free socket", null, 0);
            }
            if ((connector = LaunchUtilities.getAttachingConnector()) == null) {
                this.abort("Could not find an appropriate debug connector", null, 119);
                return;
            }
            map = connector.defaultArguments();
            LaunchUtilities.configureConnector(map, server.getHost(), debugPort);
            env.put("WLP_DEBUG_ADDRESS", debugPort + "");
            if (!useDebugScript) {
                vmArgs = vmArgs == null ? "" : vmArgs + " ";
                vmArgs = vmArgs + " -Dwas.debug.mode=true -agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=localhost:" + debugPort;
            }
        } else if ("profile".equals(mode)) {
            IVMInstall vmInstall = wsRuntime.getVMInstall();
            VMRunnerConfiguration runConfig = new VMRunnerConfiguration("n/a", new String[0]);
            runConfig.setVMArguments(DebugPlugin.parseArguments((String)vmArgs));
            try {
                ServerProfilerDelegate.configureProfiling((ILaunch)launch, (IVMInstall)vmInstall, (VMRunnerConfiguration)runConfig, (IProgressMonitor)monitor);
                String[] newVmArgs = runConfig.getVMArguments();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < newVmArgs.length; ++i) {
                    String s;
                    if (i > 0) {
                        sb.append(" ");
                    }
                    if (!(s = newVmArgs[i]).contains("\"")) {
                        sb.append("\"" + s + "\"");
                        continue;
                    }
                    sb.append(s);
                }
                vmArgs = sb.toString();
            }
            catch (CoreException ce) {
                websphereServerBehaviour.stopImpl();
                throw ce;
            }
        }
        if ((vmArgs = LaunchUtilities.processVMArguments(vmArgs, startInfo = new ServerStartInfo(server, mode))) != null) {
            env.put("JVM_ARGS", vmArgs);
        }
        Process p = pb.start();
        String cmd = pb.command().get(0) + " " + pb.command().get(1);
        IProcess process = LaunchUtilities.newProcess(server, launch, p, LaunchUtil.getProcessLabel(cmd));
        process.setAttribute(IProcess.ATTR_CMDLINE, UtilityLaunchConfigurationDelegate.renderCmdLine(pb));
        process.setAttribute(IProcess.ATTR_PROCESS_LABEL, LaunchUtil.getProcessLabelAttr(wsRuntime.getRuntime().getName(), serverName));
        launch.addProcess(process);
        websphereServerBehaviour.addProcessListeners(process);
        if (isDebugMode) {
            IJavaDebugTarget jdt;
            AbstractLibertyDebugFactory df = LaunchUtilities.getDebugTargetFactory();
            IDebugTarget curDebugTarget = null;
            if (df != null) {
                String debugTargetLabel = NLS.bind((String)Messages.debugTargetLabel, (Object)"localhost", (Object)(debugPort + ""));
                curDebugTarget = df.createDebugTarget(launch, "localhost", Integer.toString(debugPort), debugTargetLabel, null);
            }
            if (curDebugTarget == null) {
                curDebugTarget = this.connectAndWait(launch, debugPort, connector, map, p, process, server.getStartTimeout(), monitor);
            }
            if (curDebugTarget != null && (jdt = (IJavaDebugTarget)curDebugTarget.getAdapter(IJavaDebugTarget.class)) != null) {
                jdt.addHotCodeReplaceListener((IJavaHotCodeReplaceListener)new LaunchUtilities.WebSphereJavaHotCodeReplaceListener(server));
            }
        }
    }

    private IDebugTarget connectAndWait(ILaunch launch, int port, AttachingConnector connector, Map map, Process p, IProcess process, int timeout, IProgressMonitor monitor) throws IllegalConnectorArgumentsException, CoreException, IOException {
        boolean retry = false;
        while (true) {
            try {
                com.sun.jdi.VirtualMachine vm = null;
                Exception ex = null;
                int itr = timeout * 4;
                if (itr <= 0) {
                    itr = 2;
                }
                while (itr-- > 0) {
                    if (monitor.isCanceled()) {
                        p.destroy();
                        return null;
                    }
                    try {
                        vm = connector.attach(map);
                        itr = 0;
                        ex = null;
                    }
                    catch (Exception e) {
                        ex = e;
                        if (Trace.ENABLED_DETAILS && itr % 8 == 0) {
                            Trace.trace((byte)7, "Waiting for debugger attach.");
                        }
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                try {
                    p.exitValue();
                    this.checkErrorMessage(process);
                }
                catch (IllegalThreadStateException e) {
                    // empty catch block
                }
                if (ex instanceof IllegalConnectorArgumentsException) {
                    throw (IllegalConnectorArgumentsException)ex;
                }
                if (ex instanceof InterruptedIOException) {
                    throw (InterruptedIOException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                IDebugTarget debugTarget = null;
                if (vm != null) {
                    BaseLibertyLaunchConfiguration.setDebugTimeout(vm);
                    debugTarget = this.createLocalJDTDebugTarget(launch, port, process, vm);
                    monitor.worked(1);
                    monitor.done();
                }
                return debugTarget;
            }
            catch (InterruptedIOException e) {
                this.checkErrorMessage(process);
                Status status = new Status(4, "com.ibm.ws.st.core", 117, "", (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                retry = false;
                if (handler == null) {
                    throw new CoreException((IStatus)status);
                }
                Object result = handler.handleStatus((IStatus)status, (Object)this);
                if (!(result instanceof Boolean)) continue;
                retry = (Boolean)result;
                if (retry) continue;
                return null;
            }
            break;
        }
    }

    private IDebugTarget createLocalJDTDebugTarget(ILaunch launch, int port, IProcess process, com.sun.jdi.VirtualMachine vm) {
        String name = NLS.bind((String)Messages.debugTargetLabel, (Object)"localhost", (Object)(port + ""));
        return JDIDebugModel.newDebugTarget((ILaunch)launch, (com.sun.jdi.VirtualMachine)vm, (String)name, (IProcess)process, (boolean)true, (boolean)false, (boolean)true);
    }

    private void checkErrorMessage(IProcess process) throws CoreException {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        if (streamsProxy != null) {
            String errorMessage = streamsProxy.getErrorStreamMonitor().getContents();
            if (errorMessage.length() == 0) {
                errorMessage = streamsProxy.getOutputStreamMonitor().getContents();
            }
            if (errorMessage.length() != 0) {
                this.abort(errorMessage, null, 116);
            }
        }
    }

    private static void setDebugTimeout(com.sun.jdi.VirtualMachine vm) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        int timeOut = node.getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT, 0);
        if (timeOut <= 0) {
            return;
        }
        if (vm instanceof VirtualMachine) {
            VirtualMachine vm2 = (VirtualMachine)vm;
            vm2.setRequestTimeout(timeOut);
        }
    }
}

