/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.generation.IMetadataGenerator;
import com.ibm.ws.st.core.internal.generation.Metadata;
import com.ibm.ws.st.core.internal.generation.MetadataProviderManager;
import java.io.File;
import java.net.URL;

public class SchemaMetadata
extends Metadata<URL> {
    public static final String SCHEMA_XSD = "server.xsd";
    private static final SchemaMetadata instance = new SchemaMetadata();

    public static SchemaMetadata getInstance() {
        return instance;
    }

    public URL getSchemaPath(IMetadataGenerator metadataGen) {
        URL url;
        block4: {
            url = null;
            if (metadataGen != null) {
                try {
                    url = (URL)this.getGeneratedInfo(metadataGen);
                }
                catch (Throwable t) {
                    if (!Trace.ENABLED) break block4;
                    Trace.trace((byte)1, "Error occurred while getting schema for " + metadataGen.getGeneratorId(), t);
                }
            }
        }
        if (url == null) {
            url = SchemaMetadata.getFallbackSchema();
        }
        return url;
    }

    public static URL getFallbackSchema() {
        URL url = MetadataProviderManager.getDefaultSchema();
        return url;
    }

    public boolean metadataExists(IMetadataGenerator metadataGen) {
        File f = this.getTarget(metadataGen).toFile();
        return f.exists();
    }

    public URL getPayload(IMetadataGenerator metadataGen) {
        URL url;
        block6: {
            url = null;
            try {
                File f = this.getTarget(metadataGen).toFile();
                if (f.exists()) {
                    url = f.toURI().toURL();
                } else if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Schema file " + this.getTarget(metadataGen).toOSString() + " does not exist.", null);
                }
            }
            catch (Throwable t) {
                if (!Trace.ENABLED) break block6;
                Trace.trace((byte)1, "Problem occurred while retrieving schema payload for runtime id: " + metadataGen.getGeneratorId(), t);
            }
        }
        if (url == null) {
            url = SchemaMetadata.getFallbackSchema();
        }
        return url;
    }

    @Override
    URL reloadPayload(File file) {
        URL url;
        block4: {
            url = null;
            if (file.exists()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (Throwable t) {
                    if (!Trace.ENABLED) break block4;
                    Trace.trace((byte)1, "Error while attempting to reload schema", t);
                }
            }
        }
        if (url == null) {
            url = SchemaMetadata.getFallbackSchema();
        }
        return url;
    }

    private SchemaMetadata() {
        super(SCHEMA_XSD);
    }
}

