/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.ActivationType;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.st.core.internal.generation.Feature;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class ResolverFeatureAdapter
implements ProvisioningFeatureDefinition {
    private final Feature feature;

    public ResolverFeatureAdapter(Feature feature) {
        this.feature = feature;
    }

    public String getApiServices() {
        return null;
    }

    public AppForceRestart getAppForceRestart() {
        return null;
    }

    public String getFeatureName() {
        if (this.feature.getFeatureType() == Feature.FeatureType.PUBLIC) {
            return this.feature.getName();
        }
        return this.feature.getSymbolicName();
    }

    public String getSymbolicName() {
        return this.feature.getSymbolicName();
    }

    public Version getVersion() {
        return Version.emptyVersion;
    }

    public Visibility getVisibility() {
        Feature.FeatureType featureType = this.feature.getFeatureType();
        if (featureType != null) {
            switch (featureType) {
                case PUBLIC: {
                    return Visibility.PUBLIC;
                }
                case PROTECTED: {
                    return Visibility.PROTECTED;
                }
                case PRIVATE: 
                case KERNEL: 
                case AUTO: {
                    return Visibility.PRIVATE;
                }
            }
        }
        return null;
    }

    public boolean isKernel() {
        return Feature.FeatureType.KERNEL == this.feature.getFeatureType();
    }

    public String getBundleRepositoryType() {
        String featureInfoName = this.feature.getFeatureInfoName();
        if (featureInfoName != null) {
            return featureInfoName;
        }
        return "";
    }

    public Collection<FeatureResource> getConstituents(SubsystemContentType subsystemContentType) {
        if (subsystemContentType == SubsystemContentType.FEATURE_TYPE) {
            Map<String, List<String>> includes = this.feature.getIncludes();
            ArrayList<FeatureResource> constituents = new ArrayList<FeatureResource>();
            for (String symbolicName : includes.keySet()) {
                constituents.add(new FeatureResourceAdapter(symbolicName, includes.get(symbolicName)));
            }
            return constituents;
        }
        return null;
    }

    public File getFeatureChecksumFile() {
        return null;
    }

    public File getFeatureDefinitionFile() {
        return null;
    }

    public String getHeader(String arg0) {
        return null;
    }

    public String getHeader(String arg0, Locale arg1) {
        return null;
    }

    public Collection<HeaderElementDefinition> getHeaderElements(String arg0) {
        return null;
    }

    public int getIbmFeatureVersion() {
        return -1;
    }

    public String getIbmShortName() {
        if (this.feature.getFeatureType() == Feature.FeatureType.PUBLIC) {
            String name = this.feature.getName();
            int index = name.indexOf(58);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            return name;
        }
        return null;
    }

    public Collection<String> getIcons() {
        return null;
    }

    public Collection<File> getLocalizationFiles() {
        return null;
    }

    public String getSupersededBy() {
        return null;
    }

    public boolean isAutoFeature() {
        return this.feature.getAutoProvisions().size() > 0;
    }

    public boolean isCapabilitySatisfied(Collection<ProvisioningFeatureDefinition> featureDefinitionsToCheck) {
        if (!this.feature.isAutoFeature()) {
            return true;
        }
        boolean isCapabilitySatisfied = true;
        HashSet<ProvisioningFeatureDefinition> satisfiedFeatureDefs = new HashSet<ProvisioningFeatureDefinition>();
        for (String autoProvision : this.feature.getAutoProvisions()) {
            try {
                Filter filter = FrameworkUtil.createFilter((String)autoProvision);
                Iterator<ProvisioningFeatureDefinition> featureDefIter = featureDefinitionsToCheck.iterator();
                boolean featureMatch = false;
                while (featureDefIter.hasNext() && !featureMatch) {
                    ProvisioningFeatureDefinition featureDef = featureDefIter.next();
                    if (satisfiedFeatureDefs.contains(featureDef)) continue;
                    HashMap<String, String> filterProps = new HashMap<String, String>();
                    filterProps.put("osgi.identity", featureDef.getSymbolicName());
                    filterProps.put("type", "osgi.subsystem.feature");
                    if (!filter.matches(filterProps)) continue;
                    satisfiedFeatureDefs.add(featureDef);
                    featureMatch = true;
                }
                isCapabilitySatisfied = featureMatch;
                if (isCapabilitySatisfied) continue;
                break;
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                invalidSyntaxException.printStackTrace();
            }
        }
        return isCapabilitySatisfied;
    }

    public boolean isCompatibility() {
        return false;
    }

    public String getPlatformName() {
        return null;
    }

    public List<String> getPlatformNames() {
        return null;
    }

    public boolean isConvenience() {
        return false;
    }

    public boolean isVersionless() {
        return false;
    }

    public boolean isSingleton() {
        return this.feature.isSingleton();
    }

    public boolean isSuperseded() {
        return this.feature.isSuperseded();
    }

    public boolean isSupportedFeatureVersion() {
        return true;
    }

    public EnumSet<ProcessType> getProcessTypes() {
        return EnumSet.of(ProcessType.SERVER);
    }

    public String toString() {
        return this.getFeatureName();
    }

    public class FeatureResourceAdapter
    implements FeatureResource {
        private final String symbolicName;
        private final List<String> tolerates;

        public FeatureResourceAdapter(String symbolicName, List<String> tolerates) {
            this.symbolicName = symbolicName;
            this.tolerates = tolerates;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public Map<String, String> getDirectives() {
            return new HashMap<String, String>();
        }

        public Map<String, String> getAttributes() {
            return new HashMap<String, String>();
        }

        public String setExecutablePermission() {
            return null;
        }

        public boolean isType(SubsystemContentType subsystemContentType) {
            return subsystemContentType == SubsystemContentType.FEATURE_TYPE;
        }

        public VersionRange getVersionRange() {
            return null;
        }

        public SubsystemContentType getType() {
            return SubsystemContentType.FEATURE_TYPE;
        }

        public List<String> getTolerates() {
            return this.tolerates;
        }

        public int getStartLevel() {
            return 0;
        }

        public String getRawType() {
            return SubsystemContentType.FEATURE_TYPE.toString();
        }

        public List<String> getOsList() {
            return null;
        }

        public String getMatchString() {
            return null;
        }

        public String getLocation() {
            return null;
        }

        public String getFileEncoding() {
            return null;
        }

        public String getExtendedAttributes() {
            return null;
        }

        public String getBundleRepositoryType() {
            return null;
        }

        public ActivationType getActivationType() {
            throw new UnsupportedOperationException();
        }

        public VersionRange getJavaRange() {
            return null;
        }
    }
}

