/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.generation.FeatureListCoreMetadata;
import com.ibm.ws.st.core.internal.generation.FeatureListExtMetadata;
import com.ibm.ws.st.core.internal.generation.GeneratorJob;
import com.ibm.ws.st.core.internal.generation.IMetadataGenerator;
import com.ibm.ws.st.core.internal.generation.SchemaMetadata;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.osgi.framework.Bundle;

public abstract class Metadata<PayloadType>
implements GeneratorJob.Helper {
    static final int TIME_OUT_PERIOD = 362;
    public static final int CORE_METADATA = 1;
    public static final int EXT_METADATA = 2;
    public static final int SCHEMA_METADATA = 4;
    public static final int ALL_METADATA = 15;
    final ConcurrentHashMap<String, Data> infos = new ConcurrentHashMap();
    static final IPath basePath = Activator.getInstance().getStateLocation();
    final String target;

    public static void generateMetadata(IMetadataGenerator metadataGen, IJobChangeListener[] listeners, int metadataTypes) {
        String genId = metadataGen.getGeneratorId();
        ArrayList<Metadata> helpers = new ArrayList<Metadata>();
        if ((metadataTypes & 4) == 4) {
            SchemaMetadata schemaMetadata = SchemaMetadata.getInstance();
            schemaMetadata.createData(genId, metadataGen);
            helpers.add(schemaMetadata);
        }
        if ((metadataTypes & 1) == 1) {
            FeatureListCoreMetadata featureListCoreMetadata = FeatureListCoreMetadata.getInstance();
            featureListCoreMetadata.createData(genId, metadataGen);
            helpers.add(featureListCoreMetadata);
        }
        if ((metadataTypes & 2) == 2) {
            for (FeatureListExtMetadata ext : FeatureListExtMetadata.getInstances(metadataGen.getWebSphereRuntime())) {
                ext.createData(genId, metadataGen);
                helpers.add(ext);
            }
        }
        GeneratorJob.generate(metadataGen, helpers.toArray(new GeneratorJob.Helper[helpers.size()]), listeners);
    }

    public static void removeMetadata(String generatorId, boolean destroy) {
        FeatureListCoreMetadata featureListMetadata = FeatureListCoreMetadata.getInstance();
        SchemaMetadata schemaMetadata = SchemaMetadata.getInstance();
        featureListMetadata.remove(generatorId, destroy);
        schemaMetadata.remove(generatorId, destroy);
        FeatureListExtMetadata.clearRuntimeInstances(generatorId);
    }

    private static boolean doesDataFileStillExist(Data d) {
        if (d.payload instanceof URL) {
            URL u = (URL)d.payload;
            try {
                File f = new File(u.toURI().getPath());
                if (!f.exists()) {
                    return false;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PayloadType getGeneratedInfo(IMetadataGenerator metadataGen) {
        Object info;
        String genId = metadataGen.getGeneratorId();
        int i = 0;
        Data sd = this.infos.get(genId);
        if (sd == null || !Metadata.doesDataFileStillExist(sd)) {
            info = this.getTarget(metadataGen);
            File file = info.toFile();
            if (file.exists()) {
                this.createData(genId, metadataGen);
                this.setPayload(genId, this.reloadPayload(file));
            } else if (metadataGen.isReadyToGenerateMetadata()) {
                metadataGen.generateMetadata(null, true);
            }
            sd = this.infos.get(genId);
        }
        if (sd != null) {
            for (i = 0; i < 362 && sd.isGenerating(); ++i) {
                info = this;
                synchronized (info) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException file) {
                        // empty catch block
                    }
                    sd = this.infos.get(genId);
                    continue;
                }
            }
        }
        if (sd != null && sd.payload != null) {
            return sd.payload;
        }
        if (Trace.ENABLED) {
            String problem = i >= 362 ? "Timed out waiting for metadata for generator: " : (sd != null ? "Attempting to access metadata for deleted generator: " : "Problem generating metadata for generator: ");
            Throwable t = new Throwable();
            t.fillInStackTrace();
            Trace.trace((byte)1, problem + genId, t);
        }
        return null;
    }

    abstract PayloadType reloadPayload(File var1);

    public void createData(String generatorId, IMetadataGenerator metadataGen) {
        this.infos.put(generatorId, new Data(null, metadataGen));
    }

    protected static IPath getBasePath(IMetadataGenerator metadataGen) {
        return metadataGen.getBasePath(basePath);
    }

    public synchronized void remove(String generatorId, boolean destroy) {
        if (destroy) {
            this.infos.remove(generatorId);
        } else {
            this.setPayload(generatorId, null);
        }
    }

    public synchronized void generateIfMissingOrRemoved(IMetadataGenerator metadataGen, IJobChangeListener listener) {
        String id = metadataGen.getGeneratorId();
        boolean needToGenerate = false;
        Data d = this.infos.get(id);
        if (d == null) {
            needToGenerate = true;
        } else if (d.isRemoved()) {
            metadataGen.removeMetadata(null, false, true);
            needToGenerate = true;
        }
        if (needToGenerate) {
            metadataGen.generateMetadata(listener, true);
        }
    }

    public final synchronized void generationComplete(String generatorId, PayloadType payload) {
        this.setPayload(generatorId, payload);
        this.notifyAll();
    }

    protected Metadata(String target) {
        this.target = target;
    }

    @Override
    public IPath getTarget(IMetadataGenerator metadataGen) {
        return Metadata.getBasePath(metadataGen).append(this.target);
    }

    void setPayload(String generatorId, PayloadType p) {
        Data data = this.infos.get(generatorId);
        if (data == null) {
            return;
        }
        data.payload = p;
        if (p == null) {
            data.metadataGen = null;
        }
    }

    protected static URL getFallback(String file) {
        URL url = null;
        try {
            url = FileLocator.find((Bundle)Activator.getInstance().getBundle(), (IPath)new Path(file), null);
            url = FileLocator.resolve((URL)url);
        }
        catch (Throwable t) {
            Trace.logError("Could not find fallback file " + file, t);
            url = null;
        }
        return url;
    }

    final class Data {
        public PayloadType payload;
        public IMetadataGenerator metadataGen;

        public Data(PayloadType payload, IMetadataGenerator metadataGen) {
            this.payload = payload;
            this.metadataGen = metadataGen;
        }

        public boolean isGenerating() {
            return this.payload == null && this.metadataGen != null;
        }

        public boolean isRemoved() {
            return this.metadataGen == null;
        }
    }
}

