/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.generation.Metadata;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MetaDataRemover {
    public static void removeOutOfSyncMetaData() {
        try {
            long time = System.currentTimeMillis();
            MetaDataRemover.removeOutOfSyncMetaDataImpl();
            if (Trace.ENABLED) {
                Trace.tracePerf("Metadata remove job", time);
            }
        }
        catch (Exception e) {
            Trace.logError("Error in WebSphere Runtime MetaData Remover", e);
        }
    }

    protected static void removeOutOfSyncMetaDataImpl() {
        File[] dirs;
        File metaDataFolder = Activator.getInstance().getStateLocation().toFile();
        if (!metaDataFolder.exists()) {
            return;
        }
        WebSphereRuntime[] runtimes = WebSphereUtil.getWebSphereRuntimes();
        final ArrayList<String> availableRuntimeIds = new ArrayList<String>(runtimes.length);
        if (runtimes.length > 0) {
            for (WebSphereRuntime runtime : runtimes) {
                WebSphereServerInfo.removeOutOfSyncMetadata(runtime);
                availableRuntimeIds.add(runtime.getRuntime().getId());
            }
        }
        if ((dirs = metaDataFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !availableRuntimeIds.contains(name);
            }
        })) != null && dirs.length > 0) {
            for (File d : dirs) {
                if (!MetaDataRemover.isMetaDataDir(d)) continue;
                Metadata.removeMetadata(d.getName(), false);
                MetaDataRemover.removeMetaDataDir(d);
            }
        }
    }

    public static void removeCancelledMetaData(final Collection<String> runtimeIds) {
        IPath metaDataPath = Activator.getInstance().getStateLocation();
        File metaDataFolder = metaDataPath.toFile();
        if (!metaDataFolder.exists()) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not find plugin folder for meta data: " + metaDataPath.toOSString());
            }
            return;
        }
        File[] dirs = metaDataFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return runtimeIds.contains(name);
            }
        });
        if (dirs != null && dirs.length > 0) {
            for (File d : dirs) {
                if (!d.isDirectory()) continue;
                WebSphereServerInfo.removeCancelledMetaData((IPath)new Path(d.getAbsolutePath()), d.getName());
                Metadata.removeMetadata(d.getName(), true);
                MetaDataRemover.removeMetaDataDir(d);
            }
        }
    }

    private static boolean isMetaDataDir(File m) {
        if (!m.isDirectory()) {
            return false;
        }
        File[] metaDataFiles = m.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("server.xsd") || name.startsWith("featureList.xml");
            }
        });
        return metaDataFiles != null && metaDataFiles.length > 0;
    }

    private static void removeMetaDataDir(File dir) {
        File[] metaDataFiles = dir.listFiles();
        if (metaDataFiles != null && metaDataFiles.length > 0) {
            for (File m : metaDataFiles) {
                if (m.isDirectory()) {
                    MetaDataRemover.removeMetaDataDir(m);
                    continue;
                }
                MetaDataRemover.removeMetaDataFile(m);
            }
        }
        MetaDataRemover.removeMetaDataFile(dir);
    }

    private static void removeMetaDataFile(File f) {
        block3: {
            try {
                if (f.exists() && !f.delete() && Trace.ENABLED) {
                    Trace.trace((byte)1, "Unable to delete " + f.toString());
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)1, "Failed to delete " + f.toString(), e);
            }
        }
    }
}

