/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereRuntimeProductInfoCacheUtil;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.generation.AbstractFeatureListMetadata;
import com.ibm.ws.st.core.internal.generation.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FeatureListExtMetadata
extends AbstractFeatureListMetadata {
    public final String extensionName;
    private final HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> fallBackFeatureMaps = new HashMap();
    private static HashMap<String, FeatureListExtMetadata[]> instancesMap = new HashMap();

    private FeatureListExtMetadata(String extName) {
        super("featureList" + extName + ".xml");
        this.extensionName = extName;
    }

    public static synchronized FeatureListExtMetadata[] getInstances(WebSphereRuntime runtime) {
        if (runtime == null) {
            return new FeatureListExtMetadata[0];
        }
        String runtimeID = runtime.getRuntime().getId();
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Getting instances for runtime with id <" + runtimeID + "> and location <" + runtime.getRuntime().getLocation().toOSString() + ">");
        }
        if (instancesMap.containsKey(runtimeID)) {
            if (Trace.ENABLED) {
                Trace.trace((byte)7, "Found instances for runtimeID: " + runtimeID);
            }
            return instancesMap.get(runtimeID);
        }
        List<String> productExtensionNames = WebSphereRuntimeProductInfoCacheUtil.getProductExtensionNames(runtime);
        if (productExtensionNames.size() == 0) {
            FeatureListExtMetadata[] ext = new FeatureListExtMetadata[]{};
            instancesMap.put(runtimeID, ext);
            return ext;
        }
        ArrayList<FeatureListExtMetadata> exts = new ArrayList<FeatureListExtMetadata>();
        for (String productExtensionName : productExtensionNames) {
            exts.add(new FeatureListExtMetadata(productExtensionName));
        }
        FeatureListExtMetadata[] instances = exts.toArray(new FeatureListExtMetadata[exts.size()]);
        instancesMap.put(runtimeID, instances);
        return instances;
    }

    @Override
    public synchronized HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> getFallbackPayload() {
        return this.fallBackFeatureMaps;
    }

    @Override
    public String[] getCommandOptions() {
        return new String[]{"--productExtension=" + this.extensionName};
    }

    public static synchronized void clearRuntimeInstances(String runtimeId) {
        instancesMap.remove(runtimeId);
    }

    public String getFeatureListXMLName() {
        return this.target;
    }
}

