/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.generation.AbstractFeatureListMetadata;
import com.ibm.ws.st.core.internal.generation.Feature;
import com.ibm.ws.st.core.internal.generation.FeatureInfoHandler;
import com.ibm.ws.st.core.internal.generation.MetadataProviderManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;

public class FeatureListCoreMetadata
extends AbstractFeatureListMetadata {
    public static final String FEATURELIST_XML = "featureList.xml";
    private HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> fallBackFeatureMaps = null;
    private static final FeatureListCoreMetadata instance = new FeatureListCoreMetadata();

    private FeatureListCoreMetadata() {
        super(FEATURELIST_XML);
    }

    public static FeatureListCoreMetadata getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> getFallbackPayload() {
        URL url;
        if (this.fallBackFeatureMaps == null && (url = MetadataProviderManager.getDefaultFeatureList()) != null) {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(url.openStream());
                this.fallBackFeatureMaps = FeatureInfoHandler.parseFeatureListXML(is);
            }
            catch (Throwable t) {
                Trace.logError("Error loading fallback featurelist file: " + url, t);
            }
            finally {
                block14: {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            if (!Trace.ENABLED) break block14;
                            Trace.trace((byte)1, "Unable to close fallback featurelist file", e);
                        }
                    }
                }
            }
        }
        return this.fallBackFeatureMaps;
    }

    @Override
    public String[] getCommandOptions() {
        return null;
    }
}

