/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.generation.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureInfoHandler
extends DefaultHandler {
    private static final String FEATURE = "feature";
    private static final String FEATURE_INFO = "featureInfo";
    private static final String FEATURE_INFO_CORE = "core";
    private static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DESCRIPTION = "description";
    private static final String CATEGORY = "category";
    private static final String API_JAR = "apiJar";
    private static final String SPI_JAR = "spiJar";
    private static final String API_PACKAGE = "apiPackage";
    private static final String SPI_PACKAGE = "spiPackage";
    private static final String ENABLES = "enables";
    private static final String SUPERSEDED = "superseded";
    private static final String SUPERSEDED_BY = "supersededBy";
    private static final String CONFIG_ELEMENT = "configElement";
    private static final String SYMBOLIC_NAME = "symbolicName";
    private static final String SINGLETON = "singleton";
    private static final String INCLUDE = "include";
    private static final String TOLERATES = "tolerates";
    private static final String PROTECTED_FEATURE = "protectedFeature";
    private static final String PRIVATE_FEATURE = "privateFeature";
    private static final String AUTO_FEATURE = "autoFeature";
    private static final String KERNEL_FEATURE = "kernelFeature";
    private static final String AUTO_PROVISION = "autoProvision";
    private static final String PROCESS_TYPE = "processType";
    private final HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> featureMaps;
    private Feature current = null;
    private StringBuilder chars = null;
    private String featureInfoName = null;

    public FeatureInfoHandler(HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> featureMaps) {
        this.featureMaps = featureMaps;
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) {
        if (qname.equals(FEATURE_INFO)) {
            String nameAttr = attributes.getValue("", NAME);
            this.featureInfoName = nameAttr == null || nameAttr.equals(FEATURE_INFO_CORE) ? null : nameAttr;
        } else if (qname.equals(FEATURE)) {
            this.createSet(attributes, Feature.FeatureType.PUBLIC);
        } else if (qname.equals(PROTECTED_FEATURE)) {
            this.createSet(attributes, Feature.FeatureType.PROTECTED);
        } else if (qname.equals(PRIVATE_FEATURE)) {
            this.createSet(attributes, Feature.FeatureType.PRIVATE);
        } else if (qname.equals(AUTO_FEATURE)) {
            this.createSet(attributes, Feature.FeatureType.AUTO);
        } else if (qname.equals(KERNEL_FEATURE)) {
            this.createSet(attributes, Feature.FeatureType.KERNEL);
        } else if (qname.equals(INCLUDE)) {
            this.processInclude(attributes);
        } else if (qname.equals(SYMBOLIC_NAME) || qname.equals(PROCESS_TYPE) || qname.equals(DISPLAY_NAME) || qname.equals(DESCRIPTION) || qname.equals(CATEGORY) || qname.equals(ENABLES) || qname.equals(API_JAR) || qname.equals(API_PACKAGE) || qname.equals(SPI_JAR) || qname.equals(SPI_PACKAGE) || qname.equals(SUPERSEDED) || qname.equals(SUPERSEDED_BY) || qname.equals(CONFIG_ELEMENT) || qname.equals(SINGLETON) || qname.equals(AUTO_PROVISION)) {
            this.chars = new StringBuilder();
        }
    }

    private void createSet(Attributes attributes, Feature.FeatureType featureType) {
        String name = attributes.getValue("", NAME);
        if (name != null && !name.equals("") && this.featureInfoName != null && !this.featureInfoName.equals("")) {
            name = this.featureInfoName + ":" + name;
        }
        this.current = new Feature(name, this.featureInfoName, featureType);
    }

    private void processInclude(Attributes attributes) {
        String symbolicName;
        if (this.current != null && (symbolicName = attributes.getValue("", SYMBOLIC_NAME)) != null && !symbolicName.isEmpty()) {
            ArrayList<String> tolerates = new ArrayList<String>();
            String toleratesValue = attributes.getValue("", TOLERATES);
            if (toleratesValue != null && !toleratesValue.isEmpty()) {
                for (String version : toleratesValue.split(",")) {
                    tolerates.add(version.trim());
                }
            }
            Map<String, List<String>> includes = this.current.getIncludes();
            includes.put(symbolicName, tolerates);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if (qname.equals(SYMBOLIC_NAME)) {
            if (this.current != null) {
                this.current.setSymbolicName(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(PROCESS_TYPE)) {
            if (this.current != null) {
                this.current.addProcessType(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(DISPLAY_NAME)) {
            if (this.current != null) {
                this.current.setDisplayName(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(DESCRIPTION)) {
            if (this.current != null) {
                this.current.setDescription(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(CATEGORY)) {
            if (this.current != null) {
                this.current.addCategoryElements(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(ENABLES)) {
            if (this.current != null) {
                this.current.addEnables(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(API_JAR)) {
            if (this.current != null) {
                this.current.addAPIJar(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(API_PACKAGE)) {
            if (this.current != null) {
                this.current.addAPIPackage(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(SPI_JAR)) {
            if (this.current != null) {
                this.current.addSPIJar(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(SPI_PACKAGE)) {
            if (this.current != null) {
                this.current.addSPIPackage(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(SUPERSEDED)) {
            if (this.current != null) {
                this.current.setSuperseded("true".equals(this.chars.toString().trim()));
            }
            this.chars = null;
        } else if (qname.equals(SINGLETON)) {
            if (this.current != null) {
                this.current.setSingleton("true".equals(this.chars.toString().trim()));
            }
            this.chars = null;
        } else if (qname.equals(SUPERSEDED_BY)) {
            if (this.current != null) {
                this.current.addSupersededBy(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(CONFIG_ELEMENT)) {
            if (this.current != null) {
                this.current.addConfigElement(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(AUTO_PROVISION)) {
            if (this.current != null) {
                this.current.addAutoProvision(this.chars.toString().trim());
            }
            this.chars = null;
        } else if (qname.equals(FEATURE)) {
            if (!this.current.getProcessType().equals((Object)ProcessType.CLIENT)) {
                this.featureMaps.get((Object)FeatureList.FeatureMapType.PUBLIC_FEATURES_KEYED_BY_NAME).put(this.current.getName(), this.current);
                if (this.current.getSymbolicName() != null) {
                    this.featureMaps.get((Object)FeatureList.FeatureMapType.ALL_FEATURES_KEYED_BY_SYMBOLIC_NAME).put(this.current.getSymbolicName(), this.current);
                }
            }
            this.current = null;
        } else if (qname.equals(PROTECTED_FEATURE) || qname.equals(PRIVATE_FEATURE) || qname.equals(AUTO_FEATURE) || qname.equals(KERNEL_FEATURE)) {
            if (this.current.getSymbolicName() != null) {
                this.featureMaps.get((Object)FeatureList.FeatureMapType.ALL_FEATURES_KEYED_BY_SYMBOLIC_NAME).put(this.current.getSymbolicName(), this.current);
            }
            this.current = null;
        } else if (qname.equals(FEATURE_INFO)) {
            this.featureInfoName = null;
        }
    }

    @Override
    public void characters(char[] c, int start, int length) {
        if (this.chars != null) {
            this.chars.append(c, start, length);
        }
    }

    public static HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> parseFeatureListXML(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>> map = new HashMap<FeatureList.FeatureMapType, HashMap<String, Feature>>();
        map.put(FeatureList.FeatureMapType.PUBLIC_FEATURES_KEYED_BY_NAME, new HashMap());
        map.put(FeatureList.FeatureMapType.ALL_FEATURES_KEYED_BY_SYMBOLIC_NAME, new HashMap());
        FeatureInfoHandler handler = new FeatureInfoHandler(map);
        parser.parse(is, (DefaultHandler)handler);
        return map;
    }
}

