/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.generation;

import com.ibm.ws.kernel.feature.ProcessType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Feature
implements Cloneable {
    private final String name;
    private String displayName;
    private String description;
    private String symbolicName;
    private final String featureInfoName;
    private final FeatureType featureType;
    private final Set<String> enables = new HashSet<String>(8);
    private final Set<String> apiJars = new HashSet<String>(8);
    private final Set<String> spiJars = new HashSet<String>(8);
    private final Set<String> apiPackages = new HashSet<String>(8);
    private final Set<String> spiPackages = new HashSet<String>(8);
    private final Set<String> configElements = new HashSet<String>(10);
    private final Map<String, List<String>> includes = new HashMap<String, List<String>>(8);
    private final Set<String> autoProvisions = new HashSet<String>(2);
    private final Set<String> categoryElements = new HashSet<String>(10);
    private final Set<String> processTypes = new HashSet<String>(8);
    private boolean isSuperseded;
    private boolean isSingleton;
    private final Set<String> supersededBy = new HashSet<String>(6);

    public Feature(String name, String featureInfoName, FeatureType featureType) {
        this.name = name;
        this.featureInfoName = featureInfoName;
        this.featureType = featureType;
    }

    public String getName() {
        return this.name;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ProcessType getProcessType() {
        if (this.processTypes.size() == 1 && this.processTypes.contains("CLIENT")) {
            return ProcessType.CLIENT;
        }
        return ProcessType.SERVER;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Set<String> getCategoryElements() {
        return this.categoryElements;
    }

    public Set<String> getEnables() {
        return this.enables;
    }

    public Set<String> getApiJars() {
        return this.apiJars;
    }

    public Set<String> getSpiJars() {
        return this.spiJars;
    }

    public Set<String> getApiPackages() {
        return this.apiPackages;
    }

    public Set<String> getSpiPackages() {
        return this.spiPackages;
    }

    public Map<String, List<String>> getIncludes() {
        return this.includes;
    }

    public boolean isSuperseded() {
        return this.isSuperseded;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public Set<String> getSupersededBy() {
        return this.supersededBy;
    }

    public Set<String> getConfigElements() {
        return this.configElements;
    }

    public Set<String> getAutoProvisions() {
        return this.autoProvisions;
    }

    public String getFeatureInfoName() {
        return this.featureInfoName;
    }

    public boolean isAutoFeature() {
        return !this.autoProvisions.isEmpty();
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    protected void addProcessType(String processType) {
        this.processTypes.add(processType);
    }

    protected void addCategoryElements(String category) {
        this.categoryElements.add(category);
    }

    protected void addEnables(String enables) {
        this.enables.add(enables);
    }

    protected void addAPIJar(String apiJar) {
        this.apiJars.add(apiJar);
    }

    protected void addAPIPackage(String apiPackage) {
        this.apiPackages.add(apiPackage);
    }

    protected void addSPIJar(String spiJar) {
        this.spiJars.add(spiJar);
    }

    protected void addSPIPackage(String spiPackage) {
        this.spiPackages.add(spiPackage);
    }

    protected void setSuperseded(boolean isSuperseded) {
        this.isSuperseded = isSuperseded;
    }

    protected void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    protected void addSupersededBy(String supersededBy) {
        this.supersededBy.add(supersededBy);
    }

    protected void addIncludes(String symbolicName, List<String> versions) {
        this.includes.put(symbolicName, versions);
    }

    protected void addAutoProvision(String autoProvision) {
        this.autoProvisions.add(autoProvision);
    }

    public Feature clone() {
        Feature clonedFeature = new Feature(this.getName(), this.featureInfoName, this.featureType);
        clonedFeature.setDisplayName(this.getDisplayName());
        clonedFeature.setDescription(this.getDescription());
        clonedFeature.setSymbolicName(this.getSymbolicName());
        clonedFeature.getEnables().addAll(this.getEnables());
        clonedFeature.getApiJars().addAll(this.getApiJars());
        clonedFeature.getApiPackages().addAll(this.getApiPackages());
        clonedFeature.getSpiJars().addAll(this.getSpiJars());
        clonedFeature.getSpiPackages().addAll(this.getSpiPackages());
        clonedFeature.getConfigElements().addAll(this.getConfigElements());
        clonedFeature.setSuperseded(this.isSuperseded());
        clonedFeature.setSingleton(this.isSingleton());
        clonedFeature.getSupersededBy().addAll(this.getSupersededBy());
        clonedFeature.getIncludes().putAll(this.getIncludes());
        clonedFeature.getAutoProvisions().addAll(this.getAutoProvisions());
        clonedFeature.getCategoryElements().addAll(this.getCategoryElements());
        return clonedFeature;
    }

    protected void addConfigElement(String configElement) {
        this.configElements.add(configElement);
    }

    public String toString() {
        return "Feature[" + (this.name != null ? this.name : this.symbolicName) + "]";
    }

    public static enum FeatureType {
        PUBLIC,
        PROTECTED,
        PRIVATE,
        AUTO,
        KERNEL;

    }
}

