/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.expression;

public class Expression {
    private Operator operator;
    private String leftOperand;
    private String rightOperand;

    public Expression(String expression) {
        if (expression != null) {
            for (Operator operator : Operator.values()) {
                int index = expression.indexOf(operator.getSymbol());
                if (index == -1) continue;
                this.operator = operator;
                this.leftOperand = expression.substring(0, index);
                this.rightOperand = expression.substring(index + 1);
                break;
            }
        }
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getLeftOperand() {
        return this.leftOperand;
    }

    public String getRightOperand() {
        return this.rightOperand;
    }

    public static enum Operator {
        ADDITION('+'),
        SUBTRACTION('-'),
        MULTIPLICATION('*'),
        DIVISION('/');

        private final char symbol;

        private Operator(char symbol) {
            this.symbol = symbol;
        }

        public char getSymbol() {
            return this.symbol;
        }
    }
}

