/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.validation.ConfigFileFilterItem;
import com.ibm.ws.st.core.internal.config.validation.FilterItem;
import com.ibm.ws.st.core.internal.config.validation.MatchFilterItem;
import com.ibm.ws.st.core.internal.config.validation.ValidationFilterListener;
import com.ibm.ws.st.core.internal.config.validation.ValidationFilterUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValidationFilterSettings
implements FilterItem {
    private final HashMap<String, ConfigFileFilterItem> configFileMap = new HashMap();
    private final IProject project;
    private ValidationFilterListener listener;
    private Document document;

    public ValidationFilterSettings(IProject project) {
        this.project = project;
        this.load();
    }

    public void refresh() {
        if (this.configFileMap.size() > 0) {
            this.configFileMap.clear();
        }
        this.load();
    }

    private void load() {
        this.document = ValidationFilterUtil.loadSettings(this.project);
        if (this.document != null) {
            Element docElement = this.document.getDocumentElement();
            Element child = DOMUtils.getFirstChildElement(docElement, "match");
            while (child != null) {
                this.addConfigItem(child);
                child = DOMUtils.getNextElement(child, "match");
            }
        }
    }

    private void addConfigItem(Element matchElem) {
        String pathString = this.getConfigPath(matchElem);
        ConfigFileFilterItem cfi = this.configFileMap.get(pathString);
        if (cfi == null) {
            cfi = new ConfigFileFilterItem(this, pathString);
            this.configFileMap.put(pathString, cfi);
        }
        this.addMatchItem(cfi, matchElem);
    }

    private void addMatchItem(ConfigFileFilterItem configItem, Element matchElem) {
        String elemName = this.getMatchElementName(matchElem);
        String attrName = this.getMatchAttributeName(matchElem);
        String pattern = this.getIgnorePattern(matchElem);
        MatchFilterItem matchItem = new MatchFilterItem(configItem, pattern, elemName, attrName, matchElem);
        configItem.addMatchItem(matchItem);
    }

    private String getConfigPath(Element matchElem) {
        Attr attr;
        Element childElem = DOMUtils.getFirstChildElement(matchElem, "file");
        if (childElem != null && (attr = childElem.getAttributeNode("path")) != null) {
            return attr.getValue();
        }
        return "*";
    }

    private String getMatchAttributeName(Element matchElem) {
        Attr attr;
        Element childElem = DOMUtils.getFirstChildElement(matchElem, "attribute");
        if (childElem != null && (attr = childElem.getAttributeNode("name")) != null) {
            return attr.getValue();
        }
        return "*";
    }

    private String getMatchElementName(Element matchElem) {
        Attr attr;
        Element childElem = DOMUtils.getFirstChildElement(matchElem, "element");
        if (childElem != null && (attr = childElem.getAttributeNode("name")) != null) {
            return attr.getValue();
        }
        return "*";
    }

    private String getIgnorePattern(Element matchElem) {
        Attr attr;
        Element childElem = DOMUtils.getFirstChildElement(matchElem, "ignore");
        if (childElem != null && (attr = childElem.getAttributeNode("pattern")) != null) {
            return attr.getValue();
        }
        return "";
    }

    public void addFilterListener(ValidationFilterListener listener) {
        this.listener = listener;
    }

    public void removeListener(ValidationFilterListener listener) {
        this.listener = null;
    }

    public boolean removeFilter(FilterItem item) {
        if (item instanceof MatchFilterItem) {
            return this.removeMatchItem((MatchFilterItem)item);
        }
        if (item instanceof ConfigFileFilterItem) {
            return this.removeConfigFileItem((ConfigFileFilterItem)item);
        }
        return false;
    }

    private boolean removeMatchItem(MatchFilterItem matchItem) {
        if (!matchItem.parent.containsMatchItem(matchItem)) {
            return true;
        }
        if (this.removeElement(matchItem.node) && ValidationFilterUtil.saveSettings(this.project, this.document)) {
            if (this.listener != null) {
                this.listener.filterRemoved(matchItem);
            }
            matchItem.parent.removeMatchItem(matchItem);
            if (!matchItem.parent.hasChildren()) {
                this.configFileMap.remove(matchItem.parent.getPath());
                if (this.listener != null) {
                    this.listener.filterRemoved(matchItem.parent);
                }
            }
            this.refreshResource(matchItem.parent.getPath());
            return true;
        }
        return false;
    }

    private boolean removeConfigFileItem(ConfigFileFilterItem configItem) {
        if (this.configFileMap.containsKey(configItem.getPath())) {
            MatchFilterItem[] matchItems;
            for (MatchFilterItem item : matchItems = configItem.getMatchItems()) {
                if (this.removeElement(item.node)) continue;
                return false;
            }
            this.configFileMap.remove(configItem.getPath());
            if (ValidationFilterUtil.saveSettings(this.project, this.document)) {
                if (this.listener != null) {
                    this.listener.filterRemoved(configItem);
                }
                configItem.removeAllChildren();
                this.refreshResource(configItem.getPath());
                return true;
            }
        }
        return true;
    }

    private void refreshResource(String path) {
        if (path != null) {
            IFile file = this.project.getFile(path);
            try {
                file.touch((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private boolean removeElement(Element elem) {
        if (elem.getParentNode() == null) {
            return true;
        }
        if (elem.getOwnerDocument() != this.document) {
            return false;
        }
        Node parent = elem.getParentNode();
        Node sibling = elem.getNextSibling();
        try {
            if (sibling != null && sibling.getNodeType() == 3) {
                parent.removeChild(sibling);
            }
            if ((sibling = elem.getPreviousSibling()) != null && sibling.getNodeType() == 3) {
                parent.removeChild(sibling);
            }
            parent.removeChild(elem);
        }
        catch (DOMException e) {
            Trace.logError("Failed to remove '" + elem.getNodeName() + "'", e);
            return false;
        }
        return true;
    }

    protected Set<ConfigFileFilterItem> getConfigFileItems() {
        return new HashSet<ConfigFileFilterItem>(this.configFileMap.values());
    }

    @Override
    public FilterItem getParent() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.configFileMap.size() > 0;
    }

    @Override
    public Object[] getChildren() {
        return this.configFileMap.values().toArray();
    }
}

